/* This source file is for use in loading the SimpleWn.dll library at run time.
   Do not use this if you have linked your program with the SimpleWn.lib file. */

#include <windows.h>// For library loading functions
#include <stdlib.h>	// For atexit

#include "SWLoad.h"

#ifdef __cplusplus
extern "C" {
#endif


int (SWAPI *SWGetVersion)();
SWHandle (SWAPI *SWCreateWindow)(int, int, int, int, const char *);
void (SWAPI *SWDestroyWindow)(SWHandle hSWnd);
int (SWAPI *SWIsWindow)(SWHandle hSWnd);
COLOURREF (SWAPI *SWSetPixel)(SWHandle hSWnd, int x, int y, COLOURREF colour);
int (SWAPI *SWSetPixelFast)(SWHandle hSWnd, int x, int y, COLOURREF colour);
COLOURREF (SWAPI *SWGetPixel)(SWHandle hSWnd, int x, int y);
int (SWAPI *SWPlot)(SWHandle hSWnd, int x, int y);
int (SWAPI *SWMoveTo)(SWHandle hSWnd, int x, int y);
int (SWAPI *SWLine)(SWHandle hSWnd, int x, int y);
int (SWAPI *SWCircle)(SWHandle hSWnd, int x, int y, int radius);
int (SWAPI *SWArc)(SWHandle hSWnd, int x, int y, int radius, float start_angle, float sweep_angle);
int (SWAPI *SWRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
int (SWAPI *SWInvertRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
int (SWAPI *SWPie)(SWHandle hSWnd, int x, int y, int radius, float start_angle, float sweep_angle);
int (SWAPI *SWGetCurXPos)(SWHandle hSWnd);
int (SWAPI *SWGetCurYPos)(SWHandle hSWnd);
int (SWAPI *SWFillRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
int (SWAPI *SWFillCircle)(SWHandle hSWnd, int x, int y, int radius);
int (SWAPI *SWFloodFill)(SWHandle hSWnd, int x, int y, COLOURREF boundary);
int (SWAPI *SWTextOut)(SWHandle hSWnd, int x, int y, const char* string);
int (SWAPI *SWTextAlign)(SWHandle hSWnd, int alignment);
int (SWAPI *SWSetForeground)(SWHandle hSWnd, COLOURREF colour);
int (SWAPI *SWSetBackground)(SWHandle hSWnd, COLOURREF colour);
COLOURREF (SWAPI *SWGetForeground)(SWHandle hSWnd);
COLOURREF (SWAPI *SWGetBackground)(SWHandle hSWnd);
COLOURREF (SWAPI *SWGetRGBColour)(unsigned char red, unsigned char green, unsigned char blue);
int (SWAPI *SWSetLineStyle)(SWHandle hSWnd, int style);
int (SWAPI *SWSetLineWidth)(SWHandle hSWnd, int width);
int (SWAPI *SWGetLineStyle)(SWHandle hSWnd);
int (SWAPI *SWGetLineWidth)(SWHandle hSWnd);
int (SWAPI *SWSetFillStyle)(SWHandle hSWnd, int style);
int (SWAPI *SWSetFillColour)(SWHandle hSWnd, COLOURREF colour);
int (SWAPI *SWGetFillStyle)(SWHandle hSWnd);
COLOURREF (SWAPI *SWGetFillColour)(SWHandle hSWnd);
int (SWAPI *SWSetDoubleBuffer)(SWHandle hSWnd, int setting);
int (SWAPI *SWSwitchViewBuffer)(SWHandle hSWnd);
int (SWAPI *SWSwitchDrawBuffer)(SWHandle hSWnd);
int (SWAPI *SWGetViewBuffer)(SWHandle hSWnd);
int (SWAPI *SWGetDrawBuffer)(SWHandle hSWnd);
int (SWAPI *SWClearDrawBuffer)(SWHandle hSWnd);
int (SWAPI *SWClearViewBuffer)(SWHandle hSWnd);
int (SWAPI *SWCopyDrawBufferToView)(SWHandle hSWnd);
int (SWAPI *SWRedraw)(SWHandle hSWnd);
int (SWAPI *SWSetAutoRedraw)(SWHandle hSWnd, int time);
int (SWAPI *SWSetTitle)(SWHandle hSWnd, char *title);
char* (SWAPI *SWGetTitle)(SWHandle hSWnd);
int (SWAPI *SWResize)(SWHandle hSWnd, int width, int height);
int (SWAPI *SWMove)(SWHandle hSWnd, int x, int y);
int (SWAPI *SWMinimize)(SWHandle hSWnd);
int (SWAPI *SWRestore)(SWHandle hSWnd);
int (SWAPI *SWGetHeight)(SWHandle hSWnd);
int (SWAPI *SWGetWidth)(SWHandle hSWnd);
int (SWAPI *SWGetWindowX)(SWHandle hSWnd);
int (SWAPI *SWGetWindowY)(SWHandle hSWnd);
int (SWAPI *SWSetFont)(SWHandle hSWnd, int font_size, double orientation, char *name);
int (SWAPI* SWCaptureMouseCoords)(SWHandle hSWnd);
int (SWAPI* SWGetMouseCoordsX)(SWHandle hSWnd);
int (SWAPI* SWGetMouseCoordsY)(SWHandle hSWnd);
int (SWAPI* SWCaptureLastLeftMouseClick)(SWHandle hSWnd);
int (SWAPI* SWGetLastLeftMouseClickCTRL)(SWHandle hSWnd);
int (SWAPI* SWGetLastLeftMouseClickSHIFT)(SWHandle hSWnd);
int (SWAPI* SWGetLastLeftMouseClickX)(SWHandle hSWnd);
int (SWAPI* SWGetLastLeftMouseClickY)(SWHandle hSWnd);
int (SWAPI* SWCaptureLastRightMouseClick)(SWHandle hSWnd);
int (SWAPI* SWGetLastRightMouseClickCTRL)(SWHandle hSWnd);
int (SWAPI* SWGetLastRightMouseClickSHIFT)(SWHandle hSWnd);
int (SWAPI* SWGetLastRightMouseClickX)(SWHandle hSWnd);
int (SWAPI* SWGetLastRightMouseClickY)(SWHandle hSWnd);
char (SWAPI* SWReadChar)(SWHandle hSWnd);
int (SWAPI* SW_kbhit)(SWHandle hSWnd);
int (SWAPI* SWClearKeyBuffer)(SWHandle hSWnd);
int (SWAPI *SWLoadImage)(SWHandle hSWnd, char *filename);
int (SWAPI *SWSaveImage)(SWHandle hSWnd, char *filename);
SWBitmap (SWAPI *SWLoadBitmap)(char *filename);
int (SWAPI *SWSaveBitmap)(SWBitmap hBitmap, char *filename);
int (SWAPI *SWCopyBitmapToClipboard)(SWBitmap hBitmap);
int (SWAPI *SWCopyImageToClipboard)(SWHandle hSWnd);
int (SWAPI *SWDiscardBitmap)(SWBitmap hBitmap);
int (SWAPI *SWShowBitmap)(SWHandle hSWnd, SWBitmap hBitmap);
SWBitmap (SWAPI *SWCopyBitmap)(SWHandle hSWnd, int left, int top, int width, int height);
int (SWAPI *SWPasteBitmap)(SWHandle hSWnd, SWBitmap hBitmap, int x, int y);
int (SWAPI *SWGetBitmapWidth)(SWBitmap hBitmap);
int (SWAPI *SWGetBitmapHeight)(SWBitmap hBitmap);
char* (SWAPI *SWGetErrorString)(int error_code);
int (SWAPI *SWGetLastError)();
int (SWAPI *SWLoadRIFFPalette)(SWHandle hSWnd, char *filename);
int (SWAPI *SWUseBitmapPalette)(SWHandle hSWnd, SWBitmap hBitmap);
int (SWAPI *SWSaveWindowPalette)(SWHandle hSWnd, char *filename);
int (SWAPI *SWSaveBitmapPalette)(SWBitmap hBitmap, char *filename);
int (SWAPI *SWBringWindowToFront)(SWHandle hSWnd);
int (SWAPI *SWRegister)(char *reg_code1, char *reg_code2);



#define GetAddress(x) (FARPROC)x = GetProcAddress(library, #x);															\
						if(x == NULL)																					\
						{																								\
							MessageBox(NULL, "Could not find function " #x " in SimpleWn.dll", "SW Loader", MB_OK);	\
							return(SWL_FN_NOT_FOUND);																	\
						}


HINSTANCE	library = 0;
	

void SWFreeLibrary(void)
{
	FreeLibrary(library);
}


int SWLoadLibrary()
{
	library = LoadLibrary("SimpleWn.dll");
	if(library == 0)
	{
		MessageBox(NULL, "Could not locate SimpleWn.dll", "SW Loader", MB_OK);
		return(SWL_LIB_NOT_FOUND);
	}
	
	GetAddress(SWGetVersion)
	GetAddress(SWCreateWindow)
	GetAddress(SWDestroyWindow)
	GetAddress(SWIsWindow)
	GetAddress(SWSetPixel)
	GetAddress(SWSetPixelFast)
	GetAddress(SWGetPixel)
	GetAddress(SWPlot)
	GetAddress(SWMoveTo)
	GetAddress(SWLine)
	GetAddress(SWCircle)
	GetAddress(SWArc)
	GetAddress(SWRectangle)
	GetAddress(SWInvertRectangle)
	GetAddress(SWPie)
	GetAddress(SWGetCurXPos)
	GetAddress(SWGetCurYPos)
	GetAddress(SWFillRectangle)
	GetAddress(SWFillCircle)
	GetAddress(SWFloodFill)
	GetAddress(SWTextAlign)
	GetAddress(SWTextOut)
	GetAddress(SWSetForeground)
	GetAddress(SWSetBackground)
	GetAddress(SWGetForeground)
	GetAddress(SWGetBackground)
	GetAddress(SWGetRGBColour)
	GetAddress(SWSetLineStyle)
	GetAddress(SWSetLineWidth)
	GetAddress(SWGetLineStyle)
	GetAddress(SWGetLineWidth)
	GetAddress(SWSetFillStyle)
	GetAddress(SWSetFillColour)
	GetAddress(SWGetFillStyle)
	GetAddress(SWGetFillColour)
	GetAddress(SWSetDoubleBuffer)
	GetAddress(SWSwitchViewBuffer)
	GetAddress(SWSwitchDrawBuffer)
	GetAddress(SWGetViewBuffer)
	GetAddress(SWGetDrawBuffer)
	GetAddress(SWClearDrawBuffer)
	GetAddress(SWClearViewBuffer)
	GetAddress(SWCopyDrawBufferToView)
	GetAddress(SWRedraw)
	GetAddress(SWSetAutoRedraw)
	GetAddress(SWSetTitle)
	GetAddress(SWGetTitle)
	GetAddress(SWResize)
	GetAddress(SWMove)
	GetAddress(SWMinimize)
	GetAddress(SWRestore)
	GetAddress(SWGetHeight)
	GetAddress(SWGetWidth)
	GetAddress(SWGetWindowX)
	GetAddress(SWGetWindowY)
	GetAddress(SWSetFont)
	GetAddress(SWCaptureMouseCoords)
	GetAddress(SWGetMouseCoordsX)
	GetAddress(SWGetMouseCoordsY)
	GetAddress(SWCaptureLastLeftMouseClick)
	GetAddress(SWGetLastLeftMouseClickCTRL)
	GetAddress(SWGetLastLeftMouseClickSHIFT)
	GetAddress(SWGetLastLeftMouseClickX)
	GetAddress(SWGetLastLeftMouseClickY)
	GetAddress(SWCaptureLastRightMouseClick)
	GetAddress(SWGetLastRightMouseClickCTRL)
	GetAddress(SWGetLastRightMouseClickSHIFT)
	GetAddress(SWGetLastRightMouseClickX)
	GetAddress(SWGetLastRightMouseClickY)
	GetAddress(SWReadChar
	GetAddress(SW_kbhit)
	GetAddress(SWClearKeyBuffer)
	GetAddress(SWLoadImage)
	GetAddress(SWSaveImage)
	GetAddress(SWLoadBitmap)
	GetAddress(SWSaveBitmap)
	GetAddress(SWCopyBitmapToClipboard)
	GetAddress(SWCopyImageToClipboard)
	GetAddress(SWDiscardBitmap)
	GetAddress(SWShowBitmap)
	GetAddress(SWCopyBitmap)
	GetAddress(SWPasteBitmap)
	GetAddress(SWGetBitmapWidth)
	GetAddress(SWGetBitmapHeight)
	GetAddress(SWGetErrorString)
	GetAddress(SWGetLastError)
	GetAddress(SWLoadRIFFPalette)
	GetAddress(SWUseBitmapPalette)
	GetAddress(SWSaveWindowPalette)
	GetAddress(SWSaveBitmapPalette)
	GetAddress(SWBringWindowToFront)
	GetAddress(SWRegister);
	atexit(SWFreeLibrary);
	return(SWL_OKAY);
}


#ifdef __cplusplus
}
#endif

