// Demonstration of the text output functions

#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	SWDoRegister();		

	h1 = SWCreateWindow(10, 20, 100, 150, "Text Demo");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s", SWGetErrorString(SWGetLastError()));
		return;
	}

	// Set the alignment position
	SWTextAlign(h1, SW_AL_BOTTOM_CENTRE);

	// SetFont - Size 12, 0 angle, font="Times new Roman"
	SWSetFont(h1, 12, 0, "Times New Roman");

	// Output some text
	SWTextOut(h1, 50, 35, "Some text");

	// SetFont - Size 10, 20 degree angle, font="Times new Roman"
	SWSetFont(h1, 10, 20, "Times New Roman");

	// Output some text
	SWTextOut(h1, 50, 105, "Some angled text");

	printf("Hit any key to finish\n");
	while(!kbhit());

	// Now destroy the window
	SWDestroyWindow(h1);
}


