//Demonstration of keyboard functions

#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1;
	int		go;
	char		key;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	// First thing - register the DLL
	SWDoRegister();		

	// Now create a window called "First Window" at (10, 20) width = 100, height = 150
	h1 = SWCreateWindow(10, 20, 100, 150, "First Window");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s", SWGetErrorString(SWGetLastError()));
		return;
	}

	SWBringWindowToFront(h1);
	printf("Type in the window - hit ESC to quit\n\n");
	go = 1;
	while(go)
	{
		if(SW_kbhit(h1))
		{
			key = SWReadChar(h1);
			printf("%c", key);
			if(key == 0x1b) // 0x1b = ESC
				go = 0;
		}
	}
	

	// Now destroy the window
	SWDestroyWindow(h1);
}


