// Demonstration of some of the graphics functions

#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	SWDoRegister();		

	h1 = SWCreateWindow(10, 20, 300, 300, "Graphics Demo");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s",SWGetErrorString(SWGetLastError()));
		return;
	}

	// Plot a pixel, colour SW_BLUE
	SWSetPixel(h1, 25, 14, SW_BLUE);

	// Set the draw colour to green and plot a point with
	// the current pen
	SWSetForeground(h1, SW_GREEN);
	SWPlot(h1, 30, 14);

	// Move the pen
	SWMoveTo(h1, 35, 14);

	// Draw a line to (40,14)
	SWLine(h1, 40, 14);
	
	// Draw a circle, centre (50,50), radius 20
	SWCircle(h1, 50, 50, 20); 

	// Set the fill colour to red
	SWSetFillColour(h1, SW_RED);

	// Draw a filled circle, centre (100,50), radius 20
	SWFillCircle(h1, 100, 50, 20); 

	// Set the draw colour to black
	SWSetForeground(h1, SW_BLACK);

	// Draw an arc - See help for details!
	SWArc(h1, 250, 250, 200, 45.0f, 90.0f);

	// Draw a rectangle (100, 100) - (120,130)
	SWRectangle(h1, 100, 100, 120, 130);

	// Draw a filled rectangle (130, 100) - (150,130)
	SWFillRectangle(h1, 130, 100, 150, 130);

	// Draw a pie section - See help for details!
	SWPie(h1, 150, 150, 30, 45.0f, 90.0f);

	// Set the draw colour to red
	SWSetForeground(h1, SW_RED);
	// Draw a rectangle (200, 200) - (220,250)
	SWRectangle(h1, 200, 200, 220, 250);
	// Set the fill colour to blue
	SWSetFillColour(h1, SW_BLUE);
	// Fill everything from (205, 205) up to a red border
	// ie. the rectangle edges
	SWFloodFill(h1, 205, 205, SW_RED);

	printf("Hit any key to finish\n");
	while(!kbhit());

	// Now destroy the window
	SWDestroyWindow(h1);
}
