// Demonstration of double buffering

#include <windows.h> // For Sleep function
#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1;
	int			i;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	SWDoRegister();		

	h1 = SWCreateWindow(10, 20, 300, 300, "Double Buffering Demo");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s",SWGetErrorString(SWGetLastError()));
		return;
	}

	// SetFont - Size 12, 0 angle, font="Times new Roman"
	SWSetFont(h1, 12, 0, "Times New Roman");

	// Set the alignment position
	SWTextAlign(h1, SW_AL_BOTTOM_CENTRE);

	// Turn on double buffering
	SWSetDoubleBuffer(h1, 1);	
	// Swap to the second buffer for drawing
	SWSwitchDrawBuffer(h1);

	for(i = 0; i < 100; ++i)
	{
		Sleep(50);	// Make use of Windows API
		// Clear the drawing buffer
		SWClearDrawBuffer(h1);
		// Set the alignment position top left
		SWTextAlign(h1, SW_AL_TOP_LEFT);
		// Set the font at an angle - i*7 degrees
		SWSetFont(h1, 12, i * 7, "Times New Roman");
		// Output some text
		SWTextOut(h1, i*2, 200, "Moving text");
		// Set the alignment position top centre
		SWTextAlign(h1, SW_AL_TOP_CENTRE);
		// Output some more text
		SWSetFont(h1, 12, i * 13, "Times New Roman");
		// Output some text
		SWTextOut(h1, i*2, 100, "More Moving text");
			
		// Set the view to the newly drawn buffer
		SWSwitchViewBuffer(h1);
		// Start drawing on the old buffer
		SWSwitchDrawBuffer(h1);
	}


	printf("Hit any key to finish\n");
	while(!kbhit());

	// Now destroy the window
	SWDestroyWindow(h1);
}


