// Creating and destroying windows
#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	// First thing - register the DLL
	SWDoRegister();		

	// Now create a window called "First Window" at (10, 20) width = 100, height = 150
	h1 = SWCreateWindow(10, 20, 100, 150, "First Window");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s", SWGetErrorString(SWGetLastError()));
		return;
	}

	printf("Hit any key to finish\n");
	while(!kbhit());	// Wait for a key hit

	// Now destroy the window
	SWDestroyWindow(h1);
}


