// Demonstration of bitmap functions

#include <stdio.h>
#include <conio.h>

#include <SimpleWn.h>	// Use if linking in SimpleWn.lib
//#include "SWLoad.h"	// Use if including in SWLoad.c

void main()
{
	SWHandle	h1, h2;
	SWBitmap	b1;

	#ifdef SWLOAD_H
		SWLoadLibrary();
	#endif

	SWDoRegister();		

	h1 = SWCreateWindow(10, 20, 300, 300, "Bitmap Demo");
	if(h1 == SW_NULL_HANDLE)
	{
		printf("Error : %s",SWGetErrorString(SWGetLastError()));
		return;
	}

	// Draw a circle, centre (50,50), radius 20
	SWCircle(h1, 50, 50, 20); 

	// Set the fill colour to red
	SWSetFillColour(h1, SW_RED);

	// Draw a filled circle, centre (100,50), radius 20
	SWFillCircle(h1, 100, 50, 20); 

	// Set the draw colour to black
	SWSetForeground(h1, SW_BLACK);

	// Draw an arc - See help for details!
	SWArc(h1, 250, 250, 200, 45.0f, 90.0f);

	// Draw a rectangle (100, 100) - (120,130)
	SWRectangle(h1, 100, 100, 120, 130);

	// Draw a filled rectangle (130, 100) - (150,130)
	SWFillRectangle(h1, 130, 100, 150, 130);

	// Draw a pie section - See help for details!
	SWPie(h1, 150, 150, 30, 45.0f, 90.0f);

	// Set the draw colour to red
	SWSetForeground(h1, SW_RED);
	// Draw a rectangle (200, 200) - (220,250)
	SWRectangle(h1, 200, 200, 220, 250);
	// Set the fill colour to blue
	SWSetFillColour(h1, SW_BLUE);
	// Fill everything from (205, 205) up to a red border
	// ie. the rectangle edges
	SWFloodFill(h1, 205, 205, SW_RED);

	// Create a new window
	h2 = SWCreateWindow(400, 20, 300, 300, "Second Window");
	// Set the background to CYAN
	SWSetBackground(h2, SW_CYAN);
	// Clear the window to the background colour
	SWClearViewBuffer(h2);
	// Copy a section of the first window
	b1 = SWCopyBitmap(h1, 20, 20, 150, 150);
	
	// Paste the bitmap into the second window
	SWPasteBitmap(h2, b1, 100, 100);

	printf("Hit any key to finish\n");
	while(!kbhit());

	// Now destroy the window
	SWDestroyWindow(h1);
}
