#ifndef SIMPLEWIN_H
#define SIMPLEWIN_H

#include <windows.h> // Windows defn file

#ifdef __cplusplus
extern "C" {
#endif


#define RegName ""
#define RegCode ""

#define SWDoRegister() SWRegister(RegName, RegCode)

#define SWAPI WINAPI

// If using loader, define functions differently
#ifdef SWLOAD_H
#define Function(ret, name) extern ret (SWAPI *name)
#else
#define Function(ret, name) ret SWAPI name
#endif

typedef COLORREF COLOURREF;     // Used for specifiying colours


typedef long SWHandle;  // Handle for windows
typedef long SWBitmap;  // Handle for loaded or copied bitmaps



Function(int, SWGetVersion)();

Function(SWHandle, SWCreateWindow)(int x, int y, int width, int height, const char *title);
Function(void, SWDestroyWindow)(SWHandle hSWnd);
Function(int, SWIsWindow)(SWHandle hSWnd);

Function(COLOURREF, SWSetPixel)(SWHandle hSWnd, int x, int y, COLOURREF colour);
Function(int, SWSetPixelFast)(SWHandle hSWnd, int x, int y, COLOURREF colour);
Function(COLOURREF, SWGetPixel)(SWHandle hSWnd, int x, int y);

Function(int, SWPlot)(SWHandle hSWnd, int x, int y);
Function(int, SWMoveTo)(SWHandle hSWnd, int x, int y);
Function(int, SWLine)(SWHandle hSWnd, int x, int y);
Function(int, SWCircle)(SWHandle hSWnd, int x, int y, int radius);
Function(int, SWArc)(SWHandle hSWnd, int x, int y, int radius, float start_angle, float sweep_angle);
Function(int, SWRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
Function(int, SWInvertRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
Function(int, SWPie)(SWHandle hSWnd, int x, int y, int radius, float start_angle, float sweep_angle);
Function(int, SWGetCurXPos)(SWHandle hSWnd);
Function(int, SWGetCurYPos)(SWHandle hSWnd);

Function(int, SWFillRectangle)(SWHandle hSWnd, int x0, int y0, int x1, int y1);
Function(int, SWFillCircle)(SWHandle hSWnd, int x, int y, int radius);
Function(int, SWFloodFill)(SWHandle hSWnd, int x, int y, COLOURREF boundary);

Function(int, SWTextOut)(SWHandle hSWnd, int x, int y, const char* string);
Function(int, SWTextAlign)(SWHandle hSWnd, int alignment);
Function(int, SWSetForeground)(SWHandle hSWnd, COLOURREF colour);
Function(int, SWSetBackground)(SWHandle hSWnd, COLOURREF colour);
Function(COLOURREF, SWGetForeground)(SWHandle hSWnd);
Function(COLOURREF, SWGetBackground)(SWHandle hSWnd);
Function(COLOURREF, SWGetRGBColour)(unsigned char red, unsigned char green, unsigned char blue);

Function(int, SWSetLineStyle)(SWHandle hSWnd, int style);
Function(int, SWSetLineWidth)(SWHandle hSWnd, int width);

Function(int, SWGetLineStyle)(SWHandle hSWnd);
Function(int, SWGetLineWidth)(SWHandle hSWnd);

Function(int, SWSetFillStyle)(SWHandle hSWnd, int style);
Function(int, SWSetFillColour)(SWHandle hSWnd, COLOURREF colour);

Function(int, SWGetFillStyle)(SWHandle hSWnd);
Function(COLOURREF, SWGetFillColour)(SWHandle hSWnd);

Function(int, SWSetDoubleBuffer)(SWHandle hSWnd, int setting);
Function(int, SWSwitchViewBuffer)(SWHandle hSWnd);
Function(int, SWSwitchDrawBuffer)(SWHandle hSWnd);
Function(int, SWGetViewBuffer)(SWHandle hSWnd);
Function(int, SWGetDrawBuffer)(SWHandle hSWnd);
Function(int, SWClearDrawBuffer)(SWHandle hSWnd);
Function(int, SWClearViewBuffer)(SWHandle hSWnd);
Function(int, SWCopyDrawBufferToView)(SWHandle hSWnd);

Function(int, SWRedraw)(SWHandle hSWnd);
Function(int, SWSetAutoRedraw)(SWHandle hSWnd, int time);

Function(int, SWSetTitle)(SWHandle hSWnd, char *title);
Function(char*, SWGetTitle)(SWHandle hSWnd);

Function(int, SWResize)(SWHandle hSWnd, int width, int height);
Function(int, SWMove)(SWHandle hSWnd, int x, int y);
Function(int, SWMinimize)(SWHandle hSWnd);
Function(int, SWRestore)(SWHandle hSWnd);

Function(int, SWGetHeight)(SWHandle hSWnd);
Function(int, SWGetWidth)(SWHandle hSWnd);
Function(int, SWGetWindowX)(SWHandle hSWnd);
Function(int, SWGetWindowY)(SWHandle hSWnd);

Function(int, SWSetFont)(SWHandle hSWnd, int font_size, double orientation, char *name);


Function(int, SWCaptureMouseCoords)(SWHandle hSWnd);
Function(int, SWGetMouseCoordsX)(SWHandle hSWnd);
Function(int, SWGetMouseCoordsY)(SWHandle hSWnd);

Function(int, SWCaptureLastLeftMouseClick)(SWHandle hSWnd);
Function(int, SWGetLastLeftMouseClickCTRL)(SWHandle hSWnd);
Function(int, SWGetLastLeftMouseClickSHIFT)(SWHandle hSWnd);
Function(int, SWGetLastLeftMouseClickX)(SWHandle hSWnd);
Function(int, SWGetLastLeftMouseClickY)(SWHandle hSWnd);

Function(int, SWCaptureLastRightMouseClick)(SWHandle hSWnd);
Function(int, SWGetLastRightMouseClickCTRL)(SWHandle hSWnd);
Function(int, SWGetLastRightMouseClickSHIFT)(SWHandle hSWnd);
Function(int, SWGetLastRightMouseClickX)(SWHandle hSWnd);
Function(int, SWGetLastRightMouseClickY)(SWHandle hSWnd);


Function(char, SWReadChar)(SWHandle hSWnd);
Function(int, SWClearKeyBuffer)(SWHandle hSWnd);
Function(int, SW_kbhit)(SWHandle hSWnd);

Function(int, SWLoadImage)(SWHandle hSWnd, char *filename);
Function(int, SWSaveImage)(SWHandle hSWnd, char *filename);

Function(SWBitmap, SWLoadBitmap)(char *filename);
Function(int, SWSaveBitmap)(SWBitmap hBitmap, char *filename);

Function(int, SWCopyBitmapToClipboard)(SWBitmap hBitmap);
Function(int, SWCopyImageToClipboard)(SWHandle hSWnd);
Function(int, SWDiscardBitmap)(SWBitmap hBitmap);

Function(int, SWShowBitmap)(SWHandle hSWnd, SWBitmap hBitmap);
Function(SWBitmap, SWCopyBitmap)(SWHandle hSWnd, int left, int top, int width, int height);
Function(int, SWPasteBitmap)(SWHandle hSWnd, SWBitmap hBitmap, int x, int y);

Function(int, SWGetBitmapWidth)(SWBitmap hBitmap);
Function(int, SWGetBitmapHeight)(SWBitmap hBitmap);

Function(char*, SWGetErrorString)(int error_code);
Function(int, SWGetLastError)();


Function(int, SWLoadRIFFPalette)(SWHandle hSWnd, char *filename);
Function(int, SWUseBitmapPalette)(SWHandle hSWnd, SWBitmap hBitmap);
Function(int, SWSaveWindowPalette)(SWHandle hSWnd, char *filename);
Function(int, SWSaveBitmapPalette)(SWBitmap hBitmap, char *filename);

Function(int, SWBringWindowToFront)(SWHandle hSWnd);
Function(int, SWRegister)(char *reg_name, char *reg_code);



/*
Colours:

When specifying an explicit RGB color, the COLORREF value has the following hexadecimal form: 
  
0x00bbggrr 
 
The low-order byte contains a value for the relative intensity of red; the second byte contains a value for green; and the third byte contains a value for blue. The high-order byte must be zero. The maximum value for a single byte is 0xFF. 
*/

enum SWColours
{
	SW_BLACK        = 0x00000000,
	SW_DKGREY       = 0x00808080,
	SW_DKGRAY       = 0x00808080,
	SW_LTGREY       = 0x00C0C0C0,
	SW_LTGRAY       = 0x00C0C0C0,
	SW_WHITE        = 0x00FFFFFF,

	SW_RED          = 0x000000FF,
	SW_GREEN        = 0x0000FF00,
	SW_BLUE         = 0x00FF0000,
	SW_YELLOW       = 0x0000FFFF,
	SW_MAGENTA      = 0x00FF00FF,
	SW_CYAN         = 0x00FFFF00,

	SW_DKRED        = 0x00000080,
	SW_DKGREEN      = 0x00008000,
	SW_DKBLUE       = 0x00800000,
	SW_DKYELLOW     = 0x00008080,
	SW_DKMAGENTA= 0x00800080,
	SW_DKCYAN       = 0x00808000
};

#define SW_INVALID_COLOUR 0xFF000000
#define SW_NULL_HANDLE 0

// Valid line styles for drawing
enum SWLineStyles
{
	SW_LS_SOLID,
	SW_LS_DASH,
	SW_LS_DASHDOT,
	SW_LS_DASHDOTDOT,
	SW_LS_NONE
};


// Valid fill styles for brushes
enum SWFillStyles
{
	SW_FS_SOLID,
	SW_FS_DIAGDOWN,
	SW_FS_DIAGUP,
	SW_FS_DIAGCROSS,
	SW_FS_HORIZONTAL,
	SW_FS_VERTICAL
};


// SimpleWin text alignment values
enum SWTextAlignment
{
	SW_AL_BASE_LEFT,
	SW_AL_BASE_CENTRE,
	SW_AL_BASE_CENTER,
	SW_AL_BASE_RIGHT,
	SW_AL_TOP_LEFT,
	SW_AL_TOP_CENTRE,
	SW_AL_TOP_CENTER,
	SW_AL_TOP_RIGHT,
	SW_AL_BOTTOM_LEFT,
	SW_AL_BOTTOM_CENTRE,
	SW_AL_BOTTOM_CENTER,
	SW_AL_BOTTOM_RIGHT
};


//SimpleWin error message codes
enum SWErrors
{
	SW_OKAY = -1000000,
	SW_BAD,

	SW_FILE_COULD_NOT_OPEN,
	SW_FILE_READ_ERROR,
	SW_FILE_WRITE_ERROR,
	SW_FILE_BAD_BM_FILE,
	SW_FILE_SIZE_MISMATCH,
	SW_FILE_16BIT_FILE,
	SW_FILE_32BIT_FILE,
	SW_FILE_BAD_PALETTE_SIZE,
	SW_FILE_BAD_BITCOUNT,
	SW_FILE_COULD_NOT_MAKE_DIB,
	SW_FILE_NOT_RIFF,
	SW_FILE_NOT_PALETTE,
	SW_FILE_BAD_VERSION,
	SW_DIB_BAD_PALETTE_SIZE,
	SW_DIB_BAD_BITCOUNT,
	SW_DIB_NO_PALETTE,
	SW_BAD_WINDOW_HANDLE,
	SW_BAD_BITMAP_HANDLE,
	SW_BAD_WIDTH,
	SW_BAD_HEIGHT,
	SW_BAD_LEFT_VALUE,
	SW_BAD_TOP_VALUE,
	SW_COPY_BITMAP_FAILED,
	SW_COULD_NOT_OPEN_WINDOW,
	SW_TOO_MANY_WINDOWS,
	SW_NO_MEMORY,
	SW_MOUSE_OUTSIDE_WINDOW,
	SW_NOT_TOP_WINDOW,
	SW_COORDS_NOT_VALID,
	SW_NO_MOUSE_CLICK,
	SW_NOT_INITIALISED,
	SW_CLIPBOARD_BUSY,
	SW_CLIPBOARD_ERROR
};


#ifdef __cplusplus
}
#endif

#endif SIMPLEWIN_H
