/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class cooscale
extends Applet
implements Serializable,
Runnable {
    private final String Error1 = "can't load image file";
    private final String Error2 = "can't load audio file";
    private int m_percentage;
    private int m_bevel = 2;
    private Color m_barForeground = Color.blue;
    private Color m_barBackground = Color.gray;
    private Color m_tipsForeground = Color.black;
    private Color m_tipsBackground = Color.yellow;
    private Color m_textColor = Color.red;
    private Color m_outerTLShadowColor = Color.lightGray.darker();
    private Color m_outerBRShadowColor = Color.lightGray;
    private Color m_innerTLShadowColor = Color.yellow;
    private Color m_innerBRShadowColor = Color.black;
    private boolean m_displayText = true;
    private boolean m_soundPlaying = false;
    protected Applet m_applet;
    private boolean m_loaded = false;
    private String m_coolshareAd = "Click to get this Java Bean for FREE at www.coolshare.com";
    public boolean m_enableTipsText = false;
    private int m_width;
    private int m_height;
    private int m_buffWidth;
    private int m_buffHeight;
    private int m_tipsX = 200;
    private int m_tipsY = 400;
    private int m_tipsWidth = 150;
    private int m_tipsHeight = 32;
    private String m_tipsText = "Processing...Please wait.";
    private String m_soundURLText = "http://www.coolshare.com/html/sound/SOUND25.AU";
    private String m_firstImageFileURL = "http://www.coolshare.com/html/images/cooscale1.gif";
    protected String m_coolshareURL = "http://www.coolshare.com/";
    private int m_numImage = 8;
    private int m_soundMode;
    private int m_soundPlayStyle = 1;
    private int m_animationSpeed = 50;
    private AudioClip m_sound;
    private cootips m_tips;
    private boolean m_selfTest = true;
    private boolean m_processing = false;
    private Image[] m_processImages;
    private int m_currentImage = 1;
    private Thread threadProcessAnimator;
    private MediaTracker tracker;
    private Image imageOffScreen;
    private Graphics graphicsOffScreen;
    private String m_imageFilename;
    private int TheShareware = 2;
    private int TheAdware = 1;
    private int TheDemo;
    private String Name = "";
    private int releaseLevel = this.TheAdware;
    private boolean m_doAnimtion = true;
    private boolean m_doSound = true;
    private int m_barWidth;

    public cooscale() {
        this.toInit();
    }

    public cooscale(int n) {
        this.m_percentage = n <= 100 && n >= 0 ? n : 0;
        this.toInit();
    }

    public void toInit() {
        this.releaseLevel = this.TheAdware;
        this.Name = "Adware";
        if (this.releaseLevel != this.TheShareware) {
            this.m_tipsText = this.m_coolshareAd;
            this.m_tipsWidth = 300;
            this.m_tipsHeight = 80;
        }
        this.updateData();
    }

    public void start() {
        this.resize(this.getPreferredSize());
        this.m_height = this.size().height;
        this.m_width = this.size().width;
        this.repaint();
    }

    public void stopAll() {
        if (this.m_sound != null) {
            this.m_sound.stop();
            this.m_sound = null;
        }
        if (this.threadProcessAnimator != null) {
            this.threadProcessAnimator.stop();
            this.threadProcessAnimator = null;
        }
    }

    public void destroy() {
        this.stopAll();
    }

    public void stop() {
        this.stopAll();
    }

    public void setApplet(Applet applet) {
        this.m_applet = applet;
    }

    public void run() {
        while (true) {
            this.m_currentImage = this.m_currentImage < this.m_numImage ? ++this.m_currentImage : 1;
            this.drawAnimation(this.m_currentImage);
            this.sleep(this.m_animationSpeed);
        }
    }

    void sleep(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public int getPercent() {
        return this.m_percentage;
    }

    public void setBevel(int n) {
        this.m_bevel = n;
        this.repaint();
    }

    public int getBevel() {
        return this.m_bevel;
    }

    public void setPercent(int n) {
        if (n <= 100 && n >= 0) {
            this.m_percentage = n;
        }
        this.repaint();
    }

    public boolean getDisplayText() {
        return this.m_displayText;
    }

    public boolean isDisplayText() {
        return this.m_displayText;
    }

    public void setDisplayText(boolean bl) {
        this.m_displayText = bl;
    }

    public Color getBarForeground() {
        return this.m_barForeground;
    }

    public void setBarForeground(Color color) {
        this.m_barForeground = color;
        this.repaint();
    }

    public Color getBarBackground() {
        return this.m_barBackground;
    }

    public void setBarBackground(Color color) {
        this.m_barBackground = color;
        this.repaint();
    }

    public Color getTipsForeground() {
        return this.m_tipsForeground;
    }

    public void setTipsForeground(Color color) {
        this.m_tipsForeground = color;
        this.repaint();
    }

    public Color getTipsBackground() {
        return this.m_tipsBackground;
    }

    public void setTipsBackground(Color color) {
        this.m_tipsBackground = color;
        this.repaint();
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public void setTextColor(Color color) {
        this.m_textColor = color;
        this.repaint();
    }

    public Color getOuterTLShadowColor() {
        return this.m_outerTLShadowColor;
    }

    public void setOuterTLShadowColor(Color color) {
        this.m_outerTLShadowColor = color;
        this.repaint();
    }

    public Color getOuterBRShadowColor() {
        return this.m_outerBRShadowColor;
    }

    public void setOuterBRShadowColor(Color color) {
        this.m_outerBRShadowColor = color;
        this.repaint();
    }

    public Color getInnerTLShadowColor() {
        return this.m_innerTLShadowColor;
    }

    public void setInnerTLShadowColor(Color color) {
        this.m_innerTLShadowColor = color;
        this.repaint();
    }

    public Color getInnerBRShadowColor() {
        return this.m_innerBRShadowColor;
    }

    public void setInnerBRShadowColor(Color color) {
        this.m_innerBRShadowColor = color;
        this.repaint();
    }

    public void toggleDisplayText() {
        this.m_displayText = !this.m_displayText;
    }

    public int getTipsX() {
        return this.m_tipsX;
    }

    public void setTipsX(int n) {
        this.m_tipsX = n;
    }

    public int getTipsY() {
        return this.m_tipsY;
    }

    public void setTipsY(int n) {
        this.m_tipsY = n;
    }

    public int getTipsWidth() {
        return this.m_tipsWidth;
    }

    public void setTipsWidth(int n) {
        this.m_tipsWidth = n;
    }

    public int getTipsHeight() {
        return this.m_tipsHeight;
    }

    public void setTipsHeight(int n) {
        this.m_tipsHeight = n;
    }

    public String getTipsText() {
        return this.m_tipsText;
    }

    public void setTipsText(String string) {
        if (this.releaseLevel == this.TheShareware) {
            this.m_tipsText = string;
            return;
        }
        if (this.m_enableTipsText) {
            this.m_tipsText = string;
            this.m_enableTipsText = false;
            return;
        }
        this.m_tipsText = this.m_coolshareAd;
    }

    public String getSoundURL() {
        return this.m_soundURLText;
    }

    public void setSoundURL(String string) {
        if (this.m_applet == null || string == null || string.equals("")) {
            if (this.m_applet == null) {
                this.printError_0();
            }
            this.m_sound = null;
            this.m_doSound = false;
            System.err.println("Couldn't load sound");
            this.m_soundURLText = "can't load audio file";
            this.updateData();
            this.repaint();
            return;
        }
        this.m_soundURLText = string;
        try {
            URL uRL = new URL(this.m_applet.getDocumentBase(), this.m_soundURLText);
            this.m_sound = this.m_applet.getAudioClip(uRL);
            return;
        }
        catch (Exception exception) {
            this.m_sound = null;
            this.m_doSound = false;
            System.err.println("Exception" + exception + " - couldn't load sound");
            this.m_soundURLText = "can't load audio file";
            this.updateData();
            this.repaint();
            return;
        }
    }

    public void prepareImage() {
        this.m_buffWidth = this.m_height;
        this.m_buffHeight = this.m_height;
        this.imageOffScreen = this.createImage(this.m_buffWidth, this.m_buffHeight);
        this.graphicsOffScreen = this.imageOffScreen.getGraphics();
        this.graphicsOffScreen.setColor(Color.white);
        this.graphicsOffScreen.fillRect(0, 0, this.size().height, this.size().height);
        this.setFirstImageFileURL(this.m_firstImageFileURL);
    }

    public String getFirstImageFileURL() {
        return this.m_firstImageFileURL;
    }

    private void printError_0() {
        System.err.println("");
        System.err.println("***************** Note from Cooscale ***************************");
        System.err.println("*                                                              *");
        System.err.println("*  In order to enable animation and sound for cooscale, you    *");
        System.err.println("*  need to call cooscale's public method, setApplet, from      *");
        System.err.println("*  cooscale's parent and pass an applet object as the only     *");
        System.err.println("*  parameter of setApplet before starting or showing cooscale. *");
        System.err.println("*  You won't be able to do so (to change source code of        *");
        System.err.println("*  cooscale's caller) if you use BeanBox.  Sameple codes       *");
        System.err.println("*  to add setApplet is available at                            *");
        System.err.println("*   http://www.coolshare.com/html/src/caller_cs.java           *");
        System.err.println("*                                                              *");
        System.err.println("****************************************************************");
        System.err.println("");
    }

    public void setFirstImageFileURL(String string) {
        this.m_firstImageFileURL = string;
        if (this.m_applet == null) {
            this.printError_0();
            return;
        }
        int n = string.length();
        String string2 = string.substring(0, n - 5);
        String string3 = string.substring(n - 4, n);
        this.tracker = new MediaTracker(this);
        this.m_processImages = new Image[this.m_numImage + 1];
        int n2 = 1;
        while (n2 <= this.m_numImage) {
            try {
                URL uRL = new URL(this.m_applet.getDocumentBase(), String.valueOf(string2) + n2 + string3);
                this.m_processImages[n2] = this.m_applet.getImage(uRL);
                this.tracker.addImage(this.m_processImages[n2], 0);
            }
            catch (Exception exception) {
                System.err.println("Exception" + exception + " - m_processImages[" + n2 + "] is invalid");
                this.m_doAnimtion = false;
                this.m_firstImageFileURL = "can't load image file";
                this.updateData();
                this.repaint();
                return;
            }
            ++n2;
        }
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.repaint();
    }

    public int getSoundMode() {
        return this.m_soundMode;
    }

    public void setSoundMode(int n) {
        this.m_soundMode = n;
    }

    public int getNumImage() {
        return this.m_numImage;
    }

    public void setNumImage(int n) {
        this.m_numImage = n;
        this.repaint();
    }

    public int getSoundPlayStyle() {
        return this.m_soundPlayStyle;
    }

    public void setSoundPlayStyle(int n) {
        this.m_soundPlayStyle = n;
    }

    public int getAnimationSpeed() {
        return this.m_animationSpeed;
    }

    public void setAnimationSpeed(int n) {
        this.m_animationSpeed = n;
    }

    public boolean isSelfTest() {
        return this.m_selfTest;
    }

    public void setSelfTest(boolean bl) {
        this.m_selfTest = bl;
    }

    private void updateData() {
        this.m_height = this.size().height;
        this.m_width = this.size().width;
        this.m_doAnimtion &= this.m_firstImageFileURL != null && !this.m_firstImageFileURL.equals("") && this.m_numImage > 0;
        this.m_doSound = this.m_soundURLText != null && !this.m_soundURLText.equals("");
    }

    public void paint(Graphics graphics) {
        this.updateData();
        if (!this.m_loaded) {
            this.m_loaded = true;
            this.setSoundURL(this.m_soundURLText);
            this.prepareImage();
        }
        this.setStates();
        this.m_barWidth = this.m_width - this.m_height;
        if (!this.m_doAnimtion) {
            this.m_barWidth = this.m_width;
        }
        graphics.setColor(this.m_barBackground);
        graphics.fillRect(0, 0, this.m_barWidth, this.m_height);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, this.m_barWidth, 0);
        graphics.drawLine(0, 0, 0, this.m_height);
        graphics.setColor(Color.black.brighter());
        graphics.drawLine(1, 1, this.m_barWidth - 1, 1);
        graphics.drawLine(1, 1, 1, this.m_height - 1);
        graphics.setColor(this.m_outerTLShadowColor);
        graphics.drawLine(2, this.m_height - 1, this.m_barWidth - 1, this.m_height - 1);
        graphics.drawLine(this.m_barWidth - 1, this.m_height - 1, this.m_barWidth - 1, 1);
        graphics.setColor(this.m_outerBRShadowColor);
        graphics.drawLine(2, this.m_height - 2, this.m_barWidth - 2, this.m_height - 2);
        graphics.drawLine(this.m_barWidth - 2, this.m_height - 2, this.m_barWidth - 2, 2);
        this.paintBar(graphics);
        this.drawAnimation(this.m_currentImage);
    }

    private void paintBar(Graphics graphics) {
        Object object;
        if (this.m_percentage != 0) {
            int n = (int)((double)this.m_barWidth / 100.0 * (double)this.m_percentage);
            if (n > this.m_barWidth - 3) {
                n = this.m_barWidth - 3;
            }
            object = new int[6];
            int[] nArray = new int[6];
            int n2 = n;
            int n3 = this.m_height;
            int n4 = this.m_bevel;
            int n5 = this.m_bevel;
            object[0] = false;
            nArray[0] = 0;
            object[1] = false;
            nArray[1] = n3;
            object[2] = n4;
            nArray[2] = n3 - n5;
            object[3] = n4;
            nArray[3] = n5;
            object[4] = n2 - n4;
            nArray[4] = n5;
            object[5] = n2;
            nArray[5] = 0;
            graphics.setColor(this.m_innerTLShadowColor);
            graphics.fillPolygon((int[])object, nArray, 6);
            graphics.setColor(this.m_barForeground);
            graphics.fillRect(2 + this.m_bevel, 2 + this.m_bevel, n - 2 * this.m_bevel, this.m_height - 4 - 2 * this.m_bevel);
            graphics.setColor(this.m_innerBRShadowColor);
            graphics.drawLine(0, 0, n4, n5);
            object[0] = n2;
            nArray[0] = n3;
            object[1] = false;
            nArray[1] = n3;
            object[2] = n4;
            nArray[2] = n3 - n5;
            object[3] = n2 - n4;
            nArray[3] = n3 - n5;
            object[4] = n2 - n4;
            nArray[4] = n5;
            object[5] = n2;
            nArray[5] = 0;
            graphics.fillPolygon((int[])object, nArray, 6);
            graphics.setColor(this.m_innerTLShadowColor);
            graphics.drawLine(n2 - n4, n3 - n5, n2, n3);
        }
        if (this.m_displayText) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            object = String.valueOf(String.valueOf(this.m_percentage)) + "%";
            graphics.setColor(this.m_outerTLShadowColor);
            graphics.drawString((String)object, (this.m_barWidth - fontMetrics.stringWidth((String)object)) / 2 - 1, this.m_height / 2 + fontMetrics.getHeight() / 2 - 1);
            graphics.setColor(this.m_textColor);
            graphics.drawString((String)object, (this.m_barWidth - fontMetrics.stringWidth((String)object)) / 2, this.m_height / 2 + fontMetrics.getHeight() / 2);
        }
    }

    private void setStates() {
        this.startProcess();
        this.stopProcess();
        this.startSound(false);
        this.stopSound(false);
    }

    private void startProcess() {
        if (!this.m_processing && this.m_percentage < 100 && this.m_percentage > 0) {
            this.m_processing = true;
            if (this.m_doAnimtion) {
                if (this.threadProcessAnimator == null) {
                    this.threadProcessAnimator = new Thread(this);
                }
                this.threadProcessAnimator.start();
            }
            if (this.releaseLevel != this.TheShareware) {
                this.m_tipsText = this.m_coolshareAd;
            }
        }
    }

    private void stopProcess() {
        if (this.m_processing && this.m_percentage >= 100 && this.threadProcessAnimator != null) {
            this.paintBar(this.getGraphics());
            this.m_processing = false;
            this.stopSound(true);
            if (this.m_doAnimtion) {
                this.threadProcessAnimator.stop();
                this.threadProcessAnimator = null;
            }
            if (this.releaseLevel != this.TheShareware) {
                this.m_tipsText = this.m_coolshareAd;
            }
        }
    }

    private void startSound(boolean bl) {
        if (this.m_doSound && this.m_processing && !this.m_soundPlaying && this.m_sound != null && this.m_soundMode == 0 || bl) {
            if (this.m_soundPlayStyle == 0) {
                this.m_sound.play();
            } else if (this.m_soundPlayStyle == 1) {
                this.m_sound.loop();
            }
            this.m_soundPlaying = true;
        }
    }

    private void stopSound(boolean bl) {
        if (this.m_doSound && !this.m_processing && this.m_soundPlaying && this.m_sound != null && this.m_soundMode == 0 || bl) {
            this.m_sound.stop();
            this.m_soundPlaying = false;
        }
    }

    private void drawAnimation(int n) {
        if (!this.m_doAnimtion) {
            return;
        }
        try {
            if (this.graphicsOffScreen != null && this.m_processImages[n] != null && this.tracker.checkID(0)) {
                this.graphicsOffScreen.setColor(Color.white);
                this.graphicsOffScreen.drawImage(this.m_processImages[n], 0, 0, this.m_buffWidth, this.m_buffHeight, this);
                this.getGraphics().drawImage(this.imageOffScreen, this.m_width - this.m_height, 0, this.m_height, this.m_height, this);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception" + exception + " - m_processImages[" + n + "] is invalid");
            this.m_doAnimtion = false;
            this.setFirstImageFileURL("can't load image file");
            this.updateData();
            this.repaint();
            return;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 15);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 30);
    }

    public void showTips() {
        this.openHints(this.m_tipsX, this.m_tipsY);
    }

    private void openHints(int n, int n2) {
        if (this.m_tipsText.equals("")) {
            return;
        }
        if (this.m_tips != null) {
            this.m_tips.dispose();
            this.m_tips = null;
        }
        Frame frame = new Frame();
        this.m_tips = new cootips(this, frame, this.m_tipsText);
        this.getGraphics().setFont(new Font("TimesRoman", 1, 10));
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        fontMetrics.stringWidth(this.m_tipsText);
        fontMetrics.getHeight();
        Math.random();
        this.m_tips.labtips.reshape(2, 2, this.m_tipsWidth - 2, this.m_tipsHeight - 2);
        ((Component)this.m_tips).reshape(n, n2, this.m_tipsWidth, this.m_tipsHeight);
        this.m_tips.show();
        this.m_tips.requestFocus();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 505) {
            this.cooscale_MouseExit(event);
            return true;
        }
        if (event.id == 504) {
            this.cooscale_MouseEnter(event);
            return true;
        }
        if (event.id == 502) {
            this.cooscale_MouseUp(event);
            return true;
        }
        return super.handleEvent(event);
    }

    void cooscale_MouseEnter(Event event) {
        this.openHints(this.m_tipsX, this.m_tipsY);
        if (this.m_soundMode == 1) {
            if (this.m_soundPlayStyle == 0 && this.m_sound != null) {
                this.m_sound.play();
            } else if (this.m_soundPlayStyle == 1 && this.m_sound != null) {
                this.m_sound.loop();
            }
        }
        if (this.m_selfTest) {
            this.m_percentage += 5;
            if (this.m_percentage > 100) {
                this.m_percentage = 0;
                this.repaint();
            }
            this.setStates();
            this.paintBar(this.getGraphics());
        }
    }

    void cooscale_MouseExit(Event event) {
        this.m_tips.dispose();
        this.setVisible(true);
        if (this.m_soundMode == 1 && this.m_sound != null) {
            this.m_sound.stop();
        }
    }

    void cooscale_MouseUp(Event event) {
        if (this.m_applet == null || this.releaseLevel == this.TheShareware) {
            if (this.m_applet == null) {
                this.printError_0();
            }
            return;
        }
        try {
            URL uRL = new URL(this.m_coolshareURL);
            this.m_applet.getAppletContext().showDocument(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Can't open URL");
            return;
        }
    }
}

