/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Vector;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.multimedia.ImageViewer;

public class SlideShow
extends Container {
    ActionListener actionListener;
    protected boolean isReshapeHack;
    protected int imageIndex;
    protected ImageViewer imageViewer;
    protected Vector urlList = new Vector();
    protected Vector images = new Vector();
    protected Vector descriptions = new Vector();
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SlideShow() {
        this.imageViewer = new ImageViewer();
        try {
            this.imageViewer.setStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageIndex = 0;
        this.setLayout(null);
        this.isReshapeHack = false;
    }

    public int getNumberOfImages() {
        if (this.urlList == null) {
            return 0;
        }
        return this.urlList.size();
    }

    public int getCurrentImageIndex() {
        return this.imageIndex;
    }

    public URL getURL(int index) {
        if (this.urlList == null) {
            return null;
        }
        return (URL)this.urlList.elementAt(index);
    }

    public void setDescription(int index, String str) throws PropertyVetoException {
        String oldValue = this.getDescription(index);
        this.vetos.fireVetoableChange("Description", oldValue, str);
        this.descriptions.setElementAt(str, index);
        this.changes.firePropertyChange("Description", oldValue, str);
    }

    public String getDescription(int index) {
        return (String)this.descriptions.elementAt(index);
    }

    public boolean isAtFirstImage() {
        return this.imageIndex == 0;
    }

    public boolean isAtLastImage() {
        return this.imageIndex == this.urlList.size() - 1;
    }

    public int setImage(int index) {
        if (index >= 0 && index < this.urlList.size()) {
            this.imageIndex = index;
            try {
                this.imageViewer.setImage((Image)this.images.elementAt(this.imageIndex));
            }
            catch (PropertyVetoException propertyVetoException) {}
            this.repaint();
        }
        return this.imageIndex;
    }

    public void setFirstImage(URL url) {
        if (url == null) {
            try {
                this.imageViewer.setImage(null);
            }
            catch (PropertyVetoException propertyVetoException) {}
            this.imageIndex = 0;
            this.urlList = new Vector();
            this.images = new Vector();
            this.descriptions = new Vector();
        } else if (this.urlList.size() != 0) {
            this.urlList.setElementAt(url, 0);
            this.descriptions.setElementAt("", 0);
            this.images.setElementAt(this.loadImageFromURL(url), 0);
            this.setImage(0);
        } else {
            this.addImageAndDescription(url, "");
        }
    }

    public void display() {
        this.imageIndex = 0;
        this.setImage(this.imageIndex);
        this.add(this.imageViewer);
        this.repaint();
        this.validate();
    }

    public int addImageAndDescription(URL url, String description) {
        this.urlList.addElement(url);
        this.descriptions.addElement(description);
        this.images.addElement(this.loadImageFromURL(url));
        int index = this.urlList.size() - 1;
        if (index == 0) {
            this.imageIndex = 0;
            this.setImage(this.imageIndex);
            this.add(this.imageViewer);
            this.repaint();
            this.validate();
        }
        return index;
    }

    public int nextImage() {
        if (!this.isAtLastImage()) {
            ++this.imageIndex;
            int rv = this.setImage(this.imageIndex);
            this.sourceActionEvent("nextImage");
            return rv;
        }
        return this.imageIndex;
    }

    public int previousImage() {
        if (!this.isAtFirstImage()) {
            --this.imageIndex;
            int rv = this.setImage(this.imageIndex);
            this.sourceActionEvent("previousImage");
            return rv;
        }
        return this.imageIndex;
    }

    public Dimension getPreferredSize() {
        Dimension d;
        block6: {
            d = new Dimension(10, 10);
            if (this.images == null || this.imageViewer == null) break block6;
            Image oldImage = this.imageViewer.getImage();
            int i = 0;
            while (i < this.images.size()) {
                if (this.images.elementAt(i) != null) {
                    try {
                        this.imageViewer.setImage((Image)this.images.elementAt(i));
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    Dimension imDim = this.imageViewer.getPreferredSize();
                    d.width = Math.max(imDim.width, d.width);
                    d.height = Math.max(imDim.height, d.height);
                }
                ++i;
            }
            try {
                this.imageViewer.setImage(oldImage);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        return d;
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.isReshapeHack = true;
        super.setBounds(x, y, width, height);
        this.imageViewer.setBounds(0, 0, width, height);
        this.isReshapeHack = false;
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (!this.isReshapeHack) {
            this.imageViewer.setBounds(0, 0, width, height);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void sourceActionEvent(String actionCommand) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
        }
    }

    protected Image loadImageFromURL(URL url) {
        Image image = null;
        try {
            image = this.getToolkit().getImage(url);
        }
        catch (Exception exception) {
            System.err.println("Error in SlideShow: Couldn't get image " + url);
        }
        return image;
    }
}

