/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class NervousText
extends Canvas
implements Runnable {
    char[] separated;
    String text;
    boolean paused = false;
    transient Thread jitter;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public NervousText() {
        try {
            this.setText("text");
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setText(String newText) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.text, newText)) {
            String oldText = this.text;
            this.vetos.fireVetoableChange("Text", oldText, newText);
            this.text = newText;
            this.changes.firePropertyChange("Text", oldText, newText);
            int length = this.text != null ? this.text.length() : 0;
            this.separated = new char[length];
            if (this.text != null) {
                this.text.getChars(0, length, this.separated, 0);
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setPaused(boolean newIsPaused) throws PropertyVetoException {
        if (this.paused != newIsPaused) {
            Boolean oldPausedBool = new Boolean(this.paused);
            Boolean newPausedBool = new Boolean(newIsPaused);
            this.vetos.fireVetoableChange("Paused", oldPausedBool, newPausedBool);
            this.paused = newIsPaused;
            this.changes.firePropertyChange("Paused", oldPausedBool, newPausedBool);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause(boolean f) {
        try {
            this.setPaused(f);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {}
            if (this.paused) continue;
            this.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.jitter = new Thread(this);
        this.jitter.start();
    }

    public synchronized void removeNotify() {
        if (this.jitter != null) {
            this.jitter.stop();
            this.jitter = null;
        }
        super.removeNotify();
    }

    public synchronized void show() {
        super.show();
        if (this.isVisible() && this.jitter != null) {
            this.jitter.resume();
        }
    }

    public synchronized void hide() {
        super.hide();
        if (!this.isVisible() && this.jitter != null) {
            this.jitter.suspend();
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.text.length()) {
            int x_coord = (int)(Math.random() * 10.0 + (double)(20 * i));
            int y_coord = (int)(Math.random() * 10.0 + 36.0);
            g.drawChars(this.separated, i, 1, x_coord, y_coord);
            ++i;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.size();
        Dimension min = this.getMinimumSize();
        return new Dimension(Math.max(dim.width, min.width), Math.max(dim.height, min.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.separated.length * 10, this.separated.length * 10);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }
}

