/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.Orientation;
import symantec.itools.awt.util.spinner.HorizontalSpinButtonPanel;
import symantec.itools.awt.util.spinner.SpinButtonPanel;
import symantec.itools.awt.util.spinner.VerticalSpinButtonPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;

public abstract class Spinner
extends Panel
implements Orientation,
Serializable {
    public final int ORIENTATION_DEFAULT = 0;
    protected int min;
    protected int max;
    protected int current;
    protected String text;
    protected int textWidth;
    protected TextField textField;
    protected int increment = 1;
    protected ActionListener actionListener;
    protected boolean textFieldAdded = false;
    protected SpinButtonPanel buttons;
    protected int gap = 2;
    private boolean editable;
    private boolean wrappable;
    private int orientation;
    private CurrentVeto currentVeto;
    private MaxVeto maxVeto;
    private MinVeto minVeto;
    private Action action;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected Spinner() {
        try {
            this.setWrappable(false);
            this.setMin(0);
            this.setMax(0);
            this.setCurrent(0);
            this.setOrientation(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.textWidth = -1;
        super.setLayout(null);
    }

    public void setEditable(boolean f) throws PropertyVetoException {
        if (this.editable != f) {
            Boolean oldValue = new Boolean(this.editable);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("editable", oldValue, newValue);
            this.editable = f;
            if (this.textFieldAdded) {
                this.setEditable();
            }
            this.changes.firePropertyChange("editable", oldValue, newValue);
        }
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setWrappable(boolean f) throws PropertyVetoException {
        if (this.wrappable != f) {
            Boolean oldValue = new Boolean(this.wrappable);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("wrappable", oldValue, newValue);
            this.wrappable = f;
            this.updateButtonStatus();
            this.changes.firePropertyChange("wrappable", oldValue, newValue);
        }
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public boolean getWrappable() {
        return this.isWrappable();
    }

    public void setMin(int i) throws PropertyVetoException {
        if (this.min != i) {
            Integer oldValue = new Integer(this.min);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("min", oldValue, newValue);
            this.min = i;
            if (this.getCurrent() < this.min) {
                this.setCurrent(this.min);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("min", oldValue, newValue);
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int i) throws PropertyVetoException {
        if (this.max != i) {
            Integer oldValue = new Integer(this.max);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("max", oldValue, newValue);
            this.max = i;
            if (this.getCurrent() > this.max) {
                this.setCurrent(this.max);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("max", oldValue, newValue);
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrent(int i) throws PropertyVetoException {
        if (this.current != i) {
            Integer oldValue = new Integer(this.current);
            Integer newValue = new Integer(i);
            this.vetos.fireVetoableChange("current", oldValue, newValue);
            this.current = i;
            this.updateText();
            this.updateButtonStatus();
            this.changes.firePropertyChange("current", oldValue, newValue);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public void setOrientation(int o) throws PropertyVetoException {
        Integer oldValue = new Integer(this.orientation);
        Integer newValue = new Integer(o);
        this.vetos.fireVetoableChange("orientation", oldValue, newValue);
        this.orientation = o;
        if (this.buttons != null) {
            this.remove(this.buttons);
        }
        switch (this.orientation) {
            case 0: {
                this.buttons = new VerticalSpinButtonPanel();
                break;
            }
            case 1: {
                this.buttons = new HorizontalSpinButtonPanel();
                break;
            }
        }
        if (this.textFieldAdded) {
            this.setStyle();
            this.invalidate();
            this.validate();
        }
        this.changes.firePropertyChange("orientation", oldValue, newValue);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setNotifyWhilePressed(boolean f) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.getNotifyWhilePressed());
        Boolean newValue = new Boolean(f);
        this.vetos.fireVetoableChange("notifyWhilePressed", oldValue, newValue);
        this.buttons.setNotifyWhilePressed(f);
        this.changes.firePropertyChange("notifyWhilePressed", oldValue, newValue);
    }

    public boolean isNotifyWhilePressed() {
        return this.buttons.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int d) throws PropertyVetoException {
        Integer oldValue = new Integer(this.getDelay());
        Integer newValue = new Integer(d);
        this.vetos.fireVetoableChange("delay", oldValue, newValue);
        this.buttons.setDelay(d);
        this.changes.firePropertyChange("delay", oldValue, newValue);
    }

    public int getDelay() {
        return this.buttons.getDelay();
    }

    public String getEntryFieldText() {
        if (!this.textFieldAdded) {
            return "";
        }
        return this.textField.getText();
    }

    public void setLayout(LayoutManager lm) {
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (!this.textFieldAdded) {
            this.textField = new TextField(this.textWidth > 0 ? this.textWidth : 10);
            ((Component)this.textField).setBackground(Color.white);
            this.add(this.textField);
            this.textFieldAdded = true;
        }
        this.setEditable();
        this.setStyle();
        this.updateText(true);
        if (this.action == null) {
            this.action = new Action();
            this.buttons.addActionListener(this.action);
            this.textField.addActionListener(this.action);
        }
        if (this.currentVeto == null) {
            this.currentVeto = new CurrentVeto();
            this.addCurrentListener(this.currentVeto);
        }
        if (this.maxVeto == null) {
            this.maxVeto = new MaxVeto();
            this.addMaxListener(this.maxVeto);
        }
        if (this.minVeto == null) {
            this.minVeto = new MinVeto();
            this.addMinListener(this.minVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.textField.removeActionListener(this.action);
            this.buttons.removeActionListener(this.action);
            this.action = null;
        }
        if (this.currentVeto != null) {
            this.removeCurrentListener(this.currentVeto);
            this.currentVeto = null;
        }
        if (this.maxVeto != null) {
            this.removeMaxListener(this.maxVeto);
            this.maxVeto = null;
        }
        if (this.minVeto != null) {
            this.removeMinListener(this.minVeto);
            this.minVeto = null;
        }
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        int width = 50;
        int height = 20;
        if (this.textFieldAdded && this.buttons != null) {
            Dimension t = this.textField.getPreferredSize();
            Dimension b = this.buttons.getPreferredSize();
            int macTextAdjustment = 0;
            int macPosAdjustment = 0;
            if (OS.isMacintosh()) {
                if (this.textWidth == 1) {
                    macPosAdjustment = 3;
                }
                macTextAdjustment = 2;
            }
            width = b.width + t.width + this.gap + macPosAdjustment;
            height = t.height + macTextAdjustment;
        }
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void doLayout() {
        if (this.textFieldAdded) {
            Dimension s = this.getSize();
            Dimension t = this.textField.getPreferredSize();
            int macTextAdjustment = 0;
            int macPosAdjustment = 0;
            if (OS.isMacintosh()) {
                if (this.textWidth == 1) {
                    macPosAdjustment = 3;
                }
                macTextAdjustment = 2;
            }
            this.textField.setBounds(macPosAdjustment, macTextAdjustment, t.width, t.height);
            this.buttons.setBounds(t.width + this.gap + macPosAdjustment, 0, t.height + macTextAdjustment, t.height + macTextAdjustment);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addCurrentListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("current", listener);
    }

    public void removeCurrentListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("current", listener);
    }

    public void addCurrentListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("current", listener);
    }

    public void removeCurrentListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("current", listener);
    }

    public void addMaxListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("max", listener);
    }

    public void removeMaxListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("max", listener);
    }

    public void addMaxListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("max", listener);
    }

    public void removeMaxListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("max", listener);
    }

    public void addMinListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("min", listener);
    }

    public void removeMinListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("min", listener);
    }

    public void addMinListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("min", listener);
    }

    public void removeMinListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("min", listener);
    }

    protected boolean isValidCurrentValue(int i) {
        return i <= this.max && i >= this.min;
    }

    protected boolean isValidMaxValue(int i) {
        return i >= this.min;
    }

    protected boolean isValidMinValue(int i) {
        return i <= this.max;
    }

    protected void sourceActionEvent(String s) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, s));
        }
    }

    protected void scrollUp() {
        try {
            this.setCurrent(this.current + this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.min);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.max);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText();
    }

    protected void scrollDown() {
        try {
            this.setCurrent(this.current - this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.max);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.min);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText();
    }

    protected void updateText(boolean force) {
        if (this.textFieldAdded) {
            String currentText = this.getCurrentText();
            if (force || !this.textField.getText().equals(currentText)) {
                ((TextComponent)this.textField).setText(currentText);
            }
        }
    }

    protected void updateText() {
        this.updateText(false);
    }

    protected void updateButtonStatus() {
        if (this.buttons != null) {
            if (this.wrappable) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.max && this.current == this.min) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(false);
            } else if (this.current == this.max) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(false);
            } else {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            }
        }
    }

    protected abstract String getCurrentText();

    private void setEditable() {
        this.textField.setEditable(this.editable);
    }

    private void setStyle() {
        this.add(this.buttons);
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            try {
                if ((TextField)e.getSource() == Spinner.this.textField) {
                    Spinner.this.updateText();
                    return;
                }
            }
            catch (ClassCastException classCastException) {}
            String cmdStr = "";
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Increment")) {
                Spinner.this.scrollUp();
                cmdStr = "ScrollUp";
                Spinner.this.sourceActionEvent(cmdStr);
            } else if (actionCommand.equals("Decrement")) {
                Spinner.this.scrollDown();
                cmdStr = "ScrollDown";
                Spinner.this.sourceActionEvent(cmdStr);
            }
        }

        Action() {
            Spinner.this = Spinner.this;
        }
    }

    class CurrentVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidCurrentValue(i)) {
                throw new PropertyVetoException("Invalid current value: " + i, e);
            }
        }

        CurrentVeto() {
            Spinner.this = Spinner.this;
        }
    }

    class MaxVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidMaxValue(i)) {
                throw new PropertyVetoException("Invalid max value: " + i, e);
            }
        }

        MaxVeto() {
            Spinner.this = Spinner.this;
        }
    }

    class MinVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!Spinner.this.isValidMinValue(i)) {
                throw new PropertyVetoException("Invalid min value: " + i, e);
            }
        }

        MinVeto() {
            Spinner.this = Spinner.this;
        }
    }
}

