/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.AWTEventMulticaster;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import symantec.itools.awt.DirectionButton;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class SpinButtonPanel
extends Panel {
    protected DirectionButton incButton;
    protected DirectionButton decButton;
    protected ActionListener actionListener;
    private Action action;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SpinButtonPanel() {
        this.incButton = new DirectionButton(2);
        this.decButton = new DirectionButton(3);
        try {
            this.incButton.setBevelHeight(1);
            this.decButton.setBevelHeight(1);
            this.incButton.setArrowIndent(1);
            this.decButton.setArrowIndent(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.add(this.incButton);
        this.add(this.decButton);
        try {
            this.setDelay(250);
            this.setNotifyWhilePressed(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setNotifyWhilePressed(boolean f) throws PropertyVetoException {
        this.incButton.setNotifyWhilePressed(f);
        this.decButton.setNotifyWhilePressed(f);
    }

    public boolean isNotifyWhilePressed() {
        return this.incButton.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int d) throws PropertyVetoException {
        this.incButton.setNotifyDelay(d);
        this.decButton.setNotifyDelay(d);
    }

    public int getDelay() {
        return this.incButton.getNotifyDelay();
    }

    public void setLayout(LayoutManager l) {
    }

    public synchronized void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            if (flag) {
                super.enable();
                this.incButton.setEnabled(true);
                this.decButton.setEnabled(true);
            } else {
                super.disable();
                this.incButton.setEnabled(false);
                this.decButton.setEnabled(false);
            }
        }
    }

    public synchronized void enable() {
        this.setEnabled(true);
    }

    public synchronized void disable() {
        this.setEnabled(false);
    }

    public synchronized void setUpButtonEnabled(boolean flag) {
        if (this.isUpButtonEnabled() != flag) {
            if (flag) {
                this.incButton.setEnabled(true);
            } else {
                this.incButton.setEnabled(false);
            }
        }
    }

    public boolean isUpButtonEnabled() {
        return this.incButton.isEnabled();
    }

    public synchronized void setDownButtonEnabled(boolean flag) {
        if (this.isDownButtonEnabled() != flag) {
            if (flag) {
                this.decButton.setEnabled(true);
            } else {
                this.decButton.setEnabled(false);
            }
        }
    }

    public boolean isDownButtonEnabled() {
        return this.decButton.isEnabled();
    }

    public synchronized void enableUpButton() {
        this.setUpButtonEnabled(true);
    }

    public synchronized void enableDownButton() {
        this.setDownButtonEnabled(true);
    }

    public synchronized void disableUpButton() {
        this.setUpButtonEnabled(false);
    }

    public synchronized void disableDownButton() {
        this.setDownButtonEnabled(false);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.action == null) {
            this.action = new Action();
            this.incButton.addActionListener(this.action);
            this.decButton.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.incButton.removeActionListener(this.action);
            this.decButton.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void sourceActionEvent(String actionCommand) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == SpinButtonPanel.this.incButton) {
                SpinButtonPanel.this.sourceActionEvent("Increment");
            } else if (source == SpinButtonPanel.this.decButton) {
                SpinButtonPanel.this.sourceActionEvent("Decrement");
            }
        }

        Action() {
            SpinButtonPanel.this = SpinButtonPanel.this;
        }
    }
}

