/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.TextComponent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.awt.util.spinner.Spinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ListSpinner
extends Spinner {
    protected Vector list;
    protected boolean dynamicResizing;
    private boolean editAdding = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ListSpinner() {
        this.list = new Vector();
        this.updateButtonStatus();
        try {
            this.setAllowDynamicResizing(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setListItems(String[] items) throws PropertyVetoException {
        String[] oldValue = this.getListItems();
        if (!GeneralUtils.objectsEqual(oldValue, items)) {
            this.vetos.fireVetoableChange("listItems", oldValue, items);
            int i = 0;
            while (i < items.length) {
                this.addItem(items[i]);
                ++i;
            }
            this.updateText();
            this.changes.firePropertyChange("listItems", oldValue, items);
        }
    }

    public String[] getListItems() {
        int len = this.list.size();
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = (String)this.list.elementAt(i);
            ++i;
        }
        return items;
    }

    public void setAllowDynamicResizing(boolean f) throws PropertyVetoException {
        if (this.dynamicResizing != f) {
            Boolean oldValue = new Boolean(this.dynamicResizing);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("allowDynamicResizing", oldValue, newValue);
            this.dynamicResizing = f;
            this.changes.firePropertyChange("allowDynamicResizing", oldValue, newValue);
        }
    }

    public boolean isAllowDynamicResizing() {
        return this.dynamicResizing;
    }

    public String getCurrentText() {
        return this.list.size() > 0 ? (String)this.list.elementAt(this.current) : null;
    }

    public void addNotify() {
        if (this.list.size() > 0) {
            int oldTextWidth = this.textWidth;
            Enumeration e = this.list.elements();
            while (e.hasMoreElements()) {
                this.textWidth = Math.max(this.textWidth, ((String)e.nextElement()).length());
            }
            if (this.textFieldAdded && this.textWidth != oldTextWidth) {
                this.textField.setColumns(this.textWidth);
            }
            this.text = (String)this.list.elementAt(this.current);
        }
        super.addNotify();
    }

    public void addItem(String s) {
        int oldTextWidth = this.textWidth;
        this.list.addElement(s);
        this.textWidth = Math.max(this.textWidth, s.length());
        if (this.textFieldAdded && this.textWidth != oldTextWidth && this.dynamicResizing && this.editAdding) {
            this.textField.setColumns(this.textWidth);
        }
        this.invalidate();
        this.validate();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void updateText() {
        if (this.textFieldAdded) {
            String currentText = this.getCurrentText();
            if (!this.textField.getText().equals(currentText)) {
                if (!this.list.contains(this.textField.getText()) && !this.textField.getText().equals("")) {
                    this.editAdding = true;
                    this.addItem(this.textField.getText());
                } else {
                    this.editAdding = false;
                }
            }
            ((TextComponent)this.textField).setText(this.getCurrentText());
        }
    }

    protected boolean isValidMaxValue(int i) {
        return i >= this.min && i < this.list.size();
    }

    protected boolean isValidMinValue(int i) {
        return i <= this.max && i >= 0;
    }
}

