/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import symantec.itools.awt.BaseTabbedPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class TabPanel
extends BaseTabbedPanel
implements Serializable {
    private PropertyChange myPropertyChangeHandler = new PropertyChange();
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    Vector vPanels = new Vector();
    String[] labels;
    transient boolean bOsHack;

    public TabPanel() {
        this(0, 0);
    }

    public TabPanel(boolean bTabsOnTop) {
        this(bTabsOnTop ? 0 : 1, bTabsOnTop ? 0 : 1);
    }

    public TabPanel(int tabsPostion, int tabsStyle) {
        super(tabsPostion, tabsStyle);
        String sOS = System.getProperty("os.name");
        this.bOsHack = sOS.equals("Windows 95");
        super.addCurrentTabListener(this.myPropertyChangeHandler);
    }

    public int getCurrentPanelNdx() {
        return this.curIndex;
    }

    public void setCurrentPanelNdx(int index) throws PropertyVetoException {
        if (index != this.curIndex) {
            Integer oldindex = new Integer(this.curIndex);
            Integer newindex = new Integer(index);
            this.vetos.fireVetoableChange("CurrentPanelNdx", oldindex, newindex);
            this.showTabPanel(index);
            if (!Beans.isDesignTime()) {
                this.curIndex = index;
            }
            this.changes.firePropertyChange("CurrentPanelNdx", oldindex, newindex);
        }
    }

    public void setPanelLabels(String[] sLabels) throws PropertyVetoException {
        String[] oldLabels = this.labels;
        this.vetos.fireVetoableChange("PanelLabels", oldLabels, sLabels);
        this.labels = sLabels;
        this.updatePanelLabels();
        this.changes.firePropertyChange("PanelLabels", oldLabels, sLabels);
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public void setPanelLabel(String newLabel, int labelIndex) throws PropertyVetoException {
        if (labelIndex >= 0 && labelIndex < this.labels.length && this.labels[labelIndex] != newLabel) {
            String oldLabel = this.labels[labelIndex];
            this.vetos.fireVetoableChange("PanelLabel", oldLabel, newLabel);
            this.labels[labelIndex] = newLabel;
            this.updatePanelLabels();
            this.changes.firePropertyChange("PanelLabel", oldLabel, newLabel);
        }
    }

    public String getPanelLabel(int labelIndex) {
        return labelIndex >= 0 && labelIndex < this.labels.length ? this.labels[labelIndex] : null;
    }

    public void setTabsOnBottom(boolean bTabsOnBottom) throws PropertyVetoException {
        Boolean newValue;
        Boolean oldValue = new Boolean(this.getTabsOnBottom());
        if (!oldValue.equals(newValue = new Boolean(bTabsOnBottom))) {
            this.vetos.fireVetoableChange("TabsOnBottom", oldValue, newValue);
            this.setTabsInfo(bTabsOnBottom ? 1 : 0, bTabsOnBottom ? 1 : 0);
            this.layout();
            this.changes.firePropertyChange("TabsOnBottom", oldValue, newValue);
        }
    }

    public boolean isTabsOnBottom() {
        return this.getTabsPosition() != 0;
    }

    public boolean getTabsOnBottom() {
        return this.isTabsOnBottom();
    }

    public synchronized void setTabPanel(String sLabel, boolean bEnabled, Component panel, int index) throws PropertyVetoException {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        if (index == this.getCurrentTab() && !bEnabled) {
            return;
        }
        try {
            Component oldPanel = (Component)this.vPanels.elementAt(index);
            this.vetos.fireVetoableChange("TabPanel", oldPanel, panel);
            this.vPanels.setElementAt(panel, index);
            this.setTab(sLabel, bEnabled, index);
            this.changes.firePropertyChange("TabPanel", oldPanel, panel);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized Component getTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return null;
        }
        Component p = null;
        try {
            p = (Component)this.vPanels.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return p;
    }

    public synchronized int getPanelTabIndex(Component panel) {
        return this.vPanels.indexOf(panel);
    }

    public synchronized void showTabPanel(int index) {
        block3: {
            if (!this.isEnabled(index)) break block3;
            try {
                Component p = (Component)this.vPanels.elementAt(index);
                this.setCurrentTab(index);
                this.showPanel(p);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public int addTabPanel(String sLabel, boolean bEnabled, Component panel) {
        return this.addTabPanel(sLabel, bEnabled, panel, -1);
    }

    public int addTabPanel(String sLabel, boolean bEnabled, Component panel, int pos) {
        if (pos == -1) {
            this.vPanels.addElement(panel);
        } else {
            this.vPanels.insertElementAt(panel, pos);
        }
        return this.addTab(sLabel, bEnabled, pos);
    }

    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    public synchronized Component add(Component comp, int pos) {
        boolean wasSuppressingRepaints = this.setSuppressRepaints(true);
        try {
            int newIndex = this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, comp, pos);
            if (newIndex == this.curIndex || Beans.isDesignTime()) {
                this.showTabPanel(newIndex);
            }
            this.updatePanelLabels();
        }
        finally {
            Object var5_5 = null;
            this.setSuppressRepaints(wasSuppressingRepaints);
        }
        this.triggerRepaint();
        return comp;
    }

    public synchronized Component add(String name, Component comp) {
        return comp;
    }

    public synchronized void remove(Component comp) {
        int i = this.getPanelTabIndex(comp);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
        } else {
            if (i == 0) {
                this.showTabPanel(1);
            } else {
                this.showTabPanel(i - 1);
            }
            this.removeTabPanel(i);
        }
    }

    public void updatePanelLabels() {
        try {
            int i = 0;
            while (i < this.vPanels.size()) {
                String newlabel;
                if (this.labels != null) {
                    try {
                        newlabel = this.labels[i];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        newlabel = this.createDefaultLabel(i);
                    }
                } else {
                    newlabel = this.createDefaultLabel(i);
                }
                this.setLabel(newlabel, i);
                ++i;
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void enableTabPanel(boolean bEnable, int index) throws PropertyVetoException {
        if (index < 0 || index >= this.vPanels.size() || index == this.curIndex) {
            return;
        }
        this.setEnabled(bEnable, index);
    }

    public synchronized void insertTabPanel(String sLabel, boolean bEnabled, Component panel, int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        if (index == this.getCurrentTab() && !bEnabled) {
            return;
        }
        try {
            this.vPanels.insertElementAt(panel, index);
            this.insertTab(sLabel, bEnabled, index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized void removeTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size() || index == this.curIndex) {
            return;
        }
        try {
            Component p = (Component)this.vPanels.elementAt(index);
            super.remove(p);
            this.vPanels.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.removeTab(index);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public Dimension getPreferredSize() {
        Dimension p = this.size();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    private String createDefaultLabel(int i) {
        String name = "tab - ";
        name = String.valueOf(name) + String.valueOf(i);
        return name;
    }

    class PropertyChange
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent e) {
            TabPanel.this.showTabPanel((Integer)e.getNewValue());
        }

        PropertyChange() {
            TabPanel.this = TabPanel.this;
        }
    }
}

