/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Label;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.BorderPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class StatusBar
extends BorderPanel {
    protected Label text;
    protected Color textColor;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public StatusBar() {
        super.setLayout(new BorderLayout());
        this.text = new Label();
        this.add("Center", this.text);
    }

    public void setStatusText(String s) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.text.getText(), s)) {
            String oldText = this.text.getText();
            this.vetos.fireVetoableChange("StatusText", oldText, s);
            this.text.setText(s);
            this.repaint();
            this.changes.firePropertyChange("StatusText", oldText, s);
        }
    }

    public String getStatusText() {
        return this.text.getText();
    }

    public void setStatusTextColor(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textColor, c)) {
            Color oldColor = this.textColor;
            this.vetos.fireVetoableChange("StatusTextColor", oldColor, c);
            this.textColor = c;
            this.text.setForeground(c);
            this.repaint();
            this.changes.firePropertyChange("StatusTextColor", oldColor, c);
        }
    }

    public Color getStatusTextColor() {
        return this.textColor;
    }

    public void setLayout(LayoutManager l) {
    }

    public void clear() {
        try {
            this.setStatusText("");
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }
}

