/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class SplitterPanel
extends Panel {
    public static final int SPLIT_VERTICAL = 1;
    public static final int SPLIT_HORIZONTAL = 2;
    public static final int SPLIT_VER = 1;
    public static final int SPLIT_HOR = 2;
    public static final int SPLIT_BOTH = 3;
    public static final int SPLIT_BOTH_V = 4;
    public static final int SPLIT3_LEFT = 5;
    public static final int SPLIT3_RIGHT = 6;
    public static final int SPLIT3_TOP = 7;
    public static final int SPLIT3_BOTTOM = 8;
    protected boolean use3dBdr = true;
    protected Cursor moveSplitCursor = new Cursor(13);
    protected Dimension minDim;
    protected Dimension prefDim;
    protected Dimension curDim;
    protected int iGapWidth;
    protected int iGapHeight;
    protected int oGapWidth;
    protected int oGapHeight;
    protected int iBdrSize;
    protected int oBdrSize;
    protected int splitType;
    protected int moveFromX;
    protected int moveFromY;
    protected static final int SPLIT_NONE = 0;
    protected transient boolean bOsFlag;
    protected boolean enforceMinDim = false;
    protected boolean propResize = true;
    protected boolean isOuter;
    protected boolean heightOnly;
    protected boolean widthOnly;
    protected transient boolean doMoveSplit = false;
    protected transient boolean cursorChanged = false;
    protected boolean allowDynamicMoving;
    protected SplitterPanel sub1;
    protected SplitterPanel sub2;
    protected SplitterPanel innerSP;
    protected SplitterPanel outerSP;
    protected static SplitterPanel cursorCh = null;
    protected Point curLoc;
    protected Component spComponent;
    protected Color gapColor;
    private Mouse mouse;
    private MouseMtn mouseMotion;
    private STVeto stVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SplitterPanel() {
        this(true);
    }

    public SplitterPanel(int spWidth, int spHeight) {
        this(true);
        if (this == null) {
            return;
        }
        this.resize(spWidth, spHeight);
    }

    public SplitterPanel(int spWidth, int spHeight, int splitSpec) {
        this(splitSpec);
        if (this == null) {
            return;
        }
        this.resize(spWidth, spHeight);
    }

    public SplitterPanel(int splitSpec) {
        this(splitSpec, null, null, null, null);
    }

    public SplitterPanel(int splitSpec, Component compR1C1, Component compR1C2, Component compR2C1, Component compR2C2) {
        this(true);
        if (this == null) {
            return;
        }
        switch (splitSpec) {
            case 0: {
                if (compR1C1 == null) break;
                this.add(compR1C1);
                break;
            }
            case 1: {
                this.split(1, compR1C1, compR1C2);
                break;
            }
            case 2: {
                this.split(2, compR1C1, compR2C1);
                break;
            }
            case 3: {
                this.split(2);
                this.getSubPanel(1).split(1, compR1C1, compR1C2);
                this.getSubPanel(2).split(1, compR2C1, compR2C2);
                break;
            }
            case 4: {
                this.split(1);
                this.getSubPanel(1).split(2, compR1C1, compR2C1);
                this.getSubPanel(2).split(2, compR1C2, compR2C2);
                break;
            }
            case 5: {
                this.split(1, null, compR1C2);
                this.getSubPanel(1).split(2, compR1C1, compR2C1);
                break;
            }
            case 6: {
                this.split(1, compR1C1, null);
                this.getSubPanel(2).split(2, compR1C2, compR2C2);
                break;
            }
            case 7: {
                this.split(2, null, compR2C1);
                this.getSubPanel(1).split(1, compR1C1, compR1C2);
                break;
            }
            case 8: {
                this.split(2, compR1C1, null);
                this.getSubPanel(2).split(1, compR2C1, compR2C2);
                break;
            }
        }
    }

    private SplitterPanel(boolean isOuter) {
        this.isOuter = isOuter;
        this.heightOnly = false;
        this.widthOnly = false;
        this.allowDynamicMoving = false;
        this.splitType = 0;
        this.minDim = new Dimension(0, 0);
        this.curDim = new Dimension(0, 0);
        this.curLoc = new Point(0, 0);
        this.prefDim = new Dimension(0, 0);
        try {
            this.setGapColor(Color.lightGray);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.iGapWidth = 3;
        this.iGapHeight = 3;
        this.iBdrSize = 2;
        this.oGapWidth = 3;
        this.oGapHeight = 3;
        this.oBdrSize = 2;
        if (isOuter) {
            this.innerSP = new SplitterPanel(false);
            super.add((Component)this.innerSP, -1);
            this.outerSP = this;
            this.innerSP.outerSP = this;
            this.layout();
        }
    }

    public void setUse3DBorder(boolean flag) throws PropertyVetoException {
        if (this.use3dBdr != flag) {
            Boolean oldValue = new Boolean(this.use3dBdr);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("Use3DBorder", oldValue, newValue);
            this.use3dBdr = flag;
            this.changes.firePropertyChange("Use3DBorder", oldValue, newValue);
        }
    }

    public boolean isUse3DBorder() {
        return this.use3dBdr;
    }

    public void setAllowDynamicMoving(boolean flag) throws PropertyVetoException {
        if (this.allowDynamicMoving != flag) {
            Boolean oldValue = new Boolean(this.allowDynamicMoving);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("AllowDynamicMoving", oldValue, newValue);
            this.allowDynamicMoving = flag;
            this.propagateChanges();
            this.changes.firePropertyChange("AllowDynamicMoving", oldValue, newValue);
        }
    }

    public boolean isAllowDynamicMoving() {
        return this.allowDynamicMoving;
    }

    public int getSplitType() {
        SplitterPanel targetSP = this;
        if (this.isOuter) {
            targetSP = this.innerSP;
        }
        return targetSP.splitType;
    }

    public void setMoveSplitCursor(Cursor newCursor) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.moveSplitCursor, newCursor)) {
            Cursor oldValue = this.moveSplitCursor;
            this.vetos.fireVetoableChange("MoveSplitCursor", oldValue, newCursor);
            this.moveSplitCursor = newCursor;
            this.changes.firePropertyChange("MoveSplitCursor", oldValue, newCursor);
        }
    }

    public void setMoveSplitCursor(int newCursor) throws PropertyVetoException, IllegalArgumentException {
        this.setMoveSplitCursor(new Cursor(newCursor));
    }

    public Cursor getMoveSplitCursor() {
        return this.moveSplitCursor;
    }

    public void setGapColor(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.gapColor, c)) {
            Color oldValue = this.gapColor;
            this.vetos.fireVetoableChange("GapColor", oldValue, c);
            this.gapColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.propagateChanges();
            this.changes.firePropertyChange("GapColor", oldValue, c);
        }
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public Color gapColor() {
        return this.getGapColor();
    }

    public void setEnforceMinDim(boolean theFlag) throws PropertyVetoException {
        if (this.enforceMinDim != theFlag) {
            Boolean oldValue = new Boolean(this.enforceMinDim);
            Boolean newValue = new Boolean(theFlag);
            this.vetos.fireVetoableChange("EnforceMinDim", oldValue, newValue);
            this.enforceMinDim = theFlag;
            this.propagateChanges();
            this.changes.firePropertyChange("EnforceMinDim", oldValue, newValue);
        }
    }

    public boolean isEnforceMinDim() {
        return this.enforceMinDim;
    }

    public boolean getEnforceMinDim() {
        return this.isEnforceMinDim();
    }

    public void setPropResize(boolean theFlag) throws PropertyVetoException {
        if (this.propResize != theFlag) {
            Boolean oldValue = new Boolean(this.propResize);
            Boolean newValue = new Boolean(theFlag);
            this.vetos.fireVetoableChange("PropResize", oldValue, newValue);
            this.propResize = theFlag;
            this.propagateChanges();
            this.changes.firePropertyChange("PropResize", oldValue, newValue);
        }
    }

    public boolean isPropResize() {
        return this.propResize;
    }

    public boolean getPropResize() {
        return this.isPropResize();
    }

    public void setGapSizes(int gapSize) {
        this.iGapWidth = gapSize;
        this.iGapHeight = gapSize;
        this.oGapWidth = gapSize;
        this.oGapHeight = gapSize;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setGapSizes(int gapWidth, int gapHeight) {
        this.iGapWidth = gapWidth;
        this.iGapHeight = gapHeight;
        this.oGapWidth = gapWidth;
        this.oGapHeight = gapHeight;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setGapSizes(int iGapWidth, int iGapHeight, int oGapWidth, int oGapHeight) {
        this.iGapWidth = iGapWidth;
        this.iGapHeight = iGapHeight;
        this.oGapWidth = oGapWidth;
        this.oGapHeight = oGapHeight;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setBdrSizes(int iBdrSize, int oBdrSize) {
        this.iBdrSize = iBdrSize;
        this.oBdrSize = oBdrSize;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setBdrSizes(int bdrSize) {
        this.iBdrSize = bdrSize;
        this.oBdrSize = bdrSize;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public SplitterPanel getSubPanel(int n) {
        SplitterPanel targetSP = this;
        if (this.isOuter) {
            targetSP = this.innerSP;
        }
        if (n == 1) {
            return targetSP.sub1;
        }
        if (n == 2) {
            return targetSP.sub2;
        }
        return null;
    }

    public SplitterPanel getSubPanel(int n, int theSplitType) {
        if (this.getSplitType() == theSplitType) {
            return this.getSubPanel(n);
        }
        return null;
    }

    public SplitterPanel getSub2Panel(int n1, int theSplitType1, int n2, int theSplitType2) {
        SplitterPanel theSP = this.getSubPanel(n1, theSplitType1);
        if (theSP != null) {
            return theSP.getSubPanel(n2, theSplitType2);
        }
        return null;
    }

    public SplitterPanel getTopPanel() {
        return this.getSubPanel(1, 2);
    }

    public SplitterPanel getBottomPanel() {
        return this.getSubPanel(2, 2);
    }

    public SplitterPanel getLeftPanel() {
        return this.getSubPanel(1, 1);
    }

    public SplitterPanel getRightPanel() {
        return this.getSubPanel(2, 1);
    }

    public SplitterPanel getTopLeftPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(1, 2, 1, 1);
        }
        return this.getSub2Panel(1, 1, 1, 2);
    }

    public SplitterPanel getTopRightPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(1, 2, 2, 1);
        }
        return this.getSub2Panel(2, 1, 1, 2);
    }

    public SplitterPanel getBottomLeftPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(2, 2, 1, 1);
        }
        return this.getSub2Panel(1, 1, 2, 2);
    }

    public SplitterPanel getBottomRightPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(2, 2, 2, 1);
        }
        return this.getSub2Panel(2, 1, 2, 2);
    }

    public int iGapWidth() {
        return this.iGapWidth;
    }

    public int iGapHeight() {
        return this.iGapHeight;
    }

    public int oGapWidth() {
        return this.oGapWidth;
    }

    public int oGapHeight() {
        return this.oGapHeight;
    }

    public int iBdrSize() {
        return this.iBdrSize;
    }

    public int oBdrSize() {
        return this.oBdrSize;
    }

    public synchronized void layout() {
        this.placeComponents();
    }

    public void moveSplit(int spX, int spY) {
        int newY2;
        int newX2;
        int newWidth2;
        int newWidth1;
        int newHeight1;
        int newHeight2;
        if (this.isOuter) {
            this.innerSP.moveSplit(spX, spY);
            return;
        }
        Dimension min1 = this.sub1.minimumSize();
        Dimension min2 = this.sub2.minimumSize();
        Rectangle cur1 = new Rectangle(this.sub1.curLoc.x, this.sub1.curLoc.y, this.sub1.curDim.width, this.sub1.curDim.height);
        Rectangle cur2 = new Rectangle(this.sub2.curLoc.x, this.sub2.curLoc.y, this.sub2.curDim.width, this.sub2.curDim.height);
        int newX1 = cur1.x;
        int newY1 = cur1.y;
        if (this.splitType == 2) {
            if (spY == 0) {
                return;
            }
            if (spY > 0) {
                newHeight2 = this.enforceMinDim ? Math.max(cur2.height - spY, min2.height) : Math.max(cur2.height - spY, 2 * this.iBdrSize);
                newHeight1 = cur1.height + cur2.height - newHeight2;
            } else {
                newHeight1 = this.enforceMinDim ? Math.max(cur1.height + spY, min1.height) : Math.max(cur1.height + spY, 2 * this.iBdrSize);
                newHeight2 = cur2.height + cur1.height - newHeight1;
            }
            newWidth1 = cur1.width;
            newWidth2 = cur2.width;
            newX2 = cur2.x;
            newY2 = cur2.y - cur1.height + newHeight1;
            this.sub1.reshapeHeight(newY1, newHeight1);
            this.sub2.reshapeHeight(newY2, newHeight2);
        }
        if (this.splitType == 1) {
            if (spX == 0) {
                return;
            }
            if (spX > 0) {
                newWidth2 = this.enforceMinDim ? Math.max(cur2.width - spX, min2.width) : Math.max(cur2.width - spX, 2 * this.iBdrSize);
                newWidth1 = cur1.width + cur2.width - newWidth2;
            } else {
                newWidth1 = this.enforceMinDim ? Math.max(cur1.width + spX, min1.width) : Math.max(cur1.width + spX, this.iBdrSize);
                newWidth2 = cur2.width + cur1.width - newWidth1;
            }
            newHeight1 = cur1.height;
            newHeight2 = cur2.height;
            newY2 = cur2.y;
            newX2 = cur2.x - cur1.width + newWidth1;
            this.sub1.reshapeWidth(newX1, newWidth1);
            this.sub2.reshapeWidth(newX2, newWidth2);
        }
        this.sub1.invalidate();
        this.sub1.validate();
        this.sub1.repaint();
        this.sub2.invalidate();
        this.sub2.validate();
        this.sub2.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        Dimension d = this.size();
        Color bgColor = this.getBackground();
        g.setColor(bgColor);
        if (this.isOuter) {
            g.setColor(this.gapColor);
            g.fillRect(0, 0, d.width, d.height);
            this.draw3DBdr(g, 0, 0, d.width - 1, d.height - 1, this.oBdrSize, this.gapColor, true);
        } else if (this.splitType == 0) {
            g.setColor(bgColor);
            g.fillRect(0, 0, d.width, d.height);
            this.draw3DBdr(g, 0, 0, d.width - 1, d.height - 1, this.iBdrSize, this.gapColor, false);
        } else {
            g.setColor(this.gapColor);
            g.fillRect(0, 0, d.width, d.height);
        }
        super.paint(g);
    }

    public Component getComponent() {
        if (this.isOuter) {
            return this.innerSP.getComponent();
        }
        return this.spComponent;
    }

    public Component[] getComponents() {
        if (this.isOuter) {
            return this.innerSP.getComponents();
        }
        return super.getComponents();
    }

    public int getComponentCount() {
        if (this.isOuter) {
            return this.innerSP.getComponentCount();
        }
        return super.getComponentCount();
    }

    public Dimension preferredSize() {
        Dimension p = this.size();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension minimumSize() {
        Dimension theDim;
        if (this.isOuter) {
            theDim = new Dimension(this.innerSP.minimumSize());
            theDim.width += 2 * (this.oGapWidth + this.oBdrSize);
            theDim.height += 2 * (this.oGapHeight + this.oBdrSize);
        } else if (this.splitType == 0) {
            theDim = this.spComponent == null ? new Dimension(0, 0) : new Dimension(this.spComponent.minimumSize());
            theDim.width += 2 * this.iBdrSize;
            theDim.height += 2 * this.iBdrSize;
        } else {
            Dimension theDim1 = this.sub1.minimumSize();
            Dimension theDim2 = this.sub2.minimumSize();
            if (this.splitType == 2) {
                theDim = new Dimension(theDim1.width, theDim1.height + theDim2.height);
                theDim.height += this.iGapHeight;
            } else {
                theDim = new Dimension(theDim1.width + theDim1.width, theDim1.height);
                theDim.width += this.iGapWidth;
            }
        }
        return this.maxDimOf(this.minDim, theDim);
    }

    public void setPreferredSize(Dimension theDim) {
        this.prefDim.width = theDim.width;
        this.prefDim.height = theDim.height;
        this.prefDim = this.maxDimOf(theDim, this.prefDim);
        this.layout();
    }

    public void setMinimumSize(Dimension theDim) {
        this.minDim.width = theDim.width;
        this.minDim.height = theDim.height;
        this.prefDim = this.maxDimOf(theDim, this.prefDim);
        this.layout();
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (this.curDim.width != width || this.curDim.height != height || this.curLoc.x != x || this.curLoc.y != y) {
            this.layout();
            this.curDim.width = width;
            this.curDim.height = height;
            this.curLoc.x = x;
            this.curLoc.y = y;
        }
    }

    public synchronized void reshapeWidth(int x, int width) {
        Rectangle rect = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.curDim.width != width) {
            this.widthOnly = true;
            this.curDim.width = width;
        }
        this.reshape(x, rect.y, width, rect.height);
    }

    public synchronized void reshapeHeight(int y, int height) {
        Rectangle rect = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.curDim.height != height) {
            this.heightOnly = true;
            this.curDim.height = height;
        }
        this.reshape(rect.x, y, rect.width, height);
    }

    public synchronized Component add(Component comp, int pos) {
        if (comp == null) {
            return null;
        }
        if (this.isOuter) {
            return this.innerSP.add(comp, pos);
        }
        if (this.spComponent != null) {
            super.remove(this.spComponent);
        }
        this.spComponent = super.add(comp, -1);
        this.layout();
        return this.spComponent;
    }

    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    public synchronized void remove(Component comp) {
        if (this.isOuter) {
            this.innerSP.remove(comp);
        } else if (comp == this.spComponent) {
            this.spComponent = null;
            super.remove(comp);
        } else {
            if (this.sub1 != null) {
                this.sub1.remove(comp);
            }
            if (this.sub2 != null) {
                this.sub2.remove(comp);
            }
        }
    }

    public synchronized void removeAll() {
        if (this.isOuter) {
            this.innerSP.removeAll();
        } else {
            super.removeAll();
            if (this.sub1 != null) {
                super.add((Component)this.sub1, -1);
                this.sub1.removeAll();
            }
            if (this.sub2 != null) {
                super.add((Component)this.sub2, -1);
                this.sub1.removeAll();
            }
        }
        this.spComponent = null;
    }

    public SplitterPanel split(int splitType) {
        return this.split(splitType, null, null);
    }

    public synchronized SplitterPanel split(int splitType, Component theComp1, Component theComp2) {
        if (this.isOuter) {
            return this.innerSP.split(splitType, theComp1, theComp2);
        }
        if (this.splitType != 0) {
            return null;
        }
        if (splitType != 1 && splitType != 2) {
            return null;
        }
        this.sub1 = new SplitterPanel(false);
        if (this.sub1 == null) {
            return null;
        }
        this.sub2 = new SplitterPanel(false);
        if (this.sub2 == null) {
            super.remove(this.sub1);
            return null;
        }
        this.splitType = splitType;
        this.sub1.outerSP = this.outerSP;
        this.sub2.outerSP = this.outerSP;
        super.add((Component)this.sub1, -1);
        super.add((Component)this.sub2, -1);
        if (theComp1 != null) {
            this.sub1.add(theComp1);
        }
        if (theComp2 != null) {
            this.sub2.add(theComp2);
        }
        this.propagateChanges();
        return this.sub1;
    }

    public void setLayout(LayoutManager mgr) {
    }

    public void oGapThis(int x, int y) {
        if (!this.doMoveSplit && !this.inGap(x, y)) {
            this.resetCursor();
        }
    }

    public boolean oGapThis(Event evt) {
        this.oGapThis(evt.x, evt.y);
        return true;
    }

    public String toString() {
        String typeString = "Bad Panel ";
        if (this.isOuter) {
            typeString = "Outer ";
        } else {
            if (this.splitType == 0) {
                typeString = "Unsplit ";
            }
            if (this.splitType == 1) {
                typeString = "Vertically split ";
            }
            if (this.splitType == 2) {
                typeString = "Horizontally split ";
            }
        }
        Container theParent = this.getParent();
        String theParentString = theParent == null ? " with no parent (not added)" : " with parent @" + theParent.hashCode();
        return String.valueOf(typeString) + super.toString() + ": @" + this.hashCode() + theParentString;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
        if (this.stVeto == null) {
            this.stVeto = new STVeto();
            this.addSplitTypeListener(this.stVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        if (this.stVeto != null) {
            this.removeSplitTypeListener(this.stVeto);
            this.stVeto = null;
        }
        super.removeNotify();
    }

    public boolean isValidSplitType(int testSplitType) {
        switch (testSplitType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addSplitTypeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("SplitType", listener);
    }

    public void removeSplitTypeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("SplitType", listener);
    }

    public void addSplitTypeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("SplitType", listener);
    }

    public void removeSplitTypeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("SplitType", listener);
    }

    protected MouseListener getMouseListener() {
        return this.mouse;
    }

    protected int optSize(int total, int _gap, int _min1, int _min2, int _pref1, int _pref2) {
        int pref2;
        int gap = Math.max(_gap, 0);
        int min1 = Math.max(_min1, 1);
        int min2 = Math.max(_min2, 1);
        int pref1 = Math.max(_pref1, min1);
        int diff = total - (pref1 + (pref2 = Math.max(_pref2, min2)) + gap);
        if (diff >= 0) {
            float scale = (float)pref1 / (float)(pref1 + pref2);
            return pref1 + (int)((float)diff * scale);
        }
        diff = total - (min1 + min2 + gap);
        if (diff >= 0) {
            float scale = (float)pref1 / (float)(pref1 + pref2);
            return min1 + (int)((float)diff * scale);
        }
        if (total > gap) {
            float scale = (float)min1 / (float)(min1 + min2);
            return min1 + (int)((float)diff * scale);
        }
        return total;
    }

    protected void placeComponents() {
        Rectangle rect = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.isOuter) {
            int sub1X = this.oGapWidth + this.oBdrSize;
            int sub1Y = this.oGapHeight + this.oBdrSize;
            int sub1Width = rect.width - (2 * this.oGapWidth + this.oBdrSize + 1);
            int sub1Height = rect.height - (2 * this.oGapHeight + this.oBdrSize + 1);
            this.innerSP.reshape(sub1X, sub1Y, sub1Width, sub1Height);
        } else {
            int sub2Height;
            int sub2Width;
            int sub2Y;
            int sub2X;
            int sub1Height;
            int sub1Width;
            int sub1Y;
            int sub1X;
            Dimension prefDim2;
            Dimension minDim2;
            Dimension prefDim1;
            Dimension minDim1;
            if (this.sub1 == null) {
                minDim1 = new Dimension(1, 1);
                prefDim1 = new Dimension(1, 1);
            } else {
                minDim1 = this.sub1.minimumSize();
                prefDim1 = this.sub1.preferredSize();
            }
            if (this.sub2 == null) {
                minDim2 = new Dimension(1, 1);
                prefDim2 = new Dimension(1, 1);
            } else {
                minDim2 = this.sub2.minimumSize();
                prefDim2 = this.sub2.preferredSize();
            }
            switch (this.splitType) {
                case 0: {
                    if (this.spComponent != null) {
                        int sub1X2 = this.iBdrSize;
                        int sub1Y2 = this.iBdrSize;
                        int sub1Width2 = rect.width - 2 * this.iBdrSize;
                        int sub1Height2 = rect.height - 2 * this.iBdrSize;
                        if (sub1Width2 < 0) {
                            sub1Width2 = 0;
                        }
                        if (sub1Height2 < 0) {
                            sub1Height2 = 0;
                        }
                        if (this.propResize) {
                            this.spComponent.reshape(sub1X2, sub1Y2, sub1Width2, sub1Height2);
                        } else {
                            this.spComponent.move(sub1X2, sub1Y2);
                        }
                        this.spComponent.layout();
                        this.spComponent.invalidate();
                        this.spComponent.validate();
                        try {
                            this.spComponent.repaint();
                        }
                        catch (Exception exception) {
                            this.repaint();
                        }
                    }
                    return;
                }
                case 1: {
                    sub1X = 0;
                    sub1Y = 0;
                    sub1Width = this.optSize(rect.width, this.iGapWidth, minDim1.width, minDim2.width, prefDim1.width, prefDim2.width);
                    sub1Height = rect.height;
                    sub2X = sub1Width + this.iGapWidth;
                    sub2Y = 0;
                    sub2Width = rect.width - sub2X;
                    sub2Height = rect.height;
                    break;
                }
                case 2: {
                    sub1X = 0;
                    sub1Y = 0;
                    sub1Width = rect.width;
                    sub1Height = this.optSize(rect.height, this.iGapHeight, minDim1.height, minDim2.height, prefDim1.height, prefDim2.height);
                    sub2X = 0;
                    sub2Y = sub1Height + this.iGapHeight;
                    sub2Width = rect.width;
                    sub2Height = rect.height - sub2Y;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.heightOnly) {
                this.heightOnly = false;
                this.sub1.reshapeHeight(sub1Y, sub1Height);
                this.sub2.reshapeHeight(sub2Y, sub2Height);
            } else if (this.widthOnly) {
                this.widthOnly = false;
                this.sub1.reshapeWidth(sub1X, sub1Width);
                this.sub2.reshapeWidth(sub2X, sub2Width);
            } else {
                this.sub1.reshape(sub1X, sub1Y, sub1Width, sub1Height);
                this.sub2.reshape(sub2X, sub2Y, sub2Width, sub2Height);
            }
            this.sub1.invalidate();
            this.sub1.validate();
            this.sub1.repaint();
            this.sub2.invalidate();
            this.sub2.validate();
            this.sub2.repaint();
        }
    }

    protected void draw3DBdr(Graphics g, int x, int y, int width, int height, int bdrSize, Color c, boolean raised) {
        if (bdrSize < 0) {
            return;
        }
        g.setColor(this.use3dBdr ? c : c.darker());
        int i = 0;
        while (i < bdrSize) {
            if (this.use3dBdr) {
                g.draw3DRect(x + i, y + i, width - 2 * i, height - 2 * i, raised);
            } else {
                g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
            }
            ++i;
        }
    }

    protected void propagateChanges() {
        if (this.innerSP != null) {
            this.propagateChangesSP(this.innerSP);
            this.innerSP.propagateChanges();
        }
        if (this.sub1 != null) {
            this.propagateChangesSP(this.sub1);
            this.sub1.propagateChanges();
        }
        if (this.sub2 != null) {
            this.propagateChangesSP(this.sub2);
            this.sub2.propagateChanges();
        }
    }

    protected void propagateChangesSP(SplitterPanel spTarget) {
        spTarget.gapColor = this.gapColor;
        spTarget.enforceMinDim = this.enforceMinDim;
        spTarget.moveSplitCursor = this.moveSplitCursor;
        spTarget.propResize = this.propResize;
        if (spTarget.oGapWidth != this.oGapWidth || spTarget.iGapWidth != this.iGapWidth || spTarget.oGapHeight != this.oGapHeight || spTarget.iGapHeight != this.iGapHeight || spTarget.iBdrSize != this.iBdrSize || spTarget.oBdrSize != this.oBdrSize || spTarget.use3dBdr != this.use3dBdr || spTarget.allowDynamicMoving != this.allowDynamicMoving) {
            spTarget.oGapWidth = this.oGapWidth;
            spTarget.iGapWidth = this.iGapWidth;
            spTarget.oGapHeight = this.oGapHeight;
            spTarget.iGapHeight = this.iGapHeight;
            spTarget.iBdrSize = this.iBdrSize;
            spTarget.oBdrSize = this.oBdrSize;
            spTarget.use3dBdr = this.use3dBdr;
            spTarget.allowDynamicMoving = this.allowDynamicMoving;
            this.layout();
            spTarget.layout();
        }
    }

    protected Dimension maxDimOf(Dimension dim1, Dimension dim2) {
        return new Dimension(Math.max(dim1.width, dim2.width), Math.max(dim1.height, dim2.height));
    }

    protected void resetCursor() {
        if (!this.outerSP.cursorChanged) {
            return;
        }
        try {
            this.setCursor(new Cursor(0));
            this.outerSP.cursorChanged = false;
            cursorCh = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public synchronized void setCursor(Cursor cursor) {
        if (this.outerSP.cursorChanged) {
            return;
        }
        if (this.isOuter) {
            try {
                super.setCursor(cursor);
                this.cursorChanged = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.outerSP.setCursor(cursor);
        }
    }

    protected boolean inComponent(Component comp, int x, int y) {
        Rectangle r = comp.bounds();
        r.grow(-this.iBdrSize - 1, -this.iBdrSize - 1);
        return x - r.x >= 0 && x - r.x <= r.width && y - r.y >= 0 && y - r.y <= r.height;
    }

    protected boolean inGap(int evtX, int evtY) {
        if (this.inGap1(evtX, evtY)) {
            return true;
        }
        if (this.isOuter) {
            return this.innerSP.inGap(evtX - this.innerSP.curLoc.x, evtY - this.innerSP.curLoc.y);
        }
        if (this.splitType == 2 || this.splitType == 1) {
            return this.sub1.inGap(evtX - this.sub1.curLoc.x, evtY - this.sub1.curLoc.y) || this.sub2.inGap(evtX - this.sub2.curLoc.x, evtY - this.sub2.curLoc.y);
        }
        return false;
    }

    protected boolean inGap1(int evtX, int evtY) {
        if (!this.inside(evtX, evtY)) {
            return false;
        }
        if (this.isOuter) {
            return false;
        }
        if (this.inOutBoarder(evtX, evtY)) {
            return false;
        }
        if (this.splitType == 2 || this.splitType == 1) {
            if (this.inComponent(this.sub1, evtX, evtY) || this.inComponent(this.sub2, evtX, evtY)) {
                return false;
            }
            if (this.inComponent(this, evtX, evtY)) {
                cursorCh = this;
            }
            return true;
        }
        return false;
    }

    protected boolean inOutBoarder(int evtX, int evtY) {
        Container sp = this;
        Rectangle r = sp.bounds();
        int x = r.x;
        int y = r.y;
        while (sp != this.outerSP) {
            sp = sp.getParent();
            r = sp.bounds();
            x += r.x;
            y += r.y;
        }
        r.grow(-(this.outerSP.iBdrSize + this.outerSP.oBdrSize + this.outerSP.oGapWidth / 2 + 4), -(this.outerSP.iBdrSize + this.outerSP.oBdrSize + this.outerSP.oGapHeight / 2 + 4));
        r.move(r.x + this.outerSP.oGapWidth / 2, r.y + this.outerSP.oGapHeight / 2);
        return !r.inside(x + evtX, y + evtY);
    }

    protected void adjustOGapBdr() {
        if (this.oGapWidth < this.oBdrSize) {
            this.oGapWidth = Math.max(0, this.oBdrSize);
        }
        if (this.oGapHeight < this.oBdrSize) {
            this.oGapHeight = Math.max(0, this.oBdrSize);
        }
    }

    final /* synthetic */ Mouse access$0() {
        return this.mouse;
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(x, y);
            } else if (SplitterPanel.this.splitType == 2 && SplitterPanel.this.outerSP.cursorChanged) {
                SplitterPanel.this.doMoveSplit = true;
                SplitterPanel.this.moveFromX = x;
                SplitterPanel.this.moveFromY = y;
            } else if (SplitterPanel.this.splitType == 1 && SplitterPanel.this.outerSP.cursorChanged) {
                SplitterPanel.this.doMoveSplit = true;
                SplitterPanel.this.moveFromX = x;
                SplitterPanel.this.moveFromY = y;
            } else if (SplitterPanel.this.outerSP.cursorChanged) {
                Mouse parentListener;
                Point p = SplitterPanel.this.location();
                SplitterPanel parent = (SplitterPanel)SplitterPanel.this.getParent();
                if (parent != null && (parentListener = parent.access$0()) != null) {
                    parentListener.mousePressed(new MouseEvent(cursorCh, e.getID(), e.getWhen(), e.getModifiers(), p.x + x, p.y + y, e.getClickCount(), e.isPopupTrigger()));
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(x, y);
            } else if (SplitterPanel.this.doMoveSplit) {
                SplitterPanel.this.moveSplit(x - SplitterPanel.this.moveFromX, y - SplitterPanel.this.moveFromY);
                SplitterPanel.this.doMoveSplit = false;
            }
        }

        Mouse() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }

    class MouseMtn
    implements MouseMotionListener,
    Serializable {
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(x, y);
            } else if (SplitterPanel.this.splitType == 2 && SplitterPanel.this.inGap1(x, y)) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
            } else if (SplitterPanel.this.splitType == 1 && SplitterPanel.this.inGap1(x, y)) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
            } else if (!SplitterPanel.this.doMoveSplit && !SplitterPanel.this.inGap(x, y)) {
                SplitterPanel.this.resetCursor();
            }
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(x, y);
            } else if (SplitterPanel.this.doMoveSplit) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
                if (SplitterPanel.this.allowDynamicMoving) {
                    SplitterPanel.this.moveSplit(x - SplitterPanel.this.moveFromX, y - SplitterPanel.this.moveFromY);
                    SplitterPanel.this.moveFromX = x;
                    SplitterPanel.this.moveFromY = y;
                }
            }
        }

        MouseMtn() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }

    class STVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!SplitterPanel.this.isValidSplitType(i)) {
                throw new PropertyVetoException("Invalid SplitType: " + i, e);
            }
        }

        STVeto() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }
}

