/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.Serializable;
import java.net.URL;

class ListItem
implements Serializable {
    URL url;
    transient Image image;
    String sText;
    boolean bEnabled;
    boolean bSelected;
    transient boolean bDirty;
    Color color;
    int lineWidth;
    boolean bCellBorder;
    Color cellBorderColor;
    boolean bEdited = false;

    public ListItem(Image image, String sText, boolean bEnabled, FontMetrics fm, boolean bCellBorder) {
        this.image = image;
        this.sText = sText;
        this.bEnabled = bEnabled;
        this.bSelected = false;
        this.bDirty = true;
        this.color = null;
        this.bCellBorder = bCellBorder;
        this.cellBorderColor = Color.black;
        this.updateWidth(fm);
    }

    public ListItem(Image image, URL url, String sText, boolean bEnabled, FontMetrics fm, boolean bCellBorder) {
        this(image, sText, bEnabled, fm, bCellBorder);
        this.url = url;
    }

    public void updateWidth(FontMetrics fm) {
        this.lineWidth = fm != null ? fm.stringWidth(this.sText) : 0;
    }

    public String toString() {
        String s = "ListItem " + this.sText;
        if (this.image != null) {
            s = String.valueOf(s) + " [Image]";
        }
        if (this.color != Color.black) {
            s = String.valueOf(s) + " [Colored]";
        }
        s = this.bEnabled ? String.valueOf(s) + " [Enabled]" : String.valueOf(s) + " [Disabled]";
        s = this.bSelected ? String.valueOf(s) + " [Selected]" : String.valueOf(s) + " [Not Selected]";
        if (this.bDirty) {
            s = String.valueOf(s) + " [Dirty]";
        }
        return s;
    }
}

