/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ImagePanel
extends Panel {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    private transient Image image = null;
    private URL imageURL = null;
    private int imageStyle = 0;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImagePanel() {
        super.setLayout(null);
    }

    public void paint(Graphics g) {
        block10: {
            Dimension dim;
            block9: {
                dim = this.size();
                if (this.image == null) break block9;
                int imageWidth = this.image.getWidth(this);
                int imageHeight = this.image.getHeight(this);
                switch (this.imageStyle) {
                    default: {
                        int numHImages = dim.width / imageWidth;
                        if (dim.width % imageWidth != 0) {
                            ++numHImages;
                        }
                        int numVImages = dim.height / imageHeight;
                        if (dim.height % imageHeight != 0) {
                            ++numVImages;
                        }
                        int v = 0;
                        int vCount = 0;
                        while (vCount < numVImages) {
                            int h = 0;
                            int hCount = 0;
                            while (hCount < numHImages) {
                                g.drawImage(this.image, h, v, imageWidth, imageHeight, this);
                                h += imageWidth;
                                ++hCount;
                            }
                            v += imageHeight;
                            ++vCount;
                        }
                        break block10;
                    }
                    case 1: {
                        g.drawImage(this.image, (dim.width - imageWidth) / 2, (dim.height - imageHeight) / 2, imageWidth, imageHeight, this);
                        break;
                    }
                    case 2: {
                        g.drawImage(this.image, 0, 0, dim.width, dim.height, this);
                        break;
                    }
                    case 3: {
                        g.drawImage(this.image, 0, 0, this);
                        break;
                    }
                }
                break block10;
            }
            g.clearRect(0, 0, dim.width, dim.height);
        }
        super.paint(g);
    }

    public void setImageURL(URL url) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.imageURL, url)) {
            this.vetos.fireVetoableChange("imageURL", this.imageURL, url);
            this.imageURL = url;
            if (this.imageURL != null) {
                this.image = this.getToolkit().getImage(this.imageURL);
                if (this.image != null) {
                    MediaTracker mt = new MediaTracker(this);
                    try {
                        mt.addImage(this.image, 0);
                        mt.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.changes.firePropertyChange("imageURL", this.imageURL, url);
            this.repaint();
        }
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setStyle(int newStyle) throws PropertyVetoException {
        if (newStyle != this.imageStyle) {
            Integer oldStyleInt = new Integer(this.imageStyle);
            Integer newStyleInt = new Integer(newStyle);
            this.vetos.fireVetoableChange("style", oldStyleInt, newStyleInt);
            this.imageStyle = newStyle;
            this.changes.firePropertyChange("style", oldStyleInt, newStyleInt);
            this.repaint();
        }
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public Image getImage() {
        return this.image;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block3: {
            in.defaultReadObject();
            if (this.imageURL == null) break block3;
            this.image = this.getToolkit().getImage(this.imageURL);
            if (this.image != null) {
                MediaTracker mt = new MediaTracker(this);
                try {
                    mt.addImage(this.image, 0);
                    mt.waitForAll();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

