/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class FormattedTextField
extends TextField {
    public final char ESCAPE = (char)47;
    public final char DIGIT = (char)57;
    public final char SIGN = (char)43;
    public final char DIGIT_OR_SIGN = (char)45;
    public final char ALPHA_UPPER = (char)65;
    public final char ALPHA_LOWER = (char)97;
    public final char ALPHA_TO_UPPER = (char)85;
    public final char ALPHA_TO_LOWER = (char)76;
    public final char ALPHANUMERIC_UPPER = (char)88;
    public final char ALPHANUMERIC_LOWER = (char)120;
    public final char ALPHANUMERIC_TO_UPPER = (char)78;
    public final char ALPHANUMERIC_TO_LOWER = (char)110;
    public final char ANY = (char)42;
    protected final int BACKSPACE = 8;
    protected final int ENTER = 10;
    protected final int DEL = 127;
    protected boolean editable;
    protected int caret = 0;
    protected String mask;
    protected String maskStripEscapes;
    protected int maskStripEscapesLen;
    private Key keyListener;

    public FormattedTextField() {
        this(256);
    }

    public FormattedTextField(int i) {
        this("", i);
    }

    public FormattedTextField(String s) {
        this(s, 256);
    }

    public FormattedTextField(String s, int i) {
        super(s, i);
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.setFillMask();
        this.maskStripEscapes = this.stripMaskEscapes();
        this.maskStripEscapesLen = this.maskStripEscapes.length();
    }

    public String getMask() {
        return this.mask;
    }

    public void setEditFont(Font f) {
        super.setFont(f);
        this.invalidate();
    }

    public Font getEditFont() {
        return this.getFont();
    }

    public void setFont(Font f) {
    }

    public void setEditable(boolean f) {
        this.editable = f;
        super.setEditable(f);
        if (this.editable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected int validChar(String s, int start, char mc) {
        int len = s.length();
        int i = start;
        while (i < len) {
            char c = s.charAt(i);
            switch (mc) {
                case '9': {
                    if (!Character.isDigit(c)) break;
                    return i;
                }
                case '+': {
                    if (c != '+' && c != '-') break;
                    return i;
                }
                case '-': {
                    if (!Character.isDigit(c) && c != '+' && c != '-') break;
                    return i;
                }
                case 'A': {
                    if (!Character.isUpperCase(c)) break;
                    return i;
                }
                case 'a': {
                    if (!Character.isLowerCase(c)) break;
                    return i;
                }
                case 'X': {
                    if (!Character.isUpperCase(c) && !Character.isDigit(c)) break;
                    return i;
                }
                case 'x': {
                    if (!Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    return i;
                }
                case 'U': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) break;
                    return i;
                }
                case 'L': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) break;
                    return i;
                }
                case 'N': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    return i;
                }
                case 'n': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    return i;
                }
                case '*': {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    protected void setFillMask() {
        int ml = this.mask.length();
        int mi = 0;
        String ns = "";
        while (mi < ml) {
            char mc = this.mask.charAt(mi++);
            ns = String.valueOf(ns) + (mc == '/' ? this.mask.charAt(mi++) : (char)' ');
        }
        ((TextComponent)this).setText(ns);
    }

    protected String applyMask(String s) {
        String ns = "";
        boolean fill = false;
        int len = this.mask.length();
        int mi = 0;
        int si = 0;
        while (mi < len) {
            char mc;
            if ((mc = this.mask.charAt(mi++)) != '/') {
                if (!fill) {
                    if ((si = this.validChar(s, si, mc)) < 0) {
                        fill = true;
                        ns = String.valueOf(ns) + ' ';
                        continue;
                    }
                    char sc = s.charAt(si++);
                    switch (mc) {
                        case 'U': {
                            if (!Character.isLowerCase(sc)) break;
                            sc = Character.toUpperCase(sc);
                            break;
                        }
                        case 'L': {
                            if (!Character.isUpperCase(sc)) break;
                            sc = Character.toLowerCase(sc);
                            break;
                        }
                        case 'N': {
                            if (!Character.isLowerCase(sc)) break;
                            sc = Character.toUpperCase(sc);
                            break;
                        }
                        case 'n': {
                            if (!Character.isUpperCase(sc)) break;
                            sc = Character.toLowerCase(sc);
                            break;
                        }
                    }
                    ns = String.valueOf(ns) + String.valueOf(sc);
                    continue;
                }
                ns = String.valueOf(ns) + ' ';
                continue;
            }
            ns = String.valueOf(ns) + this.mask.charAt(mi++);
        }
        return ns;
    }

    private boolean isEscape(int index) {
        return index < 0 || index >= this.maskStripEscapesLen ? false : this.maskStripEscapes.charAt(index) == '/';
    }

    private String stripMaskEscapes() {
        int ml = this.mask.length();
        int mi = 0;
        String nm = "";
        while (mi < ml) {
            char mc;
            if ((mc = this.mask.charAt(mi++)) == '/') {
                ++mi;
            }
            nm = String.valueOf(nm) + mc;
        }
        return nm;
    }

    protected String stripMask(String s) {
        int sl = s.length();
        int i = 0;
        String ns = "";
        while (i < this.maskStripEscapesLen && i < sl) {
            if (this.isEscape(i)) {
                ++i;
                continue;
            }
            ns = String.valueOf(ns) + s.charAt(i++);
        }
        return ns;
    }

    protected void processChar(int key) {
        boolean inEscapeAtStart;
        int i;
        boolean isSelection;
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        boolean bs = key == 8;
        boolean del = key == 127;
        boolean bl = isSelection = selStart != selEnd;
        if (!isSelection) {
            if (bs) {
                selStart = selEnd - 1;
            } else if (del) {
                selEnd = selStart + 1;
            }
        }
        int n = i = bs || del || isSelection ? selStart : selEnd;
        if (i < 0) {
            i = 0;
        }
        boolean wasInEscape = this.isEscape(i > 0 ? i : 0);
        boolean wasAtEscape = this.isEscape(bs || del ? (i > 0 ? i - 1 : 0) : i + 1);
        if (wasInEscape) {
            inEscapeAtStart = true;
            int j = i;
            while (j >= 0) {
                if (this.isEscape(j--)) continue;
                inEscapeAtStart = false;
                break;
            }
            if (inEscapeAtStart) {
                while (i < this.maskStripEscapesLen && this.isEscape(i++)) {
                }
            }
        } else {
            inEscapeAtStart = false;
        }
        int selAdj = 0;
        while (i >= 0) {
            if (!this.isEscape(i--)) continue;
            ++selAdj;
        }
        if (!inEscapeAtStart && wasInEscape && !bs && !del) {
            --selAdj;
        }
        selEnd -= selAdj;
        if ((selStart -= selAdj) < 0) {
            selStart = 0;
        }
        if (selEnd < 0) {
            selEnd = 0;
        }
        String s = this.mask != null ? this.stripMask(this.getText()) : this.getText();
        int sl = s.length();
        String k = bs || del ? "" : String.valueOf((char)key);
        String l = selStart > 0 ? s.substring(0, selStart) : "";
        String r = selEnd < sl ? s.substring(selEnd) : "";
        String es = bs || del ? String.valueOf(l) + r : String.valueOf(l) + k + r;
        String ns = this.mask != null ? this.applyMask(es) : es;
        if (bs || del || !s.equals(this.stripMask(ns)) && this.mask != null || !s.equals(ns) && this.mask == null) {
            ((TextComponent)this).setText(ns);
            if (bs || del) {
                this.caret = selStart + --selAdj;
                if (wasAtEscape && this.caret > 0 && this.isEscape(this.caret)) {
                    i = this.caret;
                    while (i >= 0) {
                        if (this.isEscape(i--)) {
                            --this.caret;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.caret = (isSelection ? selStart : selEnd) + selAdj;
                if (this.caret < sl && this.isEscape(this.caret + 1)) {
                    i = this.caret + 1;
                    while (i < sl) {
                        if (this.isEscape(i++)) {
                            ++this.caret;
                            continue;
                        }
                        break;
                    }
                }
            }
            this.select(this.caret + 1, this.caret + 1);
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.keyListener == null) {
            this.keyListener = new Key();
            this.addKeyListener(this.keyListener);
        }
    }

    public synchronized void removeNotify() {
        if (this.keyListener != null) {
            this.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        super.removeNotify();
    }

    public Dimension preferredSize() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(f);
            if (this.mask != null) {
                int w = fm.stringWidth("W") * this.maskStripEscapesLen + 4;
                int h = fm.getHeight() + 4;
                return new Dimension(w, h);
            }
            return new Dimension(fm.stringWidth("ABCDE") + 4, fm.getHeight() + 4);
        }
        return new Dimension(30, 15);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 37: {
                    if (--FormattedTextField.this.caret >= 0) break;
                    FormattedTextField.this.caret = 0;
                    break;
                }
                case 39: {
                    if (++FormattedTextField.this.caret < FormattedTextField.this.maskStripEscapesLen) break;
                    FormattedTextField.this.caret = FormattedTextField.this.maskStripEscapesLen;
                    break;
                }
                case 36: {
                    FormattedTextField.this.caret = 0;
                    break;
                }
                case 35: {
                    FormattedTextField.this.caret = FormattedTextField.this.maskStripEscapesLen;
                    break;
                }
                default: {
                    FormattedTextField.this.processChar(e.getKeyChar());
                    e.consume();
                }
                case 9: 
                case 10: 
            }
        }

        Key() {
            FormattedTextField.this = FormattedTextField.this;
        }
    }
}

