/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;
import symantec.itools.util.Timer;

public abstract class ButtonBase
extends Canvas {
    protected transient boolean pressed;
    protected transient boolean released;
    protected transient boolean inButton;
    protected boolean notifyWhilePressed;
    protected transient boolean running;
    protected transient boolean notified;
    protected boolean showFocus;
    protected boolean useOffset;
    protected boolean showURLStatus;
    protected transient boolean isAdded;
    protected int bevel;
    protected int notifyDelay;
    protected int pressedAdjustment;
    protected String frame;
    protected Color borderColor;
    protected Color buttonColor;
    protected Timer notifyTimer;
    protected transient Image buttonImage;
    protected transient Graphics buttonImageGraphics;
    protected URL linkURL;
    protected transient AppletContext context;
    String actionCommand;
    ActionListener actionListener;
    transient boolean hasFocus;
    private Color hilightColor;
    private Color pressedHilightColor;
    private Color disabledHilightColor;
    private Color shadowColor;
    private Color pressedShadowColor;
    private Color disabledShadowColor;
    private Color disabledBorderColor;
    private Color disabledButtonColor;
    private Color pressedButtonColor;
    private Key key;
    private Focus focus;
    private Action action;
    private Mouse mouse;
    private BevelVeto bevelVeto;
    private FrameVeto frameVeto;
    private VetoableChangeSupport vetos;
    private PropertyChangeSupport changes;

    protected ButtonBase() {
        block4: {
            this.showFocus = false;
            this.hasFocus = false;
            this.action = new Action();
            this.vetos = new VetoableChangeSupport(this);
            this.changes = new PropertyChangeSupport(this);
            this.pressed = false;
            this.released = true;
            this.notifyWhilePressed = false;
            this.running = false;
            this.notified = false;
            this.useOffset = false;
            this.showURLStatus = true;
            this.isAdded = false;
            this.notifyTimer = null;
            this.notifyDelay = 1000;
            this.bevel = 2;
            this.pressedAdjustment = 0;
            try {
                this.setBorderColor(Color.black);
                this.setButtonColor(Color.lightGray);
            }
            catch (PropertyVetoException propertyVetoException) {}
            if (!OS.isWindows()) break block4;
            try {
                this.setShowFocus(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void setBevelHeight(int height) throws PropertyVetoException {
        if (this.bevel != height) {
            Integer oldValue = new Integer(this.bevel);
            Integer newValue = new Integer(height);
            this.vetos.fireVetoableChange("BevelHeight", oldValue, newValue);
            this.bevel = height;
            this.repaint();
            this.changes.firePropertyChange("BevelHeight", oldValue, newValue);
        }
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public void setNotifyWhilePressed(boolean flag) throws PropertyVetoException {
        if (this.notifyWhilePressed != flag) {
            Boolean oldValue = new Boolean(this.notifyWhilePressed);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("NotifyWhilePressed", oldValue, newValue);
            this.notifyWhilePressed = flag;
            if (this.notifyWhilePressed) {
                this.notifyTimer = new Timer(this.notifyDelay, true);
                this.notifyTimer.addActionListener(this.action);
            } else if (this.notifyTimer != null) {
                this.notifyTimer = null;
            }
            this.changes.firePropertyChange("NotifyWhilePressed", oldValue, newValue);
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setNotifyDelay(int delay) throws PropertyVetoException {
        if (this.notifyDelay != delay) {
            Integer oldValue = new Integer(this.notifyDelay);
            Integer newValue = new Integer(delay);
            this.vetos.fireVetoableChange("NotifyDelay", oldValue, newValue);
            this.notifyDelay = delay;
            if (this.notifyTimer != null) {
                this.notifyTimer.setDelay(this.notifyDelay);
            }
            this.changes.firePropertyChange("NotifyDelay", oldValue, newValue);
        }
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setUseOffset(boolean flag) throws PropertyVetoException {
        if (this.useOffset != flag) {
            Boolean oldValue = new Boolean(this.useOffset);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("UseOffset", oldValue, newValue);
            this.useOffset = flag;
            this.repaint();
            this.changes.firePropertyChange("UseOffset", oldValue, newValue);
        }
    }

    public boolean isUseOffset() {
        return this.useOffset;
    }

    public void setShowFocus(boolean flag) throws PropertyVetoException {
        if (this.showFocus != flag) {
            Boolean oldValue = new Boolean(this.showFocus);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("ShowFocus", oldValue, newValue);
            this.showFocus = flag;
            this.changes.firePropertyChange("ShowFocus", oldValue, newValue);
        }
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public boolean getShowFocus() {
        return this.isShowFocus();
    }

    public void setShowURLStatus(boolean flag) throws PropertyVetoException {
        if (this.showURLStatus != flag) {
            Boolean oldValue = new Boolean(this.showURLStatus);
            Boolean newValue = new Boolean(flag);
            this.vetos.fireVetoableChange("ShowURLStatus", oldValue, newValue);
            this.showURLStatus = flag;
            this.changes.firePropertyChange("ShowURLStatus", oldValue, newValue);
        }
    }

    public boolean isShowURLStatus() {
        return this.showURLStatus;
    }

    public void setBorderColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderColor, color)) {
            Color oldValue = this.borderColor;
            this.vetos.fireVetoableChange("BorderColor", oldValue, color);
            this.borderColor = color;
            try {
                this.disabledBorderColor = ColorUtils.lighten(this.borderColor, 0.466);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("BorderColor", oldValue, color);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setButtonColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.buttonColor, color)) {
            Color oldValue = this.buttonColor;
            this.vetos.fireVetoableChange("ButtonColor", oldValue, color);
            this.buttonColor = color;
            try {
                this.hilightColor = ColorUtils.lighten(this.buttonColor, 0.6000000000000001);
                this.pressedHilightColor = ColorUtils.darken(this.buttonColor, 0.58);
                this.disabledHilightColor = ColorUtils.lighten(this.buttonColor, 0.666);
                this.shadowColor = ColorUtils.darken(this.buttonColor, 0.25);
                this.pressedShadowColor = ColorUtils.darken(this.buttonColor, 0.1);
                this.disabledShadowColor = ColorUtils.darken(this.buttonColor, 0.16600000000000004);
                this.disabledButtonColor = ColorUtils.lighten(this.buttonColor, 0.333);
                this.pressedButtonColor = ColorUtils.darken(this.buttonColor, 0.25);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("ButtonColor", oldValue, color);
        }
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setLinkURL(URL url) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.linkURL, url)) {
            URL oldValue = this.linkURL;
            this.vetos.fireVetoableChange("LinkURL", oldValue, url);
            this.linkURL = url;
            this.context = null;
            this.changes.firePropertyChange("LinkURL", oldValue, url);
        }
    }

    public URL getLinkURL() {
        return this.linkURL;
    }

    public void setFrame(String newFrame) throws PropertyVetoException {
        String oldValue = this.frame;
        this.vetos.fireVetoableChange("Frame", oldValue, newFrame);
        this.frame = newFrame;
        this.changes.firePropertyChange("Frame", oldValue, newFrame);
    }

    public String getFrame() {
        return this.frame;
    }

    public void validate() {
        if (this.context == null) {
            Container c = this.getParent();
            while (c != null) {
                if (c instanceof Applet) {
                    this.setAppletContext(((Applet)c).getAppletContext());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            if (flag) {
                super.enable();
                this.pressed = false;
                this.pressedAdjustment = 0;
            } else {
                super.disable();
                if (this.notifyTimer != null) {
                    this.notifyTimer.stop();
                }
                this.pressed = false;
                this.pressedAdjustment = 0;
            }
            this.repaint();
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.bevelVeto == null) {
            this.bevelVeto = new BevelVeto();
            this.addBevelHeightListener(this.bevelVeto);
        }
        if (this.frameVeto == null) {
            this.frameVeto = new FrameVeto();
            this.addFrameListener(this.frameVeto);
        }
        this.isAdded = true;
        if (this.context == null) {
            Container c = this.getParent();
            while (c != null) {
                if (c instanceof Applet) {
                    this.setAppletContext(((Applet)c).getAppletContext());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public synchronized void removeNotify() {
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.bevelVeto != null) {
            this.removeBevelHeightListener(this.bevelVeto);
            this.bevelVeto = null;
        }
        if (this.frameVeto != null) {
            this.removeFrameListener(this.frameVeto);
            this.frameVeto = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.updateButtonImage();
        g.drawImage(this.buttonImage, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.bevel + this.bevel + 2, this.bevel + this.bevel + 2);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addBevelHeightListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("BevelHeight", listener);
    }

    public void removeBevelHeightListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("BevelHeight", listener);
    }

    public void addBevelHeightListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("BevelHeight", listener);
    }

    public void removeBevelHeightListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("BevelHeight", listener);
    }

    public void addFrameListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("Frame", listener);
    }

    public void removeFrameListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("Frame", listener);
    }

    public void addFrameListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("Frame", listener);
    }

    public void removeFrameListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("Frame", listener);
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("ActionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("ActionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    protected boolean isValidBevelSize(int i) {
        Dimension s = this.getSize();
        return i >= 0 && i < s.width / 2 && i < s.height / 2;
    }

    protected boolean isValidFrame(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        return string.equals(GeneralUtils.frameTarget_self) || string.equals(GeneralUtils.frameTarget_parent) || string.equals(GeneralUtils.frameTarget_top) || string.equals(GeneralUtils.frameTarget_blank);
    }

    protected void linkToURL() {
        if (this.context != null && this.linkURL != null) {
            if (this.frame == null || this.frame.length() == 0) {
                this.context.showDocument(this.linkURL);
            } else {
                this.context.showDocument(this.linkURL, this.frame);
            }
        }
    }

    protected void setAppletContext(AppletContext c) {
        this.context = c;
    }

    protected void updateButtonImage() {
        int i;
        Color highlight2;
        Color highlight1;
        Color fillColor;
        Color tempBorderColor;
        boolean raised;
        Dimension s = this.getSize();
        int width = s.width;
        int height = s.height;
        int x = this.bevel + 1;
        int y = this.bevel + 1;
        int w = width - 1;
        int h = height - 1;
        boolean bl = raised = !this.pressed || !this.inButton;
        if (this.isButtonImageInvalid()) {
            this.buttonImage = this.createImage(width, height);
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.buttonImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buttonImageGraphics = this.buttonImage.getGraphics();
        Color oldColor = this.buttonImageGraphics.getColor();
        if (this.isEnabled()) {
            tempBorderColor = this.borderColor;
            if (raised) {
                fillColor = this.buttonColor;
                highlight1 = this.hilightColor;
                highlight2 = this.shadowColor;
            } else {
                fillColor = this.pressedButtonColor;
                highlight1 = this.pressedHilightColor;
                highlight2 = this.pressedShadowColor;
            }
        } else {
            tempBorderColor = this.disabledBorderColor;
            fillColor = this.disabledButtonColor;
            highlight1 = this.disabledHilightColor;
            highlight2 = this.disabledShadowColor;
        }
        if (!raised && this.useOffset) {
            this.buttonImageGraphics.setColor(fillColor);
            this.buttonImageGraphics.fillRect(x, y, w - x, h - y);
            this.buttonImageGraphics.setColor(highlight1);
            i = 1;
            while (i <= this.bevel) {
                this.buttonImageGraphics.drawLine(i, i, i, h);
                this.buttonImageGraphics.drawLine(i, i, w, i);
                ++i;
            }
        }
        if (raised || !this.useOffset) {
            this.buttonImageGraphics.setColor(fillColor);
            this.buttonImageGraphics.fillRect(x, y, w - x, h - y);
            this.buttonImageGraphics.setColor(highlight1);
            i = 1;
            while (i <= this.bevel) {
                this.buttonImageGraphics.drawLine(i, i, i, h - i);
                this.buttonImageGraphics.drawLine(i, i, w - i, i);
                ++i;
            }
            this.buttonImageGraphics.setColor(highlight2);
            i = 1;
            while (i <= this.bevel) {
                this.buttonImageGraphics.drawLine(i, h - i, w - i, h - i);
                this.buttonImageGraphics.drawLine(w - i, i, w - i, h - i);
                ++i;
            }
        }
        this.buttonImageGraphics.setColor(tempBorderColor);
        this.buttonImageGraphics.drawLine(1, 0, w - 1, 0);
        this.buttonImageGraphics.drawLine(0, 1, 0, h - 1);
        this.buttonImageGraphics.drawLine(1, h, w - 1, h);
        this.buttonImageGraphics.drawLine(w, h - 1, w, 1);
        if (this.hasFocus && this.showFocus) {
            this.buttonImageGraphics.setColor(Color.darkGray);
            x = 3;
            while (x <= w - 3) {
                this.buttonImageGraphics.drawLine(x, 3, x + 1, 3);
                x += 3;
            }
            y = 3;
            while (y <= h - 3) {
                this.buttonImageGraphics.drawLine(3, y, 3, y + 1);
                y += 3;
            }
            x = 3;
            while (x <= w - 3) {
                this.buttonImageGraphics.drawLine(x, h - 3, x + 1, h - 3);
                x += 3;
            }
            y = 3;
            while (y <= h - 3) {
                this.buttonImageGraphics.drawLine(w - 3, y, w - 3, y + 1);
                y += 3;
            }
        }
        this.buttonImageGraphics.clipRect(this.bevel + 1, this.bevel + 1, width - this.bevel - this.bevel - 2, height - this.bevel - this.bevel - 2);
        this.buttonImageGraphics.setColor(oldColor);
    }

    protected boolean isButtonImageInvalid() {
        Dimension s = this.getSize();
        return this.buttonImage == null || s.width != this.buttonImage.getWidth(this) || s.height != this.buttonImage.getHeight(this);
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        public void focusGained(FocusEvent e) {
            ButtonBase.this.hasFocus = true;
            ButtonBase.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            ButtonBase.this.hasFocus = false;
            ButtonBase.this.repaint();
        }

        Focus() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent evt) {
            boolean isSpaceBar;
            boolean bl = isSpaceBar = (evt.getKeyCode() & 0x20) == 32;
            if (isSpaceBar && ButtonBase.this.hasFocus && ButtonBase.this.showFocus && !OS.isMacintosh()) {
                ButtonBase.this.inButton = true;
                ButtonBase.this.notified = false;
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                    ButtonBase.this.running = true;
                    ButtonBase.this.notifyTimer.start();
                }
                ButtonBase.this.pressed = true;
                ButtonBase.this.released = false;
                if (ButtonBase.this.useOffset) {
                    ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
                }
                ButtonBase.this.repaint();
            }
        }

        public void keyReleased(KeyEvent evt) {
            boolean isSpaceBar;
            boolean bl = isSpaceBar = (evt.getKeyCode() & 0x20) == 32;
            if (isSpaceBar && ButtonBase.this.hasFocus && ButtonBase.this.showFocus && !OS.isMacintosh()) {
                ButtonBase.this.inButton = false;
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                    ButtonBase.this.running = false;
                    ButtonBase.this.notifyTimer.stop();
                }
                if (ButtonBase.this.pressed) {
                    ButtonBase.this.pressed = false;
                    ButtonBase.this.pressedAdjustment = 0;
                    if (!ButtonBase.this.notifyWhilePressed || !ButtonBase.this.notified) {
                        ButtonBase.this.linkToURL();
                        ButtonBase.this.sourceActionEvent();
                    }
                }
                ButtonBase.this.released = true;
                ButtonBase.this.repaint();
            }
        }

        Key() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            ButtonBase.this.requestFocus();
            ButtonBase.this.notified = false;
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                ButtonBase.this.running = true;
                ButtonBase.this.notifyTimer.start();
            }
            ButtonBase.this.pressed = true;
            ButtonBase.this.released = false;
            if (ButtonBase.this.useOffset) {
                ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
            }
            ButtonBase.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                ButtonBase.this.running = false;
                ButtonBase.this.notifyTimer.stop();
            }
            if (ButtonBase.this.pressed) {
                ButtonBase.this.pressed = false;
                ButtonBase.this.pressedAdjustment = 0;
                if (!ButtonBase.this.notifyWhilePressed || !ButtonBase.this.notified) {
                    ButtonBase.this.linkToURL();
                    ButtonBase.this.sourceActionEvent();
                }
            }
            ButtonBase.this.released = true;
            if (ButtonBase.this.inButton) {
                ButtonBase.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
            ButtonBase.this.inButton = true;
            if (!ButtonBase.this.released) {
                ButtonBase.this.pressed = true;
                if (ButtonBase.this.useOffset) {
                    ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
                }
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                    ButtonBase.this.running = true;
                    ButtonBase.this.notifyTimer.start();
                }
                if (ButtonBase.this.showURLStatus && ButtonBase.this.context != null && ButtonBase.this.linkURL != null) {
                    ButtonBase.this.context.showStatus(ButtonBase.this.linkURL.toString());
                }
                ButtonBase.this.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            ButtonBase.this.inButton = false;
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                ButtonBase.this.running = false;
                ButtonBase.this.notifyTimer.stop();
            }
            if (ButtonBase.this.pressed) {
                ButtonBase.this.pressed = false;
                ButtonBase.this.pressedAdjustment = 0;
                ButtonBase.this.repaint();
            }
            if (ButtonBase.this.showURLStatus && ButtonBase.this.context != null && ButtonBase.this.linkURL != null) {
                ButtonBase.this.context.showStatus("");
            }
        }

        Mouse() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ButtonBase.this.notifyTimer && ButtonBase.this.notifyWhilePressed && !Beans.isDesignTime()) {
                ButtonBase.this.notified = true;
                ButtonBase.this.sourceActionEvent();
                return;
            }
        }

        Action() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class BevelVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ButtonBase.this.isValidBevelSize(i)) {
                throw new PropertyVetoException("Invalid bevel size: " + i, e);
            }
        }

        BevelVeto() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class FrameVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            String string = (String)e.getNewValue();
            if (!ButtonBase.this.isValidFrame(string)) {
                throw new PropertyVetoException("Invalid Frame: " + string, e);
            }
        }

        FrameVeto() {
            ButtonBase.this = ButtonBase.this;
        }
    }
}

