/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import symantec.itools.awt.DirectionButton;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public abstract class BaseTabbedPanel
extends Panel {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int SQUARE = 1;
    protected int curIndex = -1;
    protected transient boolean suppressRepaints = false;
    protected Vector vPolys;
    protected int firstVisibleTab;
    protected DirectionButton dbLeft;
    protected DirectionButton dbRight;
    protected Polygon nullPoly;
    protected Vector vLabels;
    protected Color borderDarkerColor;
    protected Color borderLightColor;
    protected Color borderDarkColor;
    protected Color disabledTextColor;
    protected Color cachedForeground;
    protected Color cachedBackground;
    private int TF_LEFT = 9;
    private int TF_RIGHT = -9;
    private int TF_TOP = 30;
    private int TF_BOTTOM = -9;
    private int TF_BTN_HEIGHT = 20;
    private Vector vEnabled;
    private Font fReg;
    private Font fSel;
    private Component userPanel;
    private int iTabsPosition = 0;
    private int iTabsStyle = 0;
    private transient int osAdjustment;
    private int lastWidth = -1;
    private Insets btpInsets;
    private Mouse mouse;
    private Action action;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public BaseTabbedPanel() {
        this(0, 0);
    }

    public BaseTabbedPanel(boolean bTabsOnTop) {
        this(bTabsOnTop ? 0 : 1, bTabsOnTop ? 0 : 1);
    }

    public BaseTabbedPanel(int tabsPostion, int tabsStyle) {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.btpInsets = new Insets(0, 0, 0, 0);
        this.setTabsInfo(tabsPostion, tabsStyle);
        this.fReg = new Font("Helvetica", 0, 12);
        this.fSel = new Font("Helvetica", 1, 12);
        this.osAdjustment = System.getProperty("os.name").startsWith("S") ? -1 : 0;
        super.setLayout(null);
        this.dbLeft = new DirectionButton(0);
        this.dbRight = new DirectionButton(1);
        try {
            this.dbLeft.setShowFocus(false);
            this.dbRight.setShowFocus(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dbLeft.shrinkTriangle(1, 1, 0, 1);
        this.dbRight.shrinkTriangle(1, 1, 0, 1);
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
        this.cachedForeground = this.getForeground();
        this.cachedBackground = this.getBackground();
    }

    public void setTabsPosition(int tabsPosition) throws PropertyVetoException {
        if (this.iTabsPosition != tabsPosition) {
            Integer oldValue = new Integer(this.iTabsPosition);
            Integer newValue = new Integer(tabsPosition);
            this.vetos.fireVetoableChange("TabsPosition", oldValue, newValue);
            this.setTabsInfo(tabsPosition, this.iTabsStyle);
            this.changes.firePropertyChange("TabsPosition", oldValue, newValue);
        }
    }

    public int getTabsPosition() {
        return this.iTabsPosition;
    }

    public void setTabsStyle(int tabsStyle) throws PropertyVetoException {
        if (this.iTabsStyle != tabsStyle) {
            Integer oldValue = new Integer(this.iTabsStyle);
            Integer newValue = new Integer(tabsStyle);
            this.vetos.fireVetoableChange("TabsStyle", oldValue, newValue);
            this.setTabsInfo(this.iTabsPosition, tabsStyle);
            this.changes.firePropertyChange("TabsStyle", oldValue, newValue);
        }
    }

    public int getTabsStyle() {
        return this.iTabsStyle;
    }

    public void setTabsInfo(int tabsPosition, int tabsStyle) {
        this.iTabsPosition = tabsPosition;
        this.iTabsStyle = this.iTabsPosition == 0 ? 0 : tabsStyle;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 0 ? 20 : 17;
        this.triggerRepaint();
    }

    public boolean setSuppressRepaints(boolean b) {
        boolean wasSuppressingRepaints = this.suppressRepaints;
        this.suppressRepaints = b;
        return wasSuppressingRepaints;
    }

    protected void triggerRepaint() {
        if (!this.suppressRepaints) {
            this.repaint();
        }
    }

    public void setPanel(Component p) throws PropertyVetoException {
        Component oldValue = this.userPanel;
        this.vetos.fireVetoableChange("Panel", oldValue, p);
        this.removeAll();
        this.userPanel = p;
        if (this.userPanel != null) {
            super.add(this.userPanel, -1);
            this.userPanel.requestFocus();
        }
        this.changes.firePropertyChange("Panel", oldValue, p);
    }

    public synchronized void setTab(String sLabel, boolean bEnabled, int index) throws PropertyVetoException {
        boolean wasSuppressingRepaints = this.setSuppressRepaints(true);
        try {
            this.setLabel(sLabel, index);
            this.setEnabled(bEnabled, index);
        }
        finally {
            Object var6_5 = null;
            this.setSuppressRepaints(wasSuppressingRepaints);
        }
        this.triggerRepaint();
    }

    public synchronized void setLabel(String sLabel, int index) throws PropertyVetoException {
        if (index < 0 || index >= this.vLabels.size()) {
            return;
        }
        try {
            String oldValue = (String)this.vLabels.elementAt(index);
            this.vetos.fireVetoableChange("Label", oldValue, sLabel);
            this.vLabels.setElementAt(sLabel, index);
            this.triggerRepaint();
            this.changes.firePropertyChange("Label", oldValue, sLabel);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized String getLabel(int index) {
        if (index < 0 || index >= this.vLabels.size()) {
            return "";
        }
        try {
            return (String)this.vLabels.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public synchronized void setEnabled(boolean bEnabled, int index) throws PropertyVetoException {
        if (index < 0 || index >= this.vLabels.size()) {
            return;
        }
        if (index == this.curIndex && !bEnabled) {
            return;
        }
        try {
            Boolean oldValue = (Boolean)this.vEnabled.elementAt(index);
            Boolean newValue = new Boolean(bEnabled);
            this.vetos.fireVetoableChange("Enabled", oldValue, newValue);
            this.vEnabled.setElementAt(newValue, index);
            this.triggerRepaint();
            this.changes.firePropertyChange("Enabled", oldValue, newValue);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public boolean isEnabled(int index) {
        if (index < 0 || index >= this.vLabels.size()) {
            return false;
        }
        try {
            Boolean bool = (Boolean)this.vEnabled.elementAt(index);
            if (bool.booleanValue()) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return false;
    }

    public void setCurrentTab(int index) throws PropertyVetoException {
        if (index < 0 || index >= this.vLabels.size() || index == this.curIndex) {
            return;
        }
        if (this.isEnabled(index)) {
            boolean wasSuppressingRepaints = this.setSuppressRepaints(true);
            try {
                Integer oldValue = new Integer(this.curIndex);
                Integer newValue = new Integer(index);
                this.vetos.fireVetoableChange("CurrentTab", oldValue, newValue);
                this.curIndex = index;
                this.invalidate();
                this.validate();
                this.changes.firePropertyChange("CurrentTab", oldValue, newValue);
            }
            finally {
                Object var4_5 = null;
                this.setSuppressRepaints(wasSuppressingRepaints);
            }
            this.triggerRepaint();
        }
    }

    public int getCurrentTab() {
        return this.curIndex;
    }

    public void enableTab(boolean bEnabled, int index) throws PropertyVetoException {
        this.setEnabled(bEnabled, index);
    }

    public boolean tabIsEnabled(int index) {
        return this.isEnabled(index);
    }

    public void showPanel(Component p) {
        if (this.userPanel != null) {
            this.userPanel.hide();
        }
        this.userPanel = p;
        if (this.userPanel != null) {
            Component[] comps = this.getComponents();
            int l = comps.length;
            int x = 0;
            while (x < l) {
                if (comps[x] == this.userPanel) break;
                ++x;
            }
            if (x == l) {
                super.add(this.userPanel, -1);
            }
            this.userPanel.show();
            this.userPanel.requestFocus();
            this.validate();
            this.triggerRepaint();
        }
    }

    public int addTab(String sLabel, boolean bEnabled) {
        return this.addTab(sLabel, bEnabled, -1);
    }

    public int addTab(String sLabel, boolean bEnabled, int pos) {
        int index;
        block4: {
            if (pos == -1) {
                this.vLabels.addElement(sLabel);
                this.vEnabled.addElement(new Boolean(bEnabled));
                index = this.vLabels.size() - 1;
            } else {
                this.vLabels.insertElementAt(sLabel, pos);
                this.vEnabled.insertElementAt(new Boolean(bEnabled), pos);
                index = pos;
            }
            if (this.curIndex != -1 || !bEnabled) break block4;
            try {
                this.setCurrentTab(index);
            }
            catch (PropertyVetoException propertyVetoException) {
                index = -1;
            }
        }
        return index;
    }

    public void showTab(int index) throws PropertyVetoException {
        this.setCurrentTab(index);
    }

    public int currentTabIndex() {
        return this.getCurrentTab();
    }

    public synchronized void insertTab(String sLabel, boolean bEnabled, int index) {
        if (index < 0 || index >= this.vLabels.size()) {
            return;
        }
        if (index == this.curIndex && !bEnabled) {
            return;
        }
        try {
            this.vLabels.insertElementAt(sLabel, index);
            this.vEnabled.insertElementAt(new Boolean(bEnabled), index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeTab(int index) {
        if (index < 0 || index >= this.vEnabled.size() || index == this.curIndex) {
            return;
        }
        try {
            this.vLabels.removeElementAt(index);
            this.vEnabled.removeElementAt(index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeAllTabs() {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.curIndex = -1;
        this.firstVisibleTab = 0;
        this.lastWidth = -1;
        this.removeAll();
        this.triggerRepaint();
    }

    public void layout() {
        Rectangle r = this.bounds();
        int width = r.width - this.TF_LEFT + this.TF_RIGHT;
        if (width < 0) {
            return;
        }
        int height = r.height - this.TF_TOP + this.TF_BOTTOM;
        if (height < 0) {
            return;
        }
        int col = this.TF_LEFT;
        int row = 0;
        row = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        if (this.userPanel != null) {
            this.userPanel.reshape(col + 3, row + 3, width - 6, height - 5);
            this.userPanel.invalidate();
            this.userPanel.validate();
            if (this.userPanel instanceof Canvas || this.userPanel instanceof Panel) {
                this.userPanel.repaint();
            } else {
                this.triggerRepaint();
            }
        }
    }

    public synchronized void paint(Graphics g) {
        int width;
        Rectangle r = this.bounds();
        Color curForeground = this.getForeground();
        Color curBackground = this.getBackground();
        if (!GeneralUtils.objectsEqual(curForeground, this.cachedForeground)) {
            this.cachedForeground = curForeground;
            this.calculateDisabledTextColor(curForeground);
        }
        if (!GeneralUtils.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateBorderColors(curBackground);
        }
        if ((width = r.width - this.TF_LEFT + this.TF_RIGHT) < 0) {
            return;
        }
        int height = r.height - this.TF_TOP + this.TF_BOTTOM;
        if (height < 0) {
            return;
        }
        if (r.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = r.width;
        int col = this.TF_LEFT;
        Color c = g.getColor();
        g.setColor(curBackground);
        g.fillRect(0, 0, r.width, r.height);
        int row = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        g.setColor(this.borderLightColor);
        g.drawLine(col, row, col + width - 1, row);
        g.drawLine(col, row, col, row + height - 1);
        g.setColor(this.borderDarkColor);
        g.drawLine(col + 2, row + height - 2, col + width - 2, row + height - 2);
        g.drawLine(col + width - 2, row + 2, col + width - 2, row + height - 2);
        g.setColor(this.borderDarkerColor);
        g.drawLine(col + 1, row + height - 1, col + width - 1, row + height - 1);
        g.drawLine(col + width - 1, row + 1, col + width - 1, row + height - 1);
        int x2 = this.TF_LEFT + 8;
        int x3 = 0;
        int x4 = this.TF_LEFT;
        int sze = this.vLabels.size();
        this.vPolys.removeAllElements();
        Font f = g.getFont();
        FontMetrics fm = this.getFontMetrics(this.fReg);
        FontMetrics fms = this.getFontMetrics(this.fSel);
        int labelWidth = 0;
        int w = 0;
        while (w < this.firstVisibleTab) {
            this.vPolys.addElement(this.nullPoly);
            ++w;
        }
        if (w > 0) {
            x4 += 2;
        }
        while (w < sze) {
            Polygon p = new Polygon();
            try {
                int x1;
                int y2;
                int y1;
                String sLabel = (String)this.vLabels.elementAt(w);
                labelWidth = w == this.curIndex ? fms.stringWidth(sLabel) : fm.stringWidth(sLabel);
                if (this.iTabsPosition == 0) {
                    y1 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    y2 = this.TF_TOP - 1;
                } else {
                    y1 = r.height + this.TF_BOTTOM + 1;
                    y2 = r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    x1 = x4 + 2;
                    x2 = x1 + labelWidth + 13;
                } else {
                    x1 = x2 - 7;
                    x2 = x1 + labelWidth + 28;
                }
                if (x2 + 36 - this.TF_RIGHT > r.width) break;
                if (this.iTabsPosition == 0) {
                    if (w == this.curIndex) {
                        y1 -= 3;
                        x1 -= 2;
                    }
                    g.setColor(this.borderLightColor);
                    if (this.curIndex == w + 1) {
                        g.drawLine(x1 + 2, y1, x2 - 2, y1);
                    } else {
                        g.drawLine(x1 + 2, y1, x2, y1);
                    }
                    if (this.curIndex != w - 1) {
                        g.drawLine(x1, y1 + 2, x1, y2);
                        x3 = x1;
                    } else {
                        x3 = x1 + 1;
                    }
                    g.drawLine(x1 + 1, y1 + 1, x1 + 1, y1 + 1);
                    if (this.curIndex != w + 1) {
                        g.setColor(this.borderDarkColor);
                        g.drawLine(x2, y1, x2, y2);
                        g.setColor(this.borderDarkerColor);
                        g.drawLine(x2 + 1, y1 + 2, x2 + 1, y2);
                        x4 = x2;
                    } else {
                        x4 = x2 - 1;
                    }
                } else if (this.iTabsStyle == 1) {
                    g.setColor(this.borderDarkColor);
                    g.drawLine(x1 + 9, y1, x2 - 9, y1);
                    g.setColor(this.borderDarkerColor);
                    if (w == 0 || w == this.curIndex) {
                        g.drawLine(x1, y2, x1 + 9, y1);
                        p.addPoint(x1, y2);
                    } else {
                        g.drawLine(x1 + 4, y1 - 9, x1 + 9, y1);
                        p.addPoint(x1 + 9, y2);
                        p.addPoint(x1 + 4, y1 - 9);
                    }
                    p.addPoint(x1 + 9, y1);
                    p.addPoint(x2 - 9, y1);
                    if (w + 1 == this.curIndex) {
                        g.drawLine(x2 - 5, y1 - 9, x2 - 9, y1);
                        p.addPoint(x2 - 5, y1);
                        p.addPoint(x2 - 9, y2);
                    } else {
                        g.drawLine(x2, y2, x2 - 9, y1);
                        p.addPoint(x2, y2);
                    }
                    if (w == 1 || w == this.curIndex) {
                        p.addPoint(x1, y2);
                    } else {
                        p.addPoint(x1 + 9, y2);
                    }
                } else {
                    if (w == this.curIndex) {
                        y1 += 3;
                        x1 -= 2;
                    }
                    g.setColor(this.borderLightColor);
                    if (this.curIndex == w + 1) {
                        g.drawLine(x1 + 2, y1, x2 - 2, y1);
                    } else {
                        g.drawLine(x1 + 2, y1, x2, y1);
                    }
                    if (this.curIndex != w - 1) {
                        g.drawLine(x1, y1 - 2, x1, y2);
                        x3 = x1;
                    } else {
                        x3 = x1 + 1;
                    }
                    g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 - 1);
                    if (this.curIndex != w + 1) {
                        g.setColor(this.borderDarkColor);
                        g.drawLine(x2, y1, x2, y2);
                        g.setColor(this.borderDarkerColor);
                        g.drawLine(x2 + 1, y1 - 2, x2 + 1, y2);
                        x4 = x2;
                    } else {
                        x4 = x2 - 1;
                    }
                }
                if (w == this.curIndex) {
                    y2 = this.iTabsPosition == 0 ? ++y2 : --y2;
                    g.setColor(curBackground);
                    g.drawLine(x1 + 1, y2, x2, y2);
                    if (this.iTabsPosition == 1) {
                        g.drawLine(x1 + 1, y2 - 1, x2, y2 - 1);
                    }
                    g.setFont(this.fSel);
                } else {
                    g.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0) {
                    p.addPoint(x3, y2);
                    p.addPoint(x4, y2);
                    p.addPoint(x4, y1);
                    p.addPoint(x3, y1);
                    p.addPoint(x3, y2);
                }
                this.vPolys.addElement(p);
                Boolean bool = (Boolean)this.vEnabled.elementAt(w);
                if (bool.booleanValue()) {
                    g.setColor(curForeground);
                } else {
                    g.setColor(this.disabledTextColor);
                }
                if (this.iTabsPosition == 0) {
                    g.drawString(sLabel, x1 + 8, y1 + 15 + this.osAdjustment);
                } else if (this.iTabsStyle == 0) {
                    g.drawString(sLabel, x1 + 8, y1 - 6 + this.osAdjustment);
                } else {
                    g.drawString(sLabel, x1 + 14, y1 - 4 + this.osAdjustment);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++w;
        }
        if (this.firstVisibleTab > 0 || w < sze) {
            this.dbLeft.show();
            this.dbRight.show();
            if (this.firstVisibleTab > 0) {
                this.dbLeft.setEnabled(true);
            } else {
                this.dbLeft.setEnabled(false);
            }
            if (w < sze) {
                this.dbRight.setEnabled(true);
            } else {
                this.dbRight.setEnabled(false);
            }
            if (this.iTabsPosition == 0) {
                this.dbLeft.reshape(r.width - 33 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
                this.dbRight.reshape(r.width - 16 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
            } else {
                this.dbLeft.reshape(r.width - 33 + this.TF_RIGHT, r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
                this.dbRight.reshape(r.width - 16 + this.TF_RIGHT, r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
            }
        } else {
            this.dbLeft.hide();
            this.dbRight.hide();
        }
        while (w < sze) {
            this.vPolys.addElement(this.nullPoly);
            ++w;
        }
        g.setFont(f);
        g.setColor(c);
    }

    public Component add(Component comp) {
        return comp;
    }

    public synchronized Component add(Component comp, int pos) {
        return comp;
    }

    public synchronized Component add(String name, Component comp) {
        return comp;
    }

    public synchronized void remove(Component comp) {
        if (comp == this.dbLeft || comp == this.dbRight) {
            return;
        }
        super.remove(comp);
        if (comp == this.userPanel) {
            this.userPanel = null;
        }
    }

    public synchronized void removeAll() {
        super.removeAll();
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.userPanel = null;
    }

    public void setLayout(LayoutManager mgr) {
    }

    public Insets insets() {
        this.btpInsets = super.insets();
        this.btpInsets.left += this.TF_LEFT + 3;
        this.btpInsets.right += 6 - this.TF_RIGHT;
        if (this.iTabsPosition == 0) {
            this.btpInsets.top += this.TF_TOP + 3;
            this.btpInsets.bottom += 5 - this.TF_BOTTOM;
        } else {
            this.btpInsets.top += this.TF_TOP - this.TF_BTN_HEIGHT + 3;
            this.btpInsets.bottom += this.TF_BTN_HEIGHT + 5 - this.TF_BOTTOM;
        }
        return this.btpInsets;
    }

    public Dimension getPreferredSize() {
        Dimension s = this.size();
        Dimension m = this.minimumSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height, m.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.userPanel != null) {
            Dimension s = this.userPanel.minimumSize();
            return new Dimension(s.width + this.btpInsets.left + this.btpInsets.right, s.height + this.btpInsets.top + this.btpInsets.bottom);
        }
        return new Dimension(100, 100);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.dbLeft.addActionListener(this.action);
            this.dbRight.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.dbLeft.removeActionListener(this.action);
            this.dbRight.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addCurrentTabListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("CurrentTab", listener);
    }

    public void removeCurrentTabListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("CurrentTab", listener);
    }

    public void addCurrentTabListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("CurrentTab", listener);
    }

    public void removeCurrentTabListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("CurrentTab", listener);
    }

    protected void calculateBorderColors(Color c) {
        this.borderLightColor = ColorUtils.calculateHilightColor(c);
        this.borderDarkColor = ColorUtils.calculateShadowColor(c);
        this.borderDarkerColor = ColorUtils.darken(this.borderDarkColor, 0.2);
    }

    protected void calculateDisabledTextColor(Color c) {
        try {
            this.disabledTextColor = ColorUtils.fade(c, Color.lightGray, 0.5);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            int sizeR = BaseTabbedPanel.this.vPolys.size();
            int x = 0;
            while (x < sizeR) {
                try {
                    Polygon p = (Polygon)BaseTabbedPanel.this.vPolys.elementAt(x);
                    if (p != BaseTabbedPanel.this.nullPoly && p.inside(e.getX(), e.getY())) {
                        try {
                            BaseTabbedPanel.this.setCurrentTab(x);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                ++x;
            }
        }

        Mouse() {
            BaseTabbedPanel.this = BaseTabbedPanel.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BaseTabbedPanel.this.dbLeft) {
                if (--BaseTabbedPanel.this.firstVisibleTab < 0) {
                    BaseTabbedPanel.this.firstVisibleTab = 0;
                } else {
                    BaseTabbedPanel.this.triggerRepaint();
                }
            } else if (e.getSource() == BaseTabbedPanel.this.dbRight) {
                int sze = BaseTabbedPanel.this.vLabels.size();
                if (++BaseTabbedPanel.this.firstVisibleTab == sze) {
                    --BaseTabbedPanel.this.firstVisibleTab;
                } else {
                    BaseTabbedPanel.this.triggerRepaint();
                }
            }
        }

        Action() {
            BaseTabbedPanel.this = BaseTabbedPanel.this;
        }
    }
}

