// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	VC4Demo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	To run VC4Demo.EXE you need ZS30W32.OCX and the Microsoft
//	DLLs: MSVCRT40.DLL, MFC40.DLL and OLEPRO32.DLL. (The
//	DLLs must be on the same directory or in WINDOWS/SYSTEM)
// ------------------------------------------------------------------------------------------------------------------------
#ifndef __ZSOCX_H__
#define __ZSOCX_H__

// Machine generated IDispatch wrapper class(es) created by Microsoft Visual C++

// NOTE: Do not modify the contents of this file.  If this class is regenerated by
//  Microsoft Visual C++, your modifications will be overwritten.

/////////////////////////////////////////////////////////////////////////////
// CZSOcx wrapper class

class CZSOcx : public CWnd
{
protected:
	DECLARE_DYNCREATE(CZSOcx)
public:
	CLSID const& GetClsid()
	{
		static CLSID const clsid
			= { 0x70ba6e3, 0xbc0b, 0x11cf, { 0xab, 0xb4, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };
		return clsid;
	}
	virtual BOOL Create(LPCTSTR lpszClassName,
		LPCTSTR lpszWindowName, DWORD dwStyle,
		const RECT& rect,
		CWnd* pParentWnd, UINT nID,
		CCreateContext* pContext = NULL)
	{ return CreateControl(GetClsid(), lpszWindowName, dwStyle, rect, pParentWnd, nID); }

    BOOL Create(LPCTSTR lpszWindowName, DWORD dwStyle,
		const RECT& rect, CWnd* pParentWnd, UINT nID,
		CFile* pPersist = NULL, BOOL bStorage = FALSE,
		BSTR bstrLicKey = NULL)
	{ return CreateControl(GetClsid(), lpszWindowName, dwStyle, rect, pParentWnd, nID,
		pPersist, bStorage, bstrLicKey); }

// Attributes
public:

// Operations
public:
	BOOL IsFileNameInFilter(LPCTSTR szName, LPCTSTR szPattern);
	short GetZipBufferSize();
	short GetUnzipBufferSize();
	void ZipCancel(BOOL bCancel);
	short ZipGetReplaceFlag();
	short Split(LPCTSTR szZipName, LPCTSTR szDestDir, long lFirstBlockSizeInBytes, long lNextBlockSizeInBytes, BOOL bBackGroundProcessing, LPCTSTR szTitle, LPCTSTR szMsg);
	short SetGlobalComment(LPCTSTR szZipName, LPCTSTR szComment, BOOL bBackGroundProcessing);
	short SetLocalComment(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szComment, BOOL bBackGroundProcessing);
	short Repare(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	short MakeEXEFile(LPCTSTR szZipName, LPCTSTR szEXEName, LPCTSTR szProgramToLaunch, LPCTSTR szEXETitle, LPCTSTR szELFFile, short iOverwriteMode, BOOL bAskDirectory, BOOL bWin32Target, BOOL bBackGroundProcessing);
	short DeleteWithMask(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing);
	BOOL CreateBlankZIPFile(LPCTSTR szZipName, BOOL bOpenDialog);
	BOOL GetZIPITEMIsDir(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsEncrypted(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsArchive(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsHidden(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsSystem(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsReadOnly(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	BOOL GetZIPITEMIsAnnotated(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMMethod(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMDay(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMMonth(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMYear(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMHour(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMMin(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMRate(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short GetZIPITEMIconIndex(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	long GetZIPITEMOriginalSize(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	double GetZIPITEMCrc(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	short UnzipGetReplaceFlag();
	BOOL BuildZIPITEMImageList();
	BOOL DestroyZIPITEMImageList();
	void DestroyZIPITEMLParam(long hListZIPITEM);
	short GetZIPINFOMadeUnder(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	short GetZIPINFOVersionMinor(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	CString GetGlobalComment(LPCTSTR szZipName, short iMaxLength, BOOL bBackGroundProcessing);
	short GetGlobalCommentSize(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	CString GetLocalComment(LPCTSTR szZipName, LPCTSTR szMask, short iMaxLength, BOOL bBackGroundProcessing);
	short GetCount(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	double GetTotalSize(LPCTSTR szZipName, BOOL bOriginalSize, BOOL bBackGroundProcessing);
	BOOL IsFileInTheZIPFile(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing);
	BOOL SortZIPITEMList(long hListZIPITEM, short iSortMode, BOOL bBackGroundProcessing);
	short Join(LPCTSTR szPartFileName, LPCTSTR szDestDirectory, LPCTSTR szTitle, LPCTSTR szMsg, BOOL bBackGroundProcessing);
	short Restore(LPCTSTR szSourceDirectory, LPCTSTR szDestinationDirectory, short iOverwriteMode, BOOL bDisplayDialog, BOOL bEraseReadOnlyFiles, LPCTSTR szTitle, LPCTSTR szMsg, BOOL bBackGroundProcessing);
	void UnzipCancel(BOOL bCancel);
	short UnzipToFile(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szDestFile, BOOL bEraseReadOnlyFiles, LPCTSTR szPassword, BOOL bAskPassword, BOOL bAckGroundProcessing);
	short IsZIPFileQuick(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	short IsZIPFileSlow(LPCTSTR szZipName, LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing);
	short Backup(LPCTSTR szMask, LPCTSTR szDestDrive, BOOL bRecurse, BOOL bUseArchiveFlag, BOOL bRemoveArchiveFlag, BOOL bForceSingleBackup, LPCTSTR szTitle, LPCTSTR szMsg, short iCompressionMode, BOOL bBackGroundProcessing);
	BOOL View(LPCTSTR szZipName, LPCTSTR szMask, BOOL bUseTextEditor, BOOL bRunEXE, LPCTSTR szPrivateTempDir, LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing);
	void SetStringResource(short iStringID, LPCTSTR szValue);
	BOOL IsDisketteReady(LPCTSTR szDiskette);
	BOOL IsDriveWriteable(LPCTSTR szDrive);
	BOOL IsWriteable(LPCTSTR szDestFile, long lSizeInBytes);
	void SetHelpFile(LPCTSTR szHelpFile);
	void SetIniFile(LPCTSTR szFile);
	void SetPasswordMode(BOOL bShow, BOOL bSave);
	void DeletePasswords();
	short GetZIPINFOVersionMajor(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	short GetZIPINFODiskID(LPCTSTR szZipName, BOOL bBackGroundProcessing);
	short GetLocalCommentSize(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing);
	CString GetNewZIPName();
	short UnzipFiles(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szDestDirectory, BOOL bRebuildDir, BOOL bEraseReadOnlyFiles, short iOverwriteMode, LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing);
	short ZipFiles(LPCTSTR szZipName, LPCTSTR szMask, BOOL bRecurseSubDirs, short iStorePathMethod, short iOverwriteMode, short iCompressionMode, BOOL bUseArchiveFlag, BOOL bRemoveArchiveFlag, LPCTSTR szPassword, BOOL bBackGroundProcessing);
	short BuildZIPITEMList(LPCTSTR szZipName, long hListZIPITEM, BOOL bListCtrlMode, LPCTSTR szPrivateTempDirectory, BOOL bWindowsIcons, short iSortMode, BOOL bBackGroundProcessing);
	short DeleteWithSelection(LPCTSTR szZipName, long hListZIPITEM, long hListSelected, BOOL bListIsListCtrl, BOOL bBackGroundProcessing);
	CString GetZIPITEMName(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	CString GetZIPITEMDir(long hListZIPITEM, short iIndex, BOOL bListCtrlMode);
	long GetZIPITEMHImageList(BOOL bBigIcons);
	BOOL DeleteTempDirectories();
	BOOL SetListViewImageList(long hListView);
	BOOL Initialize(long lSerialNumber, LPCTSTR szName, LPCTSTR szPassword);
	void AboutBox();
};

#endif // __ZSOCX_H__
