// ----------------------------------------------------------------------------
//	Constants for Zip Studio 3.0 OCXes
//	Copyright Hexanet SW 1993-1996, All rights reserved
//	
//	ZS30CONS.H
//	June - 02 - 1996
//
// ----------------------------------------------------------------------------
#define _ZS30CONS_H

#ifdef _WIN32
	#undef _MAX_PATH
	#define _MAX_PATH	1024
#endif


// ----------------------------------------------------------------------------
//	Strings ID (use with <SetStringResource>)
// ----------------------------------------------------------------------------
#define ZSAPI_STRINGID_TEXTNOPASSWORD				0
#define ZSAPI_STRINGID_TEXTWITHPASSWORD				1
#define ZSAPI_STRINGID_RENAMEBOXTITLE				2
#define ZSAPI_STRINGID_OLDERTEXT				3
#define ZSAPI_STRINGID_NEWERTEXT				4
#define ZSAPI_STRINGID_REPLACETEXT				5
#define ZSAPI_STRINGID_OK					6
#define ZSAPI_STRINGID_CANCEL					7
#define ZSAPI_STRINGID_REPLACEBOXTITLE				8
#define ZSAPI_STRINGID_YES					9
#define ZSAPI_STRINGID_NO					10
#define ZSAPI_STRINGID_ALWAYS					11
#define ZSAPI_STRINGID_NEVER					12
#define ZSAPI_STRINGID_RENAME					13
#define ZSAPI_STRINGID_PASSWORDBOXTITLE				14
#define ZSAPI_STRINGID_PASSWORDLABEL				15
#define ZSAPI_STRINGID_RETRY					16
#define ZSAPI_STRINGID_BYPASS					17
#define ZSAPI_STRINGID_CHOOSEBACKUPTITLE			19
#define ZSAPI_STRINGID_ZIPMAK					20
#define ZSAPI_STRINGID_NEWZIPDIALOGTITLE             		21


// ----------------------------------------------------------------------------
//	Unzip part
// ----------------------------------------------------------------------------

/* General Unzip functions returned value */
#define 	ZEXTRACT_OK			0
#define 	ZEXTRACT_INTERNALERROR  	1
#define 	ZEXTRACT_FILENOTFOUND		2
#define 	ZEXTRACT_CORRUPTED		3
#define 	ZEXTRACT_EMPTY			4
#define 	ZEXTRACT_ERRORINZIPFILE		5	 
#define 	ZEXTRACT_NOMEM			6
#define 	ZEXTRACT_DISKFULL		8
#define 	ZEXTRACT_WASRDONLY		10	// 3.0: A file was bypassed because RO
#define 	ZEXTRACT_WASLOCKED		11	// 3.0: A file was bypassed because locked
#define 	ZEXTRACT_IOERROR		12	// 3.0: I/O error like diskette missing
#define 	ZEXTRACT_DRIVENOTREADY		13 	// 3.0
#define 	ZEXTRACT_DRIVEREADONLY		14	// 3.0
#define 	ZEXTRACT_DISKWPROTECTED		15	// 3.0: The warning was already displayed
#define 	ZEXTRACT_TOOBIG			16	// 3.0: The mask is too long (more than _MAX_PATH)
#define 	ZEXTRACT_NOCHANGEALLOWED	17	// 3.0: The ZIP should be read-only (partially supported ZIP format)


/* <iOverwriteMode> for Unzip functions */
#define 	OVERWRITE_TRUE			1		
#define 	OVERWRITE_FALSE			0
#define 	OVERWRITE_QUERY	    		2	
#define 	OVERWRITE_UPDATE		3	//3.0: Only unzip the newer files

#define 	CREATEDIR_TRUE			1
#define 	CREATEDIR_FALSE			0


/* <ZIPITEMBuiltUnder> code */
#define 	ZIP_UNDER_DOS			0
#define 	ZIP_UNDER_AMIGA	  		1
#define 	ZIP_UNDER_VMS			2
#define 	ZIP_UNDER_UNIX			3
#define 	ZIP_UNDER_VM		 	4
#define 	ZIP_UNDER_ATARIST		5
#define 	ZIP_UNDER_OS2HPFS		6
#define 	ZIP_UNDER_MAC			7
#define 	ZIP_UNDER_ZSYSTEM		8
#define 	ZIP_UNDER_W32			11
#define 	ZIP_UNDER_UNKNOWN		9


/* <ZIPITEMMethod> code */
#define 	ZMETHOD_STORED			0
#define 	ZMETHOD_SHRUNK			1
#define 	ZMETHOD_REDUCE1			2
#define 	ZMETHOD_REDUCE2			3
#define 	ZMETHOD_REDUCE3			4
#define 	ZMETHOD_REDUCE4			5
#define 	ZMETHOD_IMPLODE			6
#define 	ZMETHOD_TOKEN			7
#define 	ZMETHOD_DEFLATE			8
#define 	ZMETHOD_UNKNOWN			9
#define 	ZMETHOD_ERROR			10


/* <Join> returned values */
#define 	JOIN_OK				0
#define 	JOIN_NOFILE			1
#define 	JOIN_NOMEM			2
#define 	JOIN_IOERROR			3
#define 	JOIN_ACCESSDENIED	  	4
#define 	JOIN_USERABORT			5
#define 	JOIN_NOTASPLITTEDFILE 		7
#define 	JOIN_ZIPEXIST			8
#define 	JOIN_DISKFULL			9


/* <Restore> returned values */
#define 	ZRESTORE_OK			0	// Ok
#define 	ZRESTORE_NOTALONE		1	// Possible result code when <bCanAsk> is set to FALSE
#define 	ZRESTORE_NOTEMP       		2	// Can' t create the temporary file name!
#define 	ZRESTORE_USERABORT       	3	// User abort
#define 	ZRESTORE_NONE			4	// Nothing to do
#define 	ZRESTORE_JOINERROR		10	// JOINERROR is the result code of <ZipJoin> + 10 (but JOIN_OK)
#define 	ZRESTORE_UNZIPERROR		40	// UNZIPERROR is the result code of <ExtractZipFiles> + 40 (but ZEXTRACT_OK)

/* The ZIPITEM structure */
typedef struct TAGZIPITEM
       	{
    #ifndef _WIN32
       	TCHAR szName[50];
       	TCHAR szDir[260];
    #else
       	TCHAR szName[260];
       	TCHAR szDir[_MAX_PATH];
    #endif
       	BOOL bIsDir;
       	BOOL bIsEncrypted;
       	int iMethod;
       	int iDay;
       	int iMonth;
       	int iYear;
       	int iHour;
       	int iMin;
       	long lOriginalSize;
       	int iRate;
       	BOOL bArchive;
       	BOOL bHidden;
       	BOOL bSystem;
       	BOOL bRO;
       	BOOL bComment;
       	int iIconIndex;
       	unsigned long ulCrc32;
       	}ZIPITEM;
        

/* <ZIPITEMIconIndex> special codes (or index if you don' t ask the Windows icons) */
#define 	ZITEM_ICON_DIR		0
#define 	ZITEM_ICON_ENCRYPTED    1
#define 	ZITEM_ICON_EXE		2
#define 	ZITEM_ICON_ERROR	3
#define 	ZITEM_ICON_KNOWN	4
#define 	ZITEM_ICON_UNKNOWN	5


/* <ZList> sort mode */
#define 	ZSORT_BYFULLNAME	0	// name + dir
#define 	ZSORT_BYNAME		1
#define 	ZSORT_BYDIR		2
#define 	ZSORT_BYDATE		3
#define 	ZSORT_BYSIZE		4
#define 	ZSORT_BYRATE		5
#define 	ZSORT_NONE		6


// ----------------------------------------------------------------------------
//	Zip part
// ----------------------------------------------------------------------------

/* General Zip functions returned value */
#define 	ZERROR_OK		0	// No error
#define 	ZERROR_WARNING		1	// Just a warning (not an error)
#define 	ZERROR_DESTFILE		2	// Destfile ( *.ZIP ) error
#define 	ZERROR_INTERNAL 	3	// Internal error
#define 	ZERROR_FORMAT		4	// Not a Zip file
#define 	ZERROR_NOMEM		5	// Not enough memory 
#define 	ZERROR_NOFILE		6	// Nothing to do ( can be just a warning )
#define 	ZERROR_NODLL		7	// Can' t find required DLLs (under Win16)
#define 	ZERROR_COMMENT		8	// Comment missing or NULL
#define 	ZERROR_NOCRYPT		9	// Can' t encrypt the files
#define 	ZERROR_ACCESSDENIED	12 	// 3.0
#define 	ZERROR_DRIVENOTREADY	13 	// 3.0
#define 	ZERROR_DRIVEREADONLY	14	// 3.0
#define 	ZERROR_DISKWPROTECTED	15	// 3.0: The warning was already displayed
#define 	ZERROR_DISKFULL		16	// 3.0: The warning was already displayed
#define 	ZERROR_USERABORT	17	// 3.0

/* <ZipMakeEXEFile> errors*/
#define 	ZEXE_OK			0
#define 	ZEXE_ELFFILEMISSING	1	// EXE Language File not found
#define 	ZEXE_AUTOLOADMISSING	2	// AUTOLOAD.16 or AUTOLOAD.32 not found in the app. dir.
#define 	ZEXE_AUTOLOADCORRUPTED	3	// Bad version of AUTOLOAD.16 or AUTOLOAD.32 
#define 	ZEXE_NOZIPFILE		4	// Source file mising
#define 	ZEXE_SRCACCESSDENIED	5	// Source file locked
#define 	ZEXE_DESTACCESSDENIED	6	// Exe file locked
#define 	ZEXE_DRIVENOTREADY	7
#define 	ZEXE_DRIVEREADONLY	8
#define 	ZEXE_DISKWPROTECTED	9
#define 	ZEXE_DISKFULL		10
#define 	ZEXE_NOMEM		11

/* Compression method setting */
#define 	ZMODE_NORMAL		0
#define 	ZMODE_FAST		1
#define 	ZMODE_SLOW		2
#define 	ZMODE_STORE		3

/* <Backup> result */
#define 	ZBACKUP_OK			0	// Ok
#define 	ZBACKUP_NOTEMP       		1	// Can' t create the temporary file name!
#define 	ZBACKUP_USERABORT       	2	// User abort
#define 	ZBACKUP_NOTALONE		3	 // Possible result code when <bForceSingle> is set to TRUE
#define 	ZBACKUP_WARNNOTHING		4	// <AddFileToZip> didn' t build the ZIP file (nothing to do)
#define 	ZBACKUP_ACCESSDENIEDFORALL	5	// <AddFileToZip> didn' t build the ZIP file, all files were Access denied!
#define 	ZBACKUP_ACCESSDENIED		6	// <AddFileToZip> built the file but there was some AD.
#define 	ZBACKUP_ZIPERROR		10	// ZIPERROR is the result code of <AddFileToZip> + 10 (but ZERROR_OK)
#define 	ZBACKUP_SPLITERROR		40	// SPLITERROR is the result code of <ZipSplit> + 40 (but SPLIT_OK)

/* <Split> returned code */
#define 	SPLIT_OK		0
#define 	SPLIT_NOFILE		1
#define 	SPLIT_NOMEM		2
#define 	SPLIT_IOERROR		3
#define 	SPLIT_TOOBIG		4
#define 	SPLIT_ACCESSDENIED	5
#define 	SPLIT_USERABORT		6
#define 	SPLIT_DISKFULL		10	// 3.0
#define 	SPLIT_WPROTECTED	11	// 3.0	    
			
/* Zip functions <iOverwrite> mode */
#define 	OVERWRITE_ALWAYS	0	// Always overwrite ( always zip files ) (default)
#define 	OVERWRITE_NEVER		1 	// Never overwrite
#define 	OVERWRITE_PROMPT	2	// Ask the user
#define 	OVERWRITE_UPDATE	3	// Overwrite if external file is newer
#define 	OVERWRITE_FRESHEN	4	// Overwrite if external file is newer, do not add new entries [3.0]

/* <ZipFiles> misc. settings */
#define 	STOREPATH_NO		0	// Don' t store paths
#define 	STOREPATH_YES		1	// Store paths
#define 	STOREPATH_FULL		2	// Store paths	(complete names) [3.0]
#define 	RECURSE_NO		0	// Don' t recurse sub dirs
#define 	RECURSE_YES		1	// Recurse sub dirs

