// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	VC4Demo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	To run VC4Demo.EXE you need ZS30W32.OCX and the Microsoft
//	DLLs: MSVCRT40.DLL, MFC40.DLL and OLEPRO32.DLL. (The
//	DLLs must be on the same directory or in WINDOWS/SYSTEM)
// ------------------------------------------------------------------------------------------------------------------------
#include "stdafx.h"
#include "VC4Demo.h"
#include "MainFrm.h"
#include "ZDoc.h"
#include "ZView.h"
#include "ZipBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern HWND gHwndInProcess;	// Either the Zip or UnZip box that will receieve the notification messages
											// from CZView.

// Redirected private messages from the main View
#ifndef PM_REDIRECT_ZNZIPPING2
	#define PM_REDIRECT_ZNZIPPING2			(WM_USER + 1)
	#define PM_REDIRECT_ZNEXPANDING			(WM_USER + 2)
#endif

// Same as VB <DoEvents> (required for notification messages)
extern void AfxGiveTheHand( );

// Returns a reference for the global Zip Studio OCX
extern CZSOcx& GetZipStudioOcx();



/////////////////////////////////////////////////////////////////////////////
// CZipBox dialog


CZipBox::CZipBox(CWnd* pParent /*=NULL*/)
	: CDialog(CZipBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CZipBox)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CZipBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZipBox)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CZipBox, CDialog)
	//{{AFX_MSG_MAP(CZipBox)
	ON_MESSAGE( PM_REDIRECT_ZNZIPPING2, OnZNZipping2 )
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZipBox message handlers

void CZipBox::OnBrowse() 
	{
	// -------------------------------------------------------------------
	//	We use Win95 <SHBrowseForFolder>
	LPITEMIDLIST iItem;                    
	BROWSEINFO bInfo;
	TCHAR szBuffer2[_MAX_PATH], szPath[_MAX_PATH], szDir[_MAX_PATH];
	lstrcpy( szBuffer2, _T("") );
	lstrcpy( szPath, _T("") );

	bInfo.hwndOwner = m_hWnd;
	bInfo.pidlRoot = NULL;
	bInfo.pszDisplayName = szBuffer2;
	bInfo.lpszTitle = NULL;
	bInfo.ulFlags = BIF_RETURNONLYFSDIRS;
	bInfo.lpfn = NULL;        // see below 
	if ( (iItem = SHBrowseForFolder( &bInfo ) ) )
		{
		if ( SHGetPathFromIDList( iItem, szPath) )
			{
			lstrcpy( szDir , szPath );
			if ( szDir[ lstrlen( szDir ) -1 ] != '\\' )
				lstrcat( szDir, _T("\\") );
			((CEdit*)GetDlgItem( IDC_EDITSRCDIR ))->SetWindowText( szDir );
			}
		}
	}


void CZipBox::OnOK() 
{
		if ( !m_bCanClose )
		return;
	CString sSrcDir, sMask, sPassword, sZipFile, sResult;
	int iOverwrite, iResult, iComp, iStorePath;
	BOOL bBackGroundProcessing, bUseArc, bRemoveArc, bRecurse;

	gHwndInProcess = m_hWnd;

	((CEdit*)GetDlgItem( IDC_EDITSRCDIR ))->GetWindowText( sSrcDir );
	sSrcDir.AnsiToOem();
	if ( sSrcDir.Right(1) != _T("\\") )
		sSrcDir += _T("\\");

	((CEdit*)GetDlgItem( IDC_EDITPATTERN ))->GetWindowText( sMask );
	sMask.AnsiToOem();
	if ( sMask == _T("") )
		sMask = _T("*.*");
	sSrcDir += sMask;

	((CEdit*)GetDlgItem( IDC_EDITPASSWORD ))->GetWindowText( sPassword );
	sPassword.AnsiToOem();
	iOverwrite = ((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->GetCurSel(  );
	if ( iOverwrite < 0 )
		iOverwrite = 2;
	iComp = ((CComboBox*)GetDlgItem( IDC_COMBOCOMPMODE ))->GetCurSel(  );
	if ( iComp < 0 )
		iOverwrite = 0;
	iStorePath = ((CComboBox*)GetDlgItem( IDC_COMBOKEEPPATH ))->GetCurSel(  );
	if ( iStorePath < 0 )
		iStorePath = 0;



	bBackGroundProcessing = IsDlgButtonChecked( IDC_CHECKBACKGROUND );
	bRecurse = IsDlgButtonChecked( IDC_CHECKRECURSE );
	bUseArc = IsDlgButtonChecked( IDC_CHECKUSEARC );
	bRemoveArc = IsDlgButtonChecked( IDC_CHECKREMOVEARC );


	sZipFile = (((CMainFrame*)AfxGetMainWnd())->GetActiveDocument())->GetPathName();
	if ( sZipFile == _T(""))
		{
		MessageBox( "Please open an existing ZIP file before calling this function.");
		CDialog::OnOK();
		return;
		}
	sZipFile.AnsiToOem();
	

	m_bCanClose = FALSE;
	GetDlgItem( IDOK )->EnableWindow( FALSE );
	GetDlgItem( IDCANCEL )->EnableWindow( FALSE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( FALSE );
	iResult = (int)GetZipStudioOcx().ZipFiles( sZipFile, sSrcDir, bRecurse, iStorePath, 
			iOverwrite, iComp, bUseArc, bRemoveArc, sPassword, bBackGroundProcessing );
	
	
	if ( iResult > 0 )
		{
		sResult.Format( _T("<ZipFiles> returns an Error/Warning code [%i]."), iResult );
		MessageBox( sResult );
		}
	sZipFile.OemToAnsi();
	
	// Re-Open and rebuild the new ZIP file list.
	((CZDoc*)((CMainFrame*)AfxGetMainWnd())->GetActiveDocument())->OnOpenDocument( sZipFile );
	GetDlgItem( IDOK )->EnableWindow( TRUE );
	GetDlgItem( IDCANCEL )->EnableWindow( TRUE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( TRUE );
	m_bCanClose = TRUE;
	CDialog::OnOK();
}

void CZipBox::OnClose() 
{
	if ( m_bCanClose )
		CDialog::OnClose();
	else
		MessageBeep( (UINT)-1 );
}

BOOL CZipBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_bCanClose = TRUE;
	((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->SetCurSel( 2 );
	((CComboBox*)GetDlgItem( IDC_COMBOKEEPPATH ))->SetCurSel( 0 );
	((CComboBox*)GetDlgItem( IDC_COMBOCOMPMODE ))->SetCurSel( 0 );
	CString sTemp;
	GetCurrentDirectory( _MAX_PATH, sTemp.GetBuffer(_MAX_PATH) );
	sTemp.ReleaseBuffer();
	if ( sTemp.Right(1) != _T("\\") )
		sTemp += _T("\\");
	((CEdit*)GetDlgItem( IDC_EDITSRCDIR ))->SetWindowText( sTemp );
	((CEdit*)GetDlgItem( IDC_EDITPATTERN ))->SetWindowText( _T("*.*") );
	((CButton*)GetDlgItem( IDC_CHECKBACKGROUND ))->SetCheck( 1 );
	return TRUE; 
}

// Redirected message from the main View:
//	Since we built the Zip Studio OCX on the main View, this dialog box doesn' t
//	receive the OCX notification messages. That' s why we give the HWND of the
//	dialog box (gHwndInProcess) to the main View so that this view send us back
//	a 'private' notification message.
LRESULT CZipBox::OnZNZipping2( WPARAM wParam, LPARAM lParam )
	{
	CString sTemp = (LPCTSTR)lParam, sMsg;
	int i = 0;
	if ( (i = sTemp.ReverseFind('\\')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else if ( (i = sTemp.ReverseFind('/')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else
		sTemp = _T("???");
	sMsg.Format(_T("%s [%i %%]"), (LPCTSTR)sTemp, (int)wParam );
	SetWindowText( sMsg );
	AfxGiveTheHand();
	return 0L;
	}
