// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	VC4Demo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	To run VC4Demo.EXE you need ZS30W32.OCX and the Microsoft
//	DLLs: MSVCRT40.DLL, MFC40.DLL and OLEPRO32.DLL. (The
//	DLLs must be on the same directory or in WINDOWS/SYSTEM)
// ------------------------------------------------------------------------------------------------------------------------
#include "stdafx.h"
#include "VC4Demo.h"
#include "MainFrm.h"
#include "ZDoc.h"
#include "ZView.h"
#include "UZBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// --------------------------------------
//	We will test Zip Studio 3.0 <UnzipFiles> method


extern HWND gHwndInProcess;	// Either the Zip or UnZip box that will receieve the notification messages
											// from CZView.

// Redirected message from the main View
#ifndef PM_REDIRECT_ZNZIPPING2
	#define PM_REDIRECT_ZNZIPPING2			(WM_USER + 1)
	#define PM_REDIRECT_ZNEXPANDING			(WM_USER + 2)
#endif

// Same as DoEvents (require for notification messages treatments)
extern void AfxGiveTheHand( );

// Returns a reference the the global Zip Studio OCX instance
extern CZSOcx& GetZipStudioOcx();



/////////////////////////////////////////////////////////////////////////////
// CUnzipBox dialog


CUnzipBox::CUnzipBox(CWnd* pParent /*=NULL*/)
	: CDialog(CUnzipBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUnzipBox)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CUnzipBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUnzipBox)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUnzipBox, CDialog)
	//{{AFX_MSG_MAP(CUnzipBox)
	ON_MESSAGE( PM_REDIRECT_ZNEXPANDING, OnZNExpanding )
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUnzipBox message handlers

void CUnzipBox::OnOK() 
{
	if ( !m_bCanClose )
		return;
	CString sDestDir, sMask, sPassword, sZipFile, sResult;
	int iOverwrite, iResult;
	BOOL bBackGroundProcessing, bEraseReadOnlyFiles, bRebuildDir;

	gHwndInProcess = m_hWnd;

	((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->GetWindowText( sDestDir );
	sDestDir.AnsiToOem();
	if ( sDestDir.Right(1) != _T("\\") )
		sDestDir += _T("\\");

	((CEdit*)GetDlgItem( IDC_EDITMASK ))->GetWindowText( sMask );
	sMask.AnsiToOem();
	if ( sMask == _T("") )
		sMask = _T("*.*");

	((CEdit*)GetDlgItem( IDC_EDITPASSWORD ))->GetWindowText( sPassword );
	sPassword.AnsiToOem();
	iOverwrite = ((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->GetCurSel(  );
	if ( iOverwrite < 0 )
		iOverwrite = 2;

	bBackGroundProcessing = IsDlgButtonChecked( IDC_CHECKBACKGROUND );
	bEraseReadOnlyFiles = IsDlgButtonChecked( IDC_CHECKERASERO );
	bRebuildDir = IsDlgButtonChecked( IDC_CHECKREBUILDDIR );

	sZipFile = (((CMainFrame*)AfxGetMainWnd())->GetActiveDocument())->GetPathName();
	if ( sZipFile == _T(""))
		{
		MessageBox( "Please open an existing ZIP file before calling this function.");
		CDialog::OnOK();
		return;
		}
	sZipFile.AnsiToOem();
	

	m_bCanClose = FALSE;
	GetDlgItem( IDOK )->EnableWindow( FALSE );
	GetDlgItem( IDCANCEL )->EnableWindow( FALSE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( FALSE );
	
	// The Zip Studio OCX method
	iResult = (int)GetZipStudioOcx().UnzipFiles( sZipFile, sMask, sDestDir, bRebuildDir, 
			bEraseReadOnlyFiles, iOverwrite, sPassword, TRUE /*AskPwd*/, bBackGroundProcessing );
	if ( iResult > 0 )
		{
		sResult.Format( _T("<UnzipFiles> returns an Error/Warning code [%i]."), iResult );
		MessageBox( sResult );
		}
	GetDlgItem( IDOK )->EnableWindow( TRUE );
	GetDlgItem( IDCANCEL )->EnableWindow( TRUE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( TRUE );
	m_bCanClose = TRUE;
	CDialog::OnOK();
	}

void CUnzipBox::OnBrowse() 
{
// -------------------------------------------------------------------
//	We use Win95 <SHBrowseForFolder>
LPITEMIDLIST iItem;                    
BROWSEINFO bInfo;
TCHAR szBuffer2[_MAX_PATH], szPath[_MAX_PATH], szDir[_MAX_PATH];
lstrcpy( szBuffer2, _T("") );
lstrcpy( szPath, _T("") );

bInfo.hwndOwner = m_hWnd;
bInfo.pidlRoot = NULL;
bInfo.pszDisplayName = szBuffer2;
bInfo.lpszTitle = NULL;
bInfo.ulFlags = BIF_RETURNONLYFSDIRS;
bInfo.lpfn = NULL;        // see below 
if ( (iItem = SHBrowseForFolder( &bInfo ) ) )
	{
	if ( SHGetPathFromIDList( iItem, szPath) )
		{
		lstrcpy( szDir , szPath );
		if ( szDir[ lstrlen( szDir ) -1 ] != '\\' )
			lstrcat( szDir, _T("\\") );
		((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->SetWindowText( szDir );
		}
	}
}

void CUnzipBox::OnClose() 
{
	if ( m_bCanClose )
		CDialog::OnClose();
	else
		MessageBeep( (UINT)-1 );
}

BOOL CUnzipBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_bCanClose = TRUE;
	((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->SetCurSel( 2 );
	CString sTemp;
	GetTempPath( _MAX_PATH, sTemp.GetBuffer(_MAX_PATH) );
	sTemp.ReleaseBuffer();
	if ( sTemp.Right(1) != _T("\\") )
		sTemp += _T("\\");
	((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->SetWindowText( sTemp );
	((CEdit*)GetDlgItem( IDC_EDITMASK ))->SetWindowText( _T("*.*") );
	((CButton*)GetDlgItem( IDC_CHECKBACKGROUND ))->SetCheck( 1 );
	return TRUE; 
}


// Redirected message from the main View:
//	Since we built the Zip Studio OCX on the main View, this dialog box doesn' t
//	receive the OCX notification messages. That' s why we give the HWND of the
//	dialog box (gHwndInProcess) to the main View so that this view send us back
//	a 'private' notification message.
LRESULT CUnzipBox::OnZNExpanding( WPARAM wParam, LPARAM lParam )
	{
	CString sTemp = (LPCTSTR)lParam, sMsg;
	int i = 0;
	if ( (i = sTemp.ReverseFind('\\')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else if ( (i = sTemp.ReverseFind('/')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else
		sTemp = _T("???");
	sMsg.Format(_T("%s [%i %%]"), (LPCTSTR)sTemp, (int)wParam );
	SetWindowText( sMsg );
	AfxGiveTheHand();
	return 0L;
	}