VERSION 4.00
Begin VB.Form frmListMain 
   Caption         =   "Untitled - Zip Studio VB 4.0 Sample"
   ClientHeight    =   4968
   ClientLeft      =   1248
   ClientTop       =   2004
   ClientWidth     =   5880
   Height          =   5544
   Icon            =   "VB4_MainView.frx":0000
   Left            =   1200
   LinkTopic       =   "Form1"
   ScaleHeight     =   4968
   ScaleWidth      =   5880
   Top             =   1476
   Width           =   5976
   Begin VB.ListBox List1 
      Height          =   624
      Left            =   3240
      TabIndex        =   3
      Top             =   1680
      Visible         =   0   'False
      Width           =   2532
   End
   Begin ZS30W32Lib.ZS ZS1 
      Height          =   852
      Left            =   120
      TabIndex        =   4
      Top             =   3120
      Width           =   2292
      _Version        =   196608
      _ExtentX        =   4043
      _ExtentY        =   1503
      _StockProps     =   0
   End
   Begin ComctlLib.ImageList ImageList5 
      Left            =   1680
      Top             =   2520
      _Version        =   65536
      _ExtentX        =   804
      _ExtentY        =   804
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   255
      NumImages       =   6
      i1              =   "VB4_MainView.frx":0582
      i2              =   "VB4_MainView.frx":0739
      i3              =   "VB4_MainView.frx":08F0
      i4              =   "VB4_MainView.frx":0AA7
      i5              =   "VB4_MainView.frx":0C5E
      i6              =   "VB4_MainView.frx":0E15
   End
   Begin ComctlLib.ImageList ImageList4 
      Left            =   960
      Top             =   2520
      _Version        =   65536
      _ExtentX        =   804
      _ExtentY        =   804
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      MaskColor       =   255
      NumImages       =   6
      i1              =   "VB4_MainView.frx":0FCC
      i2              =   "VB4_MainView.frx":1303
      i3              =   "VB4_MainView.frx":1FFA
      i4              =   "VB4_MainView.frx":2CF1
      i5              =   "VB4_MainView.frx":39E8
      i6              =   "VB4_MainView.frx":46DF
   End
   Begin ComctlLib.ImageList ImageList3 
      Left            =   2400
      Top             =   2040
      _Version        =   65536
      _ExtentX        =   804
      _ExtentY        =   804
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      NumImages       =   2
      i1              =   "VB4_MainView.frx":53D6
      i2              =   "VB4_MainView.frx":558D
   End
   Begin ComctlLib.ImageList ImageList2 
      Left            =   1680
      Top             =   2040
      _Version        =   65536
      _ExtentX        =   804
      _ExtentY        =   804
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      NumImages       =   2
      i1              =   "VB4_MainView.frx":572C
      i2              =   "VB4_MainView.frx":58E3
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   960
      Top             =   2040
      _Version        =   65536
      _ExtentX        =   804
      _ExtentY        =   804
      _StockProps     =   1
      ImageWidth      =   16
      ImageHeight     =   16
      NumImages       =   8
      i1              =   "VB4_MainView.frx":5A82
      i2              =   "VB4_MainView.frx":5C39
      i3              =   "VB4_MainView.frx":5DD8
      i4              =   "VB4_MainView.frx":5F8F
      i5              =   "VB4_MainView.frx":6146
      i6              =   "VB4_MainView.frx":62FD
      i7              =   "VB4_MainView.frx":64B4
      i8              =   "VB4_MainView.frx":666B
   End
   Begin ComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   516
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   5880
      _Version        =   65536
      _ExtentX        =   10372
      _ExtentY        =   910
      _StockProps     =   96
      ImageList       =   ""
      MouseIcon       =   "VB4_MainView.frx":6822
      ButtonWidth     =   868
      ButtonHeight    =   826
      NumButtons      =   10
      i1              =   "VB4_MainView.frx":683E
      i2              =   "VB4_MainView.frx":69FD
      i3              =   "VB4_MainView.frx":6BA8
      i4              =   "VB4_MainView.frx":6D73
      i5              =   "VB4_MainView.frx":6F12
      i6              =   "VB4_MainView.frx":70D1
      i7              =   "VB4_MainView.frx":729C
      i8              =   "VB4_MainView.frx":7467
      i9              =   "VB4_MainView.frx":7606
      i10             =   "VB4_MainView.frx":77D1
      AlignSet        =   -1  'True
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   264
      Left            =   0
      TabIndex        =   0
      Top             =   4704
      Width           =   5880
      _Version        =   65536
      _ExtentX        =   10372
      _ExtentY        =   466
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      NumPanels       =   4
      i1              =   "VB4_MainView.frx":797D
      i2              =   "VB4_MainView.frx":7AC8
      i3              =   "VB4_MainView.frx":7C38
      i4              =   "VB4_MainView.frx":7D84
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   240
      Top             =   2160
      _Version        =   65536
      _ExtentX        =   677
      _ExtentY        =   677
      _StockProps     =   0
      Filter          =   "Zip Files (*.zip)|*.zip|All Files (*.*)|*.*"
      Flags           =   4100
   End
   Begin ComctlLib.ListView ListView1 
      Height          =   1056
      Left            =   0
      TabIndex        =   1
      Top             =   516
      Width           =   5772
      _Version        =   65536
      _ExtentX        =   10181
      _ExtentY        =   1863
      _StockProps     =   205
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      Appearance      =   1
      Icons           =   "ImageList4"
      LabelEdit       =   1
      MultiSelect     =   -1  'True
      SmallIcons      =   "ImageList5"
      View            =   3
      NumItems        =   3
      i1              =   "VB4_MainView.frx":7EF4
      i2              =   "VB4_MainView.frx":7F9E
      i3              =   "VB4_MainView.frx":806A
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileItem 
         Caption         =   "&New"
         Enabled         =   0   'False
         Index           =   0
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&Open"
         Index           =   1
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&Close"
         Enabled         =   0   'False
         Index           =   3
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "-"
         Index           =   4
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&1 C:\ADEL\Toto.zip"
         Index           =   5
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&2 C:\Hnetcpta.zip"
         Index           =   6
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&3 C:\Tstzip.zip"
         Index           =   7
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&4 C:\Tempbak2.zip"
         Index           =   8
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "&5 C:\ADEL\Adel2.zip"
         Index           =   9
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "-"
         Index           =   10
      End
      Begin VB.Menu mnuFileItem 
         Caption         =   "E&xit"
         Index           =   11
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewItem 
         Caption         =   "&Toolbar"
         Checked         =   -1  'True
         Index           =   0
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "Status Bar"
         Checked         =   -1  'True
         Index           =   1
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "&Big Icons"
         Index           =   3
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "Small &icons"
         Index           =   4
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "&List"
         Index           =   5
      End
      Begin VB.Menu mnuViewItem 
         Caption         =   "&Report"
         Checked         =   -1  'True
         Index           =   6
      End
   End
   Begin VB.Menu mnuDemo 
      Caption         =   "&Demo"
      Enabled         =   0   'False
      Begin VB.Menu mnuDemoItem 
         Caption         =   "&Zip Files..."
         Index           =   0
      End
      Begin VB.Menu mnuDemoItem 
         Caption         =   "&Unzip Files..."
         Index           =   1
      End
   End
   Begin VB.Menu mnuToTest 
      Caption         =   "&ToTest"
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Split"
         Enabled         =   0   'False
         Index           =   0
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Join"
         Enabled         =   0   'False
         Index           =   1
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Backup"
         Enabled         =   0   'False
         Index           =   3
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Restore"
         Enabled         =   0   'False
         Index           =   4
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   5
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Global Comment"
         Enabled         =   0   'False
         Index           =   6
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Local Comment"
         Enabled         =   0   'False
         Index           =   7
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   8
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&View"
         Enabled         =   0   'False
         Index           =   9
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   10
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "CreateBlan&kZip"
         Enabled         =   0   'False
         Index           =   11
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "Self-&Extracting File"
         Enabled         =   0   'False
         Index           =   12
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   13
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "C&ount"
         Enabled         =   0   'False
         Index           =   14
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Test"
         Enabled         =   0   'False
         Index           =   15
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "Re&pair"
         Enabled         =   0   'False
         Index           =   16
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   17
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Delete File(s)"
         Enabled         =   0   'False
         Index           =   18
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   19
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Misc. Zip Info"
         Enabled         =   0   'False
         Index           =   20
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Cancel"
         Enabled         =   0   'False
         Index           =   21
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "-"
         Index           =   22
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "&Filter"
         Enabled         =   0   'False
         Index           =   23
      End
      Begin VB.Menu mnuToTestItem 
         Caption         =   "SetStr&ingResource"
         Enabled         =   0   'False
         Index           =   24
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpItem 
         Caption         =   "&About VB4Demo..."
         Index           =   0
      End
   End
End
Attribute VB_Name = "frmListMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False


Option Explicit

Private theZipFile As String

Const WIN32_MAX_PATH = 260

Const FILE_NEW = 0
Const FILE_OPEN = 1
Const FILE_CLOSE = 3
Const FILE_MRU_START = 5
Const FILE_MRU_END = 9
Const FILE_MRU_SEPARATOR = 10
Const FILE_EXIT = 11

Const VIEW_TOOLBAR = 0
Const VIEW_STATUS_BAR = 1
Const VIEW_BIG_ICONS = 3
Const VIEW_SMALL_ICONS = 4
Const VIEW_LIST = 5
Const VIEW_REPORT = 6

Const DEMO_ZIP = 0
Const DEMO_UNZIP = 1

Const HELP_ABOUT = 0

Private Sub Form_Load()
    
    Get_MRU
    
    ' Center Form
    Me.Top = (Screen.Height - Me.Height) / 2
    Me.Left = (Screen.Width - Me.Width) / 2
    
    CommonDialog1.Filter = "Zip Files (*.zip)|*.zip|All Files (*.*)|*.*"
    CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNFileMustExist
    
    ' Give your Zip Studio Developer Edition passwords here
    ZS1.Initialize 0, "", ""
    
End Sub

Private Sub Form_Resize()
    If Toolbar1.Visible Then
        ListView1.Top = Toolbar1.Height
    Else
        ListView1.Top = 0
    End If
    
    If StatusBar1.Visible Then
        If Me.Height - ListView1.Top - StatusBar1.Height > 550 Then
            ListView1.Height = Me.Height - ListView1.Top - StatusBar1.Height - 550
        End If
    Else
        If Me.Height - ListView1.Top > 550 Then
            ListView1.Height = Me.Height - ListView1.Top - 5500
        End If
    End If
    
    ListView1.Left = 0
    If Me.Width > 3600 Then
        ListView1.Width = Me.Width - 100
    End If
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Unload frmBrowseFolder
    Unload frmZip
    Unload frmUnzip
    Write_MRU
End Sub

Private Sub ListView1_ColumnClick(ByVal ColumnHeader As ColumnHeader)
    ListView1.SortKey = ColumnHeader.Index - 1
    ListView1.SortOrder = Abs(ListView1.SortOrder - 1)
    ListView1.Sorted = True
End Sub

Private Sub mnuDemoItem_Click(Index As Integer)
    Dim rc As Integer
    Select Case Index
        Case DEMO_ZIP
            frmZip.Show vbModal
            If frmZip!txtSourceDir.Text <> "" Then
                Me.MousePointer = 11 ' Hour Glass
                rc = ZS1.ZipFiles(theZipFile, _
                         frmZip!txtSourceDir.Text & "\" & frmZip!txtPattern.Text, _
                         frmZip!chkRecurse.Value, _
                         frmZip!cboPathInfo.ListIndex, _
                         frmZip!cboOverwrite.ListIndex, _
                         frmZip!cboCompression.ListIndex, _
                         frmZip!chkUseArchive.Value, _
                         frmZip!chkRemoveArchive.Value, _
                         frmZip!txtPassword.Text, _
                         frmZip!chkBackground.Value)
                If rc <> 0 And rc <> 1 Then
                    MsgBox " Error Code = " & rc, vbCritical + vbOK, "ZIP Error"
                End If
                FillListView theZipFile
                Me.MousePointer = 0 ' Default

            End If
        Case DEMO_UNZIP
            frmUnzip.Show vbModal
            If frmUnzip!txtTargetDir.Text <> "" Then
                Me.MousePointer = 11 ' Hour Glass
                rc = ZS1.UnzipFiles(theZipFile, _
                        frmUnzip!txtPattern.Text, _
                        frmUnzip!txtTargetDir.Text, _
                        frmUnzip!chkRebuildDirs.Value, _
                        frmUnzip!chkEraseROFiles.Value, _
                        frmUnzip!cboOverwrite.ListIndex, _
                        frmUnzip!txtPassword.Text, _
                        1, _
                        frmUnzip!chkBackground.Value)
                If rc <> 0 Then
                    MsgBox " Error Code = " & rc, vbCritical + vbOK, "UNZIP Error"
                End If
                Me.MousePointer = 0 ' Default
            End If
    End Select
    StatusBar1.Panels(1).Text = "Ready"

End Sub

Private Sub mnuFileItem_Click(Index As Integer)
    Select Case Index
        Case FILE_NEW
        Case FILE_OPEN
            CommonDialog1.ShowOpen
            
            If CommonDialog1.filename <> "" Then
                OpenFile CommonDialog1.filename
            End If
        Case FILE_CLOSE
            ListView1.ListItems.Clear
            mnuDemo.Enabled = False
            mnuFileItem(FILE_CLOSE).Enabled = False
        Case FILE_EXIT
            Unload Me
        Case Else
            OpenFile Right$(mnuFileItem(Index).Caption, Len(mnuFileItem(Index).Caption) - 3)
    End Select
End Sub

Private Sub mnuHelpItem_Click(Index As Integer)
    Select Case Index
        Case HELP_ABOUT
            MsgBox "VB4Demo version 1.0" _
            & Chr(13) & Chr(10) _
            & "Portions Pierre G. Boutquin" _
            & Chr(13) & Chr(10) _
            & Chr(13) & Chr(10) _
            , _
            vbInformation, "About VBDemo"
    End Select
End Sub

Private Sub mnuViewItem_Click(Index As Integer)
    Select Case Index
        Case VIEW_TOOLBAR
            If mnuViewItem(VIEW_TOOLBAR).Checked = True Then
                mnuViewItem(VIEW_TOOLBAR).Checked = False
            Else
                mnuViewItem(VIEW_TOOLBAR).Checked = True
            End If
            Toolbar1.Visible = mnuViewItem(VIEW_TOOLBAR).Checked
        Case VIEW_STATUS_BAR
            If mnuViewItem(VIEW_STATUS_BAR).Checked = True Then
                mnuViewItem(VIEW_STATUS_BAR).Checked = False
            Else
                mnuViewItem(VIEW_STATUS_BAR).Checked = True
            End If
            StatusBar1.Visible = mnuViewItem(VIEW_STATUS_BAR).Checked
        Case VIEW_BIG_ICONS
            ListView1.View = lvwIcon
        Case VIEW_SMALL_ICONS
            ListView1.View = lvwSmallIcon
        Case VIEW_LIST
            ListView1.View = lvwList
        Case VIEW_REPORT
            ListView1.View = lvwReport
    End Select
    
    mnuViewItem(VIEW_BIG_ICONS).Checked = False
    mnuViewItem(VIEW_SMALL_ICONS).Checked = False
    mnuViewItem(VIEW_LIST).Checked = False
    mnuViewItem(VIEW_REPORT).Checked = False
    
    Select Case ListView1.View
        Case lvwIcon
            mnuViewItem(VIEW_BIG_ICONS).Checked = True
        Case lvwSmallIcon
            mnuViewItem(VIEW_SMALL_ICONS).Checked = True
        Case lvwList
            mnuViewItem(VIEW_LIST).Checked = True
        Case lvwReport
            mnuViewItem(VIEW_REPORT).Checked = True
    End Select
    
    Form_Resize
End Sub


Private Sub Toolbar1_ButtonClick(ByVal Button As Button)
    Select Case Button.Key
        Case "New"
            mnuFileItem_Click FILE_NEW
        Case "Open"
            mnuFileItem_Click FILE_OPEN
        Case "Save"
        Case "Cut"
        Case "Copy"
        Case "Paste"
        Case "Print"
        Case "Help"
            mnuHelpItem_Click HELP_ABOUT
    End Select
End Sub

Private Sub OpenFile(sFullPath As String)
    Dim sFileName As String
    sFileName = getFileNameOnly(sFullPath)
    
    
    If ZS1.IsZIPFileQuick(sFullPath, 1) = ZERROR_OK Then
        Me.MousePointer = 11 ' Hour Glass
        
        theZipFile = sFullPath
        FillListView sFullPath
        
        Add_MRU sFullPath
        mnuDemo.Enabled = True
        mnuFileItem(FILE_CLOSE).Enabled = True
        
        Me.Caption = sFileName & " - Zip Studio VB 4.0 Sample"
        Me.MousePointer = 0 ' Default
        StatusBar1.Panels(1).Text = "Ready!"
    Else
        MsgBox sFileName & " is NOT a Zip file!", vbCritical + vbOK, "Open ZIP File Error"
    End If
End Sub

Private Sub FillListView(sFullPath As String)
    Dim i As Integer
    Dim j As Integer
    Dim IconIndex As Integer
    Dim fnm, dnm As String
    Dim itmX As ListItem
    
    ListView1.ListItems.Clear
    List1.Clear
    
    ' Alternative (without using GetTempPath):
    ' ZS1.BuildZIPITEMList sFullPath, List1.hWnd, 0, "", 0, 0, 0
    ' ZS1.DeleteTempDirectories
    Dim TempPath As String
    TempPath = String$(WIN32_MAX_PATH, Chr$(0))
    TempPath = Left$(TempPath, GetTempPath(Len(TempPath), TempPath))
 
    ' As we can' t directly use a ListView control with dynamic
    ' informations and we can' t dynamically change the ListView
    ' imagelists, we fill the standard listbox, then add the items
    ' to the ListView control.
    ' To access the ZIPITEM, use <GetZIPITEM..> using the standard
    ' listbox handle with the index (of the ListView control) stored
    ' as the Tag member of the items
    ZS1.BuildZIPITEMList sFullPath, List1.hWnd, 0, TempPath, 0, 0, 0
    
    For i = 0 To List1.ListCount - 1
        fnm = LCase$(ZS1.GetZIPITEMName(List1.hWnd, i, 0))
        dnm = LCase$(ZS1.GetZIPITEMDir(List1.hWnd, i, 0))
        IconIndex = ZS1.GetZIPITEMIconIndex(List1.hWnd, i, 0)
        If IconIndex < 0 Then
         IconIndex = ZITEM_ICON_ERROR
        ElseIf (IconIndex > 5) Then
         IconIndex = ZITEM_ICON_ERROR
        End If
         
        If IconIndex <> ZITEM_ICON_DIR Then
            Set itmX = ListView1.ListItems.Add(, , fnm)
            itmX.SubItems(1) = Right$(Space$(12) & CStr(ZS1.GetZIPITEMOriginalSize(List1.hWnd, i, 0)), 12)
            itmX.SubItems(2) = dnm
        Else
            Set itmX = ListView1.ListItems.Add(, , dnm)
        End If
        itmX.Tag = i
        itmX.Icon = IconIndex + 1
        itmX.SmallIcon = IconIndex + 1
    Next i
    
    
    Dim sFileName As String
    sFileName = getFileNameOnly(sFullPath)
    SetDefaults sFullPath, Left$(sFullPath, Len(sFullPath) - Len(sFileName) - 1)
    
End Sub

Private Sub SetDefaults(ZipFile As String, ZipDir As String)
    frmZip.SetDefaults ZipFile, ZipDir
    frmUnzip.SetDefaults ZipFile, ZipDir
End Sub

Private Sub Add_MRU(FName As String)
    
    Dim i, c As Integer

    ' Dim the work array
    ReDim FileArray(FILE_MRU_END - FILE_MRU_START + 1)

    ' Capture the open filename
    FileArray(0) = FName
    
    ' Capture the mnuFileItem array elements
    For i = 0 To FILE_MRU_END - FILE_MRU_START
        If mnuFileItem(i + FILE_MRU_START).Caption = "" Then
            Exit For
        End If
        FileArray(i + 1) = Right$(mnuFileItem(i + FILE_MRU_START).Caption, Len(mnuFileItem(i + FILE_MRU_START).Caption) - 3)
    Next i

    ' Place current file in mnuFileItem(0)
    mnuFileItem(FILE_MRU_START).Caption = "&1 " & FileArray(0)
    mnuFileItem(FILE_MRU_START).Visible = True
    mnuFileItem(FILE_MRU_SEPARATOR).Visible = True
    
    ' Move FileArray(1) through (FILE_MRU_END - FILE_MRU_START) to mnuFileItem();
    ' Skip if it is the current file
    c = 1
    For i = 1 To FILE_MRU_END - FILE_MRU_START
        If FileArray(i) = "" Then
            Exit For
        End If
        If FileArray(i) <> FileArray(0) Then
            mnuFileItem(c + FILE_MRU_START).Caption = "&" & c + 1 & " " & FileArray(i)
            mnuFileItem(c + FILE_MRU_START).Visible = True
            c = c + 1
        End If
    Next i
End Sub

Private Sub Write_MRU()
    Dim i, iResult As Integer
    Dim sFullPath As String

    For i = 0 To FILE_MRU_END - FILE_MRU_START
        If mnuFileItem(i + FILE_MRU_START).Caption > "" Then
            iResult = WritePrivateProfileString("MRU", "File" & Str$(i + 1), _
                        Right$(mnuFileItem(i + FILE_MRU_START).Caption, Len(mnuFileItem(i + FILE_MRU_START).Caption) - 3), _
                        App.EXEName & ".ini")
        Else
            Exit For
        End If
    Next i
End Sub

Private Sub Get_MRU()
    Dim i, iSize, iStrLen As Integer
    Dim sFullPath As String
    
    For i = 0 To FILE_MRU_END - FILE_MRU_START
        iSize = 255
        sFullPath = Space$(iSize)
        iStrLen = GetPrivateProfileString("MRU", "File" & Str$(i + 1), "None", sFullPath, iSize, App.EXEName & ".ini")
        If Left$(sFullPath, iStrLen) <> "None" Then
            mnuFileItem(i + FILE_MRU_START).Caption = "&" & i + 1 & " " & sFullPath
            mnuFileItem(i + FILE_MRU_START).Visible = True
        Else
            Exit For
        End If
    Next i
    
    If mnuFileItem(FILE_MRU_START).Visible = True Then
        mnuFileItem(FILE_MRU_SEPARATOR).Visible = True
    End If
End Sub

























Private Sub ZS1_ZNExpanding(ByVal szName As String, ByVal iRateDone As Integer)
StatusBar1.Panels(1).Text = "Unzipping " & szName & "... (" & iRateDone & "% done.)"
DoEvents
End Sub


Private Sub ZS1_ZNFileZipped(ByVal szFileName As String, ByVal iCompressionRate As Integer)
StatusBar1.Panels(1).Text = szFileName & " zipped (" & iCompressionRate & "%)!"
DoEvents

End Sub


Private Sub ZS1_ZNZipping2(ByVal szCurrentFile As String, ByVal iRateDone As Integer)
StatusBar1.Panels(1).Text = "Zipping " & szCurrentFile & "... (" & iRateDone & "% done.)"

End Sub


