Attribute VB_Name = "ZIPStudio_Constants"
' ----------------------------------------------------------------------------
'      Constants for Zip Studio 3.0 OCXes
'      Copyright Hexanet SW 1993-1996, All rights reserved
'
'      ZS30Cons.Bas
'      July - 07 - 1996
'
' PGB: Port from C version
' ----------------------------------------------------------------------------

' ----------------------------------------------------------------------------
'      Strings ID (use with <SetStringResource>)
' ----------------------------------------------------------------------------
Public Const ZSAPI_STRINGID_TEXTNOPASSWORD = 0
Public Const ZSAPI_STRINGID_TEXTWITHPASSWORD = 1
Public Const ZSAPI_STRINGID_RENAMEBOXTITLE = 2
Public Const ZSAPI_STRINGID_OLDERTEXT = 3
Public Const ZSAPI_STRINGID_NEWERTEXT = 4
Public Const ZSAPI_STRINGID_REPLACETEXT = 5
Public Const ZSAPI_STRINGID_OK = 6
Public Const ZSAPI_STRINGID_CANCEL = 7
Public Const ZSAPI_STRINGID_REPLACEBOXTITLE = 8
Public Const ZSAPI_STRINGID_YES = 9
Public Const ZSAPI_STRINGID_NO = 10
Public Const ZSAPI_STRINGID_ALWAYS = 11
Public Const ZSAPI_STRINGID_NEVER = 12
Public Const ZSAPI_STRINGID_RENAME = 13
Public Const ZSAPI_STRINGID_PASSWORDBOXTITLE = 14
Public Const ZSAPI_STRINGID_PASSWORDLABEL = 15
Public Const ZSAPI_STRINGID_RETRY = 16
Public Const ZSAPI_STRINGID_BYPASS = 17
Public Const ZSAPI_STRINGID_CHOOSEBACKUPTITLE = 19
Public Const ZSAPI_STRINGID_ZIPMAK = 20
Public Const ZSAPI_STRINGID_NEWZIPDIALOGTITLE = 21


' ----------------------------------------------------------------------------
'      Unzip part
' ----------------------------------------------------------------------------

' General Unzip functions returned value
Public Const ZEXTRACT_OK = 0
Public Const ZEXTRACT_INTERNALERROR = 1
Public Const ZEXTRACT_FILENOTFOUND = 2
Public Const ZEXTRACT_CORRUPTED = 3
Public Const ZEXTRACT_EMPTY = 4
Public Const ZEXTRACT_ERRORINZIPFILE = 5
Public Const ZEXTRACT_NOMEM = 6
Public Const ZEXTRACT_DISKFULL = 8
Public Const ZEXTRACT_WASRDONLY = 10                         ' 3.0: A file was bypassed because RO
Public Const ZEXTRACT_WASLOCKED = 11                         ' 3.0: A file was bypassed because locked
Public Const ZEXTRACT_IOERROR = 12                           ' 3.0: I/O error like diskette missing
Public Const ZEXTRACT_DRIVENOTREADY = 13                     ' 3.0
Public Const ZEXTRACT_DRIVEREADONLY = 14                     ' 3.0
Public Const ZEXTRACT_DISKWPROTECTED = 15                    ' 3.0: The warning was already displayed
Public Const ZEXTRACT_TOOBIG = 16                            ' 3.0: The mask is too long (more than _MAX_PATH)
Public Const ZEXTRACT_NOCHANGEALLOWED = 17                   ' 3.0: The ZIP should be read-only (partially supported ZIP format)


' <iOverwriteMode> for Unzip functions
Public Const OVERWRITE_TRUE = 1
Public Const OVERWRITE_FALSE = 0
Public Const OVERWRITE_QUERY = 2
Public Const OVERWRITE_UPDATE = 3                            ' 3.0: Only unzip the newer files

Public Const CREATEDIR_TRUE = 1
Public Const CREATEDIR_FALSE = 0


' <ZIPITEMBuiltUnder> code
Public Const ZIP_UNDER_DOS = 0
Public Const ZIP_UNDER_AMIGA = 1
Public Const ZIP_UNDER_VMS = 2
Public Const ZIP_UNDER_UNIX = 3
Public Const ZIP_UNDER_VM = 4
Public Const ZIP_UNDER_ATARIST = 5
Public Const ZIP_UNDER_OS2HPFS = 6
Public Const ZIP_UNDER_MAC = 7
Public Const ZIP_UNDER_ZSYSTEM = 8
Public Const ZIP_UNDER_W32 = 11
Public Const ZIP_UNDER_UNKNOWN = 9


' <ZIPITEMMethod> code
Public Const ZMETHOD_STORED = 0
Public Const ZMETHOD_SHRUNK = 1
Public Const ZMETHOD_REDUCE1 = 2
Public Const ZMETHOD_REDUCE2 = 3
Public Const ZMETHOD_REDUCE3 = 4
Public Const ZMETHOD_REDUCE4 = 5
Public Const ZMETHOD_IMPLODE = 6
Public Const ZMETHOD_TOKEN = 7
Public Const ZMETHOD_DEFLATE = 8
Public Const ZMETHOD_UNKNOWN = 9
Public Const ZMETHOD_ERROR = 10


' <Join> returned values
Public Const JOIN_OK = 0
Public Const JOIN_NOFILE = 1
Public Const JOIN_NOMEM = 2
Public Const JOIN_IOERROR = 3
Public Const JOIN_ACCESSDENIED = 4
Public Const JOIN_USERABORT = 5
Public Const JOIN_NOTASPLITTEDFILE = 7
Public Const JOIN_ZIPEXIST = 8
Public Const JOIN_DISKFULL = 9


' <Restore> returned values
Public Const ZRESTORE_OK = 0                                 ' Ok
Public Const ZRESTORE_NOTALONE = 1                           ' Possible result code when <bCanAsk> is set to FALSE
Public Const ZRESTORE_NOTEMP = 2                             ' Can' t create the temporary file name!
Public Const ZRESTORE_USERABORT = 3                          ' User abort
Public Const ZRESTORE_NONE = 4                               ' Nothing to do
Public Const ZRESTORE_JOINERROR = 10                         ' JOINERROR is the result code of <ZipJoin> + 10 (but JOIN_OK)
Public Const ZRESTORE_UNZIPERROR = 40                        ' UNZIPERROR is the result code of <ExtractZipFiles> + 40 (but ZEXTRACT_OK)

' The ZIPITEM structure
'typedef struct TAGZIPITEM
'        {
'    #ifndef _WIN32
'        TCHAR szName[50];
'        TCHAR szDir[260];
'    #else
'        TCHAR szName[260];
'        TCHAR szDir[_MAX_PATH];
'    #endif
'        BOOL bIsDir;
'        BOOL bIsEncrypted;
'        int iMethod;
'        int iDay;
'        int iMonth;
'        int iYear;
'        int iHour;
'        int iMin;
'        long lOriginalSize;
'        int iRate;
'        BOOL bArchive;
'        BOOL bHidden;
'        BOOL bSystem;
'        BOOL bRO;
'        BOOL bComment;
'        int iIconIndex;
'        unsigned long ulCrc32;
'        }ZIPITEM;
        

' <ZIPITEMIconIndex> special codes (or index if you don' t ask the Windows icons)
Public Const ZITEM_ICON_DIR = 0
Public Const ZITEM_ICON_ENCRYPTED = 1
Public Const ZITEM_ICON_EXE = 2
Public Const ZITEM_ICON_ERROR = 3
Public Const ZITEM_ICON_KNOWN = 4
Public Const ZITEM_ICON_UNKNOWN = 5


' <ZList> sort mode
Public Const ZSORT_BYFULLNAME = 0                    ' name + dir
Public Const ZSORT_BYNAME = 1
Public Const ZSORT_BYDIR = 2
Public Const ZSORT_BYDATE = 3
Public Const ZSORT_BYSIZE = 4
Public Const ZSORT_BYRATE = 5
Public Const ZSORT_NONE = 6


' ----------------------------------------------------------------------------
'      Zip part
' ----------------------------------------------------------------------------

' General Zip functions returned value
Public Const ZERROR_OK = 0                           ' No error
Public Const ZERROR_WARNING = 1                      ' Just a warning (not an error)
Public Const ZERROR_DESTFILE = 2                     ' Destfile ( *.ZIP ) error
Public Const ZERROR_INTERNAL = 3                     ' Internal error
Public Const ZERROR_FORMAT = 4                       ' Not a Zip file
Public Const ZERROR_NOMEM = 5                        ' Not enough memory
Public Const ZERROR_NOFILE = 6                       ' Nothing to do ( can be just a warning )
Public Const ZERROR_NODLL = 7                        ' Can' t find required DLLs (under Win16)
Public Const ZERROR_COMMENT = 8                      ' Comment missing or NULL
Public Const ZERROR_NOCRYPT = 9                      ' Can' t encrypt the files
Public Const ZERROR_ACCESSDENIED = 12                ' 3.0
Public Const ZERROR_DRIVENOTREADY = 13               ' 3.0
Public Const ZERROR_DRIVEREADONLY = 14               ' 3.0
Public Const ZERROR_DISKWPROTECTED = 15              ' 3.0: The warning was already displayed
Public Const ZERROR_DISKFULL = 16                    ' 3.0: The warning was already displayed
Public Const ZERROR_USERABORT = 17                   ' 3.0

' <ZipMakeEXEFile> errors
Public Const ZEXE_OK = 0
Public Const ZEXE_ELFFILEMISSING = 1                 ' EXE Language File not found
Public Const ZEXE_AUTOLOADMISSING = 2                ' AUTOLOAD.16 or AUTOLOAD.32 not found in the app. dir.
Public Const ZEXE_AUTOLOADCORRUPTED = 3              ' Bad version of AUTOLOAD.16 or AUTOLOAD.32
Public Const ZEXE_NOZIPFILE = 4                      ' Source file mising
Public Const ZEXE_SRCACCESSDENIED = 5                ' Source file locked
Public Const ZEXE_DESTACCESSDENIED = 6               ' Exe file locked
Public Const ZEXE_DRIVENOTREADY = 7
Public Const ZEXE_DRIVEREADONLY = 8
Public Const ZEXE_DISKWPROTECTED = 9
Public Const ZEXE_DISKFULL = 10
Public Const ZEXE_NOMEM = 11

' Compression method setting
Public Const ZMODE_NORMAL = 0
Public Const ZMODE_FAST = 1
Public Const ZMODE_SLOW = 2
Public Const ZMODE_STORE = 3

' <Backup> result
Public Const ZBACKUP_OK = 0                                  ' Ok
Public Const ZBACKUP_NOTEMP = 1                              ' Can' t create the temporary file name!
Public Const ZBACKUP_USERABORT = 2                           ' User abort
Public Const ZBACKUP_NOTALONE = 3                            ' Possible result code when <bForceSingle> is set to TRUE
Public Const ZBACKUP_WARNNOTHING = 4                         ' <AddFileToZip> didn' t build the ZIP file (nothing to do)
Public Const ZBACKUP_ACCESSDENIEDFORALL = 5                  ' <AddFileToZip> didn' t build the ZIP file, all files were Access denied!
Public Const ZBACKUP_ACCESSDENIED = 6                        ' <AddFileToZip> built the file but there was some AD.
Public Const ZBACKUP_ZIPERROR = 10                           ' ZIPERROR is the result code of <AddFileToZip> + 10 (but ZERROR_OK)
Public Const ZBACKUP_SPLITERROR = 40                         ' SPLITERROR is the result code of <ZipSplit> + 40 (but SPLIT_OK)

' <Split> returned code
Public Const SPLIT_OK = 0
Public Const SPLIT_NOFILE = 1
Public Const SPLIT_NOMEM = 2
Public Const SPLIT_IOERROR = 3
Public Const SPLIT_TOOBIG = 4
Public Const SPLIT_ACCESSDENIED = 5
Public Const SPLIT_USERABORT = 6
Public Const SPLIT_DISKFULL = 10                     ' 3.0
Public Const SPLIT_WPROTECTED = 11                   ' 3.0
                        
' Zip functions <iOverwrite> mode
Public Const OVERWRITE_ALWAYS = 0                    ' Always overwrite ( always zip files ) (default)
Public Const OVERWRITE_NEVER = 1                     ' Never overwrite
Public Const OVERWRITE_PROMPT = 2                    ' Ask the user
' Note: OVERWRITE_UPDATE already defined under <iOverwriteMode> for Unzip functions
' Public Const OVERWRITE_UPDATE = 3                    ' Overwrite if external file is newer
Public Const OVERWRITE_FRESHEN = 4                   ' Overwrite if external file is newer, do not add new entries [3.0]

' <ZipFiles> misc. settings
Public Const STOREPATH_NO = 0                        ' Don' t store paths
Public Const STOREPATH_YES = 1                       ' Store paths
Public Const STOREPATH_FULL = 2                      ' Store paths  (complete names) [3.0]
Public Const RECURSE_NO = 0                          ' Don' t recurse sub dirs
Public Const RECURSE_YES = 1                         ' Recurse sub dirs

