unit ZipBox;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, BrowseDr;

type
  TZipDlg = class(TForm)
    OKBtn: TButton;
    Button2: TButton;
    ecSourceDir: TEdit;
    btnBrowse: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ecMask: TEdit;
    ecPassword: TEdit;
    Label3: TLabel;
    cbOverWrite: TComboBox;
    cbCompress: TComboBox;
    cbKeepPath: TComboBox;
    cbxRecurse: TCheckBox;
    cbxArchive: TCheckBox;
    cbxRArchive: TCheckBox;
    cbxBackgrnd: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    BrowseDir: TBrowseDirectoryDlg;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnBrowseClick(Sender: TObject);
  private
    m_bCanClose : boolean;
  end;

var
  ZipDlg: TZipDlg;

implementation

uses zs30con;

{$R *.DFM}

procedure TZipDlg.FormCreate(Sender: TObject);
var
  defPath : array [0..120] of char;
  iLen : integer;
begin
  Left := 146;
  Top := 190;
  m_bCanClose := True;
  cbOverWrite.ItemIndex := 2;
  cbKeepPath.ItemIndex := 0;
  cbCompress.ItemIndex := 0;
  ecMask.Text := '*.*';
  cbxBackgrnd.Checked := True;
  iLen := GetCurrentDirectory(80, defPath);
  if (iLen > 80) and (iLen <= 120) then
    GetCurrentDirectory(iLen, defPath);
  ecSourceDir.Text := defPath;
end;

procedure TZipDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if (m_bCanClose) then
    Close
  else
    MessageBeep(-1);
end;

procedure TZipDlg.btnBrowseClick(Sender: TObject);
var
  szDir : string;
begin
  if BrowseDir.Execute then szDir := BrowseDir.Selected;
  if Length(szDir) > 0 then begin
    if szDir[Length(szDir)] <> '\' then szDir := szDir + '\';
    ecSourceDir.Text := szDir;
  end;
end;

end.
