unit UnzipBox;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, BrowseDr;

type
  TUnzipDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    ecDestDir: TEdit;
    BrowseBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ecMask: TEdit;
    ecPassword: TEdit;
    cbOverwrite: TComboBox;
    cbxRebuild: TCheckBox;
    cbxEraseRO: TCheckBox;
    cbxBackgrnd: TCheckBox;
    BrowseDir: TBrowseDirectoryDlg;
    procedure FormCreate(Sender: TObject);
    procedure BrowseBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  UnzipDlg: TUnzipDlg;

implementation

{$R *.DFM}

procedure TUnzipDlg.FormCreate(Sender: TObject);
var
  tStr : array [0..MAX_PATH] of char;
begin
  GetTempPath(MAX_PATH, tStr);
  if tStr[Length(tStr)] <> '\' then strcat(tStr, '\');
  ecDestDir.Text := tStr;
  ecMask.Text := '*.*';
  ecPassword.Text := '';
  cbOverwrite.ItemIndex := 2;
  cbxBackgrnd.Checked := True;
  cbxRebuild.Checked := False;
  cbxEraseRO.Checked := False;
end;

procedure TUnzipDlg.BrowseBtnClick(Sender: TObject);
var
  szDir : string;
begin
  if BrowseDir.Execute then szDir := BrowseDir.Selected;
  if Length(szDir) > 0 then begin
    if szDir[Length(szDir)] <> '\' then szDir := szDir + '\';
    ecDestDir.Text := szDir;
  end;
end;

end.
