unit MSListView;

interface

uses Messages, Windows, SysUtils, CommCtrl, Classes, Controls, Forms,
  Menus, Graphics, StdCtrls, RichEdit, ComCtrls;

type

  TLVGetDispInfoEvent = procedure(Sender: TObject; ptNMHdr : PNMHDR) of object;

  TMSListView = class(TCustomListView)
  private
    { Private declarations }
    FOnGetDispInfo : TLVGetDispInfoEvent;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property Align;
    property BorderStyle;
    property Color;
    property ColumnClick;
    property OnClick;
    property OnDblClick;
    property Columns;
    property Ctl3D;
    property DragMode;
    property ReadOnly;
    property Font;
    property HideSelection;
    property IconOptions;
    property Items;
    property AllocBy;
    property MultiSelect;
    property OnChange;
    property OnChanging;
    property OnColumnClick;
    property OnCompare;
    property OnDeletion;
    property OnEdited;
    property OnEditing;
    property OnEnter;
    property OnExit;
    property OnGetDispInfo: TLVGetDispInfoEvent read FOnGetDispInfo write FOnGetDispInfo;
    property OnInsert;
    property OnDragDrop;
    property OnDragOver;
    property DragCursor;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property ParentShowHint;
    property ShowHint;
    property PopupMenu;
    property ShowColumnHeaders;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property ViewStyle;
    property Visible;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property LargeImages;
    property SmallImages;
    property StateImages;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Custom', [TMSListView]);
end;

procedure TMSListView.CNNotify(var Message: TWMNotify);
var
  Item: TListItem;
  I: Integer;
begin
  WITH Message.NMHdr^ do
    CASE ( code ) OF
      LVN_GETDISPINFO:
        if Assigned(FOnGetDispInfo) then FOnGetDispInfo(Self, PNMHDR(Message.NMHdr))
        else inherited;
      LVN_DELETEITEM:
        begin
{        with PNMListView(Pointer(Message.NMHdr))^ do begin
          Delete(Self.Items[iItem]);
        end;}
        end;
      LVN_DELETEALLITEMS:
        begin
        end;
      else inherited;
    END;
end;

end.