// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	DllDemo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	This sample uses the DLL version of the API (ZSAPI32.DLL).
//	This DLL must be on the path of this appication.
// ------------------------------------------------------------------------------------------------------------------------
#include "stdafx.h"
#include "DllDemo.h"
#include "MainFrm.h"
#include "DllDDoc.h"
#include "DllDView.h"
#include "UZBox.h"
#include "ZipBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// --------------------------------------
//	We will test Zip Studio 3.0 <UnzipFiles> method

// Same as DoEvents (require for notification messages treatments)
extern void AfxGiveTheHand( );




/////////////////////////////////////////////////////////////////////////////
// CUnzipBox dialog


CUnzipBox::CUnzipBox(CWnd* pParent /*=NULL*/)
	: CDialog(CUnzipBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUnzipBox)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CUnzipBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUnzipBox)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUnzipBox, CDialog)
	//{{AFX_MSG_MAP(CUnzipBox)
	ON_MESSAGE( ZN_EXPANDING, OnZNExpanding )
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUnzipBox message handlers

void CUnzipBox::OnOK() 
{
	if ( !m_bCanClose )
		return;
	CString sDestDir, sMask, sPassword, sZipFile, sResult;
	int iOverwrite, iResult;
	BOOL bBackGroundProcessing, bEraseReadOnlyFiles, bRebuildDir;

	
	((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->GetWindowText( sDestDir );
	sDestDir.AnsiToOem();
	if ( sDestDir.Right(1) != _T("\\") )
		sDestDir += _T("\\");

	((CEdit*)GetDlgItem( IDC_EDITMASK ))->GetWindowText( sMask );
	sMask.AnsiToOem();
	if ( sMask == _T("") )
		sMask = _T("*.*");

	((CEdit*)GetDlgItem( IDC_EDITPASSWORD ))->GetWindowText( sPassword );
	sPassword.AnsiToOem();
	iOverwrite = ((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->GetCurSel(  );
	if ( iOverwrite < 0 )
		iOverwrite = 2;

	bBackGroundProcessing = IsDlgButtonChecked( IDC_CHECKBACKGROUND );
	bEraseReadOnlyFiles = IsDlgButtonChecked( IDC_CHECKERASERO );
	bRebuildDir = IsDlgButtonChecked( IDC_CHECKREBUILDDIR );

	sZipFile = (((CMainFrame*)AfxGetMainWnd())->GetActiveDocument())->GetPathName();
	if ( sZipFile == _T(""))
		{
		MessageBox( "Please open an existing ZIP file before calling this function.");
		CDialog::OnOK();
		return;
		}
	sZipFile.AnsiToOem();
	

	m_bCanClose = FALSE;
	GetDlgItem( IDOK )->EnableWindow( FALSE );
	GetDlgItem( IDCANCEL )->EnableWindow( FALSE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( FALSE );

	ZSChangeOwner( (long)m_hWnd ); // Required to receive the notification messages
	
	// The Zip Studio DLL function
	iResult = (int)ZSUnzipFiles( sZipFile, sMask, sDestDir, bRebuildDir, 
			bEraseReadOnlyFiles, iOverwrite, sPassword, TRUE /*AskPwd*/, bBackGroundProcessing );
	if ( iResult > 0 )
		{
		sResult.Format( _T("<UnzipFiles> returns an Error/Warning code [%i]."), iResult );
		MessageBox( sResult );
		}
	GetDlgItem( IDOK )->EnableWindow( TRUE );
	GetDlgItem( IDCANCEL )->EnableWindow( TRUE );
	GetDlgItem( IDC_BROWSE )->EnableWindow( TRUE );
	m_bCanClose = TRUE;
	CDialog::OnOK();
	}

void CUnzipBox::OnBrowse() 
{
// -------------------------------------------------------------------
//	We use Win95 <SHBrowseForFolder>
LPITEMIDLIST iItem;                    
BROWSEINFO bInfo;
TCHAR szBuffer2[_MAX_PATH], szPath[_MAX_PATH], szDir[_MAX_PATH];
lstrcpy( szBuffer2, _T("") );
lstrcpy( szPath, _T("") );

bInfo.hwndOwner = m_hWnd;
bInfo.pidlRoot = NULL;
bInfo.pszDisplayName = szBuffer2;
bInfo.lpszTitle = NULL;
bInfo.ulFlags = BIF_RETURNONLYFSDIRS;
bInfo.lpfn = NULL;        // see below 
if ( (iItem = SHBrowseForFolder( &bInfo ) ) )
	{
	if ( SHGetPathFromIDList( iItem, szPath) )
		{
		lstrcpy( szDir , szPath );
		if ( szDir[ lstrlen( szDir ) -1 ] != '\\' )
			lstrcat( szDir, _T("\\") );
		((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->SetWindowText( szDir );
		}
	}
}

void CUnzipBox::OnClose() 
{
	if ( m_bCanClose )
		CDialog::OnClose();
	else
		MessageBeep( (UINT)-1 );
}

BOOL CUnzipBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_bCanClose = TRUE;
	((CComboBox*)GetDlgItem( IDC_COMBOOVERWRITE ))->SetCurSel( 2 );
	CString sTemp;
	GetTempPath( _MAX_PATH, sTemp.GetBuffer(_MAX_PATH) );
	sTemp.ReleaseBuffer();
	if ( sTemp.Right(1) != _T("\\") )
		sTemp += _T("\\");
	((CEdit*)GetDlgItem( IDC_EDITDESTDIR ))->SetWindowText( sTemp );
	((CEdit*)GetDlgItem( IDC_EDITMASK ))->SetWindowText( _T("*.*") );
	((CButton*)GetDlgItem( IDC_CHECKBACKGROUND ))->SetCheck( 1 );
	return TRUE; 
}


// Redirected message from the main View:
//	Since we initialize the Zip Studio with the main View handle, this dialog box doesn' t
//	receive the DLL notification messages. That' s why we give the HWND of the
//	dialog box (gHwndInProcess) to the main View so that this view send us back
//	a 'private' notification message.
LRESULT CUnzipBox::OnZNExpanding( WPARAM wParam, LPARAM lParam )
	{
	CString sTemp = (LPCTSTR)lParam, sMsg;
	int i = 0;
	if ( (i = sTemp.ReverseFind('\\')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else if ( (i = sTemp.ReverseFind('/')) > -1 )
		sTemp = sTemp.Mid( i+1 );
	else
		sTemp = _T("???");
	sMsg.Format(_T("%s [%i %%]"), (LPCTSTR)sTemp, (int)wParam );
	SetWindowText( sMsg );
	AfxGiveTheHand();
	return 0L;
	}

