// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	DllDemo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	This sample uses the DLL version of the API (ZSAPI32.DLL).
//	This DLL must be on the path of this appication.
// ------------------------------------------------------------------------------------------------------------------------
#include "stdafx.h"
#include "DllDemo.h"
#include "MainFrm.h"
#include "DllDDoc.h"
#include "DLLDView.h"
#include "UZBox.h"
#include "ZipBox.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(IDM_BIGICONS, OnBigicons)
	ON_COMMAND(IDM_LIST, OnList)
	ON_COMMAND(IDM_REPORT, OnReport)
	ON_COMMAND(IDM_SMALLICONS, OnSmallicons)
	ON_COMMAND(IDM_UNZIP, OnUnzip)
	ON_COMMAND(IDM_ZIP, OnZip)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

// Change the style of the main ListView control
void CMainFrame::OnBigicons() 
{
GetListCtrl()->ModifyStyle( LVS_REPORT | LVS_LIST | LVS_SMALLICON, 0L );
}

void CMainFrame::OnList() 
{
GetListCtrl()->ModifyStyle( LVS_REPORT | LVS_SMALLICON, LVS_LIST  );
}

void CMainFrame::OnReport() 
{
GetListCtrl()->ModifyStyle( LVS_LIST | LVS_SMALLICON, LVS_REPORT );
}

void CMainFrame::OnSmallicons() 
{
GetListCtrl()->ModifyStyle( LVS_REPORT | LVS_LIST, LVS_SMALLICON  );
}


// Call UNZIP and ZIP dialogboxes
void CMainFrame::OnUnzip() 
{
CUnzipBox ub( this );
ub.DoModal();	
}

void CMainFrame::OnZip() 
{
CZipBox zb( this );
zb.DoModal();	
	
}
