// ------------------------------------------------------------------------------------------------------------------------
//	Zip Studio 3.0 - Developer Edition
//	DllDemo sample for Microsoft Visual C++ 4.0
//
//	Copyright Hexanet 1993-1996, All rights reserved
// ------------------------------------------------------------------------------------------------------------------------
//	Note:
//	This sample uses the DLL version of the API (ZSAPI32.DLL).
//	This DLL must be on the path of this appication.
// ------------------------------------------------------------------------------------------------------------------------
#include "stdafx.h"
#include "DllDemo.h"
#include "MainFrm.h"
#include "DllDDoc.h"
#include "DLLDView.h"
#include "UZBox.h"
#include "ZipBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDllDemoDoc

IMPLEMENT_DYNCREATE(CDllDemoDoc, CDocument)

BEGIN_MESSAGE_MAP(CDllDemoDoc, CDocument)
	//{{AFX_MSG_MAP(CDllDemoDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDllDemoDoc construction/destruction

CDllDemoDoc::CDllDemoDoc()
{
	// TODO: add one-time construction code here

}

CDllDemoDoc::~CDllDemoDoc()
{
}

BOOL CDllDemoDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CDllDemoDoc serialization

void CDllDemoDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDllDemoDoc diagnostics

#ifdef _DEBUG
void CDllDemoDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDllDemoDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDllDemoDoc commands
//	This function actually load a ZIP file using a ListView control
//	instead of a simple ListBox control. The ListView control has
//	the style LVS_SHAREIMAGELISTS because we will destroy the
//	HIMAGELIST thanks to the Zip Studio OCX <DestroyZIPITEMImageList>
//	method.
//	Notice that we don' t need to call <DestroyZIPITEMLParam> before
//	we build a new List but we need to do this when we destroy the ListView
//	(that is when we destroy our main View when we close this application).
//	Finally we need to provide a 'private' temporary directory which will
//	be used by <BuildZIPITEMList> to retrieve the Windows95 icons.

BOOL CDllDemoDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	if ( AfxGetMainWnd() )
		if ( ((CMainFrame*)AfxGetMainWnd())->GetActiveView() )
		{
		int i = ZSBuildZIPITEMList( lpszPathName, (long)GetListCtrlHwnd(), TRUE, _T(""), TRUE, 0, TRUE);
		if ( i < 0 )
			MessageBox(NULL, "Error while loading the ZIP files list", "", MB_OK);
		}
						   
	
	return TRUE;
}
