unit ZSAPI32;

interface

uses WinTypes, Messages, ZS30C32;

{// --------------------------------------------------------------------------
// <Initialize> function to use just after loading
// the DLL.
// Set <lSerialNumber> to 0L, and <szName>
// and <szPassword> to NULL to evaluate the
// Zip Studio enabilities, or use your passwords
// as described on your invoice.
// <hWndParent> is your main HWND which will
// receive the notification messages
//
// ZSChangeOwner lets you specify a new parent dialog-box (during
// Zip and Unzip treatments).
// --------------------------------------------------------------------------}
function ZSInitialize( lSerialNumber : Integer; szName, szPassword : string; hWndParent : Integer) : WordBool; stdcall;
procedure ZSChangeOwner( hWndParent : Integer ); stdcall;

{// --------------------------------------------------------------------------
//	Informations functions
// --------------------------------------------------------------------------}
function ZSIsZIPFileQuick(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSIsZIPFileSlow(const szZipName, szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetCount(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetTotalSize(const szZipName : string; bOriginalSize, bBackGroundProcessing : WordBool) : double; stdcall;
function ZSIsFileInTheZIPFile(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : WordBool; stdcall;

function ZSGetZIPINFOMadeUnder(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetZIPINFOVersionMinor(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetZIPINFOVersionMajor(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetZIPINFODiskID(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;

function ZSGetGlobalCommentSize(const szZipName; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSGetLocalCommentSize(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : smallint; stdcall;

{// The following functions use a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.}
procedure ZSGetGlobalComment(const szZipName : string; iMaxLength : smallint; bBackGroundProcessing : WordBool ; var szBuffer : string); stdcall;
procedure ZSGetLocalComment(const szZipName, szMask : string; iMaxLength : smallint; bBackGroundProcessing : WordBool; var szBuffer : string); stdcall;

{// This function has replaced the OCX <GetZIPITEM...> methods, and fill the <zItem> parameter
// with all the ZIPITEM informations.}
function ZSGetZIPITEM( hListZIPITEM : Integer; iIndex : smallint; bListCtrlMode : WordBool; var zItem : PZipItem ) : WordBool; stdcall;

{// --------------------------------------------------------------------------
//	Common misc. functions
// --------------------------------------------------------------------------}
function ZSIsFileNameInFilter(const szName, szPattern : string) : WordBool; stdcall;

function ZSGetZipBufferSize : smallint; stdcall;
function ZSGetUnzipBufferSize : smallint; stdcall;

procedure ZSSetStringResource(iStringID : smallint; const szValue : string) ; stdcall;

function ZSIsDisketteReady(const szDiskette : string) : WordBool; stdcall;
function ZSIsDriveWriteable(const szDrive : string) : WordBool; stdcall;
function ZSIsWriteable(const szDestFile : string; lSizeInBytes : Integer) : WordBool; stdcall;

procedure ZSSetHelpFile(const szHelpFile : string) ; stdcall;  // (undocumented)
procedure ZSSetIniFile(const szFile : string) ; stdcall;
function ZSDeleteTempDirectories : WordBool; stdcall;

procedure ZSSetPasswordMode(bShow, bSave : WordBool) ; stdcall;
procedure ZSDeletePasswords; stdcall;

{// --------------------------------------------------------------------------
//	ZIP files list functions
// --------------------------------------------------------------------------}
function ZSBuildZIPITEMImageList : WordBool; stdcall;
function ZSSetListViewImageList(hListView : Integer) : WordBool; stdcall;
function ZSGetZIPITEMHImageList(bBigIcons : WordBool) : Integer; stdcall;
function ZSBuildZIPITEMList(const szZipName : string; hListZIPITEM : Integer; bListCtrlMode : WordBool;
                       const szPrivateTempDirectory : string; bWindowsIcons : WordBool; iSortMode : smallint; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSSortZIPITEMList(hListZIPITEM : Integer; iSortMode : smallint; bBackGroundProcessing : WordBool) : WordBool; stdcall;
procedure ZSDestroyZIPITEMLParam(hListZIPITEM : Integer) ; stdcall;
function ZSDestroyZIPITEMImageList : WordBool; stdcall;

{// --------------------------------------------------------------------------
//	Unzip functions
// --------------------------------------------------------------------------}
function ZSUnzipFiles(const szZipName, szMask, szDestDirectory : string; bRebuildDir, bEraseReadOnlyFiles : WordBool;
                      iOverwriteMode : smallint; const szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSUnzipToFile(const szZipName, szMask, szDestFile : string; bEraseReadOnlyFiles : WordBool; const szPassword : string;
                      bAskPassword, bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSView(const szZipName, szMask : string; bUseTextEditor, bRunEXE : WordBool; const szPrivateTempDir,
                      szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : WordBool; stdcall;

procedure ZSUnzipCancel(bCancel : WordBool) ; stdcall;
function ZSUnzipGetReplaceFlag : smallint; stdcall;

function ZSJoin(const szPartFileName, szDestDirectory, szTitle, szMsg : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSRestore(const szSourceDirectory, szDestinationDirectory : string;
                      iOverwriteMode : smallint; bDisplayDialog, bEraseReadOnlyFiles : WordBool;
                      const szTitle, szMsg : string; bBackGroundProcessing : WordBool) : smallint; stdcall;

{// --------------------------------------------------------------------------
//	Zip functions
//
//	Note: With the Windows 3.1x version, you need ZS30ZW16.DLL in order
//            to call <ZSZipFiles> and <ZSBackup>. You may get this file
//            from the Zip Shhell (Win16 version) directory.
//
// --------------------------------------------------------------------------}
function ZSCreateBlankZIPFile(const szZipName : string; bOpenDialog : WordBool) : WordBool; stdcall;
{// The following function uses a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.}
procedure ZSGetNewZIPName(var szBuffer : string); stdcall;

function ZSZipFiles(const szZipName, szMask : string; bRecurseSubDirs : WordBool; iStorePathMethod, iOverwriteMode,
                       iCompressionMode : smallint; bUseArchiveFlag, bRemoveArchiveFlag : WordBool;
                       const szPassword : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
procedure ZSZipCancel(bCancel : WordBool) ; stdcall;
function ZSZipGetReplaceFlag : smallint; stdcall;

function ZSSetGlobalComment(const szZipName, szComment : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSSetLocalComment(const szZipName, szMask, szComment : string; bBackGroundProcessing : WordBool) : smallint; stdcall;

function ZSDeleteWithMask(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSDeleteWithSelection(const szZipName : string; hListZIPITEM, hListSelected : Integer; bListIsListCtrl,
                       bBackGroundProcessing : WordBool) : smallint; stdcall;

function ZSRepare(const szZipName : string; bBackGroundProcessing : WordBool) : smallint; stdcall;
function ZSMakeEXEFile(const szZipName, szEXEName, szProgramToLaunch, szEXETitle, szELFFile : string;
                       iOverwriteMode : smallint; bAskDirectory, bWin32Target, bBackGroundProcessing : WordBool) : smallint; stdcall;

function ZSSplit(const szZipName, szDestDir : string; lFirstBlockSizeInBytes, lNextBlockSizeInBytes : Integer; bBackGroundProcessing : WordBool;
                       const szTitle, szMsg : string) : smallint; stdcall;
function ZSBackup(const szMask, szDestDrive : string; bRecurse, bUseArchiveFlag, bRemoveArchiveFlag, bForceSingleBackup : WordBool;
                       const szTitle, szMsg : string; iCompressionMode : smallint; bBackGroundProcessing : WordBool) : smallint; stdcall;

implementation

function ZSInitialize;                      external 'ZSAPI32';
procedure ZSChangeOwner;                    external 'ZSAPI32';
function ZSIsZIPFileQuick;                  external 'ZSAPI32';
function ZSIsZIPFileSlow;                   external 'ZSAPI32';
function ZSGetCount;                        external 'ZSAPI32';
function ZSGetTotalSize;                    external 'ZSAPI32';
function ZSIsFileInTheZIPFile;              external 'ZSAPI32';
function ZSGetZIPINFOMadeUnder;             external 'ZSAPI32';
function ZSGetZIPINFOVersionMinor;          external 'ZSAPI32';
function ZSGetZIPINFOVersionMajor;          external 'ZSAPI32';
function ZSGetZIPINFODiskID;                external 'ZSAPI32';
function ZSGetGlobalCommentSize;            external 'ZSAPI32';
function ZSGetLocalCommentSize;             external 'ZSAPI32';
procedure ZSGetGlobalComment;               external 'ZSAPI32';
procedure ZSGetLocalComment;                external 'ZSAPI32';
function ZSGetZIPITEM;                      external 'ZSAPI32';
function ZSIsFileNameInFilter;              external 'ZSAPI32';
function ZSGetZipBufferSize;                external 'ZSAPI32';
function ZSGetUnzipBufferSize;              external 'ZSAPI32';
procedure ZSSetStringResource;              external 'ZSAPI32';
function ZSIsDisketteReady;                 external 'ZSAPI32';
function ZSIsDriveWriteable;                external 'ZSAPI32';
function ZSIsWriteable;                     external 'ZSAPI32';
procedure ZSSetHelpFile;                    external 'ZSAPI32';
procedure ZSSetIniFile;                     external 'ZSAPI32';
function ZSDeleteTempDirectories;           external 'ZSAPI32';
procedure ZSSetPasswordMode;                external 'ZSAPI32';
procedure ZSDeletePasswords;                external 'ZSAPI32';
function ZSBuildZIPITEMImageList;           external 'ZSAPI32';
function ZSSetListViewImageList;            external 'ZSAPI32';
function ZSGetZIPITEMHImageList;            external 'ZSAPI32';
function ZSBuildZIPITEMList;                external 'ZSAPI32';
function ZSSortZIPITEMList;                 external 'ZSAPI32';
procedure ZSDestroyZIPITEMLParam;           external 'ZSAPI32';
function ZSDestroyZIPITEMImageList;         external 'ZSAPI32';
function ZSUnzipFiles;                      external 'ZSAPI32';
function ZSUnzipToFile;                     external 'ZSAPI32';
function ZSView;                            external 'ZSAPI32';
procedure ZSUnzipCancel;                    external 'ZSAPI32';
function ZSUnzipGetReplaceFlag;             external 'ZSAPI32';
function ZSJoin;                            external 'ZSAPI32';
function ZSRestore;                         external 'ZSAPI32';
function ZSCreateBlankZIPFile;              external 'ZSAPI32';
procedure ZSGetNewZIPName;                  external 'ZSAPI32';
function ZSZipFiles;                        external 'ZSAPI32';
procedure ZSZipCancel;                      external 'ZSAPI32';
function ZSZipGetReplaceFlag;               external 'ZSAPI32';
function ZSSetGlobalComment;                external 'ZSAPI32';
function ZSSetLocalComment;                 external 'ZSAPI32';
function ZSDeleteWithMask;                  external 'ZSAPI32';
function ZSDeleteWithSelection;             external 'ZSAPI32';
function ZSRepare;                          external 'ZSAPI32';
function ZSMakeEXEFile;                     external 'ZSAPI32';
function ZSSplit;                           external 'ZSAPI32';
function ZSBackup;                          external 'ZSAPI32';

end.