unit zs30con;

interface

uses Windows;

const
  {------------------------------------------------
     Strings ID
   ------------------------------------------------}
  ZSAPI_STRINGID_TEXTNOPASSWORD    =  0;
  ZSAPI_STRINGID_TEXTWITHPASSWORD  =  1;
  ZSAPI_STRINGID_RENAMEBOXTITLE    =  2;
  ZSAPI_STRINGID_OLDERTEXT         =  3;
  ZSAPI_STRINGID_NEWERTEXT         =  4;
  ZSAPI_STRINGID_REPLACETEXT       =  5;
  ZSAPI_STRINGID_OK                =  6;
  ZSAPI_STRINGID_CANCEL            =  7;
  ZSAPI_STRINGID_REPLACEBOXTITLE   =  8;
  ZSAPI_STRINGID_YES               =  9;
  ZSAPI_STRINGID_NO                = 10;
  ZSAPI_STRINGID_ALWAYS            = 11;
  ZSAPI_STRINGID_NEVER             = 12;
  ZSAPI_STRINGID_RENAME            = 13;
  ZSAPI_STRINGID_PASSWORDBOXTITLE  = 14;
  ZSAPI_STRINGID_PASSWORDLABEL     = 15;
  ZSAPI_STRINGID_RETRY             = 16;
  ZSAPI_STRINGID_BYPASS            = 17;
  ZSAPI_STRINGID_CHOOSEBACKUPTITLE = 19;
  ZSAPI_STRINGID_ZIPMAK            = 20;
  ZSAPI_STRINGID_NEWZIPDIALOGTITLE = 21;

  {----------------------------------------------
      General Unzip function return values
   ----------------------------------------------}
  ZEXTRACT_OK                 =  0;
  ZEXTRACT_INTERNALERROR      =  1;
  ZEXTRACT_FILENOTFOUND       =  2;
  ZEXTRACT_CORRUPTED          =  3;
  ZEXTRACT_EMPTY              =  4;
  ZEXTRACT_ERRORINZIPFILE     =  5;
  ZEXTRACT_NOMEM              =  6;
  ZEXTRACT_DISKFULL           =  8;
  ZEXTRACT_WASRDONLY          = 10;  { 3.0: A file was bypassed because RO }
  ZEXTRACT_WASLOCKED          = 11;  { 3.0: A file was bypassed because locked }
  ZEXTRACT_IOERROR            = 12;  { 3.0: I/O error like diskette missing }
  ZEXTRACT_DRIVENOTREADY      = 13;  { 3.0 }
  ZEXTRACT_DRIVEREADONLY      = 14;  { 3.0 }
  ZEXTRACT_DISKWRITEPROTECTED = 15;  { 3.0: The warning was already displayed }
  ZEXTRACT_TOOBIG             = 16;  { 3.0: The mask is too long (more that MAX_PATH)}
  ZEXTRACT_NOCHANGEALLOWED    = 17;  { 3.0: The ZIP should be read-only (partially supported ZIP format)}

  {----------------------------------------------
     <iOverwriteMode> for Unzip functions
   ----------------------------------------------}
   OVERWRITE_TRUE   = 1;
   OVERWRITE_FALSE  = 0;
   OVERWRITE_QUERY  = 2;

   CREATEDIR_TRUE  = 1;
   CREATEDIR_FALSE = 0;

   { <ZIPITEMBuiltUnder> code }
   ZIP_UNDER_DOS     =  0;
   ZIP_UNDER_AMIGA   =  1;
   ZIP_UNDER_VMS     =  2;
   ZIP_UNDER_UNIX    =  3;
   ZIP_UNDER_VM      =  4;
   ZIP_UNDER_ATARIST =  5;
   ZIP_UNDER_OS2HPFS =  6;
   ZIP_UNDER_MAC     =  7;
   ZIP_UNDER_ZSYSTEM =  8;
   ZIP_UNDER_W32     = 11;
   ZIP_UNDER_UNKNOWN =  9;

   { <ZIPITEMMethod> code }
   ZMETHOD_STORED  =  0;
   ZMETHOD_SHRUNK  =  1;
   ZMETHOD_REDUCE1 =  2;
   ZMETHOD_REDUCE2 =  3;
   ZMETHOD_REDUCE3 =  4;
   ZMETHOD_REDUCE4 =  5;
   ZMETHOD_IMPLODE =  6;
   ZMETHOD_TOKEN   =  7;
   ZMETHOD_DEFLATE =  8;
   ZMETHOD_UNKNOWN =  9;
   ZMETHOD_ERROR   = 10;

   { <Join> returned values }
   JOIN_OK               = 0;
   JOIN_NOFILE           = 1;
   JOIN_NOMEM            = 2;
   JOIN_IOERROR          = 3;
   JOIN_ACCESSDENIED     = 4;
   JOIN_USERABORT        = 5;
   JOIN_NOTASPLITTEDFILE = 7;
   JOIN_ZIPEXIST         = 8;
   JOIN_DISKFULL         = 9;

   { <Restore> returned values }
   ZRESTORE_OK         =  0;  { Ok }
   ZRESTORE_NOTALONE   =  1;  { Possible result code when <bCanAsk> is set to FALSE }
   ZRESTORE_NOTEMP     =  2;  { Can't create the temporary file name! }
   ZRESTORE_USERABORT  =  3;  { User Abort }
   ZRESTORE_NONE       =  4;  { Nothing To Do }
   ZRESTORE_JOINERROR  = 10;  { JOINERROR is the result code of <ZipJoin> + 10 (but JOIN_OK) }
   ZRESTORE_UNZIPERROR = 40;  { UNZIPERROR is the result of <ExtractZipFiles> + 40 (but ZEXTRACT_OK) }

{ <ZIPITEMIconIndex> special codes (or index if you don' t ask the Windows icons) }
   ZITEM_ICON_DIR       = 0;
   ZITEM_ICON_ENCRYPTED = 1;
   ZITEM_ICON_EXE       = 2;
   ZITEM_ICON_ERROR     = 3;
   ZITEM_ICON_KNOWN     = 4;
   ZITEM_ICON_UNKNOWN   = 5;


{ <ZList> sort mode }
   ZSORT_BYFULLNAME = 0; { name + dir }
   ZSORT_BYNAME     = 1;
   ZSORT_BYDIR      = 2;
   ZSORT_BYDATE     = 3;
   ZSORT_BYSIZE     = 4;
   ZSORT_BYRATE     = 5;
   ZSORT_NONE       = 6;


{----------------------------------------------------------------------------
  Zip part
 ----------------------------------------------------------------------------}

{ General Zip functions returned value }
   ZERROR_OK   =0; { No error }
   ZERROR_WARNING   = 1; { Just a warning (not an error) }
   ZERROR_DESTFILE  = 2; { Destfile ( *.ZIP ) error }
   ZERROR_INTERNAL  = 3; { Internal error }
   ZERROR_FORMAT   =4; { Not a Zip file }
   ZERROR_NOMEM    =5; { Not enough memory  }
   ZERROR_NOFILE   =6; { Nothing to do ( can be just a warning ) }
   ZERROR_NODLL    =7; { Can' t find required DLLs (under Win16) }
   ZERROR_COMMENT    =8; { Comment missing or NULL }
   ZERROR_NOCRYPT    =9; { Can' t encrypt the files }
   ZERROR_ACCESSDENIED =12;  { 3.0 }
   ZERROR_DRIVENOTREADY  =13;  { 3.0 }
   ZERROR_DRIVEREADONLY  =14;  { 3.0 }
   ZERROR_DISKWPROTECTED =15;  { 3.0: The warning was already displayed }
   ZERROR_DISKFULL  = 16;  { 3.0: The warning was already displayed }
   ZERROR_USERABORT = 17;  { 3.0 }

{ <ZipMakeEXEFile> errors }
   ZEXE_OK     =0;
   ZEXE_ELFFILEMISSING =1; { EXE Language File not found }
   ZEXE_AUTOLOADMISSING  =2; { AUTOLOAD.16 or AUTOLOAD.32 not found in the app. dir. }
   ZEXE_AUTOLOADCORRUPTED  =3; { Bad version of AUTOLOAD.16 or AUTOLOAD.32  }
   ZEXE_NOZIPFILE    =4; { Source file mising }
   ZEXE_SRCACCESSDENIED  =5; { Source file locked }
   ZEXE_DESTACCESSDENIED =6; { Exe file locked }
   ZEXE_DRIVENOTREADY  =7;
   ZEXE_DRIVEREADONLY  =8;
   ZEXE_DISKWPROTECTED =9;
   ZEXE_DISKFULL   =10;
   ZEXE_NOMEM    =11;

{ Compression method setting }
   ZMODE_NORMAL   = 0;
   ZMODE_FAST   = 1;
   ZMODE_SLOW   = 2;
   ZMODE_STORE  = 3;

{ <Backup> result }
   ZBACKUP_OK      =0; { Ok }
   ZBACKUP_NOTEMP         = 1; { Can' t create the temporary file name! }
   ZBACKUP_USERABORT      =   2; { User abort }
   ZBACKUP_NOTALONE    =3;  { Possible result code when <bForceSingle> is set to TRUE }
   ZBACKUP_WARNNOTHING  = 4; { <AddFileToZip> didn' t build the ZIP file (nothing to do) }
   ZBACKUP_ACCESSDENIEDFORALL = 5; { <AddFileToZip> didn' t build the ZIP file, all files were Access denied! }
   ZBACKUP_ACCESSDENIED   = 6; { <AddFileToZip> built the file but there was some AD. }
   ZBACKUP_ZIPERROR    =10;  { ZIPERROR is the result code of <AddFileToZip> + 10 (but ZERROR_OK) }
   ZBACKUP_SPLITERROR   = 40;  { SPLITERROR is the result code of <ZipSplit> + 40 (but SPLIT_OK) }

{ <Split> returned code }
   SPLIT_OK   = 0;
   SPLIT_NOFILE   = 1;
   SPLIT_NOMEM  = 2;
   SPLIT_IOERROR  = 3;
   SPLIT_TOOBIG   = 4;
   SPLIT_ACCESSDENIED = 5;
   SPLIT_USERABORT  = 6;
   SPLIT_DISKFULL   = 10;  { 3.0 }
   SPLIT_WPROTECTED = 11;  { 3.0 }

{ Zip functions <iOverwrite> mode }
   OVERWRITE_ALWAYS  =0; { Always overwrite ( always zip files ) (default) }
   OVERWRITE_NEVER   =1;   { Never overwrite }
   OVERWRITE_PROMPT  =2; { Ask the user }
   OVERWRITE_UPDATE  =3; { Overwrite if external file is newer }
   OVERWRITE_FRESHEN = 4; { Overwrite if external file is newer, do not add new entries [3.0] }

{ <ZipFiles> misc. settings }
   STOREPATH_NO    =0; { Don' t store paths }
   STOREPATH_YES   =1; { Store paths }
   STOREPATH_FULL  =  2; { Store paths  (complete names) [3.0] }
   RECURSE_NO   = 0; { Don' t recurse sub dirs }
   RECURSE_YES  = 1; { Recurse sub dirs }

type
  ZipItem = record
    szName : array [0..259] of char;
    szDir  : array [0..1023] of char;
    bIsDir : BOOL;
    bIsEncrypt : BOOL;
    iMethod : integer;
    iDay    : integer;
    iMonth  : integer;
    iYear   : integer;
    iHour   : integer;
    iMin    : integer;
    lOrigSize : longint;
    iRate   : integer;
    bArchive : BOOL;
    bHidden  : BOOL;
    bSystem  : BOOL;
    bRO      : BOOL;
    bComment : BOOL;
    iIconIndex : integer;
    ulCrc32 : ULONG;
  end;

  PZipItem = ^ZipItem;

implementation

end.