unit ZipDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, BrowseDr;

type
  TZipBox = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    BrowseDir: TBrowseDirectoryDlg;
    cbxBackgrnd: TCheckBox;
    cbxRArchive: TCheckBox;
    cbxArchive: TCheckBox;
    cbxRecurse: TCheckBox;
    cbKeepPath: TComboBox;
    Label6: TLabel;
    cbCompress: TComboBox;
    Label5: TLabel;
    cbOverWrite: TComboBox;
    Label4: TLabel;
    ecPassword: TEdit;
    Label3: TLabel;
    ecMask: TEdit;
    ecSourceDir: TEdit;
    Label1: TLabel;
    btnBrowse: TButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ZipBox: TZipBox;

implementation

{$R *.DFM}

procedure TZipBox.FormCreate(Sender: TObject);
var
  defPath : array [0..120] of char;
  iLen : integer;
begin
  Left := 146;
  Top := 190;
  cbOverWrite.ItemIndex := 2;
  cbKeepPath.ItemIndex := 0;
  cbCompress.ItemIndex := 0;
  ecMask.Text := '*.*';
  cbxBackgrnd.Checked := True;
  iLen := GetCurrentDirectory(80, defPath);
  if (iLen > 80) and (iLen <= 120) then
    GetCurrentDirectory(iLen, defPath);
  ecSourceDir.Text := defPath;
end;

procedure TZipBox.btnBrowseClick(Sender: TObject);
var
  szDir : string;
begin
  if BrowseDir.Execute then szDir := BrowseDir.Selected;
  if Length(szDir) > 0 then begin
    if szDir[Length(szDir)] <> '\' then szDir := szDir + '\';
    ecSourceDir.Text := szDir;
  end;
end;

end.
