unit LogoMain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, OleCtrls, ZS30W32,
  MSListView, zs30con, ZipDlg, UnzipBox;

function ListViewCompareFunc(lParam1, lParam2, lParamSort : LPARAM) : integer ; stdcall;

  type
  TD2DemoForm = class(TForm)
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileExitItem: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    Help1: TMenuItem;
    AboutItem: TMenuItem;
    StatusBar: TStatusBar;
    View: TMenuItem;
    Demo1: TMenuItem;
    ToTest1: TMenuItem;
    Toolbar1: TMenuItem;
    StatusBar1: TMenuItem;
    BigIcons1: TMenuItem;
    SmallIcons1: TMenuItem;
    List1: TMenuItem;
    Report1: TMenuItem;
    ZipFiles1: TMenuItem;
    UnzipFiles1: TMenuItem;
    Split1: TMenuItem;
    Join1: TMenuItem;
    ZSCtrl1: TZSCtrl;
    MSListView1: TMSListView;
    SpeedPanel: TPanel;
    SaveBtn: TSpeedButton;
    NewBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    PrintBtn: TSpeedButton;
    AboutBtn: TSpeedButton;
    OpenBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure FileNew(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure About(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure Toolbar1Click(Sender: TObject);
    procedure StatusBar1Click(Sender: TObject);
    procedure BigIcons1Click(Sender: TObject);
    procedure SmallIcons1Click(Sender: TObject);
    procedure List1Click(Sender: TObject);
    procedure Report1Click(Sender: TObject);
    procedure MSListView1DblClick(Sender: TObject);
    procedure ZipFiles1Click(Sender: TObject);
    procedure MSListView1GetDispInfo(Sender: TObject; ptNMHdr: PNMHdr);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MSListView1ColumnClick(Sender: TObject; Column: TListColumn);
    procedure ZSCtrl1ZNZipping(Sender: TObject;
      const szCurrentFile: string; iProcessedKBytes: Smallint);
    procedure UnzipFiles1Click(Sender: TObject);
    procedure ZSCtrl1ZNExpanding(Sender: TObject; const szName: string;
      iRateDone: Smallint);
  private
    FFileName: String;
    bClosing, bChanging : Boolean;
  public
    { Public declarations }
  end;

var
  D2DemoForm: TD2DemoForm;

implementation

uses SysUtils, Mapi, About, LogoStrs, ZipBox, CommCtrl;

{$R *.DFM}

procedure TD2DemoForm.FormCreate(Sender: TObject);
var
  NewColumn : TListColumn;
begin
  Application.OnHint := ShowHint;
  ZSCtrl1.Initialize(0, '', '', ZSCtrl1.Handle);
  ZSCtrl1.BuildZIPITEMImageList();
  bClosing := False;
  bChanging := False;
  NewColumn := MSListView1.Columns.Add;
  NewColumn.Caption := 'File';
  NewColumn.Width := 200;
  NewColumn.Alignment := taLeftJustify;
  NewColumn := MSListView1.Columns.Add;
  NewColumn.Caption := 'Size';
  NewColumn.Width := 100;
  NewColumn.Alignment := taRightJustify;
  NewColumn := MSListView1.Columns.Add;
  NewColumn.Caption := 'Directory';
  NewColumn.Width := 150;
  NewColumn.Alignment := taLeftJustify;

  MSListView1.LargeImages := TImageList.Create(Self);
  MSListView1.SmallImages := TImageList.Create(Self);

  MSListView1.LargeImages.Handle := ZSCtrl1.GetZIPItemHImageList(True);
  MSListView1.SmallImages.Handle := ZSCtrl1.GetZIPItemHImageList(False);

  MSListView1.LargeImages.ShareImages := True;
  MSListView1.SmallImages.ShareImages := True;
end;

procedure TD2DemoForm.FileNew(Sender: TObject);
begin
  FFileName := LoadStr(sUntitled);
end;

procedure TD2DemoForm.FileOpen(Sender: TObject);
var
  tStr : array [0..MAX_PATH] of char;
begin
  OpenDialog.Filter := 'ZIP Files (*.ZIP)|*.ZIP';
  if OpenDialog.Execute then
  begin
    GetTempPath(MAX_PATH, tStr);
    if tStr[Length(tStr)-1] <> '\' then strcat(tStr, '\');
    MSListView1.Update;
    FFileName := OpenDialog.FileName;
    if ZSCtrl1.IsZIPFileQuick(FFileName, True) = 0 then begin
      Caption := FFileName + ' - Zip Studio 3.0 Demo';
      if ZSCtrl1.BuildZIPITEMList(FFileName, MSListView1.Handle, True, tStr, True, 0, True) < 0 then
        Application.MessageBox('Error while loading the ZIP file list', 'Zip Error', mb_OK);
    end;
  end;
end;

procedure TD2DemoForm.FileSave(Sender: TObject);
begin
  if FFileName = LoadStr(sUntitled) then
    FileSaveAs(Sender)
end;

procedure TD2DemoForm.FileSaveAs(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    if FileExists(SaveDialog.FileName) then
      if MessageDlg(FmtLoadStr(sOverwrite, [SaveDialog.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then Exit;
    FFileName := SaveDialog.FileName;
  end;
end;

procedure TD2DemoForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TD2DemoForm.About(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TD2DemoForm.ShowHint(Sender: TObject);
begin
  StatusBar.Panels[0].Text := Application.Hint;
end;

procedure TD2DemoForm.Toolbar1Click(Sender: TObject);
begin
  Toolbar1.Checked := not Toolbar1.Checked;
  SpeedPanel.Visible := Toolbar1.Checked;
end;

procedure TD2DemoForm.StatusBar1Click(Sender: TObject);
begin
  StatusBar1.Checked := not StatusBar1.Checked;
  StatusBar.Visible := StatusBar1.Checked;
end;

procedure TD2DemoForm.BigIcons1Click(Sender: TObject);
begin
  SmallIcons1.Checked := false;
  List1.Checked := false;
  Report1.Checked := false;
  BigIcons1.Checked := true;
  MSListView1.ViewStyle := vsIcon;
end;

procedure TD2DemoForm.SmallIcons1Click(Sender: TObject);
begin
  SmallIcons1.Checked := true;
  List1.Checked := false;
  Report1.Checked := false;
  BigIcons1.Checked := false;
  MSListView1.ViewStyle := vsSmallIcon;
end;

procedure TD2DemoForm.List1Click(Sender: TObject);
begin
  SmallIcons1.Checked := false;
  List1.Checked := true;
  Report1.Checked := false;
  BigIcons1.Checked := false;
  MSListView1.ViewStyle := vsList;
end;

procedure TD2DemoForm.Report1Click(Sender: TObject);
begin
  SmallIcons1.Checked := false;
  List1.Checked := false;
  Report1.Checked := true;
  BigIcons1.Checked := false;
  MSListView1.ViewStyle := vsReport;
end;

procedure TD2DemoForm.MSListView1DblClick(Sender: TObject);
begin
  Application.MessageBox('This feature not implemented.', 'Double Click Event', mb_OK);
end;

procedure TD2DemoForm.ZipFiles1Click(Sender: TObject);
var
  pZipDlg : TZipBox;
  sResult, sSrcDir, sMask, sPassword : string;
  iOverwrite, iComp, iStorePath, iResult : integer;
  bBackGround, bRecurse, bUseArc, bRemoveArc : Boolean;
  tStr : array [0..MAX_PATH] of char;
begin
  if Length(FFileName) = 0 then
    Application.MessageBox('Please open an existing ZIP file before calling this function',
        'Error...', mb_Ok + mb_IconStop)
  else begin
    pZipDlg := TZipBox.Create(self);
    pZipDlg.ShowModal;
    if pZipDlg.ModalResult = mrOK then begin
      GetTempPath(MAX_PATH, tStr);
      if tStr[Length(tStr)-1] <> '\' then strcat(tStr, '\');
      sSrcDir := pZipDlg.ecSourceDir.Text;
      if sSrcDir[Length(sSrcDir)-1] <> '\' then sSrcDir := sSrcDir + '\';
      sMask := pZipDlg.ecMask.Text;
      sPassword := pZipDlg.ecPassword.Text;
      iOverwrite := pZipDlg.cbOverWrite.ItemIndex;
      if iOverwrite < 0 then iOverwrite := 2;
      iComp := pZipDlg.cbCompress.ItemIndex;
      if iComp < 0 then iComp := 0;
      iStorePath := pZipDlg.cbKeepPath.ItemIndex;
      if iStorePath < 0 then iStorePath := 0;
      bBackGround := pZipDlg.cbxBackgrnd.Checked;
      bRecurse := pZipDlg.cbxRecurse.Checked;
      bUseArc := pZipDlg.cbxArchive.Checked;
      bRemoveArc := pZipDlg.cbxRArchive.Checked;

      iResult := ZSCtrl1.ZipFiles(FFileName, sSrcDir+sMask, bRecurse, iStorePath, iOverwrite,
          iComp, bUseArc, bRemoveArc, sPassword, bBackGround);

      if iResult > 0 then begin
        sResult := Format('<ZipFiles> returns an Error/Warning code [%d].', [iResult]);
        Application.MessageBox(PChar(sResult), 'Zip Error...', mb_Ok+mb_IconStop);
      end;
    end;
    pZipDlg.free;
    StatusBar.Panels[0].Text := '';
    if ZSCtrl1.IsZIPFileQuick(FFileName, True) = 0 then begin
      Caption := FFileName + ' - Zip Studio 3.0 Demo';
      if ZSCtrl1.BuildZIPITEMList(FFileName, MSListView1.Handle, True, tStr, True, 0, True) < 0 then
        Application.MessageBox('Error while loading the ZIP file list', 'Zip Error', mb_OK);
    end;
  end;
end;

procedure TD2DemoForm.MSListView1GetDispInfo(Sender: TObject;
  ptNMHdr: PNMHdr);
var
  pDispInfo : PLVDispInfo;
  pItem : PZipItem;
  sTemp : string;
  i : shortint;
begin
  pDispInfo := PLVDispInfo(ptNMHdr);
  if not bClosing then begin
    if (pDispInfo^.Item.mask and LVIF_TEXT) <> 0 then begin
      pItem := PZipItem(pDispInfo^.item.lParam);
      case pDispInfo^.Item.iSubItem of
        0: begin
             if pItem^.bIsDir then
               pDispInfo^.item.pszText := CharLower(pItem^.szDir)
             else begin
               pDispInfo^.item.pszText := CharLower(pItem^.szName);
             end;
             pDispInfo^.item.mask := pDispInfo^.item.mask or LVIF_DI_SETITEM;
           end;
        1: begin
             sTemp := '                                                  ';
             if not pItem^.bIsDir then begin
               sTemp := PChar(Format('%10d', [pItem^.lOrigSize]));
               pDispInfo^.item.pszText := PChar(sTemp);
             end;
           end;
        2: begin
             if not pItem^.bIsDir then pDispInfo^.item.pszText := pItem^.szDir;
             if Length(string(pDispInfo^.item.pszText)) > 0 then begin
               OemToChar(pDispInfo^.item.pszText, pDispInfo^.item.pszText);
               CharLower(pDispInfo^.item.pszText);
             end;
           end;
      end;
    end;
  end
  else begin
    pDispInfo^.item.pszText := #0;
  end;

end;

procedure TD2DemoForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ZSCtrl1.DestroyZIPITEMLParam(MSListView1.Handle);
  ZSCtrl1.DestroyZIPITEMImageList();
end;

procedure TD2DemoForm.MSListView1ColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  MSListView1.CustomSort(@ListViewCompareFunc, LPARAM(Column.Index));
end;

function ListViewCompareFunc(lParam1, lParam2, lParamSort : LPARAM) : integer; stdcall;
var
  pItem1, pItem2 : PZipItem;
  sItem1, sItem2 : string;
  tStr1, tStr2 : string;
begin
  pItem1 := PZipItem(lParam1);
  pItem2 := PZipItem(lParam2);

  case lParamSort of
    0: begin
      if Length(pItem1^.szName) = 0 then tStr1 := pItem1^.szDir
      else tStr1 := pItem1^.szName;

      if Length(pItem2^.szName) = 0 then tStr2 := pItem2^.szDir
      else tStr2 := pItem2^.szName;

      if tStr1 = tStr2 then Result := 0
      else if tStr1 > tStr2 then Result := 1
      else Result := -1;
    end;
    1: begin
      if pItem1^.lOrigSize < pItem2^.lOrigSize then Result := -1
      else if pItem1^.lOrigSize > pItem2^.lOrigSize then Result := 1
      else Result := 0;
    end;
    else begin
      if pItem1^.szDir <> '' then
        sItem1 := pItem1^.szDir
      else
        sItem1 := ':';

      if pItem2^.szDir <> '' then
        sItem2 := pItem2^.szDir
      else
        sItem2 := ':';

      sItem1 := LowerCase(sItem1 + pItem1^.szName);
      sItem2 := LowerCase(sItem2 + pItem2^.szName);

      if sItem1 > sItem2 then Result := 1
      else if sItem1 < sItem2 then Result := -1
      else Result := 0;

    end;
  end;
end;

procedure TD2DemoForm.ZSCtrl1ZNZipping(Sender: TObject;
  const szCurrentFile: string; iProcessedKBytes: Smallint);
var
  tStr : string;
begin
  tStr := Format('%s [%d %%]', [szCurrentFile, iProcessedKBytes]);
  StatusBar.Panels[0].Text := tStr;
end;

procedure TD2DemoForm.UnzipFiles1Click(Sender: TObject);
var
  pUnZipDlg : TUnzipDlg;
  sResult, sDestDir, sMask, sPassword : string;
  iOverwrite, iResult : integer;
  bBackGround, bEraseRO, bRebuildDir : Boolean;
begin
  if Length(FFileName) = 0 then
    Application.MessageBox('Please open an existing ZIP file before calling this function',
        'Error...', mb_Ok + mb_IconStop)
  else begin
    pUnZipDlg := TUnzipDlg.Create(self);
    pUnZipDlg.ShowModal;
    if pUnZipDlg.ModalResult = mrOK then begin
      sDestDir := pUnZipDlg.ecDestDir.Text;
      if sDestDir[Length(sDestDir)] <> '\' then sDestDir := sDestDir + '\';
      sMask := pUnZipDlg.ecMask.Text;
      sPassword := pUnZipDlg.ecPassword.Text;
      iOverwrite := pUnZipDlg.cbOverwrite.ItemIndex;
      if iOverwrite < 0 then iOverwrite := 2;
      bBackGround := pUnZipDlg.cbxBackgrnd.Checked;
      bEraseRO := pUnZipDlg.cbxEraseRO.Checked;
      bRebuildDir := pUnZipDlg.cbxRebuild.Checked;

      iResult := ZSCtrl1.UnzipFiles(FFileName, sMask, sDestDir, bRebuildDir, bEraseRO,
          iOverwrite, sPassword, True, bBackGround);
      if iResult > 0 then begin
        sResult := Format('<UnzipFiles> returns an Error/Warning code [%d].', [iResult]);
        Application.MessageBox(PChar(sResult), 'Unzip Error...', mb_Ok+mb_IconStop);
      end;
    end;
    pUnZipDlg.free;
    StatusBar.Panels[0].Text := '';
  end;
end;

procedure TD2DemoForm.ZSCtrl1ZNExpanding(Sender: TObject;
  const szName: string; iRateDone: Smallint);
var
  tStr : string;
begin
  tStr := Format('%s [%d %%]', [szName, iRateDone]);
  StatusBar.Panels[0].Text := tStr;
end;

end.

