// ------------------------------------------------------------------------------------------------------------------------------------------------------------
//
//                                               Z I P    S T U D I O     A P I  
//
// 	                              Copyright Hexanet - 1993-1996 All rights reserved
//                                               EMail: hnet@dialup.francenet.fr
//                                       http://ourworld.compuserve.com/homepages/hnet
//
// ------------------------------------------------------------------------------------------------------------------------------------------------------------
#ifndef _zip30dll_h
#define _zip30dll_h

#ifndef _WIN32
 #ifndef LPCTSTR
   #define LPCTSTR LPCSTR
 #endif
 #ifndef LPTSTR
   #define LPTSTR LPSTR
 #endif
#endif

#ifdef __cplusplus
extern "C"
	{
#endif

// --------------------------------------------------------------------------
// <Initialize> function to use just after loading
// the DLL.
// Set <lSerialNumber> to 0L, and <szName>
// and <szPassword> to NULL to evaluate the
// Zip Studio enabilities, or use your passwords
// as described on your invoice.
// <hWndParent> is your main HWND which will
// receive the notification messages
//
// ZSChangeOwner lets you specify a new parent dialog-box (during
// Zip and Unzip treatments).
// --------------------------------------------------------------------------
extern BOOL WINAPI ZSInitialize( long lSerialNumber, LPCTSTR szName, LPCTSTR szPassword, long hWndParent );
extern void WINAPI ZSChangeOwner( long hWndParent );

// ------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Constants and types (same as the OCX)
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------
#ifndef _ZS30CONS_H

#ifdef _WIN32
	#undef _MAX_PATH
	#define _MAX_PATH	1024
#endif


// ----------------------------------------------------------------------------
//	Strings ID (use with <SetStringResource>)
// ----------------------------------------------------------------------------
#define ZSAPI_STRINGID_TEXTNOPASSWORD				0
#define ZSAPI_STRINGID_TEXTWITHPASSWORD				1
#define ZSAPI_STRINGID_RENAMEBOXTITLE				2
#define ZSAPI_STRINGID_OLDERTEXT				3
#define ZSAPI_STRINGID_NEWERTEXT				4
#define ZSAPI_STRINGID_REPLACETEXT				5
#define ZSAPI_STRINGID_OK					6
#define ZSAPI_STRINGID_CANCEL					7
#define ZSAPI_STRINGID_REPLACEBOXTITLE				8
#define ZSAPI_STRINGID_YES					9
#define ZSAPI_STRINGID_NO					10
#define ZSAPI_STRINGID_ALWAYS					11
#define ZSAPI_STRINGID_NEVER					12
#define ZSAPI_STRINGID_RENAME					13
#define ZSAPI_STRINGID_PASSWORDBOXTITLE				14
#define ZSAPI_STRINGID_PASSWORDLABEL				15
#define ZSAPI_STRINGID_RETRY					16
#define ZSAPI_STRINGID_BYPASS					17
#define ZSAPI_STRINGID_CHOOSEBACKUPTITLE			19
#define ZSAPI_STRINGID_ZIPMAK					20
#define ZSAPI_STRINGID_NEWZIPDIALOGTITLE             		21


// ----------------------------------------------------------------------------
//	Unzip part
// ----------------------------------------------------------------------------

/* General Unzip functions returned value */
#define 	ZEXTRACT_OK			0
#define 	ZEXTRACT_INTERNALERROR  	1
#define 	ZEXTRACT_FILENOTFOUND		2
#define 	ZEXTRACT_CORRUPTED		3
#define 	ZEXTRACT_EMPTY			4
#define 	ZEXTRACT_ERRORINZIPFILE		5	 
#define 	ZEXTRACT_NOMEM			6
#define 	ZEXTRACT_DISKFULL		8
#define 	ZEXTRACT_WASRDONLY		10	// 3.0: A file was bypassed because RO
#define 	ZEXTRACT_WASLOCKED		11	// 3.0: A file was bypassed because locked
#define 	ZEXTRACT_IOERROR		12	// 3.0: I/O error like diskette missing
#define 	ZEXTRACT_DRIVENOTREADY		13 	// 3.0
#define 	ZEXTRACT_DRIVEREADONLY		14	// 3.0
#define 	ZEXTRACT_DISKWPROTECTED		15	// 3.0: The warning was already displayed
#define 	ZEXTRACT_TOOBIG			16	// 3.0: The mask is too long (more than _MAX_PATH)
#define 	ZEXTRACT_NOCHANGEALLOWED	17	// 3.0: The ZIP should be read-only (partially supported ZIP format)


/* <iOverwriteMode> for Unzip functions */
#define 	OVERWRITE_TRUE			1		
#define 	OVERWRITE_FALSE			0
#define 	OVERWRITE_QUERY	    		2	
#define 	OVERWRITE_UPDATE		3	//3.0: Only unzip the newer files

#define 	CREATEDIR_TRUE			1
#define 	CREATEDIR_FALSE			0


/* <ZIPITEMBuiltUnder> code */
#define 	ZIP_UNDER_DOS			0
#define 	ZIP_UNDER_AMIGA	  		1
#define 	ZIP_UNDER_VMS			2
#define 	ZIP_UNDER_UNIX			3
#define 	ZIP_UNDER_VM		 	4
#define 	ZIP_UNDER_ATARIST		5
#define 	ZIP_UNDER_OS2HPFS		6
#define 	ZIP_UNDER_MAC			7
#define 	ZIP_UNDER_ZSYSTEM		8
#define 	ZIP_UNDER_W32			11
#define 	ZIP_UNDER_UNKNOWN		9


/* <ZIPITEMMethod> code */
#define 	ZMETHOD_STORED			0
#define 	ZMETHOD_SHRUNK			1
#define 	ZMETHOD_REDUCE1			2
#define 	ZMETHOD_REDUCE2			3
#define 	ZMETHOD_REDUCE3			4
#define 	ZMETHOD_REDUCE4			5
#define 	ZMETHOD_IMPLODE			6
#define 	ZMETHOD_TOKEN			7
#define 	ZMETHOD_DEFLATE			8
#define 	ZMETHOD_UNKNOWN			9
#define 	ZMETHOD_ERROR			10


/* <Join> returned values */
#define 	JOIN_OK				0
#define 	JOIN_NOFILE			1
#define 	JOIN_NOMEM			2
#define 	JOIN_IOERROR			3
#define 	JOIN_ACCESSDENIED	  	4
#define 	JOIN_USERABORT			5
#define 	JOIN_NOTASPLITTEDFILE 		7
#define 	JOIN_ZIPEXIST			8
#define 	JOIN_DISKFULL			9


/* <Restore> returned values */
#define 	ZRESTORE_OK			0	// Ok
#define 	ZRESTORE_NOTALONE		1	// Possible result code when <bCanAsk> is set to FALSE
#define 	ZRESTORE_NOTEMP       		2	// Can' t create the temporary file name!
#define 	ZRESTORE_USERABORT       	3	// User abort
#define 	ZRESTORE_NONE			4	// Nothing to do
#define 	ZRESTORE_JOINERROR		10	// JOINERROR is the result code of <ZipJoin> + 10 (but JOIN_OK)
#define 	ZRESTORE_UNZIPERROR		40	// UNZIPERROR is the result code of <ExtractZipFiles> + 40 (but ZEXTRACT_OK)

/* The ZIPITEM structure */
typedef struct TAGZIPITEM
       	{
    #ifndef _WIN32
       	TCHAR szName[50];
       	TCHAR szDir[260];
    #else
       	TCHAR szName[260];
       	TCHAR szDir[1024];
    #endif
       	BOOL bIsDir;
       	BOOL bIsEncrypted;
       	int iMethod;
       	int iDay;
       	int iMonth;
       	int iYear;
       	int iHour;
       	int iMin;
       	long lOriginalSize;
       	int iRate;
       	BOOL bArchive;
       	BOOL bHidden;
       	BOOL bSystem;
       	BOOL bRO;
       	BOOL bComment;
       	int iIconIndex;
       	unsigned long ulCrc32;
       	}ZIPITEM;
        

/* <ZIPITEMIconIndex> special codes (or index if you don' t ask the Windows icons) */
#define 	ZITEM_ICON_DIR		0
#define 	ZITEM_ICON_ENCRYPTED    1
#define 	ZITEM_ICON_EXE		2
#define 	ZITEM_ICON_ERROR	3
#define 	ZITEM_ICON_KNOWN	4
#define 	ZITEM_ICON_UNKNOWN	5


/* <ZList> sort mode */
#define 	ZSORT_BYFULLNAME	0	// name + dir
#define 	ZSORT_BYNAME		1
#define 	ZSORT_BYDIR		2
#define 	ZSORT_BYDATE		3
#define 	ZSORT_BYSIZE		4
#define 	ZSORT_BYRATE		5
#define 	ZSORT_NONE		6


// ----------------------------------------------------------------------------
//	Zip part
// ----------------------------------------------------------------------------

/* General Zip functions returned value */
#define 	ZERROR_OK		0	// No error
#define 	ZERROR_WARNING		1	// Just a warning (not an error)
#define 	ZERROR_DESTFILE		2	// Destfile ( *.ZIP ) error
#define 	ZERROR_INTERNAL 	3	// Internal error
#define 	ZERROR_FORMAT		4	// Not a Zip file
#define 	ZERROR_NOMEM		5	// Not enough memory 
#define 	ZERROR_NOFILE		6	// Nothing to do ( can be just a warning )
#define 	ZERROR_NODLL		7	// Can' t find required DLLs (under Win16)
#define 	ZERROR_COMMENT		8	// Comment missing or NULL
#define 	ZERROR_NOCRYPT		9	// Can' t encrypt the files
#define 	ZERROR_ACCESSDENIED	12 	// 3.0
#define 	ZERROR_DRIVENOTREADY	13 	// 3.0
#define 	ZERROR_DRIVEREADONLY	14	// 3.0
#define 	ZERROR_DISKWPROTECTED	15	// 3.0: The warning was already displayed
#define 	ZERROR_DISKFULL		16	// 3.0: The warning was already displayed
#define 	ZERROR_USERABORT	17	// 3.0

/* <ZipMakeEXEFile> errors*/
#define 	ZEXE_OK			0
#define 	ZEXE_ELFFILEMISSING	1	// EXE Language File not found
#define 	ZEXE_AUTOLOADMISSING	2	// AUTOLOAD.16 or AUTOLOAD.32 not found in the app. dir.
#define 	ZEXE_AUTOLOADCORRUPTED	3	// Bad version of AUTOLOAD.16 or AUTOLOAD.32 
#define 	ZEXE_NOZIPFILE		4	// Source file mising
#define 	ZEXE_SRCACCESSDENIED	5	// Source file locked
#define 	ZEXE_DESTACCESSDENIED	6	// Exe file locked
#define 	ZEXE_DRIVENOTREADY	7
#define 	ZEXE_DRIVEREADONLY	8
#define 	ZEXE_DISKWPROTECTED	9
#define 	ZEXE_DISKFULL		10
#define 	ZEXE_NOMEM		11

/* Compression method setting */
#define 	ZMODE_NORMAL		0
#define 	ZMODE_FAST		1
#define 	ZMODE_SLOW		2
#define 	ZMODE_STORE		3

/* <Backup> result */
#define 	ZBACKUP_OK			0	// Ok
#define 	ZBACKUP_NOTEMP       		1	// Can' t create the temporary file name!
#define 	ZBACKUP_USERABORT       	2	// User abort
#define 	ZBACKUP_NOTALONE		3	 // Possible result code when <bForceSingle> is set to TRUE
#define 	ZBACKUP_WARNNOTHING		4	// <AddFileToZip> didn' t build the ZIP file (nothing to do)
#define 	ZBACKUP_ACCESSDENIEDFORALL	5	// <AddFileToZip> didn' t build the ZIP file, all files were Access denied!
#define 	ZBACKUP_ACCESSDENIED		6	// <AddFileToZip> built the file but there was some AD.
#define 	ZBACKUP_ZIPERROR		10	// ZIPERROR is the result code of <AddFileToZip> + 10 (but ZERROR_OK)
#define 	ZBACKUP_SPLITERROR		40	// SPLITERROR is the result code of <ZipSplit> + 40 (but SPLIT_OK)

/* <Split> returned code */
#define 	SPLIT_OK		0
#define 	SPLIT_NOFILE		1
#define 	SPLIT_NOMEM		2
#define 	SPLIT_IOERROR		3
#define 	SPLIT_TOOBIG		4
#define 	SPLIT_ACCESSDENIED	5
#define 	SPLIT_USERABORT		6
#define 	SPLIT_DISKFULL		10	// 3.0
#define 	SPLIT_WPROTECTED	11	// 3.0	    
			
/* Zip functions <iOverwrite> mode */
#define 	OVERWRITE_ALWAYS	0	// Always overwrite ( always zip files ) (default)
#define 	OVERWRITE_NEVER		1 	// Never overwrite
#define 	OVERWRITE_PROMPT	2	// Ask the user
#define 	OVERWRITE_UPDATE	3	// Overwrite if external file is newer
#define 	OVERWRITE_FRESHEN	4	// Overwrite if external file is newer, do not add new entries [3.0]

/* <ZipFiles> misc. settings */
#define 	STOREPATH_NO		0	// Don' t store paths
#define 	STOREPATH_YES		1	// Store paths
#define 	STOREPATH_FULL		2	// Store paths	(complete names) [3.0]
#define 	RECURSE_NO		0	// Don' t recurse sub dirs
#define 	RECURSE_YES		1	// Recurse sub dirs

#endif // _ZS30CONS_H
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------




// --------------------------------------------------------------------------
//	Informations functions
// --------------------------------------------------------------------------
extern short WINAPI ZSIsZIPFileQuick(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSIsZIPFileSlow(LPCTSTR szZipName, LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSGetCount(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern double WINAPI ZSGetTotalSize(LPCTSTR szZipName, BOOL bOriginalSize, BOOL bBackGroundProcessing) ;
extern BOOL WINAPI ZSIsFileInTheZIPFile(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing) ;

extern short WINAPI ZSGetZIPINFOMadeUnder(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSGetZIPINFOVersionMinor(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSGetZIPINFOVersionMajor(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSGetZIPINFODiskID(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;

extern short WINAPI ZSGetGlobalCommentSize(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSGetLocalCommentSize(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing) ;

// The following functions use a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.
extern void WINAPI ZSGetGlobalComment(LPCTSTR szZipName, short iMaxLength, BOOL bBackGroundProcessing, LPTSTR szBuffer) ;
extern void WINAPI ZSGetLocalComment(LPCTSTR szZipName, LPCTSTR szMask, short iMaxLength, BOOL bBackGroundProcessing, LPTSTR szBuffer) ;

// This function has replaced the OCX <GetZIPITEM...> methods, and fill the <zItem> parameter
// with all the ZIPITEM informations.
extern BOOL WINAPI ZSGetZIPITEM( long hListZIPITEM, short iIndex, BOOL bListCtrlMode, ZIPITEM FAR* zItem ) ;



// --------------------------------------------------------------------------
//	Common misc. functions
// --------------------------------------------------------------------------
extern BOOL WINAPI ZSIsFileNameInFilter(LPCTSTR szName, LPCTSTR szPattern);

extern short WINAPI ZSGetZipBufferSize() ;
extern short WINAPI ZSGetUnzipBufferSize() ;

extern void WINAPI ZSSetStringResource(short iStringID, LPCTSTR szValue) ;

extern BOOL WINAPI ZSIsDisketteReady(LPCTSTR szDiskette) ;
extern BOOL WINAPI ZSIsDriveWriteable(LPCTSTR szDrive) ;
extern BOOL WINAPI ZSIsWriteable(LPCTSTR szDestFile, long lSizeInBytes) ;

extern void WINAPI ZSSetHelpFile(LPCTSTR szHelpFile) ; // (undocumented)
extern void WINAPI ZSSetIniFile(LPCTSTR szFile) ; 
extern BOOL WINAPI ZSDeleteTempDirectories() ;

extern void WINAPI ZSSetPasswordMode(BOOL bShow, BOOL bSave) ;
extern void WINAPI ZSDeletePasswords() ;


// --------------------------------------------------------------------------
//	ZIP files list functions
// --------------------------------------------------------------------------
extern BOOL WINAPI ZSBuildZIPITEMImageList() ;
extern BOOL WINAPI ZSSetListViewImageList(long hListView) ;
extern long WINAPI ZSGetZIPITEMHImageList(BOOL bBigIcons) ;
extern short WINAPI ZSBuildZIPITEMList(LPCTSTR szZipName, long hListZIPITEM, BOOL bListCtrlMode, 
                       LPCTSTR szPrivateTempDirectory, BOOL bWindowsIcons, short iSortMode, BOOL bBackGroundProcessing) ;
extern BOOL WINAPI ZSSortZIPITEMList(long hListZIPITEM, short iSortMode, BOOL bBackGroundProcessing) ;
extern void WINAPI ZSDestroyZIPITEMLParam(long hListZIPITEM) ;
extern BOOL WINAPI ZSDestroyZIPITEMImageList() ;



// --------------------------------------------------------------------------
//	Unzip functions
// --------------------------------------------------------------------------
extern short WINAPI ZSUnzipFiles(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szDestDirectory, BOOL bRebuildDir, BOOL bEraseReadOnlyFiles, 
                      short iOverwriteMode, LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSUnzipToFile(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szDestFile, BOOL bEraseReadOnlyFiles, LPCTSTR szPassword, 
                      BOOL bAskPassword, BOOL bBackGroundProcessing) ;
extern BOOL WINAPI ZSView(LPCTSTR szZipName, LPCTSTR szMask, BOOL bUseTextEditor, BOOL bRunEXE, LPCTSTR szPrivateTempDir, 
                      LPCTSTR szPassword, BOOL bAskPassword, BOOL bBackGroundProcessing) ;

extern void WINAPI ZSUnzipCancel(BOOL bCancel) ;
extern short WINAPI ZSUnzipGetReplaceFlag() ;

extern short WINAPI ZSJoin(LPCTSTR szPartFileName, LPCTSTR szDestDirectory, LPCTSTR szTitle, LPCTSTR szMsg, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSRestore(LPCTSTR szSourceDirectory, LPCTSTR szDestinationDirectory, 
                      short iOverwriteMode, BOOL bDisplayDialog, BOOL bEraseReadOnlyFiles, 
                      LPCTSTR szTitle, LPCTSTR szMsg, BOOL bBackGroundProcessing) ;


// --------------------------------------------------------------------------
//	Zip functions
//
//	Note: With the Windows 3.1x version, you need ZS30ZW16.DLL in order
//            to call <ZSZipFiles> and <ZSBackup>. You may get this file
//            from the Zip Shhell (Win16 version) directory.
//
// --------------------------------------------------------------------------
extern BOOL WINAPI ZSCreateBlankZIPFile(LPCTSTR szZipName, BOOL bOpenDialog) ;
// The following function uses a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.
extern void WINAPI ZSGetNewZIPName( LPTSTR szBuffer ) ;

extern short WINAPI ZSZipFiles(LPCTSTR szZipName, LPCTSTR szMask, BOOL bRecurseSubDirs, short iStorePathMethod, short iOverwriteMode, 
                       short iCompressionMode, BOOL bUseArchiveFlag, BOOL bRemoveArchiveFlag, LPCTSTR szPassword, BOOL bBackGroundProcessing );
extern void WINAPI ZSZipCancel(BOOL bCancel) ;
extern short WINAPI ZSZipGetReplaceFlag() ;

extern short WINAPI ZSSetGlobalComment(LPCTSTR szZipName, LPCTSTR szComment, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSSetLocalComment(LPCTSTR szZipName, LPCTSTR szMask, LPCTSTR szComment, BOOL bBackGroundProcessing) ;

extern short WINAPI ZSDeleteWithMask(LPCTSTR szZipName, LPCTSTR szMask, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSDeleteWithSelection(LPCTSTR szZipName, long hListZIPITEM, long hListSelected, BOOL bListIsListCtrl, BOOL bBackGroundProcessing) ;

extern short WINAPI ZSRepare(LPCTSTR szZipName, BOOL bBackGroundProcessing) ;
extern short WINAPI ZSMakeEXEFile(LPCTSTR szZipName, LPCTSTR szEXEName, LPCTSTR szProgramToLaunch, LPCTSTR szEXETitle, LPCTSTR szELFFile, 
                       short iOverwriteMode, BOOL bAskDirectory, BOOL bWin32Target, BOOL bBackGroundProcessing) ;

extern short WINAPI ZSSplit(LPCTSTR szZipName, LPCTSTR szDestDir, long lFirstBlockSizeInBytes, long lNextBlockSizeInBytes, BOOL bBackGroundProcessing, 
                       LPCTSTR szTitle, LPCTSTR szMsg) ;
extern short WINAPI ZSBackup(LPCTSTR szMask, LPCTSTR szDestDrive, BOOL bRecurse, BOOL bUseArchiveFlag, BOOL bRemoveArchiveFlag, BOOL bForceSingleBackup, 
                       LPCTSTR szTitle, LPCTSTR szMsg, short iCompressionMode, BOOL bBackGroundProcessing) ;



// ------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Events
// wp -> WParam, lp -> lParam
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------

#define ZN_JOINING		(WM_USER+41)	// wp = <size>; lp =<name>
#define ZN_JOINDONESIZE 	(WM_USER+43)	// wp = NULL; lp =<size>
#define ZN_JOINDONENAME		(WM_USER+44)	// wp = NULL; lp =<name>
#define ZN_SPLITTING		(WM_USER+61)	// wp = <size>; lp =<name>
#define ZN_SPLITTED		(WM_USER+62)	// wp = <number>; lp =<size>
#define ZN_OPENFILE		(WM_USER+38)	// (=ZNUnzipOpen) wp = <flag>; lp =<name>
#define ZN_EXPANDING		(WM_USER+39)	// wp = <rate>; lp =<name>
#define ZN_CLOSEFILE		(WM_USER+40)	// (=ZNUnzipClose) wp = <flag>; lp =<name>
#define ZN_ZIPPING		(WM_USER+46)	// wp = <size>; lp =<name>
#define ZN_ZIPPING2		(WM_USER+50)	// wp = <rate>; lp =<name>
#define ZN_FILEZIPPED		(WM_USER+45)	// wp = <rate>; lp =<name>
#define ZN_WRITING		(WM_USER+48)	// wp = NULL; lp =<name>
#define ZN_DELETING		(WM_USER+47)	// wp = NULL; lp =<name>
#define ZN_REPARING		(WM_USER+49)	// wp = <step>; lp =<name>
#define ZN_ENCRYPT		(WM_USER+66)	// wp = <rate>; lp =<name>
#define ZN_TEST			(WM_USER+69)	// wp = <error level>; lp =<name>
#define ZN_BACKUP_BUILDZIP	(WM_USER+80)	// wp = NULL; lp =<name>
#define ZN_BACKUP_ZIPDONE	(WM_USER+81)	// wp = NULL; lp =<size>
#define ZN_RESTORE_BUILDZIP	(WM_USER+82)	// wp = NULL; lp =<name>
#define ZN_RESTORE_ZIPDONE	(WM_USER+83)	// wp = NULL; lp =<size>
#define ZN_MAKEEXE_STEP1	(WM_USER+90)	// wp = NULL; lp =NULL
#define ZN_MAKEEXE_STEP2	(WM_USER+91)	// wp = <rate>; lp =NULL


#ifdef __cplusplus
}
#endif

#endif // _zip30

