unit ZSAPI16;

interface

uses WinTypes, Messages, ZS30C16;

{// --------------------------------------------------------------------------
// <Initialize> function to use just after loading
// the DLL.
// Set <lSerialNumber> to 0L, and <szName>
// and <szPassword> to NULL to evaluate the
// Zip Studio enabilities, or use your passwords
// as described on your invoice.
// <hWndParent> is your main HWND which will
// receive the notification messages
//
// ZSChangeOwner lets you specify a new parent dialog-box (during
// Zip and Unzip treatments).
// --------------------------------------------------------------------------}
function ZSInitialize( lSerialNumber : Integer; szName, szPassword : string; hWndParent : Integer) : WordBool;
procedure ZSChangeOwner( hWndParent : Integer );

{// --------------------------------------------------------------------------
//	Informations functions
// --------------------------------------------------------------------------}
function ZSIsZIPFileQuick(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSIsZIPFileSlow(const szZipName, szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : smallint;
function ZSGetCount(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSGetTotalSize(const szZipName : string; bOriginalSize, bBackGroundProcessing : WordBool) : double;
function ZSIsFileInTheZIPFile(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : WordBool;

function ZSGetZIPINFOMadeUnder(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSGetZIPINFOVersionMinor(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSGetZIPINFOVersionMajor(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSGetZIPINFODiskID(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;

function ZSGetGlobalCommentSize(const szZipName; bBackGroundProcessing : WordBool) : smallint;
function ZSGetLocalCommentSize(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : smallint;

{// The following functions use a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.}
procedure ZSGetGlobalComment(const szZipName : string; iMaxLength : smallint; bBackGroundProcessing : WordBool;
   var szBuffer : string);
procedure ZSGetLocalComment(const szZipName, szMask : string; iMaxLength : smallint; bBackGroundProcessing : WordBool;
   var szBuffer : string);

{// This function has replaced the OCX <GetZIPITEM...> methods, and fill the <zItem> parameter
// with all the ZIPITEM informations.}
function ZSGetZIPITEM( hListZIPITEM : Integer; iIndex : smallint; bListCtrlMode : WordBool; var zItem : PZipItem ) : WordBool;

{// --------------------------------------------------------------------------
//	Common misc. functions
// --------------------------------------------------------------------------}
function ZSIsFileNameInFilter(const szName, szPattern : string) : WordBool;

function ZSGetZipBufferSize : smallint;
function ZSGetUnzipBufferSize : smallint;

procedure ZSSetStringResource(iStringID : smallint; const szValue : string) ;

function ZSIsDisketteReady(const szDiskette : string) : WordBool;
function ZSIsDriveWriteable(const szDrive : string) : WordBool;
function ZSIsWriteable(const szDestFile : string; lSizeInBytes : Integer) : WordBool;

procedure ZSSetHelpFile(const szHelpFile : string) ; {undocumented}
procedure ZSSetIniFile(const szFile : string) ;
function ZSDeleteTempDirectories : WordBool;

procedure ZSSetPasswordMode(bShow, bSave : WordBool) ;
procedure ZSDeletePasswords;

{// --------------------------------------------------------------------------
//	ZIP files list functions
// --------------------------------------------------------------------------}
function ZSBuildZIPITEMImageList : WordBool;
function ZSSetListViewImageList(hListView : Integer) : WordBool;
function ZSGetZIPITEMHImageList(bBigIcons : WordBool) : Integer;
function ZSBuildZIPITEMList(const szZipName : string; hListZIPITEM : Integer; bListCtrlMode : WordBool;
                       const szPrivateTempDirectory : string; bWindowsIcons : WordBool; iSortMode : smallint;
                       bBackGroundProcessing : WordBool) : smallint;
function ZSSortZIPITEMList(hListZIPITEM : Integer; iSortMode : smallint;
    bBackGroundProcessing : WordBool) : WordBool;
procedure ZSDestroyZIPITEMLParam(hListZIPITEM : Integer) ;
function ZSDestroyZIPITEMImageList : WordBool;

{// --------------------------------------------------------------------------
//	Unzip functions
// --------------------------------------------------------------------------}
function ZSUnzipFiles(const szZipName, szMask, szDestDirectory : string; bRebuildDir, bEraseReadOnlyFiles : WordBool;
                      iOverwriteMode : smallint; const szPassword : string; bAskPassword,
                      bBackGroundProcessing : WordBool) : smallint;
function ZSUnzipToFile(const szZipName, szMask, szDestFile : string; bEraseReadOnlyFiles : WordBool;
                      const szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : smallint;
function ZSView(const szZipName, szMask : string; bUseTextEditor, bRunEXE : WordBool;
                const szPrivateTempDir, szPassword : string; bAskPassword, bBackGroundProcessing : WordBool) : WordBool;

procedure ZSUnzipCancel(bCancel : WordBool) ;
function ZSUnzipGetReplaceFlag : smallint;

function ZSJoin(const szPartFileName, szDestDirectory, szTitle, szMsg : string; bBackGroundProcessing : WordBool) : smallint;
function ZSRestore(const szSourceDirectory, szDestinationDirectory : string;
                      iOverwriteMode : smallint; bDisplayDialog, bEraseReadOnlyFiles : WordBool;
                      const szTitle, szMsg : string; bBackGroundProcessing : WordBool) : smallint;

{// --------------------------------------------------------------------------
//	Zip functions
//
//	Note: With the Windows 3.1x version, you need ZS30ZW16.DLL in order
//            to call <ZSZipFiles> and <ZSBackup>. You may get this file
//            from the Zip Shhell (Win16 version) directory.
//
// --------------------------------------------------------------------------}
function ZSCreateBlankZIPFile(const szZipName : string; bOpenDialog : WordBool) : WordBool;
{// The following function uses a new argument (<szBuffer>) to receive the buffer instead
// of returning a basic string.}
procedure ZSGetNewZIPName(const szBuffer : string) ;

function ZSZipFiles(const szZipName, szMask : string; bRecurseSubDirs : WordBool; iStorePathMethod, iOverwriteMode,
                       iCompressionMode : smallint; bUseArchiveFlag, bRemoveArchiveFlag : WordBool;
                       const szPassword : string; bBackGroundProcessing : WordBool) : smallint;
procedure ZSZipCancel(bCancel : WordBool) ;
function ZSZipGetReplaceFlag : smallint;

function ZSSetGlobalComment(const szZipName, szComment : string; bBackGroundProcessing : WordBool) : smallint;
function ZSSetLocalComment(const szZipName, szMask, szComment : string; bBackGroundProcessing : WordBool) : smallint;

function ZSDeleteWithMask(const szZipName, szMask : string; bBackGroundProcessing : WordBool) : smallint;
function ZSDeleteWithSelection(const szZipName : string; hListZIPITEM, hListSelected : Integer; bListIsListCtrl,
                       bBackGroundProcessing : WordBool) : smallint;

function ZSRepare(const szZipName : string; bBackGroundProcessing : WordBool) : smallint;
function ZSMakeEXEFile(const szZipName, szEXEName, szProgramToLaunch, szEXETitle, szELFFile : string;
                       iOverwriteMode : smallint; bAskDirectory, bWin32Target, bBackGroundProcessing : WordBool) : smallint;

function ZSSplit(const szZipName, szDestDir : string; lFirstBlockSizeInBytes, lNextBlockSizeInBytes : Integer;
     bBackGroundProcessing : WordBool; const szTitle, szMsg : string) : smallint;
function ZSBackup(const szMask, szDestDrive : string; bRecurse, bUseArchiveFlag, bRemoveArchiveFlag,
       bForceSingleBackup : WordBool; const szTitle, szMsg : string; iCompressionMode : smallint;
       bBackGroundProcessing : WordBool) : smallint;

implementation

function ZSInitialize;                      external 'ZSAPI16';
procedure ZSChangeOwner;                    external 'ZSAPI16';
function ZSIsZIPFileQuick;                  external 'ZSAPI16';
function ZSIsZIPFileSlow;                   external 'ZSAPI16';
function ZSGetCount;                        external 'ZSAPI16';
function ZSGetTotalSize;                    external 'ZSAPI16';
function ZSIsFileInTheZIPFile;              external 'ZSAPI16';
function ZSGetZIPINFOMadeUnder;             external 'ZSAPI16';
function ZSGetZIPINFOVersionMinor;          external 'ZSAPI16';
function ZSGetZIPINFOVersionMajor;          external 'ZSAPI16';
function ZSGetZIPINFODiskID;                external 'ZSAPI16';
function ZSGetGlobalCommentSize;            external 'ZSAPI16';
function ZSGetLocalCommentSize;             external 'ZSAPI16';
procedure ZSGetGlobalComment;               external 'ZSAPI16';
procedure ZSGetLocalComment;                external 'ZSAPI16';
function ZSGetZIPITEM;                      external 'ZSAPI16';
function ZSIsFileNameInFilter;              external 'ZSAPI16';
function ZSGetZipBufferSize;                external 'ZSAPI16';
function ZSGetUnzipBufferSize;              external 'ZSAPI16';
procedure ZSSetStringResource;              external 'ZSAPI16';
function ZSIsDisketteReady;                 external 'ZSAPI16';
function ZSIsDriveWriteable;                external 'ZSAPI16';
function ZSIsWriteable;                     external 'ZSAPI16';
procedure ZSSetHelpFile;                    external 'ZSAPI16';
procedure ZSSetIniFile;                     external 'ZSAPI16';
function ZSDeleteTempDirectories;           external 'ZSAPI16';
procedure ZSSetPasswordMode;                external 'ZSAPI16';
procedure ZSDeletePasswords;                external 'ZSAPI16';
function ZSBuildZIPITEMImageList;           external 'ZSAPI16';
function ZSSetListViewImageList;            external 'ZSAPI16';
function ZSGetZIPITEMHImageList;            external 'ZSAPI16';
function ZSBuildZIPITEMList;                external 'ZSAPI16';
function ZSSortZIPITEMList;                 external 'ZSAPI16';
procedure ZSDestroyZIPITEMLParam;           external 'ZSAPI16';
function ZSDestroyZIPITEMImageList;         external 'ZSAPI16';
function ZSUnzipFiles;                      external 'ZSAPI16';
function ZSUnzipToFile;                     external 'ZSAPI16';
function ZSView;                            external 'ZSAPI16';
procedure ZSUnzipCancel;                    external 'ZSAPI16';
function ZSUnzipGetReplaceFlag;             external 'ZSAPI16';
function ZSJoin;                            external 'ZSAPI16';
function ZSRestore;                         external 'ZSAPI16';
function ZSCreateBlankZIPFile;              external 'ZSAPI16';
procedure ZSGetNewZIPName;                  external 'ZSAPI16';
function ZSZipFiles;                        external 'ZS30ZW16';
procedure ZSZipCancel;                      external 'ZSAPI16';
function ZSZipGetReplaceFlag;               external 'ZSAPI16';
function ZSSetGlobalComment;                external 'ZSAPI16';
function ZSSetLocalComment;                 external 'ZSAPI16';
function ZSDeleteWithMask;                  external 'ZSAPI16';
function ZSDeleteWithSelection;             external 'ZSAPI16';
function ZSRepare;                          external 'ZSAPI16';
function ZSMakeEXEFile;                     external 'ZSAPI16';
function ZSSplit;                           external 'ZSAPI16';
function ZSBackup;                          external 'ZS30ZW16';

end.
