unit ZS30W16;

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ZSAPI16, ZS30C16;

type

  TZSCtrlZNOpenFile = procedure(Sender: TObject; const szName: string) of object;
  TZSCtrlZNExpanding = procedure(Sender: TObject; const szName: string; iRateDone: Smallint) of object;
  TZSCtrlZNCloseFile = procedure(Sender: TObject; const szName: string; bNoError: WordBool) of object;
  TZSCtrlZNTest = procedure(Sender: TObject; const szName: string; bNoError: WordBool) of object;
  TZSCtrlZNJoining = procedure(Sender: TObject; iSizeInKBytes: Smallint; const szPartFileName: string) of object;
  TZSCtrlZNJoined = procedure(Sender: TObject; iPartFileNumber: Smallint; lTotalSize: Integer) of object;
  TZSCtrlZNJoinDoneSize = procedure(Sender: TObject; lTotalSize: Integer) of object;
  TZSCtrlZNJoinDoneName = procedure(Sender: TObject; const szZipName: string) of object;
  TZSCtrlZNRestoreBuildZip = procedure(Sender: TObject; const szZipName: string) of object;
  TZSCtrlZNRestoreZipDone = procedure(Sender: TObject; lTempZipSize: Integer) of object;
  TZSCtrlZNBackupBuildZip = procedure(Sender: TObject; const szZipName: string) of object;
  TZSCtrlZNBackupZipDone = procedure(Sender: TObject; lTempZipSize: Integer) of object;
  TZSCtrlZNMakeEXEStep2 = procedure(Sender: TObject; iRateDone: Smallint) of object;
  TZSCtrlZNZipping = procedure(Sender: TObject; const szCurrentFile: string; iProcessedKBytes: Smallint) of object;
  TZSCtrlZNZipping2 = procedure(Sender: TObject; const szCurrentFile: string; iRateDone: Smallint) of object;
  TZSCtrlZNFileZipped = procedure(Sender: TObject; const szFileName: string; iCompressionRate: Smallint) of object;
  TZSCtrlZNWriting = procedure(Sender: TObject; const szZipName: string) of object;
  TZSCtrlZNReparing = procedure(Sender: TObject; const szName: string; iRepareStep: Smallint) of object;
  TZSCtrlZNCompute = procedure(Sender: TObject; iFilesInZip: Smallint) of object;
  TZSCtrlZNEncrypt = procedure(Sender: TObject; const szFileName: string; iRateDone: Smallint) of object;
  TZSCtrlZNSplitting = procedure(Sender: TObject; iSizeInKBytes: Smallint; const szPartFileName: string) of object;
  TZSCtrlZNSplitted = procedure(Sender: TObject; iPartNumber: Smallint; lSizeInBytes: Integer) of object;
  TZSCtrlZNDeleting = procedure(Sender: TObject; const szCurrentFile: string) of object;

  TOverwriteOptions  = (owAlways, owNever, owPrompt, owUpdate);
  TLanguageOptions   = (lgFrench, lgEnglish, lgGerman, lgNone);
  TZipModeOptions    = (zmNormal, zmFast, zmSlow, zmStore);
  TUnzipQueryOptions = (umFalse, umTrue, umQuery);
  TUnzipSortOptions  = (zsFullName, zsName, zsDirectory, zsDate, zsSize, zsRate, zsNone);

  TZSCtrl = class(TWinControl)
  private
    FOnZNOpenFile: TZSCtrlZNOpenFile;
    FOnZNExpanding: TZSCtrlZNExpanding;
    FOnZNCloseFile: TZSCtrlZNCloseFile;
    FOnZNTest: TZSCtrlZNTest;
    FOnZNJoining: TZSCtrlZNJoining;
    FOnZNJoined: TZSCtrlZNJoined;
    FOnZNJoinDoneSize: TZSCtrlZNJoinDoneSize;
    FOnZNJoinDoneName: TZSCtrlZNJoinDoneName;
    FOnZNRestoreBuildZip: TZSCtrlZNRestoreBuildZip;
    FOnZNRestoreZipDone: TZSCtrlZNRestoreZipDone;
    FOnZNBackupBuildZip: TZSCtrlZNBackupBuildZip;
    FOnZNBackupZipDone: TZSCtrlZNBackupZipDone;
    FOnZNMakeEXEStep1: TNotifyEvent;
    FOnZNMakeEXEStep2: TZSCtrlZNMakeEXEStep2;
    FOnZNZipping: TZSCtrlZNZipping;
    FOnZNZipping2: TZSCtrlZNZipping2;
    FOnZNFileZipped: TZSCtrlZNFileZipped;
    FOnZNWriting: TZSCtrlZNWriting;
    FOnZNReparing: TZSCtrlZNReparing;
    FOnZNCompute: TZSCtrlZNCompute;
    FOnZNEncrypt: TZSCtrlZNEncrypt;
    FOnZNSplitting: TZSCtrlZNSplitting;
    FOnZNSplitted: TZSCtrlZNSplitted;
    FOnZNDeleting: TZSCtrlZNDeleting;
  protected
    procedure ZNJoining(var Message: TMessage); message ZN_JOINING;
    procedure ZNJoined(var Message: TMessage); message ZN_JOINED;
    procedure ZNJoinDoneSize(var Message: TMessage); message ZN_JOINDONESIZE;
    procedure ZNJoinDoneName(var Message: TMessage); message ZN_JOINDONENAME;
    procedure ZNSplitting(var Message: TMessage); message ZN_SPLITTING;
    procedure ZNSplitted(var Message: TMessage); message ZN_SPLITTED;
    procedure ZNOpenFile(var Message: TMessage); message ZN_OPENFILE;
    procedure ZNExpanding(var Message: TMessage); message ZN_EXPANDING;
    procedure ZNCloseFile(var Message: TMessage); message ZN_CLOSEFILE;
    procedure ZNZipping(var Message: TMessage); message ZN_ZIPPING;
    procedure ZNZipping2(var Message: TMessage); message ZN_ZIPPING2;
    procedure ZNFileZipped(var Message: TMessage); message ZN_FILEZIPPED;
    procedure ZNWriting(var Message: TMessage); message ZN_WRITING;
    procedure ZNDeleting(var Message: TMessage); message ZN_DELETING;
    procedure ZNReparing(var Message: TMessage); message ZN_REPARING;
    procedure ZNEncrypt(var Message: TMessage); message ZN_ENCRYPT;
    procedure ZNTest(var Message: TMessage); message ZN_TEST;
    procedure ZNBackupBuildZip(var Message: TMessage); message ZN_BACKUP_BUILDZIP;
    procedure ZNBackupZipDone(var Message: TMessage); message ZN_BACKUP_ZIPDONE;
    procedure ZNRestoreBuildZip(var Message: TMessage); message ZN_RESTORE_BUILDZIP;
    procedure ZNRestoreZipDone(var Message: TMessage); message ZN_RESTORE_ZIPDONE;
    procedure ZNMakeEXEStep1(var Message: TMessage); message ZN_MAKEEXE_STEP1;
    procedure ZNMakeEXEStep2(var Message: TMessage); message ZN_MAKEEXE_STEP2;
  public
    function IsFileNameInFilter(const szName, szPattern: string): WordBool;
    function GetZipBufferSize: Smallint;
    function GetUnzipBufferSize: Smallint;
    procedure ZipCancel(bCancel: WordBool);
    function ZipGetReplaceFlag: Smallint;
    function Split(const szZipName, szDestDir: string; lFirstBlockSizeInBytes, lNextBlockSizeInBytes: Integer;
       bBackGroundProcessing: WordBool; const szTitle, szMsg: string): Smallint;
    function SetGlobalComment(const szZipName, szComment: string; bBackGroundProcessing: WordBool): Smallint;
    function SetLocalComment(const szZipName, szMask, szComment: string; bBackGroundProcessing: WordBool): Smallint;
    function Repare(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function MakeEXEFile(const szZipName, szEXEName, szProgramToLaunch, szEXETitle, szELFFile: string;
         iOverwriteMode: Smallint; bAskDirectory, bWin32Target, bBackGroundProcessing: WordBool): Smallint;
    function DeleteWithMask(const szZipName, szMask: string; bBackGroundProcessing: WordBool): Smallint;
    function CreateBlankZIPFile(const szZipName: string; bOpenDialog: WordBool): WordBool;
    function GetZIPITEMIsDir(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsEncrypted(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsArchive(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsHidden(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsSystem(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsReadOnly(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMIsAnnotated(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
    function GetZIPITEMMethod(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMDay(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMMonth(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMYear(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMHour(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMMin(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMRate(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMIconIndex(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
    function GetZIPITEMOriginalSize(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Integer;
    function GetZIPITEMCrc(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Double;
    function UnzipGetReplaceFlag: Smallint;
    function BuildZIPITEMImageList: WordBool;
    function DestroyZIPITEMImageList: WordBool;
    procedure DestroyZIPITEMLParam(hListZIPITEM: Integer);
    function GetZIPINFOMadeUnder(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetZIPINFOVersionMinor(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetGlobalComment(const szZipName: string; iMaxLength: Smallint; bBackGroundProcessing: WordBool): string;
    function GetGlobalCommentSize(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetLocalComment(const szZipName, szMask: string; iMaxLength: Smallint; bBackGroundProcessing: WordBool): string;
    function GetCount(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetTotalSize(const szZipName: string; bOriginalSize, bBackGroundProcessing: WordBool): Double;
    function IsFileInTheZIPFile(const szZipName, szMask: string; bBackGroundProcessing: WordBool): WordBool;
    function SortZIPITEMList(hListZIPITEM: Integer; iSortMode: Smallint; bBackGroundProcessing: WordBool): WordBool;
    function Join(const szPartFileName, szDestDirectory, szTitle, szMsg: string; bBackGroundProcessing: WordBool): Smallint;
    function Restore(const szSourceDirectory, szDestinationDirectory: string; iOverwriteMode: Smallint; bDisplayDialog,
       bEraseReadOnlyFiles: WordBool; const szTitle, szMsg: string; bBackGroundProcessing: WordBool): Smallint;
    procedure UnzipCancel(bCancel: WordBool);
    function UnzipToFile(const szZipName, szMask, szDestFile: string; bEraseReadOnlyFiles: WordBool; const szPassword: string;
       bAskPassword, bAckGroundProcessing: WordBool): Smallint;
    function IsZIPFileQuick(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function IsZIPFileSlow(const szZipName, szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): Smallint;
    function Backup(const szMask, szDestDrive: string; bRecurse, bUseArchiveFlag, bRemoveArchiveFlag,
       bForceSingleBackup: WordBool; const szTitle, szMsg: string; iCompressionMode: Smallint;
       bBackGroundProcessing: WordBool): Smallint;
    function View(const szZipName, szMask: string; bUseTextEditor, bRunEXE: WordBool; const szPrivateTempDir,
       szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): WordBool;
    procedure SetStringResource(iStringID: Smallint; const szValue: string);
    function IsDisketteReady(const szDiskette: string): WordBool;
    function IsDriveWriteable(const szDrive: string): WordBool;
    function IsWriteable(const szDestFile: string; lSizeInBytes: Integer): WordBool;
    procedure SetHelpFile(const szHelpFile: string);
    procedure SetIniFile(const szFile: string);
    procedure SetPasswordMode(bShow, bSave: WordBool);
    procedure DeletePasswords;
    function GetZIPINFOVersionMajor(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetZIPINFODiskID(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
    function GetLocalCommentSize(const szZipName, szMask: string; bBackGroundProcessing: WordBool): Smallint;
    function GetNewZIPName: string;
    function UnzipFiles(const szZipName, szMask, szDestDirectory: string; bRebuildDir, bEraseReadOnlyFiles: WordBool;
       iOverwriteMode: Smallint; const szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): Smallint;
    function ZipFiles(const szZipName, szMask: string; bRecurseSubDirs: WordBool; iStorePathMethod, iOverwriteMode,
       iCompressionMode: Smallint; bUseArchiveFlag, bRemoveArchiveFlag: WordBool; const szPassword: string;
       bBackGroundProcessing: WordBool): Smallint;
    function BuildZIPITEMList(const szZipName: string; hListZIPITEM: Integer; bListCtrlMode: WordBool;
       const szPrivateTempDirectory: string; bWindowsIcons: WordBool; iSortMode: Smallint;
       bBackGroundProcessing: WordBool): Smallint;
    function DeleteWithSelection(const szZipName: string; hListZIPITEM, hListSelected: Integer; bListIsListCtrl,
       bBackGroundProcessing: WordBool): Smallint;
    function GetZIPITEMName(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): string;
    function GetZIPITEMDir(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): string;
    function GetZIPITEMHImageList(bBigIcons: WordBool): Integer;
    function DeleteTempDirectories: WordBool;
    function SetListViewImageList(hListView: Integer): WordBool;
    function Initialize(lSerialNumber: Integer; const szName, szPassword: string; ParentWnd : Integer): WordBool;
{    procedure About;}
  published
    property OnZNOpenFile: TZSCtrlZNOpenFile read FOnZNOpenFile write FOnZNOpenFile;
    property OnZNExpanding: TZSCtrlZNExpanding read FOnZNExpanding write FOnZNExpanding;
    property OnZNCloseFile: TZSCtrlZNCloseFile read FOnZNCloseFile write FOnZNCloseFile;
    property OnZNTest: TZSCtrlZNTest read FOnZNTest write FOnZNTest;
    property OnZNJoining: TZSCtrlZNJoining read FOnZNJoining write FOnZNJoining;
    property OnZNJoined: TZSCtrlZNJoined read FOnZNJoined write FOnZNJoined;
    property OnZNJoinDoneSize: TZSCtrlZNJoinDoneSize read FOnZNJoinDoneSize write FOnZNJoinDoneSize;
    property OnZNJoinDoneName: TZSCtrlZNJoinDoneName read FOnZNJoinDoneName write FOnZNJoinDoneName;
    property OnZNRestoreBuildZip: TZSCtrlZNRestoreBuildZip read FOnZNRestoreBuildZip write FOnZNRestoreBuildZip;
    property OnZNRestoreZipDone: TZSCtrlZNRestoreZipDone read FOnZNRestoreZipDone write FOnZNRestoreZipDone;
    property OnZNBackupBuildZip: TZSCtrlZNBackupBuildZip read FOnZNBackupBuildZip write FOnZNBackupBuildZip;
    property OnZNBackupZipDone: TZSCtrlZNBackupZipDone read FOnZNBackupZipDone write FOnZNBackupZipDone;
    property OnZNMakeEXEStep1: TNotifyEvent read FOnZNMakeEXEStep1 write FOnZNMakeEXEStep1;
    property OnZNMakeEXEStep2: TZSCtrlZNMakeEXEStep2 read FOnZNMakeEXEStep2 write FOnZNMakeEXEStep2;
    property OnZNZipping: TZSCtrlZNZipping read FOnZNZipping write FOnZNZipping;
    property OnZNZipping2: TZSCtrlZNZipping2 read FOnZNZipping2 write FOnZNZipping2;
    property OnZNFileZipped: TZSCtrlZNFileZipped read FOnZNFileZipped write FOnZNFileZipped;
    property OnZNWriting: TZSCtrlZNWriting read FOnZNWriting write FOnZNWriting;
    property OnZNReparing: TZSCtrlZNReparing read FOnZNReparing write FOnZNReparing;
    property OnZNCompute: TZSCtrlZNCompute read FOnZNCompute write FOnZNCompute;
    property OnZNEncrypt: TZSCtrlZNEncrypt read FOnZNEncrypt write FOnZNEncrypt;
    property OnZNSplitting: TZSCtrlZNSplitting read FOnZNSplitting write FOnZNSplitting;
    property OnZNSplitted: TZSCtrlZNSplitted read FOnZNSplitted write FOnZNSplitted;
    property OnZNDeleting: TZSCtrlZNDeleting read FOnZNDeleting write FOnZNDeleting;
  end;

procedure Register;

implementation

function TZSCtrl.IsFileNameInFilter(const szName, szPattern: string): WordBool;
begin
  Result := ZSIsFileNameInFilter(szName, szPattern);
end;

function TZSCtrl.GetZipBufferSize: Smallint;
begin
  Result := ZSGetZipBufferSize;
end;

function TZSCtrl.GetUnzipBufferSize: Smallint;
begin
  Result := ZSGetUnzipBufferSize;
end;

procedure TZSCtrl.ZipCancel(bCancel: WordBool);
begin
  ZSZipCancel(bCancel);
end;

function TZSCtrl.ZipGetReplaceFlag: Smallint;
begin
  Result := ZSZipGetReplaceFlag;
end;

function TZSCtrl.Split(const szZipName, szDestDir: string; lFirstBlockSizeInBytes, lNextBlockSizeInBytes: Integer;
   bBackGroundProcessing: WordBool; const szTitle, szMsg: string): Smallint;
begin
  Result := ZSSplit(szZipName, szDestDir, lFirstBlockSizeInBytes, lNextBlockSizeInBytes, bBackgroundProcessing, szTitle,
    szMsg);
end;

function TZSCtrl.SetGlobalComment(const szZipName, szComment: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSSetGlobalComment(szZipName, szComment, bBackGroundProcessing);
end;

function TZSCtrl.SetLocalComment(const szZipName, szMask, szComment: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSSetLocalComment(szZipName, szMask, szComment, bBackGroundProcessing);
end;

function TZSCtrl.Repare(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSRepare(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.MakeEXEFile(const szZipName, szEXEName, szProgramToLaunch, szEXETitle, szELFFile: string;
  iOverwriteMode: Smallint; bAskDirectory, bWin32Target, bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSMakeEXEFile(szZipName, szEXEName, szProgramToLaunch, szEXETitle, szELFFile, iOverwriteMode,
     bAskDirectory, bWin32Target, bBackGroundProcessing);
end;

function TZSCtrl.DeleteWithMask(const szZipName, szMask: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSDeleteWithMask(szZipName, szMask, bBackGroundProcessing);
end;

function TZSCtrl.CreateBlankZIPFile(const szZipName: string; bOpenDialog: WordBool): WordBool;
begin
  Result := ZSCreateBlankZIPFile(szZipName, bOpenDialog);
end;

function TZSCtrl.GetZIPITEMIsDir(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bIsDir;
end;

function TZSCtrl.GetZIPITEMIsEncrypted(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bIsEncrypt;
end;

function TZSCtrl.GetZIPITEMIsArchive(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bArchive;
end;

function TZSCtrl.GetZIPITEMIsHidden(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bHidden;
end;

function TZSCtrl.GetZIPITEMIsSystem(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bSystem;
end;

function TZSCtrl.GetZIPITEMIsReadOnly(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bRO;
end;

function TZSCtrl.GetZIPITEMIsAnnotated(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): WordBool;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.bComment;
end;

function TZSCtrl.GetZIPITEMMethod(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iMethod;
end;

function TZSCtrl.GetZIPITEMDay(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iDay;
end;

function TZSCtrl.GetZIPITEMMonth(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iMonth;
end;

function TZSCtrl.GetZIPITEMYear(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iYear;
end;

function TZSCtrl.GetZIPITEMHour(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iHour;
end;

function TZSCtrl.GetZIPITEMMin(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iMin;
end;

function TZSCtrl.GetZIPITEMRate(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iRate;
end;

function TZSCtrl.GetZIPITEMIconIndex(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Smallint;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.iIconIndex;
end;

function TZSCtrl.GetZIPITEMOriginalSize(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Integer;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.lOrigSize;
end;

function TZSCtrl.GetZIPITEMCrc(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): Double;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.ulCrc32;
end;

function TZSCtrl.UnzipGetReplaceFlag: Smallint;
begin
  Result := ZSUnzipGetReplaceFlag;
end;

function TZSCtrl.BuildZIPITEMImageList: WordBool;
begin
  Result := ZSBuildZIPITEMImageList;
end;

function TZSCtrl.DestroyZIPITEMImageList: WordBool;
begin
  Result := ZSDestroyZIPITEMImageList;
end;

procedure TZSCtrl.DestroyZIPITEMLParam(hListZIPITEM: Integer);
begin
  ZSDestroyZIPITEMLParam(hListZIPITEM);
end;

function TZSCtrl.GetZIPINFOMadeUnder(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetZIPINFOMadeUnder(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetZIPINFOVersionMinor(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetZIPINFOVersionMinor(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetGlobalComment(const szZipName: string; iMaxLength: Smallint; bBackGroundProcessing: WordBool): string;
var
  tStr : string;
begin
  ZSGetGlobalComment(szZipName, iMaxLength, bBackGroundProcessing, tStr);
  Result := tStr;
end;

function TZSCtrl.GetGlobalCommentSize(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetGlobalCommentSize(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetLocalComment(const szZipName, szMask: string; iMaxLength: Smallint;
  bBackGroundProcessing: WordBool): string;
var
  tStr : string;
begin
  ZSGetLocalComment(szZipName, szMask, iMaxLength, bBackGroundProcessing, tStr);
  Result := tStr;
end;

function TZSCtrl.GetCount(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetCount(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetTotalSize(const szZipName: string; bOriginalSize, bBackGroundProcessing: WordBool): Double;
begin
  Result := ZSGetTotalSize(szZipName, bOriginalSize, bBackGroundProcessing);
end;

function TZSCtrl.IsFileInTheZIPFile(const szZipName, szMask: string; bBackGroundProcessing: WordBool): WordBool;
begin
  Result := ZSIsFileInTheZIPFile(szZipName, szMask, bBackGroundProcessing);
end;

function TZSCtrl.SortZIPITEMList(hListZIPITEM: Integer; iSortMode: Smallint; bBackGroundProcessing: WordBool): WordBool;
begin
  Result := ZSSortZIPITEMList(hListZIPITEM, iSortMode, bBackGroundProcessing);
end;

function TZSCtrl.Join(const szPartFileName, szDestDirectory, szTitle, szMsg: string;
  bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSJoin(szPartFileName, szDestDirectory, szTitle, szMsg, bBackGroundProcessing);
end;

function TZSCtrl.Restore(const szSourceDirectory, szDestinationDirectory: string; iOverwriteMode: Smallint; bDisplayDialog,
   bEraseReadOnlyFiles: WordBool; const szTitle, szMsg: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSRestore(szSourceDirectory, szDestinationDirectory, iOverwriteMode, bDisplayDialog, bEraseReadOnlyFiles,
     szTitle, szMsg, bBackGroundProcessing);
end;

procedure TZSCtrl.UnzipCancel(bCancel: WordBool);
begin
  ZSUnzipCancel(bCancel);
end;

function TZSCtrl.UnzipToFile(const szZipName, szMask, szDestFile: string; bEraseReadOnlyFiles: WordBool;
  const szPassword: string; bAskPassword, bAckGroundProcessing: WordBool): Smallint;
begin
  Result := ZSUnzipToFile(szZipName, szMask, szDestFile, bEraseReadOnlyFiles, szPassword, bAskPassword, bAckGroundProcessing);
end;

function TZSCtrl.IsZIPFileQuick(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSIsZIPFileQuick(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.IsZIPFileSlow(const szZipName, szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSIsZIPFileSlow(szZipName, szPassword, bAskPassword, bBackGroundProcessing);
end;

function TZSCtrl.Backup(const szMask, szDestDrive: string; bRecurse, bUseArchiveFlag, bRemoveArchiveFlag,
  bForceSingleBackup: WordBool; const szTitle, szMsg: string; iCompressionMode: Smallint;
  bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSBackup(szMask, szDestDrive, bRecurse, bUseArchiveFlag, bRemoveArchiveFlag, bForceSingleBackup,
     szTitle, szMsg, iCompressionMode, bBackGroundProcessing);
end;

function TZSCtrl.View(const szZipName, szMask: string; bUseTextEditor, bRunEXE: WordBool; const szPrivateTempDir,
   szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): WordBool;
begin
  Result := ZSView(szZipName, szMask, bUseTextEditor, bRunEXE, szPrivateTempDir, szPassword, bAskPassword,
     bBackGroundProcessing);
end;

procedure TZSCtrl.SetStringResource(iStringID: Smallint; const szValue: string);
begin
  ZSSetStringResource(iStringID, szValue);
end;

function TZSCtrl.IsDisketteReady(const szDiskette: string): WordBool;
begin
  Result := ZSIsDisketteReady(szDiskette);
end;

function TZSCtrl.IsDriveWriteable(const szDrive: string): WordBool;
begin
  Result := ZSIsDriveWriteable(szDrive);
end;

function TZSCtrl.IsWriteable(const szDestFile: string; lSizeInBytes: Integer): WordBool;
begin
  Result := ZSIsWriteable(szDestFile, lSizeInBytes);
end;

procedure TZSCtrl.SetHelpFile(const szHelpFile: string);
begin
  ZSSetHelpFile(szHelpFile);
end;

procedure TZSCtrl.SetIniFile(const szFile: string);
begin
  ZSSetIniFile(szFile);
end;

procedure TZSCtrl.SetPasswordMode(bShow, bSave: WordBool);
begin
  ZSSetPasswordMode(bShow, bSave);
end;

procedure TZSCtrl.DeletePasswords;
begin
  ZSDeletePasswords;
end;

function TZSCtrl.GetZIPINFOVersionMajor(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetZIPINFOVersionMajor(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetZIPINFODiskID(const szZipName: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetZIPINFODiskID(szZipName, bBackGroundProcessing);
end;

function TZSCtrl.GetLocalCommentSize(const szZipName, szMask: string; bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSGetLocalCommentSize(szZipName, szMask, bBackGroundProcessing);
end;

function TZSCtrl.GetNewZIPName: string;
var
  tStr : string;
begin
  ZSGetNewZIPName(tStr);
  Result := tStr;
end;

function TZSCtrl.UnzipFiles(const szZipName, szMask, szDestDirectory: string; bRebuildDir, bEraseReadOnlyFiles: WordBool;
  iOverwriteMode: Smallint; const szPassword: string; bAskPassword, bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSUnzipFiles(szZipName, szMask, szDestDirectory, bRebuildDir, bEraseReadOnlyFiles, iOverwriteMode, szPassword,
    bAskPassword, bBackGroundProcessing);
end;

function TZSCtrl.ZipFiles(const szZipName, szMask: string; bRecurseSubDirs: WordBool; iStorePathMethod, iOverwriteMode,
   iCompressionMode: Smallint; bUseArchiveFlag, bRemoveArchiveFlag: WordBool; const szPassword: string;
   bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSZipFiles(szZipName, szMask, bRecurseSubDirs, iStorePathMethod, iOverwriteMode, iCompressionMode,
     bUseArchiveFlag, bRemoveArchiveFlag, szPassword, bBackGroundProcessing);
end;

function TZSCtrl.BuildZIPITEMList(const szZipName: string; hListZIPITEM: Integer; bListCtrlMode: WordBool;
   const szPrivateTempDirectory: string; bWindowsIcons: WordBool; iSortMode: Smallint;
   bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSBuildZIPITEMList(szZipName, hListZIPITEM, bListCtrlMode, szPrivateTempDirectory, bWindowsIcons,
     iSortMode, bBackGroundProcessing);
end;

function TZSCtrl.DeleteWithSelection(const szZipName: string; hListZIPITEM, hListSelected: Integer;
   bListIsListCtrl, bBackGroundProcessing: WordBool): Smallint;
begin
  Result := ZSDeleteWithSelection(szZipName, hListZIPITEM, hListSelected, bListIsListCtrl, bBackGroundProcessing);
end;

function TZSCtrl.GetZIPITEMName(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): string;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
  Result := lZipItem.szName;
end;

function TZSCtrl.GetZIPITEMDir(hListZIPITEM: Integer; iIndex: Smallint; bListCtrlMode: WordBool): string;
var
  lZipItem : ZipItem;
  pItem : PZipItem;
begin
  pItem := @lZipItem;
  ZSGetZIPITEM( hListZIPITEM, iIndex, bListCtrlMode, pItem);
    Result := StrPas(lZipItem.szDir);
end;

function TZSCtrl.GetZIPITEMHImageList(bBigIcons: WordBool): Integer;
begin
  Result := ZSGetZIPITEMHImageList(bBigIcons);
end;

function TZSCtrl.DeleteTempDirectories: WordBool;
begin
  Result := ZSDeleteTempDirectories;
end;

function TZSCtrl.SetListViewImageList(hListView: Integer): WordBool;
begin
  Result := ZSSetListViewImageList(hListView);
end;

function TZSCtrl.Initialize(lSerialNumber: Integer; const szName, szPassword: string; ParentWnd : Integer): WordBool;
begin
  Result := ZSInitialize(lSerialNumber, szName, szPassword, ParentWnd);
end;

procedure TZSCtrl.ZNJoining(var Message: TMessage);
var
  iSizeInKBytes : smallint;
  szPartFileName : string;
begin
  IF ( Assigned(FOnZNJoining) ) THEN BEGIN
    iSizeInKBytes := Smallint(Message.WParam);
    szPartFileName := StrPas(PChar(Message.LParam));
    FOnZNJoining(Self, iSizeInKBytes, szPartFileName);
  END;
end;

procedure TZSCtrl.ZNJoined(var Message : TMessage);
var
  iPartFileNumber : Smallint;
  lTotalSize : Integer;
begin
  IF ( Assigned(FOnZNJoined) ) THEN BEGIN
    iPartFileNumber := SmallInt(Message.WParam);
    lTotalSize := Integer(Message.LParam);
    FOnZNJoined(Self, iPartFileNumber, lTotalSize);
  END;
end;

procedure TZSCtrl.ZNJoinDoneSize(var Message: TMessage);
var
  lTotalSize : Integer;
begin
  IF ( Assigned(FOnZNJoinDoneSize) ) THEN BEGIN
    lTotalSize := Integer(Message.LParam);
    FOnZNJoinDoneSize(Self, lTotalSize);
  END;
end;

procedure TZSCtrl.ZNJoinDoneName(var Message: TMessage);
var
  szZipName : string;
begin
  IF ( Assigned(FOnZNJoinDoneName) ) THEN BEGIN
    szZipName := StrPas(PChar(Message.LParam));
    FOnZNJoinDoneName(Self, szZipName);
  END;
end;

procedure TZSCtrl.ZNSplitting(var Message: TMessage);
var
  iSizeInKBytes : Smallint;
  szPartFileName : string;
begin
  IF ( Assigned(FOnZNSplitting) ) THEN BEGIN
    iSizeInKBytes := SmallInt(Message.WParam);
    szPartFileName := StrPas(PChar(Message.LParam));
    FOnZNSplitting(Self, iSizeInKBytes, szPartFileName);
  END;
end;

procedure TZSCtrl.ZNSplitted(var Message: TMessage);
var
  iPartNumber : Smallint;
  lSizeInBytes : Integer;
begin
  IF ( Assigned(FOnZNSplitted) ) THEN BEGIN
    iPartNumber := SmallInt(Message.WParam);
    lSizeInBytes := Integer(Message.LParam);
    FOnZNSplitted(Self, iPartNumber, lSizeInBytes);
  END;
end;

procedure TZSCtrl.ZNOpenFile(var Message: TMessage);
var
  szName : string;
begin
  IF ( Assigned(FOnZNOpenFile) ) THEN BEGIN
    szName := StrPas(PChar(Message.LParam));
    FOnZNOpenFile(Self, szName);
  END;
end;

procedure TZSCtrl.ZNExpanding(var Message: TMessage);
var
  szName : string;
  iRateDone : Smallint;
begin
  IF ( Assigned(FOnZNExpanding) ) THEN BEGIN
    szName := StrPas(PChar(Message.LParam));
    iRateDone := SmallInt(Message.WParam);
    FOnZNExpanding(Self, szName, iRateDone);
  END;
end;

procedure TZSCtrl.ZNCloseFile(var Message: TMessage);
var
  szName : string;
  bNoError : WordBool;
begin
  IF ( Assigned(FOnZNCloseFile) ) THEN BEGIN
    szName := StrPas(PChar(Message.LParam));
    bNoError := WordBool(Message.WParam);
    FOnZNCloseFile(Self, szName, bNoError);
  END;
end;

procedure TZSCtrl.ZNZipping(var Message: TMessage);
var
  szCurrentFile : string;
  iProcessedKBytes : Smallint;
begin
  IF ( Assigned(FOnZNZipping) ) THEN BEGIN
    szCurrentFile := StrPas(PChar(Message.LParam));
    iProcessedKBytes := Smallint(Message.WParam);
    FOnZNZipping(Self, szCurrentFile, iProcessedKBytes);
  END;
end;

procedure TZSCtrl.ZNZipping2(var Message: TMessage);
var
  szCurrentFile : string;
  iRateDone : smallint;
begin
  IF ( Assigned(FOnZNZipping2) ) THEN BEGIN
    szCurrentFile := StrPas(PChar(Message.LParam));
    iRateDone := SmallInt(Message.WParam);
    FOnZNZipping2(Self, szCurrentFile, iRateDone);
  END;
end;

procedure TZSCtrl.ZNFileZipped(var Message: TMessage);
var
  szFileName : string;
  iCompressionRate : smallint;
begin
  IF ( Assigned(FOnZNFileZipped) ) THEN BEGIN
    szFileName := StrPas(PChar(Message.LParam));
    iCompressionRate := SmallInt(Message.WParam);
    FOnZNFileZipped(Self, szFileName, iCompressionRate);
  END;
end;

procedure TZSCtrl.ZNWriting(var Message: TMessage);
var
  szZipName : string;
begin
  IF ( Assigned(FOnZNWriting) ) THEN BEGIN
    szZipName := StrPas(PChar(Message.LParam));
    FOnZNWriting(Self, szZipName);
  END;
end;

procedure TZSCtrl.ZNDeleting(var Message: TMessage);
var
  szCurrentFile : string;
begin
  IF ( Assigned(FOnZNDeleting) ) THEN BEGIN
    szCurrentFile := StrPas(PChar(Message.LParam));
    FOnZNDeleting(Self, szCurrentFile);
  END;
end;

procedure TZSCtrl.ZNReparing(var Message: TMessage);
var
  szFileName : string;
  iRepareStep : SmallInt;
begin
  IF ( Assigned(FOnZNReparing) ) THEN BEGIN
    szFileName := StrPas(PChar(Message.LParam));
    iRepareStep := SmallInt(Message.WParam);
    FOnZNReparing(Self, szFileName, iRepareStep);
  END;
end;

procedure TZSCtrl.ZNEncrypt(var Message: TMessage);
var
  szFileName : string;
  iRateDone : smallint;
begin
  IF ( Assigned(FOnZNEncrypt) ) THEN BEGIN
    szFileName := StrPas(PChar(Message.LParam));
    iRateDone := SmallInt(Message.WParam);
    FOnZNEncrypt(Self, szFileName, iRateDone);
  END;
end;

procedure TZSCtrl.ZNTest(var Message: TMessage);
var
  szName : string;
  bNoError : WordBool;
begin
  IF ( Assigned(FOnZNTest) ) THEN BEGIN
    szName := StrPas(PChar(Message.LParam));
    bNoError := WordBool(Message.WParam);
    FOnZNTest(Self, szName, bNoError);
  END;
end;

procedure TZSCtrl.ZNBackupBuildZip(var Message: TMessage);
var
  szZipName : string;
begin
  IF ( Assigned(FOnZNBackupBuildZip) ) THEN BEGIN
    szZipName := StrPas(PChar(Message.LParam));
    FOnZNBackupBuildZip(Self, szZipName);
  END;
end;

procedure TZSCtrl.ZNBackupZipDone(var Message: TMessage);
var
  lTempZipSize : Integer;
begin
  IF ( Assigned(FOnZNBackupZipDone) ) THEN BEGIN
    lTempZipSize := Integer(Message.LParam);
    FOnZNBackupZipDone(Self, lTempZipSize);
  END;
end;

procedure TZSCtrl.ZNRestoreBuildZip(var Message: TMessage);
var
  szZipName : string;
begin
  IF ( Assigned(FOnZNRestoreBuildZip) ) THEN BEGIN
    szZipName := StrPas(PChar(Message.LParam));
    FOnZNRestoreBuildZip(Self, szZipName);
  END;
end;

procedure TZSCtrl.ZNRestoreZipDone(var Message: TMessage);
var
  Size : Integer;
begin
  IF ( Assigned(FOnZNRestoreZipDone) ) THEN BEGIN
    Size := Integer(Message.LParam);
    FOnZNRestoreZipDone(Self, Size);
  END;
end;

procedure TZSCtrl.ZNMakeEXEStep1(var Message: TMessage);
begin
  IF ( Assigned(FOnZNMakeEXEStep1) ) THEN BEGIN
    FOnZNMakeEXEStep1(Self);
  END;
end;

procedure TZSCtrl.ZNMakeEXEStep2(var Message: TMessage);
var
  Compressed : Smallint;
begin
  IF ( Assigned(FOnZNMakeEXEStep2)) THEN BEGIN
    Compressed := Smallint(Message.WParam);
    FOnZNMakeEXEStep2(Self, Compressed);
  END;
end;

procedure Register;
begin
  RegisterComponents('Hexanet', [TZSCtrl]);
end;

end.
