//*********************************************************************
//
//  CRSH.C - Example usage of Winsock RCMD.DLL
//
//
//  Winsock RCMD.DLL Copyright (c) 1994 Denicomp Systems
//
// 
//  Usage:
//
//     CRSH host user command
//
//  Where:
//     host - host name of the remote host
//     user - user name to use at the remote host when executing the command
//     command - the command to execute at the remote host
//
//
//  This program will execute the "command" specified on the "host" specified
//  as user "user".  The output will be displayed in a window.  When the
//  command is complete, it will wait for you to press Return.
//
//  The command must be a non-interactive command; that is, it cannot require
//  any keyboard input.
//
//  The directory containing Winsock RCMD.DLL must be in your PATH.
//
//
//*********************************************************************

#include <windows.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "winio.h"
#include "rcmd.h"

char rhost[16];
char ruser[16];
char cmd[128];
char errmsg[128];

void rsh(argc,argv)
	int argc;
	char *argv[];
{
	int a, hRCmd;
	char c;

	
	strcpy(rhost,argv[1]);

	strcpy(ruser,argv[2]);

	cmd[0] = '\0';
	for(a = 3; a < argc; a++)
	{
	  strcat(cmd,argv[a]);
	  strcat(cmd," ");
	}

	hRCmd = WinsockRCmd(rhost,514,ruser,ruser,cmd,errmsg,sizeof(errmsg));

	if (hRCmd < 0)
	  winio_warn(0,errmsg);
	else
	{
	  while(RCmdRead(hRCmd,&c,1) > 0)
	   (void) putchar(c);

	  printf("Press Return: ");
	  getchar();
	}

	RCmdClose(hRCmd);

}

#define argc __argc
#define argv __argv

extern int __argc;
extern char **__argv;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	
	winio_settitle("Winsock RCMD DLL Sample");
	nCmdShow = SW_SHOWNORMAL;

	if (! winio_init(hInstance, hPrevInstance, nCmdShow, 16384))
	  return 1;
	
	rsh(argc, argv);

	winio_close();

	return TRUE;
}

