/* **************************************************************
 *
 *
 *      C W   :   B o u c l e    P r i n c i p a l e
 * 
 *
 * **************************************************************** */

#define  STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* messages particuliers */
#define  CW_BEGIN    (WM_USER + 41)
#define  CW_LOGGED   (WM_USER + 48)
#define  CW_END      (WM_USER + 52)
#define  CW_DIR      (WM_USER + 51)
#define  CW_FIN      (WM_USER + 65)
#define  CW_VERBOSE  (WM_USER+112)

#include "wftp.h"

/* Quelques variables globales */

int nHorzSiz, nVertSiz;
int  nVertPos, nHorzPos;           // scroll pos for debug window
int  nHorzMax, nCurMsg;
int  nMaxMsg;
static int nHorzTab = 20;


char            szApplication[20]; /* name of application      */
HINSTANCE       hInst;             /* hInstance of application */
HWND            hwnd;              /* hWnd of main window      */
static unsigned Timer;             /* frquence de reveil      */
static unsigned TimeRest;          /* Gestion Timer > minute   */
BOOL            FirstEmission;

// function prototypes
int PASCAL FAR  DLL_Work (HWND, int);
int PASCAL FAR  DLL_FT   (HWND, BOOL, int);
int PASCAL FAR  DLL_End (void);
int PASCAL FAR  DLL_Dir (HWND hParent, BOOL First, UINT Msg);

void SetXmitBytes (LONG lBytes);
void DeleteXferWindow (void);
int nCwRegisterClasses(void);
int nCwUnregisterClasses(void);


int PASCAL FAR InitWindow (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                           LPSTR lpszCmdLine, int cmdShow);
int Ecris(const char *szFormat,...);
void DoPrintf (char * szFormat, ...);
void DoPaint (HWND hwnd);
void DoAddLine (LPSTR szLine);                           
void ReleaseDisplayMem(void);



#define  WM_FTPDIR  (WM_USER+2)
#define  SHORT_DIR  FALSE

struct LL_File
{
  LPSTR          *szFile;
  struct LL_File *Next;
} *pFirstFile=NULL;





//*******************************************************************
LRESULT CALLBACK   MainWndProc (HWND hWnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
static      IsMinimized = FALSE;
static      nClose=0;
static      bFileTransfered=FALSE;
static      bAborted=FALSE;
static struct S_ProcData *pProcData;
static struct LL_File *p, *pTmp;
static char szBuf[1024];
LPSTR p1, p2;

    switch (message)
    {
       case WM_CREATE :
          /* Gestion de la fentre debug */
          SetScrollPos (hWnd, SB_HORZ, 0, TRUE);
          SetScrollPos (hWnd, SB_VERT, 0, TRUE);
          SetScrollRange (hWnd, SB_HORZ, 0, 1, TRUE);
          SetScrollRange (hWnd, SB_VERT, 0, 1, TRUE);
          nVertPos = nHorzPos = nHorzMax = nCurMsg = 0;
          nMaxMsg = 80;
   
          nCwRegisterClasses();
          /* On attend que la fenetre apparaisse et on debute les inits */
          PostMessage (hWnd, CW_BEGIN, 0, 0);
          break;

       case WM_SIZE :
          IsMinimized = wParam==SIZE_MINIMIZED;
          break;    

       case WM_VSCROLL:
          switch(wParam)
           {
            case SB_LINEDOWN     : if (nVertPos<(nCurMsg-(nVertSiz>>1))) nVertPos++;  break;
            case SB_LINEUP       : if (nVertPos>0) --nVertPos; break;
            case SB_THUMBPOSITION: nVertPos = min ((WORD) (nCurMsg-(nVertSiz>>1)), LOWORD (lParam)); break;
            case SB_PAGEUP       : nVertPos = (nVertPos>10) ? (nVertPos-10) : 0; break;
            case SB_PAGEDOWN     : nVertPos = (nVertPos<(nCurMsg-nVertSiz)) ? (nVertPos+nVertSiz) : nCurMsg-(nVertSiz>>1); break;
            default              : return 0L;
           } /* switch wParam */
          SetScrollPos (hWnd, SB_VERT, nVertPos, TRUE);
          InvalidateRect (hWnd, NULL, TRUE); 
          return 0L;

       case WM_HSCROLL:
          FtpAbort ();
          switch (wParam)
           {
            case SB_LINEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzTab)) ? (nHorzPos+nHorzTab) : nHorzMax; break;
            case SB_LINEUP       : nHorzPos = (nHorzPos>nHorzTab) ? (nHorzPos-nHorzTab) : 0; break;
            case SB_THUMBPOSITION: nHorzPos = min ((WORD) nHorzMax, LOWORD (lParam)); break;
            case SB_PAGEUP       : nHorzPos = (nHorzPos>nHorzSiz) ? (nHorzPos-nHorzSiz) : 0; break;
            case SB_PAGEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzSiz)) ? (nHorzPos+nHorzSiz) : nHorzMax; break;
            default              : return 0L;
           }
          SetScrollPos (hWnd, SB_HORZ, nHorzPos, TRUE);
          InvalidateRect (hWnd, NULL, TRUE); 
          return 0L;

      case WM_PAINT :
          DoPaint (hWnd);
          break;
          
   /* ---------------------------------------------------------- */
   /*              Code  spcifique  aux collecteurs             */
   /* ---------------------------------------------------------- */

      case WM_QUERYENDSESSION :
          FtpLocalClose ();
          DeleteXferWindow ();
          break;

      case CW_VERBOSE :
          DoAddLine ((LPSTR) lParam);
          break;

      case  CW_BEGIN :
            /* Get UINIFile Name */
          Ecris ("--- CW ---");  
          if (FirstEmission) unlink ("traces");
          DLL_Work (hWnd, CW_LOGGED);
          break;

 
      case CW_LOGGED :
          Ecris ("-- LOGIN  -> %d, %d", wParam, (int) lParam);  
          bFileTransfered = FALSE;
          if (lParam == FTPERR_OK)
            {
              memset (szBuf, 0, sizeof szBuf);
//              lParam = FtpHelp (NULL, szBuf, sizeof szBuf);
              p1=szBuf;
              for (;0;)
               {
                 p2 = strchr (p1, '\r');
                 if (p2==NULL) break;
                 *p2 = 0;
                 Ecris ( p1 );
                 p1 = p2+2;
                }
              Ecris (p1);
             DLL_Dir (hWnd, FirstEmission, WM_FTPDIR);
//           DLL_FT (hWnd, FirstEmission, CW_END);
            }
          if (lParam==FTPERR_UNEXPECTEDANSWER)
             Ecris (FtpDataPtr()->ftp.szInBuf);   
          break;


      case WM_FTPDIR :
       if (wParam)
          {
             Ecris ("Reception %d, %d", wParam, lParam);
             for (p=pFirstFile ; p!=NULL ; p=pTmp)
               {
                 Ecris (p->szFile);
                 free (p->szFile);
                 pTmp = p->Next;
                 free (p);
               }
             pFirstFile=NULL;
             Ecris ("---- Transfert Fini ----- %d, %d", wParam, (WORD) lParam);
             Ecris ("Reponse : [%s]", FtpDataPtr ()->ftp.szInBuf);
             DLL_FT (hWnd, FirstEmission, CW_END);
          }
       else
           {
             if (pFirstFile==NULL) p = pFirstFile=calloc (sizeof *pFirstFile, 1);
             else                  p = p->Next   =calloc (sizeof *pFirstFile, 1);
             p->szFile = strdup ((LPSTR) lParam);
           }
       break;          

      case CW_END :
         if (wParam)
           {
            DeleteXferWindow ();
            bFileTransfered = TRUE;
            Ecris ("FTF %d, %ld", wParam, lParam);
            pProcData = FtpDataPtr ();
            if (pProcData!=NULL)  
              {
                 Ecris ("Pointeur %p", pProcData);
                 Ecris ("Buffer |%s|", pProcData->ftp.szInBuf);
              }
           } /* wPram */
          else
           {
             SetXmitBytes (lParam);
           }
          break;

      case  WM_TIMER :
            break;
            
      case CW_FIN :
          Ecris ("CW FIN");
          break;

      case WM_CLOSE :
          Ecris ("Close %d", ++nClose);  
          if (! bFileTransfered) FtpAbort (), bAborted=TRUE;
          else if (nClose==2)
             {
                if (MessageBox (hWnd,
                               "Refaire un transfert ?", 
                               "Test FTP",
                               MB_YESNO) == IDYES)
                  { PostMessage (hWnd, CW_LOGGED, 0, 0);
                    MessageBeep (65535u); 
                    nClose=0;
                    return 0; } 
                Ecris ("---> Closing connection ");
                DLL_End ();
                ReleaseDisplayMem();
                /* Tell windows to destroy our window.*/
                nCwUnregisterClasses();
                PostQuitMessage(0);
                DestroyWindow (hWnd);
             }

          if (hWnd==hwnd  && nClose>=3)
           { 
             /* si l'utilsateur n'attend pas l'excution du ABORT */
             FtpLocalClose ();
             /* This is the end if we were closed by a DestroyWindow call.*/
             ReleaseDisplayMem();
             /* Tell windows to destroy our window.*/
             nCwUnregisterClasses();
             PostQuitMessage(0);
             DestroyWindow (hWnd);
           }
          else
            return 0;
          break;


    default:
          return(DefWindowProc(hWnd, message, wParam, lParam));
    }
return TRUE;
} /* Boucle Windows */




/* ******************************************************************* */
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int cmdShow)
{
MSG   msg;
    // Go init this application, Change default Font
    FirstEmission = (hPrevInstance==NULL);
    
    InitWindow (hInstance, hPrevInstance, lpszCmdLine, cmdShow);
    /* Get and dispatch messages for this applicaton.*/
    while (GetMessage(&msg, NULL, 0, 0))
      {
        TranslateMessage(&msg);
        DispatchMessage(&msg);                  
      }
    UnregisterClass ("DLLCW", hInst);  
    UnregisterClass ("CW", hInst);  
return(msg.wParam);
} /* WinMain */


/* ******************************************************************* */

int PASCAL FAR InitWindow (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                           LPSTR lpszCmdLine, int cmdShow)
{
WNDCLASS wndClass;

    hInst = hInstance;       /* save for use by window procs */
    strcpy (szApplication, "CW");

    if (!hPrevInstance)     /* if no previous instance, this is first */
      {
        /* Get string from resource with application name. */
        /* Define the window class for this application. */
        wndClass.lpszClassName = szApplication;
        wndClass.hInstance     = hInstance;
        wndClass.lpfnWndProc   = MainWndProc;
        wndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndClass.hIcon         = LoadIcon(hInstance, szApplication);
        wndClass.lpszMenuName  = (LPSTR) NULL;
        wndClass.hbrBackground = COLOR_WINDOW+1;
        // style : Redraw window if its vertcal size has been changed
        wndClass.style         = CS_OWNDC | CS_VREDRAW;
        wndClass.cbClsExtra    = 0;
        wndClass.cbWndExtra    = 0;
     // Register the class
        RegisterClass(&wndClass);
      }
    hwnd = CreateWindow(
                    szApplication,     // window class name
                    szApplication,     // window title
                    WS_OVERLAPPEDWINDOW | WS_HSCROLL | WM_VSCROLL | WS_VISIBLE,
                    CW_USEDEFAULT,          // x - same as dialog box
                    CW_USEDEFAULT,          // y
                    250,                     // cx
                    150,                     // cy
                    NULL,                    // no parent for this window
                    NULL,                    // use the class menu
                    hInstance,               // who created this window
                    NULL                     // no parms to pass on
          );
    if (hwnd==NULL)  exit(0);
    UpdateWindow (hwnd);
    ShowWindow (hwnd, cmdShow);

return 0;
}  /* InitWindows */




//*************************************************************************
//*************************************************************************

/* ------------------------------------------------------- */
/*          Affichage d'un texte a l'ecran                 */
/* ------------------------------------------------------- */
/* Attention : Pas de test de debordement                  */


#include <stdarg.h>




int Ecris(const char *szFormat,...)
{
   va_list vaArgs;
   static char szBuf[256];

   va_start(vaArgs,szFormat);
   if (vsprintf (szBuf,szFormat,vaArgs)!=EOF) DoAddLine (szBuf);
   va_end(vaArgs);
return 0;
} /* Ecris */


//*************************************************************************
//*************************************************************************
static HWND hWndViewMsg = (HWND) NULL;
static LPSTR *lpMsg;
static LPSTR szNoMem = "Unable to allocate memory!";
static LPSTR szZoomErr = "Zoom Error";
static BOOL bZoomFlag=FALSE;



void DoAddLine (LPSTR lpBuf)
{
LPSTR lp;

  // added in some error checking to try to eliminate GPFs
  if (lpBuf==NULL || lpBuf[0]==0)   return;
  if (lpMsg==NULL)
    {
      lpMsg = (LPSTR *) GlobalAllocPtr (GHND, nMaxMsg * sizeof (LPSTR));
      nCurMsg = 0;
      if (lpMsg==NULL) 
        {
          MessageBox (hwnd, szNoMem, szZoomErr, MB_OK);
          return;
        }
    }
  if (nCurMsg>=nMaxMsg)
    {
      GlobalFreePtr (lpMsg[0]);
      memmove (lpMsg, lpMsg+1, (nMaxMsg-1)*sizeof (LPSTR));
      nCurMsg = nMaxMsg-1;
    }
  lp = lpMsg[nCurMsg] = (LPSTR) GlobalAllocPtr (GHND, lstrlen (lpBuf) + 5);
  if (lp!=NULL) 
    {
      HDC hDC;
      SIZE siz;
      
      lstrcpy (lp, lpBuf);
      hDC = GetDC (hwnd);
      GetTextExtentPoint (hDC, lp, lstrlen (lp), &siz);
      ReleaseDC (hwnd, hDC);
      nHorzMax = __max (nHorzMax, siz.cx);
      SetScrollRange (hwnd, SB_HORZ, 0, nHorzMax, TRUE);
      SetScrollRange (hwnd, SB_VERT, 0, nCurMsg, TRUE);
      InvalidateRect (hwnd, NULL, TRUE);
      nCurMsg++;
    }  /* lp not NULL */
    else 
    {
      MessageBox (hwnd, szNoMem, szZoomErr, MB_OK);
      return;
    } /* no more memory */
} /* DoAddLine */


//*************************************************************************
//*************************************************************************
void ReleaseDisplayMem()
{
int nI;
  if (lpMsg!=NULL) 
  {
    for (nI=0; nI<nMaxMsg; nI++) 
    {
      if (lpMsg[nI]!=NULL) GlobalFreePtr (lpMsg[nI]);
      lpMsg[nI] = NULL;
    }
  }
  nCurMsg = nVertPos = nHorzPos = nHorzMax = 0;
  SetScrollPos (hwnd, SB_HORZ, 0, TRUE);
  SetScrollPos (hwnd, SB_VERT, 0, TRUE);
  SetScrollRange (hwnd, SB_HORZ, 0, 1, TRUE);
  SetScrollRange (hwnd, SB_VERT, 0, 1, TRUE);
} /* ReleaseDisplymemory */


//*************************************************************************
void DoPaint(HWND hWnd)
{
HDC         hDC;
PAINTSTRUCT ps;
int         nI, nRows, nLine, nPos, nHt;
RECT        rRect;
TEXTMETRIC  tm;

  memset (& ps, 0, sizeof ps);  
  hDC = BeginPaint (hWnd, &ps);
  // Included as the background is not a pure color
  SetBkMode(hDC, TRANSPARENT);
  GetTextMetrics (hDC,&tm);
  nHt = tm.tmHeight + tm.tmExternalLeading;
  GetClientRect (hWnd, &rRect);
  nHorzSiz = rRect.right;
  nVertSiz = nRows = rRect.bottom/nHt;
  ShowScrollBar (hWnd, SB_VERT, (nRows<nCurMsg));
  nLine = nVertPos;
  if (lpMsg!=NULL)
  {
    for (nI=nPos=0; (nI<nRows) && (nLine<nCurMsg); nI++, nLine++, nPos+=nHt) 
    {
      if (lpMsg[nLine]!=NULL) 
      {
        TextOut (hDC, 20-nHorzPos, nPos, lpMsg[nLine], lstrlen (lpMsg[nLine]));
      }
    }
  }
  EndPaint(hWnd, &ps);
} /* DoPaint */


