{
  Public Domain  - Please leave this notice intact.
 Usage: Install a TCP/IP stack with associated WINSOCK.DLL.

telnet daemon for Borland Pascal
P.Wzietek, 1996}


unit telnetd;
INTERFACE

uses winsock, strings, windos,mycrt, winprocs, wintypes;


type
    commandproc=procedure (cmd: string);
    {each procedure of this type must be declared as 'far';
    can be called with s='' for remote screen refresh}


  procedure telnet_init(Pcmd: commandproc; password, prompt :string);


{proc used by commandproc:}
  procedure telnet_sendline(ss: string);
  procedure telnet_sendstring(ss: string);
                     {menus:}
  procedure telnet_nextmenu(Pcmd: commandproc; prompt :string);
  procedure telnet_previousmenu;  {return to previous commandproc}
  procedure telnet_mainmenu;

  {vt100 commands}
 procedure vt_clearscreen;
 procedure vt_home;
 procedure vt_eraseline;
 procedure vt_savecursor;
 procedure vt_restorecursor;
 procedure vt_locate(row,col:word);

 {command parser}
function GET_cmd_param (cmd: string; index: integer;
                        var par: string): boolean;

{**********************************}
IMPLEMENTATION
{*********************************}

const
     progversion='1.0';
     loginmsg='telnet server v.1.0, ready';
     exitcommand='exit';
     debug=false;
     traceusercmd=false;
     maxshells=10;
  {vt100}
       esc=#27;
       ans='[';
       maxrow=24;
       maxcol=80;

type
    connection=record
       socket: tSocket;
       rbuf:   string;
       remote_IPaddr: string;  {x.x.x.x Internet addr}
    end;

    shellrec=record
       pcmd: commandproc;
       prompt: string;
     end;

var
  myVerReqd : word;
  myWSAData : WSADATA;
  s : String[255];
  i : integer;
  CharArray: array[0..255] of char;
  HostNameArray: array[0..255] of char;

  shelltab: array[0..maxshells] of shellrec;
  shellindex: word;

  TelnetSocket: tSOCKET;    {daemon socked: always open}
  cLogin, cUser: connection; {sockets for 'login' and 'user' shells}
  err : integer;
  TelnetPort : word;
  passwd: string;
  hostname: string;

  hCRTWnd: Thandle;     {window handle}
  fCRT:    text;        {CRT window as text file}

const
  cm_Exit               = 100;
  cm_About              = 101;
  wm_winsock             = WM_USER + 100;


procedure CleanUp; Forward;

{$I ERROR.INC}




  {*************************}
function string_to_socket(ss: string; sck: tSocket): integer;
var
   Buff : array [0..255] of char;
   rcode: integer;
begin
    if sck=0 then begin string_to_socket:=SOCKET_ERROR; exit;end;
    strPcopy(Buff, ss);
    rcode:= Send(sck,Buff,strlen(Buff),0);
    if rcode < strlen(Buff)then error(fCRT, 'str_to_socket: ');
    string_to_socket:=rcode;
end;
{**********************************}
function line_to_socket(ss: string; sck: tSocket):integer;
begin
    ss:=concat(ss, #13#10);
    line_to_socket:=string_to_socket(ss,sck);
end;
{*************************************}
procedure telnet_sendline(ss: string);
begin
line_to_socket(ss, cUser.socket);
end;
{*****************************************}
procedure telnet_sendstring(ss: string);
begin
string_to_socket(ss, cUser.socket);
end;
{*********************}
procedure execute(cmd:string);
var ind: word;
begin
if traceusercmd then write(fCRT,'executing ',shellindex,':', cmd);
ind:=shellindex;
shelltab[shellindex].pcmd(cmd);
{redraw user screen if menu changed}
if ind<>shellindex then
   begin
   if traceusercmd then writeln(fCRT,'; ',shellindex,':');
   shelltab[shellindex].pcmd('');
   end;

if shelltab[shellindex].prompt<>'' then
   begin
   telnet_sendline('');
   telnet_sendstring(shelltab[shellindex].prompt);
   end;
end;

{******}
procedure telnet_nextmenu(Pcmd: commandproc; prompt :string);
begin
if shellindex=maxshells then exit;

shellindex:=shellindex+1;
shelltab[shellindex].pcmd:=pcmd;
shelltab[shellindex].prompt:=prompt;

end;
{*********}
procedure telnet_previousmenu;  {return to previous commandproc}
begin
if shellindex=0 then exit;
shellindex:=shellindex-1;
end;
{*********}

procedure telnet_mainmenu;
begin
if shellindex=0 then exit;

shellindex:=0;
end;
{*********}
{$I parse.inc}
{$I vt100.inc}


{******** end of interface functions********************************************}
{***************}
function retrieveline(var buf:string; var line:string): boolean;
{gets first line from the input buffer}
var ipos:byte;
    ic:word;
    rawline,sl: string ;
begin
line:='';
ipos:=pos(#10, buf);
if ipos=0 then retrieveline:=false
 else
    begin
    retrieveline:=true;
    rawline:=copy(buf, 1, ipos-1);
         {scan text until linefeed}
    delete(buf, 1, ipos);

    line:='';
    for ic:=1 to length(rawline) do
                 {strip ctrl chars from line
                  (this is the caracter set used by the server}
        if rawline[ic] in [' ','a'..'z', 'A'..'Z', '0'..'9',
                           '!','?','@','#','$','%','^','&',
                           '*','(',')','[',']','-','+',
                           '/',',','.','=','_'] then
            line:=concat(line, rawline[ic]);
    end;
end;

{****************************}
{off-line message processing (from rbuf)}

procedure msgproc_user;
var
   scmd:string;

begin;
if not retrieveline(cUser.rbuf, scmd) then exit;

if traceusercmd then writeln(fCRT,'user cmd:', scmd);


    {strip control chars if any:}
if length(scmd)>0 then
   while (scmd[length(scmd)] in [#10, #13]) and (length(scmd)>0)
          do dec(scmd[0]);



if scmd=exitcommand then
      begin
      if shellindex=0 then
          begin
          writeln(fCRT,'exit command received, closing connection');
          closesocket(cUser.socket);
          cUser.socket:=0;
          end
       else    telnet_previousmenu;
      end
 else
      execute(scmd);


end;

{***********************}
procedure msgproc_login;
var
   scmd:string;
begin;

if not retrieveline(cLogin.rbuf, scmd) then exit;

if debug then writeln(fCRT,'processing Login cmd: "', scmd, '"');

{send a cr:}
line_to_socket('', cLogin.socket);

    {strip control chars:}
if length(scmd)>0 then
   while (scmd[length(scmd)] in [#10, #13]) and (length(scmd)>0)
          do dec(scmd[0]);

{check password}
 if scmd=passwd then
    begin
    {transform login to user, close old user if any}
    line_to_socket(#13#10'closing connection'#10, cUser.socket);
    if debug then writeln(fCRT,'closing socket ', ord(cUser.socket));

    if cUser.socket>0 then closesocket(cUser.socket);
    cUser:=cLogin;
    cLogin.socket:=0;
    cLogin.rbuf:='';
    shellindex:=0;
    line_to_socket('',cUser.socket);
    {draw user screen}
    execute('');
    end
  else
    begin
    line_to_socket('password incorrect', cLogin.socket);
    closesocket(cLogin.socket);
    end;
end;


  {*************************}
function WindowProc(Window:HWnd; Message,wParam:Word; lParam:LongInt) : LongInt; export;
var
msg_socket: tSocket;   {socket the msg comes from}

procedure um_con;   {called on CONNECT request}
var Buff : array [1..1024] of char;
    adr_tab: sockaddr_in;
    Len : integer;
    Addr : sockaddr;
    ReadCount,Readindex : Integer;
       Remote_Addr: sockaddr_in;

begin
  if debug then writeln(fCRT,'Received a USER_CONNECT message:', WSAGetSelectEvent(lParam));
  if (WSAGetSelectError(lparam) <> 0) then Error(fCRT, 'USER_CONNECT msg')
   else
      begin
      if debug then writeln(fCRT,'closing previous login socket');
       if cLogin.Socket>0 then closesocket(cLogin.Socket);

      Len := SizeOf(Remote_Addr);
      Addr := SockAddr(Remote_Addr);
      cLogin.Socket := accept(TelnetSocket, @Addr, @Len);

      adr_tab:=sockaddr_in(Addr);
      cLogin.remote_IPaddr:=strpas( inet_ntoa(adr_tab.sin_addr))  ;

      writeln(fCRT,'connection request from: ',cLogin.remote_IPaddr);
      if debug then writeln(fCRT,'Login Socket=',cLogin.Socket);

      if cLogin.Socket=INVALID_SOCKET  then Error(fCRT, 'Login Socket')
       else
         begin  {begin login dialog}
         WSAAsyncSelect(cLogin.Socket, hCRTWnd, wm_winsock, FD_READ or FD_CLOSE);

         line_to_socket(loginmsg, cLogin.socket);
         line_to_socket('', cLogin.socket);

         {tell previous user if exists}
         if cUser.socket>0 then
           if line_to_socket(concat(#13#10'Connect request from ',
             cLogin.remote_IPaddr), cUser.socket)<>SOCKET_ERROR then
               begin {user exists}
               {tell new user about it}
               line_to_socket(concat(#13#10'current connection: ',
                        cUser.remote_IPaddr,
                        #13#10'(type ENTER to quit)'), cLogin.socket);
               end;

         {prompt for password}
         string_to_socket('password:', cLogin.socket);

         end;
      end;
end;

procedure um_rd(var con: connection);    {process read message}
{will update rbuf field}
var
   Buffrec : array [1..255] of char;
   srec:string;
   ir: word;
   ReadCount: integer;
begin;
if debug then writeln(fCRT,'um_rd: msg', WSAGetSelectEvent(lParam));
ReadCount := recv(con.Socket, @Buffrec, 254, 0);


if ReadCount = SOCKET_ERROR then Error(fCRT, 'Read')
  else
    begin
    Buffrec[Readcount+1]:=#0;
    if debug then
       begin writeln(fCRT,'Characters received:');
       for ir := 1 to ReadCount do write(fCRT,ord(Buffrec[ir]),' ');
       writeln;
       end;
    {append to rbuf}
    srec:=strpas(@Buffrec);
    con.rbuf:=concat(con.rbuf,srec);
    end;
end;


begin {windowproc}
  case Message of

    wm_Command   :
           begin
                   case WParam of
	           cm_About:
                     begin
                     MessageBox(Window,
        'Telnet Daemon'#13#13'(C) Pawel Wzietek, 1995',
                    'Telnet Daemon',mb_OK);
                    end;
	            cm_Exit:
                       begin
                       CleanUp;
                       done_myCrt;
                       end;
                    end;
           end;
     wm_winsock  :
         begin
         {identify the socket:}
         msg_socket:=wParam;

         case WSAGetSelectEvent(lParam) of
              FD_ACCEPT :   begin   um_con; end;

              FD_CLOSE:
                   begin
                   if msg_socket=cUser.socket then
                       begin
                       if debug then writeln(fCRT,'cUser: received USER_CLOSE msg');
                       closesocket(cUser.Socket);
                       writeln(fCRT,'connection closed by foreign host');
                       cUser.Socket:=0;
                       cUser.rbuf:='';
                       end;
                   if msg_socket=cLogin.socket then
                       begin
                       if debug then writeln(fCRT,'cLogin: received USER_CLOSE msg');
                       closesocket(cLogin.Socket);
                       cLogin.Socket:=0;
                       cLogin.rbuf:='';
                       end;

                   end;
              FD_READ :
                   begin
                   if msg_socket=cUser.socket then
                      begin um_rd(cUser); msgproc_user; end;
                   if msg_socket=cLogin.socket then
                      begin um_rd(cLogin); msgproc_login; end;
                   end;
           end;
         end;
  end;
  WindowProc := 0;
    {CallWindowProc(OldWndProc, Window, Message, wParam, lParam);}
end;

procedure MakeMenu;
var
  Menu      : HMenu;
  FileMenu  : HMenu;
begin
  Menu := CreateMenu;
  FileMenu := CreateMenu;
  AppendMenu(Menu, mf_PopUp or mf_Enabled, FileMenu, 'File');
  AppendMenu(FileMenu, mf_Enabled, cm_Exit, 'Exit');
  AppendMenu(Menu, mf_Enabled, cm_About, 'About');
  SetMenu(hCRTWnd,Menu);
end;

procedure InitCRT;
begin
  hCRTWnd:=init_mycrt(hInstance, TFarProc(@WindowProc),
                     'Telnet Daemon', fCRT);
   MakeMenu;
end;

{************************}
procedure CleanUp;
begin
  if WSACleanup <> 0 then Error(fCRT, 'WSACleanup');
end;

{***********************}
procedure StartUp;
var
  pSE : pServEnt;
 sopt: integer;
   Remote_Addr: sockaddr_in;
  rc : integer;

begin
  myVerReqd:=$0101;
  writeln(fCRT,'Winsock version required : ',hibyte(myVerReqd),'.',lobyte(myVerReqd));
  if WSAStartup(myVerReqd,@myWSAData) <>0 then Abort(fCRT, 'WSAStartup');

  {show Winsock info:}
  writeln(fCRT,'Telnet Daemon, version ',progversion);
  write(fCRT,'Winsock Version found: ');
  writeln(fCRT,lobyte(myWSAData.wVersion),'.',lobyte(myWSAData.wHighVersion));
  S := StrPas(myWSAData.szDescription);
  writeln(fCRT,'Description=',S);
  S := StrPas(myWSAData.szSystemStatus);
  writeln(fCRT,'SystemStatus=',S);
  writeln(fCRT,'MaxSockets=',word(myWSAData.iMaxSockets));
  writeln(fCRT,'MaxUdpDg=',word(myWSAData.iMaxUdpDg));
  write(fCRT,'VendorInfo= ');
    if myWSAData.lpVendorInfo <> NIL then begin
      writeln(fCRT,myWSAData.lpVendorInfo);
    end else writeln(fCRT,'NULL');
  {this can cause an error in host name is not defined:}
  {write(fCRT,'Local Hostname=');
  hostname:='';
  if (gethostname(@CharArray,255) <> 0) then Error('GetHostName')
    else
       begin writeln(fCRT,CharArray); hostname:=strpas(Chararray); end;}

{find Telnet service:}
  TelnetPort := 0;
  writeln(fCRT,'looking up for telnet service...');
  pSE := getservbyname('telnet','tcp');
  if pSE = nil then
     begin
     Error(fCRT, 'GetServByName'); Writeln;
     writeln(fCRT,'telnet is usually on port 23.  Check Services table.');
     abort(fCRT, '');
     end
  else
      begin
      TelnetPort := htons(pSE^.s_port);
      writeln(fCRT,'Using telnet service on port ',TelnetPort);
      end;

{create socket:}
  TelnetSocket:=socket(PF_INET, SOCK_STREAM, IPPROTO_IP);
  If TelnetSocket = INVALID_SOCKET then Abort(fCRT, 'Can''t CreateSocket')
  else
      begin
      writeln(fCRT,'Socket descriptor: ',ord(TelnetSocket));
      sopt:=1;  {set graceful disconnect}
      setsockopt (TelnetSocket, integer(SOL_SOCKET), integer(SO_DONTLINGER),
                  @sopt, sizeof(sopt));
      end;

{bind to socket:}
  Remote_addr.sin_family := PF_INET;
  Remote_addr.sin_port := htons(TelnetPort);
  Remote_addr.sin_addr.s_addr:=INADDR_ANY;
  if bind(TelnetSocket, sockaddr(Remote_Addr), SizeOf(Remote_Addr)) <> 0 then
     begin
     CloseSocket(TelnetSocket);
     Abort(fCRT, 'Bind');
     end;

{listen to socket:}

rc := listen(TelnetSocket,5);
  if rc > 0 then Error(fCRT, 'Listen');
  {set all sockets to non-blocking mode}
  rc := rc + WSAAsyncSelect(TelnetSocket, hCRTWnd, wm_winsock, FD_ACCEPT);
  if rc > 0 then begin
    CloseSocket(TelnetSocket);
    Abort(fCRT, 'WSAAsyncSelect');
  end;
writeln(fCRT,'daemon ready, listening on socket ',ord(TelnetSocket));

end;

{****************************************************}
procedure telnet_init(Pcmd: commandproc; password, prompt :string);
begin
cUser.Socket:=0;
TelnetSocket:=0;
cLogin.Socket:=0;

cUser.rbuf:='';
cLogin.rbuf:='';

passwd:=password;
shelltab[0].pcmd:=Pcmd;
shelltab[0].prompt:= prompt;
shellindex:=0;
{loginprompt:='host:>';}


  InitCRT;

  StartUp;
end;

end.