{CRT like window with scroll bars}
{P.Wzietek,1996}

unit mycrt;

interface
uses wintypes,winprocs, win31,strings,wincrt,windos;



function init_mycrt(hinst: Thandle; wproc: TFarProc;
                     title: pchar;
                     var fwnd: text): Thandle;
{init_mycrt:  opens a CRT window for use with
              writeln instruction
     parameters:
              hinst   -  instance of the app
              wproc  -  optional pointer to the
                         user supplied window msg processing
                         function (use nil for default proc)
              title  - window title
   returns:  fwnd    - text file handle for use
                        in:  writeln(fwnd, ...)
             function - window handle

example call: init_mycrt(hInstance, nil, 'mywindow', f)}

procedure  done_myCRT;

{***************************************************}
{***************************************************}
implementation

const

{ menu defines}
  IDM_QUIT   =   101;
 { IDM_ABOUT   =  102;}
  IDM_HOME    =  103;
   IDM_MESSAGE =  104;
  IDM_CLEAR   =  105;
  IDM_LINES   =  106;


 MAX_QRT_LEN = 100;

type scrollkeys = record
     case integer of
     1:( wVirtkey: word;
      iMessage :integer;
      wRequest :word);
     2:(x: array[1..3] of word);
      end;

type LPSTR=pointer;

const  key2scroll: array[0..7] of SCROLLKEYS =
  (
    (x:(VK_HOME,  WM_COMMAND, IDM_HOME)),
    (x:(VK_END,   WM_VSCROLL, SB_BOTTOM)),
    (x:(VK_PRIOR, WM_VSCROLL, SB_PAGEUP)),
    (x:(VK_NEXT,  WM_VSCROLL, SB_PAGEDOWN)),
    (x:(VK_UP,    WM_VSCROLL, SB_LINEUP)),
    (x:(VK_DOWN,  WM_VSCROLL, SB_LINEDOWN)),
    (x:(VK_LEFT,  WM_HSCROLL, SB_PAGEUP)),
    (x:(VK_RIGHT, WM_HSCROLL, SB_PAGEDOWN))
  );

const NUMKEYS =(sizeof(key2scroll) div sizeof (key2scroll[0]));

var
initialized: boolean;
hInstapp:  Thandle ;   {copy of hInstance of application}
hWndCrt: HWND;      {hWnd of CRT window}
wndtitle: Pchar;
crtclass: Twndclass;
userwinproc: Tfarproc; {copy of user proc pointer}

xChar, yChar, yCharnl:  integer;
xClient, yClient:  integer;

 cursfont:  TLOGFONT  ;
 holdsfont, hnewsfont: HFONT;

 wrect:  TRECT;

 {window scroll/paint stuff}
       nVscrollMax, nHscrollMax:     integer;
       nVscrollPos, nHscrollPos:     integer;
       numlines:     integer;
       maxwidth:     integer;
       nVscrollInc, nHscrollInc:     integer;
       nPaintBeg, nPaintEnd:     integer;
       nPageMaxLines:     integer;

{ for scroll print}
  rect:  TRECT;
   blanklen:  integer;
   blanks: array[0..255] of char;

{ to keep lines}
const  MAX_KEEP =  50;
var hkeep: array[0..MAX_KEEP + 1]of THandle;
    hwm_keep: integer;
{text file}
const flinelen=128;  {window line length}
      fbuflen=1024;  {dos buffer size}

var fwnd:text;
    tbuf:array[0..fbuflen]of char; {file IO buffer}

{local functions:}
function CrtWndProc(Window: hWnd; Message, WParam: Word;
  LParam: Longint): Longint; export; forward;

{local procedures:
procedure defcrtclass(...);
 procedure SetupScroll(Window: hWnd);
procedure crtPaint(Window: hWnd);
procedure ScrollPrint(Window: hWnd; str: Pchar);
procedure Closecrt;
procedure Initcrtwindow(hInst:Thandle; cmdShow:integer
                         var  hWnd: hWnd);

function crtWndProc(Window: hWnd; Message, WParam: Word;
  LParam: Longint): Longint;}


{********************************************}


function max(x,y:integer):integer;
begin
if x>y then max :=x else max:=y;
end;
function min(x,y:integer):integer;
begin
if x<y then min :=x else min:=y;
end;

{*******************************************************************
 SetupScroll - setup scroll ranges

   Setup the vertical and horizontal scroll ranges and positions
   of the applicatons main window based on:

       numlines - The maximum number of lines to display.
       maxwidth - The maximum width of any line to display.

   The resulting variables, nVscrollPos and nPageMaxLines, are used
   by the function TstAppPaint to determine what part of the selected
   file to display in the window.

 paramaters:
             hWnd          - The callers window handle  }


{**********************************************}
procedure SetupScroll(Window: hWnd);
begin
    { numlines established during open}
    nVscrollMax := max(0, numlines - yClient div yChar);
    nVscrollPos := min(nVscrollPos, nVscrollMax);

    nHscrollMax := max(0, maxwidth - xClient div xChar);
    nHscrollPos := min(nHscrollPos, nHscrollMax);

    SetScrollRange (Window, SB_VERT, 0, nVscrollMax, FALSE);
    SetScrollPos   (Window, SB_VERT, nVscrollPos, TRUE);

    SetScrollRange (Window, SB_HORZ, 0, nHscrollMax, FALSE);
    SetScrollPos   (Window, SB_HORZ, nHscrollPos, TRUE);

    nPageMaxLines := min(numlines, yClient div yChar);

    rect.left := 0;
    rect.top := 0;
    rect.right := xClient;
    rect.bottom := yClient;

    blanklen := rect.right div xChar + 1;
end;

{*******************************************************************
 crtPaint - paint the main window

 This function is responsible for redisplaying a portion of the saved
 strings.  Which strings it displays depends on the current scroll
 position.

 paramaters:
             Window          - The callers window handle

*******************************************************************}
procedure crtPaint(Window: hWnd);
var
    ps:  TPAINTSTRUCT;
    HDC         : Thandle;
    currec: array[0..256]of char;
    ypos        :integer;
    lcp         :LPSTR;
    i:          integer;
    ndone       :integer;
begin
    { Get display context.}
    BeginPaint(Window, ps);
    hDC := ps.hdc;

    { Select fixed font.}
    SelectObject(hDC, hnewsfont);

    { Setup scroll ranges.}
    SetupScroll(Window);

    { See if we have any lines to show.}
    if (hwm_keep>0)then
        begin
        { Y position of bottom line in client area.}
        ypos := rect.bottom - yChar;

	{ Index into keep list of first line (from bottom) to show.}
        i := nVscrollMax - nVscrollPos;

        ndone := 1;
        while (ndone<>0)do
            begin
            lcp := GlobalLock(hkeep[i]);
            if (lcp<>nil)then
                begin
                { We must fill line with blanks to width of window
                 or else some previous longet text might show through.}
                strcopy(currec, blanks);

                { Line to show.}
                strLcopy(currec, lcp, strlen(lcp));

                { Send to window.}
                TextOut(hDC,
                        xChar * (-nHscrollPos + 0),
                        ypos,
                        currec,
                         strlen(currec));

                { New Y is one character height higher.}
                ypos := ypos - yChar;

                GlobalUnlock(hkeep[i]);
              end;

           {  Index of next keep string to show.}
            inc(i);

            { No use drawing lines beyond top of client area.
             They would not show, so don't wast the energy.}
            if (ypos < -yChar)then ndone := 0;

            { Have we done all of the lines?}
            if (i > (hwm_keep - 1))then  ndone := 0;
	  end;
      end;

    { Release the display context.}
    EndPaint(Window, ps);
end;

{*******************************************************************
 ScrollPrint - saves string sent to it and cause it to display

 This function gets a string and saves it in a list of strings.
 The oldest string is deleted when the list reaches its maximum
 size.

 paramaters:
             Window          - The window to put the message in.
             str           - the string to print in window.

*******************************************************************}
procedure ScrollPrint(Window: hWnd; str: Pchar);
var
    i, lstr:    integer;
    lcp:  LPSTR;
    rect:  Trect;
begin
    { If our keep stack is full free oldest member.}
    if (hwm_keep >= MAX_KEEP)then
     GlobalFree(hkeep[hwm_keep]);

     {  Move all handles to make room for new one.}
      for i := hwm_keep downto 1 do
      hkeep[i] := hkeep[i - 1];

    { If keep stack not yet full add one to high watter mark.}
    if (hwm_keep < MAX_KEEP)then
      inc(hwm_keep);

    { Make sure we know how many saved lines there are.}
    numlines := hwm_keep;

    { Length of new string.}
    lstr := strlen(str);

    { Is it longer than any previous string.}
    if (lstr > maxwidth)then maxwidth := lstr;

    { Get storage to save it.}
    hkeep[0] := GlobalAlloc(GMEM_MOVEABLE,(lstr + 1));
    if (hkeep[0]<>0)then
        begin
        { Lock it down to get address.}
        lcp := GlobalLock(hkeep[0]);
        if (lcp<>nil)then
            begin
	    { Save string.}
            strcopy(lcp, str);
            GlobalUnlock(hkeep[0]);
            end;
        end;

    { See what we have to do to display it efficently.}
    if  (nVscrollMax <= nVscrollPos)then
        begin
        { We are scrolled to bottom of list.}

        { Scroll contents of window up one character hehght.}
        ScrollWindow(Window, 0, -yChar, @rect, @rect);

        { Set scroll position to last line}
        nVscrollPos := numlines - yChar div yClient;

        { Tell windows to repaint only the bottom line of window.}
        GetClientRect(Window, rect);
        rect.top := rect.bottom - yChar;
	InvalidateRect(Window, @rect, TRUE);
        end
    else
        begin
        { We are not scrolled to bottom of list.}

        { Set scroll position to last line. }
        nVscrollPos := numlines - yChar div yClient;

        { Tell windows to repaint the entire window.}
        InvalidateRect(Window, nil, TRUE);
        end;
end;

{*******************************************************************
 ClearKeep - free all saved strings}
procedure ClearKeep;
var
    i: integer;
begin
    if hwm_keep>0 then for i := 0 to hwm_keep-1 do
        begin
        GlobalFree(hkeep[i]);
        hkeep[i] := 0;
        end;

    { Reset counters.}
    numlines := 0; hwm_keep := 0;
end;

{*******************************************************************
 Closecrt -
               This is where wrapup code that should be run
               at the termination of the application should go.

*******************************************************************}
procedure Closecrt;
begin
    ClearKeep;
    DeleteObject(hnewsfont);
    ttextrec(fwnd).mode:=fmClosed;
end;


procedure  done_myCRT;
begin

PostMessage(hWndCRT, WM_CLOSE, 0, 0)
end;



{*******************************************************************
 crtclass : defines window class
 paramaters:
             hInst     - The instance of this instance of this
                             application.
             defclass - default window class for crt
*******************************************************************}
procedure defcrtclass(name: pchar; hinst:Thandle;
                 var wclass: Twndclass);

begin

{     fill in window class information}

    wclass.lpszClassName := name;
    wclass.hInstance     := hInst;
    wclass.lpfnWndProc   := @crtWndProc;
    wclass.hCursor       := LoadCursor(0, IDC_ARROW);
    wclass.hIcon         := LoadIcon(0, idi_application);
    wclass.lpszMenuName  := '';
    wclass.hbrBackground := GetStockObject(WHITE_BRUSH);
    wclass.style         := CS_HREDRAW or CS_VREDRAW;
    wclass.cbClsExtra    := 0;
    wclass.cbWndExtra    := 0;

end;


{*******************************************************************
 initcrtwindow     Will create the window and sets a fixed font
                   for tabular display.

 paramaters:
             hInst     - The instance of this instance of this
                             application.
             cmdShow       - Indicates how the window is to be shown
                             initially. ie. SW_SHOWNORMAL, SW_HIDE,
                             SW_MIMIMIZE.

     returns: hWnd  -window handle
*******************************************************************}
procedure Initcrtwindow(hInst:Thandle; cmdShow:integer;
                         var  hWnd: hWnd);
var

    tm        :TTEXTMETRIC;
    HDC        :Thandle;
    i:         integer;

{  Menu      : HMenu;
  FileMenu  : HMenu;}


begin

    hInstapp := hInst;      {  save for use by window procs}

    hWnd := CreateWindow(
                  'mycrt',             {  window class name}
                  wndtitle,             {  window title      }
                  WS_OVERLAPPEDWINDOW or    { type of window    }
                    WS_HSCROLL or
                    WS_VSCROLL,
		  CW_USEDEFAULT,           { x  window location}
                  0,                       { y }
                  500,                     { cx and size  }
                  250,                     { cy }
                  0,                    { no parent for this window}
                  0,                    { use the class menu}
                  hInst,               { who created this window}
                  NiL                   {   no parms to pass on}
                  );

    hDC := GetDC(hWnd);



   {  build screen font}
    cursfont.lfHeight         :=  6;
    cursfont.lfWidth          :=  6;
    cursfont.lfEscapement     :=  0;
    cursfont.lfOrientation    :=  0;
    cursfont.lfWeight         :=  FW_NORMAL;
    cursfont.lfItalic         :=  0;{FALSE;}
    cursfont.lfUnderline      :=  0;{FALSE;}
    cursfont.lfStrikeOut      :=  0;{FALSE;}
    cursfont.lfCharSet        :=  ANSI_CHARSET;
    cursfont.lfOutPrecision   :=  OUT_DEFAULT_PRECIS;
    cursfont.lfClipPrecision  :=  CLIP_DEFAULT_PRECIS;
    cursfont.lfQuality        :=  DEFAULT_QUALITY;
    cursfont.lfPitchAndFamily :=  FIXED_PITCH or FF_DONTCARE;
    strcopy(cursfont.lfFaceName, 'System');

    hnewsfont := CreateFontIndirect(cursfont);
    holdsfont := SelectObject(hDC, hnewsfont);

    { get text metrics for paint}
    GetTextMetrics(hDC, tm);
    xChar := tm.tmAveCharWidth;
    yChar := tm.tmHeight + tm.tmExternalLeading;
    yCharnl := tm.tmHeight;

   {  init blank line}
    blanklen := 255;
    for i:=0 to blanklen-1 do blanks[i]:=' ';

    ReleaseDC(hWnd, hDC);


    ShowWindow(hWnd, cmdShow);

      UpdateWindow(hWnd);


end;

{*******************************************************************
 crtWndProc - every message for this instance will come here

   Handle the messages for this application.

 paramaters:
             hWnd          - The window handle for this message
             message       - The message number
             wParam        - The WPARAM parameter for this message
             lParam        - The LPARAM parameter for this message

 returns:
             depends on message.

*******************************************************************}
function crtWndProc(Window: hWnd; Message, WParam: Word;
  LParam: Longint): Longint;
var
    msgno    :integer; {static?}
    lpproc      :Tfarproc;
    buf:      array[0..128]of char;
    i:      integer;
    hTmp  :Thandle;
    lpTmp :LPSTR;

    msgdone: boolean;
begin
msgdone:=false;

    case message of

        WM_COMMAND:
            case wParam of


                 IDM_HOME:
                    { Home key was hit.}
                    begin
                    SendMessage(Window, WM_HSCROLL, SB_TOP, 0);
                    SendMessage(Window, WM_VSCROLL, SB_TOP, 0);
                    msgdone:=true;
                    end;

                else ;

            end;

         WM_SIZE:
            { Save size of window client area.}
            begin
            yClient := HIWORD(lParam);
            xClient := LOWORD(lParam);

            { Go setup scroll ranges and file display area based upon
             client area size.}
            SetupScroll(Window);
             msgdone:=true;
            end;

         WM_VSCROLL:
            { React to the various vertical scroll related actions.}
            begin
             msgdone:=true;
            case wParam of

                SB_TOP:
                    nVscrollInc := -nVscrollPos;


                 SB_BOTTOM:
                    nVscrollInc := nVscrollMax - nVscrollPos;

                 SB_LINEUP:
		    nVscrollInc := -1;


                 SB_LINEDOWN:
                    nVscrollInc := 1;

                 SB_PAGEUP:
                    nVscrollInc := -max(1, yClient div yChar);

                 SB_PAGEDOWN:
                    nVscrollInc := max(1, yClient div yChar);

                 SB_THUMBPOSITION:
                    nVscrollInc := LOWORD(lParam) - nVscrollPos;

                 SB_THUMBTRACK:
		    nVscrollInc := LOWORD(lParam) - nVscrollPos;

                else
                    nVscrollInc := 0;
                end;

            nVscrollInc := max(-nVscrollPos,
                              min(nVscrollInc, nVscrollMax - nVscrollPos));
            if (nVscrollInc<>0) then
                begin
                nVscrollPos := nVscrollPos+nVscrollInc;
                ScrollWindow(Window, 0, -yChar * nVscrollInc, Nil, Nil);
                SetScrollPos(Window, SB_VERT, nVscrollPos, TRUE);
                UpdateWindow(Window);
                end;

            end; {vscroll}

         WM_HSCROLL:
            { React to the various horizontal scroll related actions.}
            begin
             msgdone:=true;
	    case wParam of

                SB_LINEUP:
                    nHscrollInc := -1;
                SB_LINEDOWN:
                    nHscrollInc := 1;

                SB_PAGEUP:
                    nHscrollInc := -8;

                SB_PAGEDOWN:
                    nHscrollInc := 8;

                SB_THUMBPOSITION:
                    nHscrollInc := LOWORD(lParam) -
                                      nHscrollPos;
                SB_THUMBTRACK:
                    nHscrollInc := LOWORD(lParam) - nHscrollPos;

                else
                    nHscrollInc := 0;

                end;


            nHscrollInc := max(-nHscrollPos,
                              min(nHscrollInc, nHscrollMax - nHscrollPos));
            if (nHscrollInc<>0)then
                begin
                nHscrollPos := nHscrollPos+nHscrollInc;
                ScrollWindow(Window, -xChar * nHscrollInc, 0, Nil, Nil);
                SetScrollPos(Window, SB_HORZ, nHscrollPos, TRUE);
                UpdateWindow(Window);
                end;
             end; {hscroll}

        WM_KEYDOWN:
            { Translate various keydown messages to appropriate horizontal
             and vertical scroll actions.}
            begin
            for i := 0 to NUMKEYS-1 do

                if (wParam = key2scroll[i].wVirtkey)then
                    SendMessage(Window, key2scroll[i].iMessage,
                                key2scroll[i].wRequest, 0);

             msgdone:=true;
             end;


        WM_PAINT:
          {   Go paint the client area of the window with the appropriate
             part of the selected file.}

            begin
	    crtPaint(Window);
             msgdone:=true;
             end;

        WM_DESTROY:
           {  This is the end if we were closed by a DestroyWindow call.}
            begin
            Closecrt;        {  take any necessary wrapup action.}
           { PostQuitMessage(0); }  {  this is the end...}
             msgdone:=true;
            end;

        WM_QUERYENDSESSION:
           {  If we return TRUE we are saying it's
               ok with us to end the
             windows session.}
            begin
            initialized:=false;        {  take any necessary wrapup action.}
            crtWndProc:= 1;   { we agree to end session.  }
             msgdone:=true;
            end;

        WM_CLOSE:
            { Tell windows to terminate us.}
            begin
            closeCRT;
            DestroyWindow(Window);
             msgdone:=true;
            end;
	end;

        { Let either user or windows handle all messages
              we choose to ignore.}
 if not msgdone then
            begin
            if userwinproc<>nil then
            crtwndProc := CallWindowProc
              (userwinProc, Window, Message, wParam, lParam);

            crtWndProc:=DefWindowProc
                (Window, message, wParam, lParam);
            end;

end;


{***************************************************************}
 {*******************************************************************}
{functions to hook the text file output buffer}

var spr:array[0..sizeof(tbuf)] of char;

function text_dummy(var f:ttextrec):integer;export;
{do nothing, return IOresult OK}
begin
text_dummy:=0;
end;


function text_inout(var f:ttextrec):integer;export;
{writes the buffer to the window}
{only writeln causes to flush the buffer}
const CR=#13;
      LF=#10;
      NUL=#0;

var
    s:string;
    i:integer;
begin

if not initialized then
   begin text_inout:=-1; f.bufpos:=0; exit; end;

if f.bufpos=0 then
   begin   text_inout:=0; exit; end;



if tbuf[f.bufpos-1]=LF then { full line}
   begin

   tbuf[f.bufpos-2]:=Nul;  {strip CR,LF}

   strcopy(spr,tbuf);
   ScrollPrint(hWndCrt, spr);
   f.bufpos:=0;
   end
 else     {not a full line}
  if f.bufpos>flinelen then   {if line too long, cut it}
      begin
      strmove(spr, tbuf, flinelen);
      for i:=flinelen to f.bufpos do
         tbuf[i-flinelen]:=tbuf[i];  {move, with #0}
      tbuf[f.bufpos-flinelen]:=NUL;
      ScrollPrint(hWndCrt, spr);
      f.bufpos:=f.bufpos-flinelen;
      end;

text_inout:=0;
 end;

 {************************}

procedure text_init(var f: text);
begin
assign(f, '');
ttextrec(f).OpenFunc:=@text_dummy;
rewrite(f);

with ttextrec(f) do
     begin
    Mode:=fmOutput;
    BufSize:= fbuflen;
    BufPos:= 0;
    BufEnd:=0;
    BufPtr:=@tbuf;
    OpenFunc:=@text_dummy;
    InOutFunc:=@text_inout;
    FlushFunc:=@text_inout;
    CloseFunc:=@text_dummy;
    end;
 end;
{*******************************************}
{initialization of mycrt}
function init_mycrt(hinst: Thandle; wproc: tfarproc;
                     title: pchar;
                     var fwnd: text): Thandle;

begin
hInstapp:=hinst;        {hInstance of application}
userwinproc:=wproc; {copy of user proc pointer}
wndtitle:=title;

if initialized then closecrt;

if getclassinfo(hinst, 'mycrt', crtclass) then
         unregisterclass('mycrt',hinst);  {if exists}
defcrtclass('mycrt',hinst, crtclass);
registerclass(crtclass);

Initcrtwindow(hInst,SW_SHOWNORMAL, hWndcrt);
init_mycrt:=hWndCrt;

{assign file printing to window}
text_init(fwnd);

{reset variables}
 hwm_keep:=0; numlines:=0;
 initialized:=true;
end;
{*****************************************}
begin
initialized:=false;
end.

