VERSION 2.00
Begin Form Form1 
   Caption         =   "TCP Example"
   ClientHeight    =   5820
   ClientLeft      =   1272
   ClientTop       =   1596
   ClientWidth     =   7368
   Height          =   6192
   Icon            =   TCPEX.FRX:0000
   Left            =   1224
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   7368
   Top             =   1272
   Width           =   7464
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   120
      TabIndex        =   14
      Top             =   120
      Width           =   1215
   End
   Begin Frame Frame3 
      Caption         =   "Connected &From"
      Height          =   3855
      Left            =   3720
      TabIndex        =   13
      Top             =   1800
      Width           =   3495
      Begin PowerTCP_TCP tcpConnectFrom 
         Flags           =   0
         Left            =   840
         LocalDotAddr    =   ""
         OemLicense      =   ""
         RemoteHost      =   ""
         RemotePort      =   7
         Top             =   300
      End
      Begin CommandButton cmdConnectFromSend 
         Caption         =   "Se&nd"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2160
         TabIndex        =   20
         Top             =   720
         Width           =   1215
      End
      Begin TextBox txtConnectFromSend 
         Height          =   375
         Left            =   120
         TabIndex        =   19
         Top             =   720
         Width           =   1935
      End
      Begin CommandButton cmdConnectFromClose 
         Caption         =   "Clo&se"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2160
         TabIndex        =   16
         Top             =   240
         Width           =   1215
      End
      Begin TextBox txtConnectFrom 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Fixedsys"
         FontSize        =   10.8
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2535
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   15
         Top             =   1200
         Width           =   3255
      End
   End
   Begin Frame Frame2 
      Caption         =   "&Listen"
      Height          =   1455
      Left            =   3720
      TabIndex        =   0
      Top             =   120
      Width           =   3495
      Begin PowerTCP_TCP tcpListen 
         Flags           =   0
         Left            =   780
         LocalDotAddr    =   ""
         OemLicense      =   ""
         RemoteHost      =   ""
         RemotePort      =   7
         Top             =   960
      End
      Begin CommandButton cmdStop 
         Caption         =   "&Stop"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2040
         TabIndex        =   4
         Top             =   840
         Width           =   1215
      End
      Begin TextBox txtListenPort 
         Height          =   375
         Left            =   600
         TabIndex        =   2
         Text            =   "23"
         Top             =   360
         Width           =   1215
      End
      Begin CommandButton cmdListen 
         Caption         =   "&Listen"
         Height          =   375
         Left            =   2040
         TabIndex        =   3
         Top             =   360
         Width           =   1215
      End
      Begin Label Label3 
         Caption         =   "&Port:"
         Height          =   375
         Left            =   120
         TabIndex        =   1
         Top             =   360
         Width           =   1215
      End
   End
   Begin Frame Frame1 
      Caption         =   "Connect &To"
      Height          =   4935
      Left            =   120
      TabIndex        =   5
      Top             =   720
      Width           =   3495
      Begin PowerTCP_TCP tcpConnectTo 
         Flags           =   0
         Left            =   240
         LocalDotAddr    =   ""
         OemLicense      =   ""
         RemoteHost      =   ""
         RemotePort      =   7
         Top             =   1200
      End
      Begin CommandButton cmdConnectToSend 
         Caption         =   "&Send"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2160
         TabIndex        =   18
         Top             =   1800
         Width           =   1215
      End
      Begin TextBox txtConnectToSend 
         Height          =   375
         Left            =   120
         TabIndex        =   17
         Top             =   1800
         Width           =   1935
      End
      Begin CommandButton cmdConnectToClose 
         Caption         =   "C&lose"
         Enabled         =   0   'False
         Height          =   375
         Left            =   2160
         TabIndex        =   11
         Top             =   1200
         Width           =   1215
      End
      Begin TextBox txtConnectToPort 
         Height          =   375
         Left            =   2040
         TabIndex        =   9
         Text            =   "23"
         Top             =   600
         Width           =   1335
      End
      Begin TextBox txtConnectToAddress 
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Text            =   "x.x.x.x"
         Top             =   600
         Width           =   1335
      End
      Begin CommandButton cmdConnect 
         Caption         =   "&Connect"
         Height          =   375
         Left            =   720
         TabIndex        =   10
         Top             =   1200
         Width           =   1215
      End
      Begin TextBox txtConnectTo 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Fixedsys"
         FontSize        =   10.8
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2535
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   12
         Top             =   2280
         Width           =   3255
      End
      Begin Label Label2 
         Caption         =   "&Port:"
         Height          =   495
         Left            =   2040
         TabIndex        =   8
         Top             =   360
         Width           =   1215
      End
      Begin Label Label1 
         Caption         =   "&Address:"
         Height          =   495
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   1215
      End
   End
End

' IMPORTANT: We MUST use the API MessageBox function
' instead of the VB MsgBox function. See the PowerTCP
' README for more information.
Declare Function MessageBox Lib "User" (ByVal hWnd As Integer, ByVal lpText As String, ByVal lpCaption As String, ByVal wType As Integer) As Integer

Sub cmdConnect_Click ()
    ' Set the properties of the remote computer
    tcpConnectTo.RemoteHost = txtConnectToAddress.Text
    tcpConnectTo.RemotePort = Val(txtConnectToPort.Text)

    ' Make the connection
    tcpConnectTo.Action = CONNECTCOMM
End Sub

Sub cmdConnectFromClose_Click ()
    tcpConnectFrom.Action = CLOSECOMM
End Sub

Sub cmdConnectFromSend_Click ()
    tcpConnectFrom.Send = txtConnectFromSend.Text
End Sub

Sub cmdConnectToClose_Click ()
    tcpConnectTo.Action = CLOSECOMM
End Sub

Sub cmdConnectToSend_Click ()
    tcpConnectTo.Send = txtConnectToSend.Text
End Sub

Sub cmdExit_Click ()
    tcpConnectTo.Action = ABORTCOMM
    tcpListen.Action = ABORTCOMM
    tcpConnectFrom.Action = ABORTCOMM
    End
End Sub

Sub cmdListen_Click ()
    ' Set the mode of tcpListen to Listen
    tcpListen.LocalPort = Val(txtListenPort.Text)
    tcpListen.Action = LISTENCOMM
End Sub

Sub cmdStop_Click ()
    tcpListen.Action = CLOSECOMM
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub tcpConnectFrom_Connect ()
    cmdConnectFromClose.Enabled = True
    cmdConnectFromSend.Enabled = True
End Sub

Sub tcpConnectFrom_Exception (ErrorCode As Integer, ErrorDesc As String)
    ' An unexpected error occurred--
    ' notify the user and close the connection
    suc% = MessageBox(Me.hWnd, ErrorDesc, App.Title, 0)
    tcpConnectFrom.Action = CLOSECOMM
End Sub

Sub tcpConnectFrom_Recv (RecvData As String)
    If RecvData = "" Then
        suc% = MessageBox(Me.hWnd, "The connection was closed.", App.Title, 0)
        cmdConnectFromClose.Enabled = False
        cmdConnectFromSend.Enabled = False
    Else
        txtConnectFrom.Text = txtConnectFrom.Text & Chr$(13) & Chr$(10) & Format$(tcpConnectFrom.RemoteHost) & ":" & Chr$(9) & RecvData
    End If
End Sub

Sub tcpConnectFrom_Send (SendInstance As Long)
    ' Clear the text box to let the user know
    ' the data was sent
    txtConnectFrom.Text = txtConnectFrom.Text & Chr$(13) & Chr$(10) & "Me:" & Chr$(9) & txtConnectFromSend.Text
    txtConnectFromSend.Text = ""
End Sub

Sub tcpConnectTo_Connect ()
    ' Make the Connect button disabled,
    ' and the Close and Send buttons enabled.
    cmdConnect.Enabled = False
    cmdConnectToClose.Enabled = True
    cmdConnectToSend.Enabled = True
End Sub

Sub tcpConnectTo_Exception (ErrorCode As Integer, ErrorDesc As String)
    ' An unexpected error occurred--
    ' notify the user
    suc% = MessageBox(Me.hWnd, ErrorDesc, App.Title, 0)
End Sub

Sub tcpConnectTo_Recv (RecvData As String)
    If RecvData = "" Then
        ' The connection was closed
        cmdConnect.Enabled = True
        cmdConnectToClose.Enabled = False
        cmdConnectToSend.Enabled = False
        suc% = MessageBox(Me.hWnd, "The connection was closed.", App.Title, 0)
    Else
        txtConnectTo.Text = txtConnectTo.Text & Chr$(13) & Chr$(10) & Format$(tcpConnectTo.RemoteHost) & ":" & Chr$(9) & RecvData
    End If
End Sub

Sub tcpConnectTo_Send (SendInstance As Long)
    ' Clear the text box to let the user know
    ' the data was sent
    txtConnectTo.Text = txtConnectTo.Text & Chr$(13) & Chr$(10) & "Me:" & Chr$(9) & txtConnectToSend.Text
    txtConnectToSend.Text = ""
End Sub

Sub tcpListen_Accept (NewSession As Long)
    ' We must pass the connection on to tcpConnectFrom
    If tcpConnectFrom.State = CLOSED Then tcpConnectFrom.Session = NewSession
End Sub

Sub tcpListen_Exception (ErrorCode As Integer, ErrorDesc As String)
    ' An unexpected error occurred--
    ' notify the user and close the connection
    suc% = MessageBox(Me.hWnd, ErrorDesc, App.Title, 0)
    tcpListen.Action = CLOSECOMM
End Sub

Sub tcpListen_Listen ()
    ' Make the Listen button disabled,
    ' and the Stop button enabled.
    cmdListen.Enabled = False
    cmdStop.Enabled = True
End Sub

Sub tcpListen_Recv (RecvData As String)
    ' The connection was closed
    cmdStop.Enabled = False
    cmdListen.Enabled = True
    suc% = MessageBox(Me.hWnd, "Listening was stopped.", App.Title, 0)
End Sub

