/* **************************************************************
 *
 *
 *      C W _ M A I N 
 * 
 *
 * **************************************************************** */

#define  STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\ftp4w.h"
#include "resource.h"


/* user's defined messages */
#define  FTP_LOGGED          (WM_USER + 48)
#define  FTP_DIR             (WM_USER + 51)
#define  FTP_FILETRANSFERED  (WM_USER + 54)
#define  CW_VERBOSE          (WM_USER + 57)
#define  CW_BEGIN            (WM_USER + 60)
#define  SHORT_DIR            FALSE
#define  IsOptOn(x) (GetMenuState (GetMenu(hWnd),x,MF_BYCOMMAND)==MF_CHECKED)



int  nHorzSiz, nVertSiz;
int  nVertPos, nHorzPos;           // scroll pos for debug window
int  nHorzMax, nCurMsg;
int  nMaxMsg;
int  nHorzTab = 20;


char            szApplication[20]; /* name of application          */
HINSTANCE       hInst;             /* hInstance of application     */
HWND            hwnd;              /* hWnd of main window          */

BOOL            FirstEmission;
BOOL            bFileTransfer=FALSE; /* TRUE->data transfer in progress */


/* in main2 : gauge window */
void SetXmitBytes (LONG lBytes, LONG lTotalBytes);
void DeleteXferWindow (void);
void CreateXferWindow(void);
void SetXferWindowText (LPSTR lpStr);
int nCwRegisterClasses(void);
int nCwUnregisterClasses(void);
/* in main2 : scroller window */
int  Ecris(const char *szFormat,...);
void DoPrintf (char * szFormat, ...);
void DoPaint (HWND hwnd);
void DoAddLine (LPSTR szLine);                           
void ReleaseDisplayMem(void);

/* in this file */
int PASCAL FAR InitWindow (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                           LPSTR lpszCmdLine, int cmdShow);



// #define  WM_FTPDIR  (WM_USER+2)


LPSTR HOST_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "Host", "", szBuf,256, "cw_main.ini");
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field Host not defined in Cw_Main.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        

LPSTR USER_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "User", "", szBuf,256, "cw_main.ini");
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field User not defined in Cw_Main.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


LPSTR PASSWD_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Connect", "PassWd", "", szBuf,256, "cw_main.ini");
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field PassWd not defined in Cw_Main.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        
LPSTR LOCALFILE_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Transfer", "LocalFile", "",szBuf,256,"cw_main.ini");
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field LocalFile not defined in Cw_Main.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  
                        
                        
LPSTR REMOTEFILE_NAME(void) 
{
static char szBuf[256];
 GetPrivateProfileString ("Transfer", "RemoteFile", "",szBuf,256,"cw_main.ini");
  if (szBuf[0]==0)
    {
      MessageBox ( NULL,
                   "Field RemoteFile not defined in Cw_Main.Ini", 
                   "CW_MAIN", MB_OK);
      return NULL;
    }
  return szBuf; }  


long FileSize (LPSTR szFile)
{
HFILE hF;
long FS;
  hF = _lopen (szFile, 0);
  if (hF==HFILE_ERROR)  return 0;
  FS = _llseek (hF, 0, SEEK_END);
  _lclose (hF);
return FS;
} /* FileSize */


//*******************************************************************
LRESULT CALLBACK   MainWndProc (HWND hWnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
static char szBuf[10240];
int         Rc;
LPSTR       p, q;
HFILE       hF;

    switch (message)
    {
       case WM_CREATE :
          SetScrollPos (hWnd, SB_HORZ, 0, TRUE);
          SetScrollPos (hWnd, SB_VERT, 0, TRUE);
          SetScrollRange (hWnd, SB_HORZ, 0, 1, TRUE);
          SetScrollRange (hWnd, SB_VERT, 0, 1, TRUE);
          nVertPos = nHorzPos = nHorzMax = nCurMsg = 0;
          nMaxMsg = 80;
          nCwRegisterClasses();
          PostMessage (hWnd, CW_BEGIN, 0, 0);
          break;  



       case WM_VSCROLL:
          switch(wParam)
           {
            case SB_LINEDOWN     : if (nVertPos<(nCurMsg-(nVertSiz>>1))) nVertPos++;  break;
            case SB_LINEUP       : if (nVertPos>0) --nVertPos; break;
            case SB_THUMBPOSITION: nVertPos = min ((WORD) (nCurMsg-(nVertSiz>>1)), LOWORD (lParam)); break;
            case SB_PAGEUP       : nVertPos = (nVertPos>10) ? (nVertPos-10) : 0; break;
            case SB_PAGEDOWN     : nVertPos = (nVertPos<(nCurMsg-nVertSiz)) ? (nVertPos+nVertSiz) : nCurMsg-(nVertSiz>>1); break;
            default              : return 0L;
           } /* switch wParam */
          SetScrollPos (hWnd, SB_VERT, nVertPos, TRUE);
          InvalidateRect (hWnd, NULL, TRUE); 
          return 0L;

       case WM_HSCROLL:
          FtpAbort ();
          switch (wParam)
           {
            case SB_LINEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzTab)) ? (nHorzPos+nHorzTab) : nHorzMax; break;
            case SB_LINEUP       : nHorzPos = (nHorzPos>nHorzTab) ? (nHorzPos-nHorzTab) : 0; break;
            case SB_THUMBPOSITION: nHorzPos = min ((WORD) nHorzMax, LOWORD (lParam)); break;
            case SB_PAGEUP       : nHorzPos = (nHorzPos>nHorzSiz) ? (nHorzPos-nHorzSiz) : 0; break;
            case SB_PAGEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzSiz)) ? (nHorzPos+nHorzSiz) : nHorzMax; break;
            default              : return 0L;
           }
          SetScrollPos (hWnd, SB_HORZ, nHorzPos, TRUE);
          InvalidateRect (hWnd, NULL, TRUE); 
          return 0L;

      case WM_PAINT :
          DoPaint (hWnd);
          break;
          
   /* ---------------------------------------------------------- */

       case CW_BEGIN :
 DoAddLine ("----------------------------------------------------------------");
          DoAddLine ("Sample program For FTP4W.DLL By Ph. Jounin");
          DoAddLine ("Host description and file names must be defined");
          DoAddLine ("in the file CW_MAIN.INI as shown in the INI file");
          DoAddLine ("provided in the package FTP4W.ZIP.");
          DoAddLine (" ");
          DoAddLine ("Please report bugs and disfonctionments to");
          DoAddLine ("           ark@ifh.sncf.fr");
 DoAddLine ("----------------------------------------------------------------");

          /* initialize FTP sesson */  
          if (FtpInit(NULL) != FTPERR_OK)   Ecris ("FtpInit failed !");
          else
             {
                FtpSetDefaultTimeOut (30);       /* new Timeout : 30 seconds */
             }
          break;


      case WM_CLOSE : 
          if (! bFileTransfer  ||
              MessageBox (NULL, 
                          "Abort transfer", 
                          "CW_MAIN", MB_ICONQUESTION |
                           MB_OKCANCEL) == IDOK )
                  {
                     FtpLocalClose ();
                     FtpRelease ();
                     ReleaseDisplayMem();
                     PostQuitMessage (0);
                  }  
                return 0;
           break;  

      case WM_QUERYENDSESSION :
          FtpLocalClose ();
          FtpRelease ();
          ReleaseDisplayMem();
          DeleteXferWindow ();
          break;

      /* --------------------- */
      /* asynchronous Messages */
      /* --------------------- */
      case CW_VERBOSE :
          DoAddLine ((LPSTR) lParam);
          break;

      case FTP_LOGGED :
          Ecris ("Asynchronous Login returns %d", (int) lParam);
          break;

      case FTP_DIR :
          Ecris ("Dir returns %d", (int) lParam);
          Ecris ("-------");
          hF = _lopen ("$$dir$$.tmp", 0);
          _lread (hF, szBuf, sizeof szBuf);
          _lclose (hF);
          for (p=szBuf ; (q=strchr (p,'\r')) !=NULL ; p=q+2 )
              {  *q=0;
                  DoAddLine (p); }
          Ecris ("-------");
          unlink ("$$dir$$.tmp");
          break;


       case FTP_FILETRANSFERED :
          if (wParam)
            {
               DeleteXferWindow ();
               Ecris ("Asynchronous transfer returns %d", (int) lParam);
               bFileTransfer = FALSE;
            }
          else
            {
               SetXmitBytes (lParam, FtpBytesToBeTransfered ());
            }  
          break;
                

      /* --------------------- */
      /*     M   E   N   U     */
      /* --------------------- */
      case  WM_COMMAND :
        switch (wParam)
         {

           case  CW_CONNECT :
               Ecris ("--- Connection on %s  ---", HOST_NAME () );
               Rc = FtpLogin ( HOST_NAME (), 
                               USER_NAME (), 
                               PASSWD_NAME (),
                               hWnd, FTP_LOGGED);
               Ecris ("Function returns %d", Rc);                              
               break;

 
           case CW_RECV :
               Ecris ("Remote %s -> Local %s",REMOTEFILE_NAME (),LOCALFILE_NAME ());
               bFileTransfer = TRUE;
               if (IsOptOn(CW_GAUGE))
                 {
                    CreateXferWindow ();
                    SetXferWindowText (LOCALFILE_NAME());
                 }
               Rc = FtpRecvFile ( REMOTEFILE_NAME (),
                                  LOCALFILE_NAME (),
                                  IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                  IsOptOn(CW_GAUGE),
                                  hWnd, 
                                  FTP_FILETRANSFERED);
               if (! IsOptOn (CW_SYNC) )
                 {       
                    Ecris ("Taille %ld", FtpBytesToBeTransfered () );
                 }
               else
                {
                    DeleteXferWindow ();
                    Ecris ("Recv returns %d", Rc);
                    bFileTransfer = FALSE;
                }
               break;

        

           case CW_SEND :
               Ecris ("Local %s -> Remote %s",LOCALFILE_NAME (),REMOTEFILE_NAME ());
               bFileTransfer = TRUE;
               if (IsOptOn(CW_GAUGE))
                 {
                    CreateXferWindow ();
                    SetXferWindowText (LOCALFILE_NAME());
                 }
               Rc = FtpSendFile ( LOCALFILE_NAME (),
                                  REMOTEFILE_NAME (),
                                  IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A, 
                                  IsOptOn(CW_GAUGE),
                                  hWnd, 
                                  FTP_FILETRANSFERED);
               if (! IsOptOn (CW_SYNC) )
                 {       
                    Ecris ("Taille %ld", FtpBytesToBeTransfered () );
                 }
               else
                 {
                    DeleteXferWindow ();
                    Ecris ("Send returns %d", Rc);
                    bFileTransfer = FALSE;
                 }
               break;


           case CW_SHORTDIR :
           case CW_LONGDIR :
               Rc=FtpDir (NULL, "$$dir$$.tmp",wParam==CW_LONGDIR,hWnd,FTP_DIR);
               if (IsOptOn(CW_SYNC))  PostMessage (hWnd, FTP_DIR, TRUE, Rc);
               break;


           case CW_ABORT :
               if (! bFileTransfer)
                 {
                   Ecris ("No active file transfer");
                 }
               else
                 {
                    Ecris ("Abort");
                    FtpAbort ();
                 }
               break;  


           case CW_DISCONNECT : 
               if (bFileTransfer)
                  {
                     Ecris ("File transfer in progress, can not close session");
                  }
               else
                  {
                     Rc = FtpCloseConnection ();
                     Ecris ("FtpCloseConnection returns %d", Rc);
                  }
               break;


           case CW_QUIT : 
               if (! bFileTransfer  ||
                     MessageBox (NULL, 
                                "Abort transfer", 
                                "CW_MAIN", MB_ICONQUESTION |
                                 MB_OKCANCEL) == IDOK )
                     {
                        FtpLocalClose ();
                        ReleaseDisplayMem();
                        FtpRelease ();
                        PostQuitMessage (0);
                      }  
                     return 0;
                     
           case CW_SYNC : 
               if (bFileTransfer)
                 {
                   MessageBox (NULL, "Can not change now", "CW_MAIN", MB_OK);
                 }
               else
                 {
                   if (! IsOptOn (CW_SYNC))
                      {
                          CheckMenuItem (GetMenu (hWnd), CW_SYNC, 
                                         MF_BYCOMMAND  | MF_CHECKED);
                          FtpSetSynchronousMode ();
                       }
                   else   
                      {
                          CheckMenuItem (GetMenu (hWnd), CW_SYNC, 
                                         MF_BYCOMMAND  | MF_UNCHECKED);
                          FtpSetAsynchronousMode ();
                       }
                 }
               break;      
                     
           case CW_SETVERB :
               if (IsOptOn (CW_SETVERB))
                   
                 {                
                   CheckMenuItem (GetMenu (hWnd), CW_SETVERB, 
                                  MF_BYCOMMAND  | MF_UNCHECKED);
                   FtpSetVerboseMode (FALSE, hWnd, CW_VERBOSE);
                 }
               else
                 {                
                   CheckMenuItem (GetMenu (hWnd), CW_SETVERB, 
                                  MF_BYCOMMAND  | MF_CHECKED);
                   FtpSetVerboseMode (TRUE, hWnd, CW_VERBOSE);
                 }
               break; 


           case CW_GAUGE :
               CheckMenuItem (GetMenu (hWnd), CW_GAUGE, MF_BYCOMMAND  | 
                              IsOptOn(CW_GAUGE) ? MF_UNCHECKED : MF_CHECKED); 
               /* pause (for display) each 20 frames if gauge is on */
               if IsOptOn(CW_GAUGE)   FtpSetNewSlices(20, 5);
               else                   FtpSetNewSlices(50, 15);
               break; 
                
                
           case CW_BINARY :
               CheckMenuItem (GetMenu (hWnd), CW_BINARY, MF_BYCOMMAND  | 
                              IsOptOn(CW_BINARY) ? MF_UNCHECKED : MF_CHECKED);
               break; 
                
                
            } /* WM_COMMAND */

    default:
          return(DefWindowProc(hWnd, message, wParam, lParam));
    }
return TRUE;
} /* Boucle Windows */




/* ******************************************************************* */
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int cmdShow)
{
MSG   msg;
    // Go init this application, Change default Font
    FirstEmission = (hPrevInstance==NULL);
    
    InitWindow (hInstance, hPrevInstance, lpszCmdLine, cmdShow);
    /* Get and dispatch messages for this applicaton.*/
    while (GetMessage(&msg, NULL, 0, 0))
      {
        TranslateMessage(&msg);
        DispatchMessage(&msg);                  
      }
    UnregisterClass ("DLLCW", hInst);  
    UnregisterClass ("CW_Main", hInst);  
return(msg.wParam);
} /* WinMain */


/* ******************************************************************* */

int PASCAL FAR InitWindow (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                           LPSTR lpszCmdLine, int cmdShow)
{
WNDCLASS wndClass;

    hInst = hInstance;       /* save for use by window procs */
    strcpy (szApplication, "CW_Main");

    if (!hPrevInstance)     /* if no previous instance, this is first */
      {
        /* Get string from resource with application name. */
        /* Define the window class for this application. */
        wndClass.lpszClassName = szApplication;
        wndClass.hInstance     = hInstance;
        wndClass.lpfnWndProc   = MainWndProc;
        wndClass.hCursor       = LoadCursor(hInstance, IDC_ARROW);
        wndClass.hIcon         = LoadIcon  (hInstance, "CW_MAIN");
        wndClass.lpszMenuName  = "CW_MAIN";
        wndClass.hbrBackground = 1 + COLOR_WINDOW;
        // style : Redraw window if its vertcal size has been changed
        wndClass.style         = CS_VREDRAW | CS_HREDRAW;
        wndClass.cbClsExtra    = 0;
        wndClass.cbWndExtra    = 0;
     // Register the class
        RegisterClass(&wndClass);
      }
    hwnd = CreateWindow(
                    szApplication,     // window class name
                    szApplication,     // window title
                    WS_OVERLAPPEDWINDOW | WS_HSCROLL | WM_VSCROLL | WS_VISIBLE,
                    CW_USEDEFAULT,          // x - same as dialog box
                    CW_USEDEFAULT,          // y
                    470,                     // cx
                    250,                     // cy
                    NULL,                    // no parent for this window
                    NULL,                    // use the class menu
                    hInstance,               // who created this window
                    NULL                     // no parms to pass on
          );
    if (hwnd==NULL)  exit(0);
    ShowWindow (hwnd, cmdShow);
    UpdateWindow (hwnd);
return 0;
}  /* InitWindows */





