*** makeinfo.c	Mon Feb 12 23:03:17 1996
--- makertf.c	Tue Feb 13 23:00:16 1996
***************
*** 29,34 ****
--- 29,42 ----
  
     Makeinfo is authored by Brian Fox (bfox@ai.mit.edu). */
  
+ /* Define RTF_OUTPUT, if you want to create RTF files. */
+ #define RTF_OUTPUT
+ 
+ #ifdef RTF_OUTPUT
+ /* Code in `RTF_OUTPUT' sections:
+    Copyright (C) 1994-96 Christian Schenk (cschenk@berlin.snafu.de). */
+ #endif
+ 
  /* You can change some of the behaviour of Makeinfo by changing the
     following defines: */
  
***************
*** 60,65 ****
--- 68,91 ----
     facility, users can create their own command procedures with arguments. */
  #define HAVE_MACROS
  
+ #ifdef RTF_OUTPUT
+ #define _quarter_inch   (_one_inch / 4)
+ #define _half_inch      (_one_inch / 2)
+ #define _one_inch       1440
+ #define _two_inches     (2 * _one_inch)
+ 
+ #define RTF_FONT_NORMAL         0
+ #define RTF_FONT_FIXED_WIDTH    1
+ 
+ #define MENU_INDENTATION                 _two_inches
+ #define TABLE_INDENTATION_INCREMENT      _half_inch
+ #define ITEM_PRE_INCREMENT               (_half_inch / 5)
+ #define ITEM_INDENTATION_INCREMENT       _half_inch
+ #define ENUM_PRE_INCREMENT               (_half_inch / 5)
+ #define ENUM_INDENTATION_INCREMENT       _half_inch
+ #define EXAMPLE_INDENTATION_INCREMENT    _half_inch
+ #endif /* RTF_OUTPUT */
+ 
  /* **************************************************************** */
  /*								    */
  /*			Include File Declarations       	    */
***************
*** 75,81 ****
--- 101,109 ----
  #include <sys/types.h>
  #include <ctype.h>
  #include <sys/stat.h>
+ #if ! defined (_WIN32)
  #include <pwd.h>
+ #endif
  #include <errno.h>
  
  #if defined (HAVE_VARARGS_H)
***************
*** 119,127 ****
--- 147,159 ----
  #if defined(HAVE_ALLOCA_H)
  #include <alloca.h>
  #else /* !HAVE_ALLOCA_H */
+ #if defined (_WIN32)
+ #define alloca _alloca
+ #else
  #if !defined (_AIX)
  extern char *alloca ();
  #endif /* !_AIX */
+ #endif
  #endif /* !HAVE_ALLOCA_H */
  #endif /* !__GNUC__ */
  
*************** struct passwd *getpwnam ();
*** 239,245 ****
--- 271,281 ----
  /* Stuff for splitting large files. */
  #define SPLIT_SIZE_THRESHOLD 70000  /* What's good enough for Stallman... */
  #define DEFAULT_SPLIT_SIZE 50000    /* Is probably good enough for me. */
+ #ifdef RTF_OUTPUT
+ int splitting = 0;		    /* We want a single RTF file. */
+ #else
  int splitting = 1;		    /* Always true for now. */
+ #endif
  
  typedef void COMMAND_FUNCTION (); /* So I can say COMMAND_FUNCTION *foo; */
  
*************** char *pretty_output_filename;
*** 299,304 ****
--- 335,346 ----
     Such a name overrides any name found with the @setfilename command. */
  char *command_output_filename = (char *)NULL;
  
+ #ifdef RTF_OUTPUT
+ /* Name of the help project file that the user elected to pass on the
+    command line. */
+ char *command_hpj_filename = (char *)NULL;
+ #endif
+ 
  /* A colon separated list of directories to search for files included
     with @include.  This can be controlled with the `-I' option to makeinfo. */
  char *include_files_path = (char *)NULL;
*************** int non_splitting_words = 0;
*** 336,346 ****
--- 378,407 ----
  int indented_fill = 0;
  
  /* The column at which long lines are broken. */
+ #ifdef RTF_OUTPUT
+ int fill_column = 30000;	/* Do not break lines. WinHelp does it. */
+ #else
  int fill_column = 72;
+ #endif
  
  /* The amount of indentation to apply at the start of each line. */
  int current_indent = 0;
  
+ #ifdef RTF_OUTPUT
+ int rtf_font = 0;               /* The font for the current paragraph. */
+ int rtf_current_font = 0;       /* The font we are using right now.  */
+ int rtf_li = 0;                 /* Current paragraph indentation. */
+ int rtf_fi = 0;                 /* Indentation of first line in paragraph. */
+ int rtf_fs = 20;                /* Font size. */
+ int rtf_tab_stops[10];          /* Tab stop positions. */
+ int rtf_n_tab_stops = 0;        /* Number of tab stop positions. */
+ int in_non_scrolling_region = 0; /* >0 means we are assembling the node line. */
+ int in_index_entry = 0; /* >0 means we are making an index entry. */
+ int imprint_printed = 0; /* >0 means we have printed the title page. */
+ char *author_name = 0; /* 'and' seperated list of authors/ */
+ char *doc_title = 0; /* Document title. */
+ #endif /* RTF_OUTPUT */
+ 
  /* The amount of indentation to add at the starts of paragraphs.
     0 means don't change existing indentation at paragraph starts.
     > 0 is amount to indent new paragraphs by.
*************** void
*** 618,623 ****
--- 679,688 ----
    cm_flushright (), cm_smalllisp (), cm_finalout (), cm_math (),
    cm_cartouche (), cm_ignore_sentence_ender ();
  
+ #ifdef RTF_OUTPUT
+ void cm_settitle (), cm_t (), cm_ktable (), cm_ref ();
+ #endif
+ 
  /* Conditionals. */
  void cm_set (), cm_clear (), cm_ifset (), cm_ifclear ();
  void cm_value (), cm_ifeq ();
*************** static COMMAND CommandTable[] = {
*** 776,781 ****
--- 841,849 ----
    { "kbd", cm_kbd, BRACE_ARGS },
    { "key", cm_key, BRACE_ARGS },
    { "kindex", cm_kindex, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "ktable", cm_ktable, NO_BRACE_ARGS },
+ #endif
    { "lowersections", cm_lowersections, NO_BRACE_ARGS },
    { "lisp", cm_lisp, NO_BRACE_ARGS },
  #if defined (HAVE_MACROS)
*************** static COMMAND CommandTable[] = {
*** 800,806 ****
--- 868,878 ----
    { "quotation", cm_quotation, NO_BRACE_ARGS },
    { "r", cm_roman, BRACE_ARGS },
    { "raisesections", cm_raisesections, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "ref", cm_ref, BRACE_ARGS },
+ #else
    { "ref", cm_xref, BRACE_ARGS },
+ #endif
    { "refill", cm_refill, NO_BRACE_ARGS },
    { "result", cm_result, BRACE_ARGS },
    { "samp", cm_samp, BRACE_ARGS },
*************** static COMMAND CommandTable[] = {
*** 810,816 ****
--- 882,892 ----
    { "setchapternewpage", cm_ignore_line, NO_BRACE_ARGS },
    { "setchapterstyle", cm_ignore_line, NO_BRACE_ARGS },
    { "setfilename", cm_setfilename, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "settitle", cm_settitle, NO_BRACE_ARGS },
+ #else
    { "settitle", cm_ignore_line, NO_BRACE_ARGS },
+ #endif
    { "shortcontents", do_nothing, NO_BRACE_ARGS },
    { "shorttitlepage", cm_ignore_line, NO_BRACE_ARGS },
    { "smallbook", cm_ignore_line, NO_BRACE_ARGS },
*************** static COMMAND CommandTable[] = {
*** 826,832 ****
--- 902,912 ----
    { "summarycontents", do_nothing, NO_BRACE_ARGS },
    { "syncodeindex", cm_synindex, NO_BRACE_ARGS },
    { "synindex", cm_synindex, NO_BRACE_ARGS },
+ #ifdef RTF_OUTPUT
+   { "t", cm_t, BRACE_ARGS },
+ #else
    { "t", cm_title, BRACE_ARGS },
+ #endif
    { "table", cm_table, NO_BRACE_ARGS },
    { "tex", command_name_condition, NO_BRACE_ARGS },
    { "tindex", cm_tindex, NO_BRACE_ARGS },
*************** static COMMAND CommandTable[] = {
*** 877,888 ****
--- 957,974 ----
  int major_version = 1;
  int minor_version = 64;
  
+ #if defined (RTF_OUTPUT)
+ #define makertf_version_string "1.04"
+ #endif
+ 
  struct option long_options[] =
  {
    { "error-limit", 1, 0, 'e' },			/* formerly -el */
    { "fill-column", 1, 0, 'f' },			/* formerly -fc */
    { "footnote-style", 1, 0, 's' },		/* formerly -ft */
+ #ifndef RTF_OUTPUT
    { "no-headers", 0, &no_headers, 1 },		/* Do not output Node: foo */
+ #endif
    { "no-pointer-validate", 0, &validating, 0 }, /* formerly -nv */
    { "no-validate", 0, &validating, 0 },		/* formerly -nv */
    { "no-split", 0, &splitting, 0 },		/* formerly -ns */
*************** struct option long_options[] =
*** 896,901 ****
--- 982,990 ----
    { "paragraph-indent", 1, 0, 'p' },		/* formerly -pi */
    { "reference-limit", 1, 0, 'r' },		/* formerly -rl */
    { "verbose", 0, &verbose_mode, 1 },		/* formerly -verbose */
+ #ifdef RTF_OUTPUT
+   { "hpj", 1, 0, 'J' },
+ #endif
    { "help", 0, 0, 'h' },
    { "version", 0, 0, 'V' },
    {NULL, 0, NULL, 0}
*************** main (argc, argv)
*** 932,940 ****
--- 1021,1037 ----
    while ((c = getopt_long
  	  (argc, argv,
  #if defined (HAVE_MACROS)
+ #if defined (RTF_OUTPUT)
+ 	   "D:E:U:I:J:f:o:p:e:r:s:V",
+ #else
  	   "D:E:U:I:f:o:p:e:r:s:V",
+ #endif
+ #else
+ #if defined (RTF_OUTPUT)
+ 	   "D:U:I:J:f:o:p:e:r:s:V",
  #else
  	   "D:U:I:f:o:p:e:r:s:V",
+ #endif
  #endif /* !HAVE_MACROS */
  	   long_options, &ind))
  	 != EOF)
*************** main (argc, argv)
*** 1012,1017 ****
--- 1109,1121 ----
  	  footnote_style_preset = 1;
  	  break;
  
+ #ifdef RTF_OUTPUT
+ 	  /* User specified help project file? */
+ 	case 'J':
+ 	  command_hpj_filename = strdup (optarg);
+ 	  break;
+ #endif
+ 
  	case 'h':
  	  usage (stdout, NO_ERROR);
  	  break;
*************** main (argc, argv)
*** 1074,1081 ****
--- 1178,1191 ----
  void
  print_version_info ()
  {
+ #ifdef RTF_OUTPUT
+   printf ("This is Makertf version %s (GNU Makeinfo version %d.%d).\n",
+ 	  makertf_version_string,
+ 	  major_version, minor_version);
+ #else
    printf ("This is GNU Makeinfo version %d.%d, from texinfo-3.7.\n",
  	  major_version, minor_version);
+ #endif
  }
  
  /* **************************************************************** */
*************** usage (stream, exit_value)
*** 1152,1157 ****
--- 1262,1303 ----
       FILE *stream;
       int exit_value;
  {
+ #ifdef RTF_OUTPUT
+   fprintf (stream, "Usage: %s [options] texinfo-file...\n\
+ \n\
+ This program accepts as input files of texinfo commands and text\n\
+ and outputs a file in rich-text format (RTF).\n\
+ \n\
+ Options:\n\
+ `-I DIR'              add DIR to the directory search list for including\n\
+                       files with the `@include' command.\n\
+ -D VAR                define a variable, as with `@set'.\n\
+ -U VAR                undefine a variable, as with `@clear'.\n\
+ --no-validate         suppress node cross reference validation.\n\
+ --no-warn             suppress warning messages (errors are still output).\n\
+ --verbose             print information about what is being done.\n\
+ --version             print the version number of Makertf.\n\
+ --output FILE or -o FILE\n\
+                       specify the output file.  When you specify the\n\
+                       output file in this way, any `@setfilename' in the\n\
+                       input file is ignored.\n\
+ --paragraph-indent NUM\n\
+                       set the paragraph indent to NUM (default %d).\n\
+ --fill-column NUM     set the filling column to NUM (default %d).\n\
+ --error-limit NUM     set the error limit to NUM (default %d).\n\
+ --reference-limit NUM\n\
+                       set the reference warning limit to NUM (default %d).\n\
+ --footnote-style STYLE\n\
+                       set the footnote style to STYLE.  STYLE should\n\
+                       either be `separate' to place footnotes in their own\n\
+                       node (the default), or `end', to place the footnotes\n\
+                       at the end of the node in which they are defined.\n\
+ --hpj FILE or -J FILE\n\
+                       specify the help project file.\n\
+ --help                print this message and exit.\n\n",
+ 	   progname, paragraph_start_indent,
+ 	   fill_column, max_error_level, reference_warning_limit);
+ #else
    fprintf (stream, "Usage: %s [options] texinfo-file...\n\
  \n\
  This program accepts as input files of texinfo commands and text\n\
*************** Options:\n\
*** 1187,1192 ****
--- 1333,1339 ----
  --help                print this message and exit.\n\n",
  	   progname, paragraph_start_indent,
  	   fill_column, max_error_level, reference_warning_limit);
+ #endif
    exit (exit_value);
  }
  
*************** find_and_load (filename)
*** 1248,1254 ****
--- 1395,1405 ----
    filename = fullpath;
    file_size = (long) fileinfo.st_size;
  
+ #if defined (MSDOS) || defined (_WIN32)
+   file = open (filename, O_RDONLY | O_TEXT);
+ #else /* !MSDOS */
    file = open (filename, O_RDONLY);
+ #endif /* !MSDOS */
    if (file < 0)
      goto error_exit;
  
*************** find_and_load (filename)
*** 1259,1272 ****
       readable bytes is always less than this value.  The arcane
       mysteries of VMS/RMS are too much to probe, so this hack
      suffices to make things work. */
! #if defined (VMS)
    while ((n = read (file, result + count, file_size)) > 0)
      count += n;
    if (n == -1)
! #else /* !VMS */
      count = file_size;
      if (read (file, result, file_size) != file_size)
! #endif /* !VMS */
    error_exit:
      {
        if (result)
--- 1410,1428 ----
       readable bytes is always less than this value.  The arcane
       mysteries of VMS/RMS are too much to probe, so this hack
      suffices to make things work. */
! #if defined (VMS) || defined (MSDOS)
    while ((n = read (file, result + count, file_size)) > 0)
      count += n;
    if (n == -1)
! #else /* !VMS && !MSDOS */
! #if defined (_WIN32)
!   count = read (file, result + count, file_size);
!   if (count == -1)
! #else /* !_WIN32 */
      count = file_size;
      if (read (file, result, file_size) != file_size)
! #endif /* !_WIN32 */
! #endif /* !VMS && !MSDOS */
    error_exit:
      {
        if (result)
*************** push_node_filename ()
*** 1378,1384 ****
--- 1534,1544 ----
        else
  	node_filename_stack =
  	  (char **)xrealloc (node_filename_stack,
+ #ifdef RTF_OUTPUT
+ 			     (node_filename_stack_size += 10)
+ #else
  			     (node_filename_stack_size + 10)
+ #endif
  			     * sizeof (char *));
      }
  
*************** expand_filename (filename, input_name)
*** 1490,1499 ****
--- 1650,1666 ----
        if (!i)
  	i = strlen (filename);
  
+ #ifdef RTF_OUTPUT
+       if (i + 5 > (strlen (filename)))
+ 	filename = (char *)xrealloc (filename, i + 5);
+       strcpy (filename + i, ".rtf");
+       return (filename);
+ #else
        if (i + 6 > (strlen (filename)))
  	filename = (char *)xrealloc (filename, i + 6);
        strcpy (filename + i, ".info");
        return (filename);
+ #endif
      }
  	
    if (filename[0] == '.' || filename[0] == '/')
*************** full_pathname (filename)
*** 1583,1588 ****
--- 1750,1756 ----
  	}
        else
  	{
+ #if ! defined (_WIN32)
  	  struct passwd *user_entry;
  	  int i, c;
  	  char *username = (char *)xmalloc (257);
*************** full_pathname (filename)
*** 1606,1611 ****
--- 1774,1780 ----
  				    + strlen (&filename[i]));
  	  strcpy (result, user_entry->pw_dir);
  	  strcat (result, &filename[i]);
+ #endif
  	}
      }
    return (result);
*************** convert_from_loaded_file (name)
*** 2130,2135 ****
--- 2299,2308 ----
    remember_itext (input_text, 0);
  #endif /* HAVE_MACROS */
  
+ #ifdef RTF_OUTPUT
+   preprocess ();
+ #endif
+ 
    /* Search this file looking for the special string which starts conversion.
       Once found, we may truly begin. */
    input_text_offset = 0;
*************** convert_from_loaded_file (name)
*** 2214,2220 ****
--- 2387,2397 ----
      }
  
    if (output_stream != stdout)
+ #ifdef RTF_OUTPUT
+     printf ("Making RTF file `%s' from `%s'.\n", output_filename, name);
+ #else
      printf ("Making info file `%s' from `%s'.\n", output_filename, name);
+ #endif
  
    if (output_stream == NULL)
      {
*************** convert_from_loaded_file (name)
*** 2241,2252 ****
--- 2418,2433 ----
  	line_number++;
    }
  
+ #ifdef RTF_OUTPUT
+   start_rtf_file ();
+ #else
    if (!no_headers)
      {
        add_word_args ("This is Info file %s, produced by Makeinfo-%d.%d from ",
  		     output_filename, major_version, minor_version);
        add_word_args ("the input file %s.\n", input_filename);
      }
+ #endif
  
    close_paragraph ();
    reader_loop ();
*************** finished:
*** 2267,2276 ****
--- 2448,2467 ----
        if (tag_table != NULL)
  	{
  	  tag_table = (TAG_ENTRY *) reverse_list (tag_table);
+ #ifdef RTF_OUTPUT
+ 	  /* We do not need a tag table. */
+ #else
  	  if (!no_headers)
  	    write_tag_table ();
+ #endif
  	}
  
+ #ifdef RTF_OUTPUT
+       end_rtf_file ();
+       if (command_hpj_filename)
+ 	write_help_project_file (command_hpj_filename, real_output_filename);
+ #endif
+ 
        if (output_stream != stdout)
  	fclose (output_stream);
  
*************** reader_loop ()
*** 2401,2406 ****
--- 2592,2606 ----
  		 gauranteed to be NULL when glean_node_from_menu () is
  		 called with a non-zero argument. */
  	      tem = glean_node_from_menu (1);
+ #ifdef RTF_OUTPUT
+ 	      /* Process this menu entry... */
+ 	      /* add_char ('\n'); */
+ 	      input_text_offset++;
+ 	      process_menu_line ();
+ 
+ 	      /* ...then continue the reader loop. */
+ 	      continue;
+ #endif
  	    }
  	}
  
*************** add_char (character)
*** 2753,2759 ****
--- 2953,2967 ----
      case '\n':
        if (!filling_enabled)
  	{
+ #ifdef RTF_OUTPUT
+ 	  extern int printing_index;
+ 	  if (in_menu || in_non_scrolling_region || printing_index)
+ 	    inserts ("\\par\n");
+ 	  else
+ 	    inserts ("\\line\n");
+ #else
  	  insert ('\n');
+ #endif
  
  	  if (force_flush_right)
  	    {
*************** add_char (character)
*** 2863,2868 ****
--- 3071,3079 ----
  			    }
  			}
  
+ #ifdef RTF_OUTPUT
+ 			/* We do not break lines. WinHelp does it. */
+ #else
  			/* Filled, but now indent if that is right. */
  			if (indented_fill && current_indent)
  			  {
*************** add_char (character)
*** 2896,2901 ****
--- 3107,3113 ----
  			    output_paragraph_offset += current_indent;
  			    free (temp_buffer);
  			  }
+ #endif
  			output_column = 0;
  			while (temp < output_paragraph_offset)
  			  output_column +=
*************** add_char (character)
*** 2909,2915 ****
--- 3121,3143 ----
  
  	if (!suppress_insert)
  	  {
+ #ifdef RTF_OUTPUT
+ 	    /* Some characters have to be written as escape sequences since
+ 	       they have special meaning in RTF. */
+ 	    if (character == '{' || character == '}' || character == '\\'
+ 		|| (! isascii (character)
+ 		    && character != (unsigned char)(' ' | 0x80)
+ 		    && character != (unsigned char)('\t' | 0x80)
+ 		    && character != (unsigned char)('\n' | 0x80)
+ 		    && ! sentence_ender (UNMETA (character))))
+ 	      vinserts ("\\'%02X", (int) (character & 0xff));
+ 	    else if (character == '\f')	/* This can happen! */
+ 	      inserts ("^L");
+ 	    else
+ 	      insert (character);
+ #else
  	    insert (character);
+ #endif
  	    last_inserted_character = character;
  	  }
  	last_char_was_newline = 0;
*************** flush_output ()
*** 2987,2994 ****
--- 3215,3226 ----
  
    for (i = 0; i < output_paragraph_offset; i++)
      {
+ #ifdef RTF_OUTPUT
+       output_paragraph[i] = UNMETA (output_paragraph[i]);
+ #else
        if (output_paragraph[i] == (unsigned char)(' ' | 0x80))
  	output_paragraph[i] &= 0x7f;
+ #endif
      }
  
    fwrite (output_paragraph, 1, output_paragraph_offset, output_stream);
*************** close_paragraph ()
*** 3093,3106 ****
--- 3325,3362 ----
        output_paragraph_offset = ++tindex;
  
        /* Break the line if that is appropriate. */
+ #ifdef RTF_OUTPUT      
+       if (paragraph_spacing >= 0) 
+ 	{
+ 	  if (output_paragraph_offset >= 5
+ 	      && strncmp (&output_paragraph[output_paragraph_offset-5],
+ 			  "\\line", 5) == 0)
+ 	    {
+ 	      output_paragraph_offset -= 5;
+ 	    }
+ 
+ 	  if (! in_non_scrolling_region)
+ 	    inserts ("\\par");
+ 	  insert ('\n');
+ 	}
+ #else
        if (paragraph_spacing >= 0)
  	insert ('\n');
+ #endif
  
        /* Add as many blank lines as is specified in PARAGRAPH_SPACING. */
        if (!force_flush_right)
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (! in_non_scrolling_region)
+ 	    {
+ 	      for (i = 0; i < (paragraph_spacing - line_already_broken); i++)
+ 		inserts ("\\par\n");
+ 	    }
+ #else
  	  for (i = 0; i < (paragraph_spacing - line_already_broken); i++)
  	    insert ('\n');
+ #endif
  	}
  
        /* If we are doing flush right indentation, then do it now
*************** do_flush_right_indentation ()
*** 3135,3140 ****
--- 3391,3398 ----
  
    if (output_paragraph[0] != '\n')
      {
+ #ifdef RTF_OUTPUT
+ #else
        output_paragraph[output_paragraph_offset] = '\0';
  
        if (output_paragraph_offset < fill_column)
*************** do_flush_right_indentation ()
*** 3157,3162 ****
--- 3415,3421 ----
  	  free (temp);
  	  output_paragraph_offset = fill_column;
  	}
+ #endif
      }
  }
  
*************** start_paragraph ()
*** 3201,3206 ****
--- 3460,3503 ----
  	      indent (amount_to_indent);
  	      output_column += amount_to_indent;
  	    }
+ 
+ #ifdef RTF_OUTPUT
+ 	  if (in_non_scrolling_region)
+ 	    {
+ 	      warning ("%cnode should be followed by a sectioning command",
+ 		       COMMAND_PREFIX);
+ 	      inserts ("\\par\n");
+ 	      if (! imprint_printed)
+ 		imprint ();
+ 	      in_non_scrolling_region = 0;
+ 	    }
+ 
+ 	  /* Set paragraph properties. */
+ 	  vinserts ("\\pard");
+ 	  if (force_flush_right)
+ 	    inserts ("\\qr");
+ 	  if (! filling_enabled && in_fixed_width_font)
+ 	    inserts ("\\keep");
+ 	  if (rtf_fi != 0)
+ 	    vinserts ("\\fi%d", rtf_fi);
+ 	  if (rtf_li != 0)
+ 	    vinserts ("\\li%d", rtf_li);
+ 
+ 	  /* Set tab stops. */
+ 	  {
+ 	    int i;
+ 	    for (i=0; i<rtf_n_tab_stops; i++)
+ 	      vinserts ("\\tx%d", rtf_tab_stops[i]);
+ 	  }
+ 
+ 	  /* Set the current font. */
+ 	  if (rtf_current_font != rtf_font)
+ 	    {
+ 	      rtf_current_font = rtf_font;
+ 	      vinserts ("\\f%d", rtf_font);
+ 	    }
+ 	  inserts ("{}");
+ #endif
  	}
      }
    else
*************** indent (amount)
*** 3223,3230 ****
--- 3520,3531 ----
        elt = elt->next;
      }
  
+ #ifdef RTF_OUTPUT
+   /* We use tab stops. */
+ #else
    while (--amount >= 0)
      insert (' ');
+ #endif
  }
  
  /* Search forward for STRING in input_text.
*************** search_forward (string, from)
*** 3248,3257 ****
--- 3549,3566 ----
  /* Whoops, Unix doesn't have strcasecmp. */
  
  /* Case independent string compare. */
+ #if defined (_WIN32)
+ #define strcasecmp strcmpi
+ #define HAVE_STRCASECMP
+ #endif
  #if !defined (HAVE_STRCASECMP)
  int
  strcasecmp (string1, string2)
+ #ifdef RTF_OUTPUT
+      const char *string1, *string2;
+ #else
       char *string1, *string2;
+ #endif
  {
    char ch1, ch2;
  
*************** enum insertion_type { menu, quotation, l
*** 3277,3283 ****
    ftable, vtable, group, ifinfo, flushleft, flushright, ifset, ifclear, deffn,
    defun, defmac, defspec, defvr, defvar, defopt, deftypefn,
    deftypefun, deftypevr, deftypevar, defcv, defivar, defop, defmethod,
!   deftypemethod, deftp, bad_type };
  
  char *insertion_type_names[] = { "menu", "quotation", "lisp",
    "smalllisp", "example", "smallexample", "display", "itemize",
--- 3586,3596 ----
    ftable, vtable, group, ifinfo, flushleft, flushright, ifset, ifclear, deffn,
    defun, defmac, defspec, defvr, defvar, defopt, deftypefn,
    deftypefun, deftypevr, deftypevar, defcv, defivar, defop, defmethod,
!   deftypemethod, deftp,
! #ifdef RTF_OUTPUT
!   ktable,
! #endif
! bad_type };
  
  char *insertion_type_names[] = { "menu", "quotation", "lisp",
    "smalllisp", "example", "smallexample", "display", "itemize",
*************** char *insertion_type_names[] = { "menu",
*** 3286,3291 ****
--- 3599,3607 ----
    "defun", "defmac", "defspec", "defvr", "defvar", "defopt",
    "deftypefn", "deftypefun", "deftypevr", "deftypevar", "defcv",
    "defivar", "defop", "defmethod", "deftypemethod", "deftp",
+ #ifdef RTF_OUTPUT
+   "ktable",
+ #endif
    "bad_type" };
  
  int insertion_level = 0;
*************** typedef struct istack_elt
*** 3299,3304 ****
--- 3615,3628 ----
    int indented_fill;
    enum insertion_type insertion;
    int inhibited;
+ #ifdef RTF_OUTPUT
+   int rtf_li;			/* Left indent. */
+   int rtf_fi;			/* First indent. */
+   int rtf_tab_stops[10];	/* Tab stops. */
+   int rtf_n_tab_stops;		/* Number of tab stops. */
+   int rtf_font;			/* Font. */
+   int rtf_fs;			/* Font size. */
+ #endif /* RTF_OUTPUT */
  } INSERTION_ELT;
  
  INSERTION_ELT *insertion_stack = (INSERTION_ELT *) NULL;
*************** push_insertion (type, item_function)
*** 3380,3385 ****
--- 3704,3717 ----
    new->line_number = line_number;
    new->filename = strdup (input_filename);
    new->inhibited = inhibit_paragraph_indentation;
+ #ifdef RTF_OUTPUT
+   new->rtf_li = rtf_li;
+   new->rtf_fi = rtf_fi;
+   memcpy (new->rtf_tab_stops, rtf_tab_stops, sizeof (new->rtf_tab_stops));
+   new->rtf_n_tab_stops = rtf_n_tab_stops;
+   new->rtf_font = rtf_font;
+   new->rtf_fs = rtf_fs;
+ #endif /* RTF_OUTPUT */
    new->next = insertion_stack;
    insertion_stack = new;
    insertion_level++;
*************** pop_insertion ()
*** 3398,3403 ****
--- 3730,3743 ----
    inhibit_paragraph_indentation = temp->inhibited;
    filling_enabled = temp->filling_enabled;
    indented_fill = temp->indented_fill;
+ #ifdef RTF_OUTPUT
+   rtf_li = temp->rtf_li;
+   rtf_fi = temp->rtf_fi;
+   memcpy (rtf_tab_stops, temp->rtf_tab_stops, sizeof (rtf_tab_stops));
+   rtf_n_tab_stops = temp->rtf_n_tab_stops;
+   rtf_font = temp->rtf_font;
+   rtf_fs = temp->rtf_fs;
+ #endif /* RTF_OUTPUT */
    free_and_clear (&(temp->item_function));
    free_and_clear (&(temp->filename));
    insertion_stack = insertion_stack->next;
*************** enumerate_item ()
*** 3512,3517 ****
--- 3852,3861 ----
  {
    char temp[10];
  
+ #ifdef RTF_OUTPUT
+   inserts ("\\tab{}");		/* Pre-Increment. */
+ #endif
+ 
    if (current_enumtype == ENUM_ALPHA)
      {
        if (current_enumval == ('z' + 1) || current_enumval == ('Z' + 1))
*************** enumerate_item ()
*** 3519,3531 ****
--- 3863,3886 ----
  	  current_enumval = ((current_enumval - 1) == 'z' ? 'a' : 'A');
  	  warning ("Lettering overflow, restarting at %c", current_enumval);
  	}
+ #ifdef RTF_OUTPUT
+       sprintf (temp, "%c.", current_enumval);
+ #else
        sprintf (temp, "%c. ", current_enumval);
+ #endif
      }
    else
+ #ifdef RTF_OUTPUT
+     sprintf (temp, "%d.", current_enumval);
+ #else
      sprintf (temp, "%d. ", current_enumval);
+ #endif
  
    indent (output_column += (current_indent - strlen (temp)));
    add_word (temp);
+ #ifdef RTF_OUTPUT
+   inserts ("\\tab{}");		/* Post-Increment. */
+ #endif
    current_enumval++;
  }
  
*************** begin_insertion (type)
*** 3546,3551 ****
--- 3901,3910 ----
    else
      push_insertion (type, get_item_function ());
  
+ #ifdef RTF_OUTPUT
+   inserts ("{");
+ #endif
+ 
    switch (type)
      {
      case menu:
*************** begin_insertion (type)
*** 3555,3562 ****
--- 3914,3929 ----
        filling_enabled = no_indent = 0;
        inhibit_paragraph_indentation = 1;
  
+ #ifdef RTF_OUTPUT
+       rtf_li = MENU_INDENTATION;
+       rtf_fi = -MENU_INDENTATION;
+       rtf_n_tab_stops = 1;
+       rtf_tab_stops[0] = rtf_li;
+       add_word ("* Menu:\n");
+ #else
        if (!no_headers)
  	add_word ("* Menu:\n");
+ #endif
  
        in_menu++;
        no_discard++;
*************** begin_insertion (type)
*** 3570,3575 ****
--- 3937,3945 ----
        indented_fill = filling_enabled = 1;
        inhibit_paragraph_indentation = 1;
        current_indent += default_indentation_increment;
+ #ifdef RTF_OUTPUT
+       rtf_li += EXAMPLE_INDENTATION_INCREMENT;
+ #endif
        break;
  
      case display:
*************** begin_insertion (type)
*** 3589,3598 ****
--- 3959,3977 ----
        if (type != format)
  	current_indent += default_indentation_increment;
  
+ #ifdef RTF_OUTPUT
+       rtf_font = RTF_FONT_FIXED_WIDTH;
+       if (type != format)
+ 	rtf_li += EXAMPLE_INDENTATION_INCREMENT;
+ #endif
+ 
        break;
  
      case table:
      case ftable:
+ #ifdef RTF_OUTPUT
+     case ktable:
+ #endif
      case vtable:
      case itemize:
        close_single_paragraph ();
*************** begin_insertion (type)
*** 3620,3625 ****
--- 3999,4024 ----
  	  line_error ("%s requires an argument: the formatter for %citem",
  		      insertion_type_pname (type), COMMAND_PREFIX);
  	}
+ 
+ #ifdef RTF_OUTPUT
+       if (type == itemize)
+ 	{
+ 	  rtf_li += ITEM_INDENTATION_INCREMENT;
+ #if 0
+ 	  rtf_fi = -ITEM_INDENTATION_INCREMENT;
+ 	  rtf_n_tab_stops = 2;
+ 	  rtf_tab_stops[0] = (rtf_li
+ 			      - ITEM_INDENTATION_INCREMENT
+ 			      + ITEM_PRE_INCREMENT);
+ 	  rtf_tab_stops[1] = rtf_li;
+ #endif
+ 	}
+       else
+ 	{
+ 	  rtf_li += TABLE_INDENTATION_INCREMENT;
+ 	  rtf_fi = 0;
+ 	}
+ #endif /* RTF_OUTPUT */
        break;
  
      case enumerate:
*************** begin_insertion (type)
*** 3638,3643 ****
--- 4037,4054 ----
  	start_enumerating (atoi (enumeration_arg), ENUM_DIGITS);
        else
  	start_enumerating (*enumeration_arg, ENUM_ALPHA);
+ 
+ #ifdef RTF_OUTPUT
+       rtf_li += ENUM_INDENTATION_INCREMENT;
+ #if 0
+       rtf_fi = -ENUM_INDENTATION_INCREMENT;
+       rtf_n_tab_stops = 2;
+       rtf_tab_stops[0] = (rtf_li
+ 			  - ENUM_INDENTATION_INCREMENT
+ 			  + ENUM_PRE_INCREMENT);
+       rtf_tab_stops[1] = rtf_li;
+ #endif
+ #endif
        break;
  
        /* Does nothing special in makeinfo. */
*************** begin_insertion (type)
*** 3678,3683 ****
--- 4089,4097 ----
        filling_enabled = indented_fill = 1;
        current_indent += default_indentation_increment;
        no_indent = 0;
+ #ifdef RTF_OUTPUT
+       rtf_li += EXAMPLE_INDENTATION_INCREMENT;
+ #endif
        break;
  
      case flushleft:
*************** end_insertion (type)
*** 3778,3783 ****
--- 4192,4200 ----
  
      case table:
      case ftable:
+ #ifdef RTF_OUTPUT
+     case ktable:
+ #endif
      case vtable:
      case itemize:
        current_indent -= default_indentation_increment;
*************** end_insertion (type)
*** 3794,3799 ****
--- 4211,4220 ----
        close_insertion_paragraph ();
        break;
      }
+ 
+ #ifdef RTF_OUTPUT
+   inserts ("}");
+ #endif
  }
  
  /* Insertions cannot cross certain boundaries, such as node beginnings.  In
*************** discard_insertions ()
*** 3823,3828 ****
--- 4244,4252 ----
  		      COMMAND_PREFIX, offender);
  	  input_filename = current_filename;
  	  pop_insertion ();
+ #ifdef RTF_OUTPUT
+ 	  inserts ("}");
+ #endif
  	}
      }
    line_number = real_line_number;
*************** void
*** 3860,3867 ****
--- 4284,4300 ----
  cm_bullet (arg)
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     {
+       add_char ('*');
+       output_paragraph_offset--;
+       inserts ("{\\f2\\'B7}");
+     }
+ #else
    if (arg == START)
      add_char ('*');
+ #endif
  }
  
  void
*************** cm_code (arg)
*** 3926,3936 ****
--- 4359,4377 ----
    if (arg == START)
      {
        in_fixed_width_font++;
+ #ifdef RTF_OUTPUT
+       vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+ #else
        add_char ('`');
+ #endif
      }
    else
      {
+ #ifdef RTF_OUTPUT
+       inserts ("}");
+ #else
        add_word ("'");
+ #endif
        in_fixed_width_font--;
      }
  }
*************** void
*** 3939,3945 ****
--- 4380,4412 ----
  cm_samp (arg)
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   extern int printing_index;
+ 
+   if (printing_index)
+     return;
+ 
+   if (arg == START)
+     {
+ #if 0
+       if (! in_index_entry)
+ 	inserts ("'");
+ #endif
+       in_fixed_width_font++;
+       vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+     }
+   else
+     {
+       inserts ("}");
+       in_fixed_width_font--;
+ #if 0
+       if (! in_index_entry)
+ 	inserts ("'");
+ #endif
+     }
+ #else
    cm_code (arg);
+ #endif
  }
  
  void
*************** void
*** 3967,3972 ****
--- 4434,4443 ----
  cm_ctrl (arg, start, end)
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{^");
+ #endif
    /* Should we allow multiple character arguments?  I think yes. */
    if (arg == END)
      {
*************** cm_ctrl (arg, start, end)
*** 3981,3989 ****
--- 4452,4468 ----
  	  {
  	    character = output_paragraph[i];
  
+ #ifdef RTF_OUTPUT
+ 	    if (isletter (character))
+ 	      output_paragraph[i] = coerce_to_upper (character);
+ #else
  	    if (isletter (character))
  	      output_paragraph[i] = CTL (coerce_to_upper (character));
+ #endif
  	  }
+ #ifdef RTF_OUTPUT
+       inserts ("}");
+ #endif
      }
  }
  
*************** void
*** 3992,3997 ****
--- 4471,4487 ----
  cm_sc (arg, start_pos, end_pos)
       int arg, start_pos, end_pos;
  {
+ #ifdef RTF_OUTPUT
+   extern int printing_index;
+ 
+   if (printing_index)
+     return;
+ 
+   if (arg == START)
+     vinserts ("{\\scaps\\fs16{}"); /* FIXME */
+   else
+     inserts ("}");
+ #else
    if (arg == END)
      {
        while (start_pos < end_pos)
*************** cm_sc (arg, start_pos, end_pos)
*** 4001,4006 ****
--- 4491,4497 ----
  	  start_pos++;
  	}
      }
+ #endif
  }
  
  /* @var in makeinfo just uppercases the text. */
*************** void
*** 4008,4013 ****
--- 4499,4510 ----
  cm_var (arg, start_pos, end_pos)
       int arg, start_pos, end_pos;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{\\i ");
+   else
+     inserts ("}");
+ #else
    if (arg == END)
      {
        while (start_pos < end_pos)
*************** cm_var (arg, start_pos, end_pos)
*** 4017,4022 ****
--- 4514,4520 ----
  	  start_pos++;
  	}
      }
+ #endif
  }
  
  void
*************** void
*** 4030,4053 ****
--- 4528,4566 ----
  cm_emph (arg)
       int arg;
  {
+ #ifdef RTF_OUTPUT
+   cm_var (arg);
+ #else /* ! RTF_OUTPUT */
    add_char ('*');
+ #endif /* ! RTF_OUTPUT */
  }
  
  void
  cm_strong (arg, position)
       int arg, position;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     inserts ("{\\b ");
+   else
+     inserts ("}");
+ #else /* ! RTF_OUTPUT */
    cm_emph (arg);
+ #endif /* ! RTF_OUTPUT */
  }
  
  void
  cm_cite (arg, position)
       int arg, position;
  {
+ #ifdef RTF_OUTPUT
+   cm_italic (arg);
+ #else /* ! RTF_OUPUT */
    if (arg == START)
      add_word ("`");
    else
      add_word ("'");
+ #endif /* ! RTF_OUTPUT */
  }
  
  /* Current text is italicized. */
*************** void
*** 4055,4060 ****
--- 4568,4576 ----
  cm_italic (arg, start, end)
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   cm_emph (arg, start, end);
+ #endif
  }
  
  /* Current text is highlighted. */
*************** void
*** 4070,4082 ****
--- 4586,4620 ----
  cm_roman (arg, start, end)
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   if (arg == START)
+     vinserts ("{\\f%d{}", RTF_FONT_NORMAL);
+   else
+     inserts ("}");
+ #endif
+ }
+ 
+ #ifdef RTF_OUTPUT
+ /* Current text is in fixed-width font. */
+ void
+ cm_t (arg, start, end)
+      int arg, start, end;
+ {
+   if (arg == START)
+     vinserts ("{\\f%d{}", RTF_FONT_FIXED_WIDTH);
+   else
+     inserts ("}");
  }
+ #endif
  
  /* Current text is in roman font. */
  void
  cm_titlefont (arg, start, end)
       int arg, start, end;
  {
+ #ifdef RTF_OUTPUT
+   cm_roman (arg, start, end);
+ #endif
  }
  
  /* Italicize titles. */
*************** insert_and_underscore (with_char)
*** 4126,4132 ****
--- 4664,4688 ----
    int old_no_indent, starting_pos, ending_pos;
    char *temp;
  
+ #ifdef RTF_OUTPUT
+   int big_heading = in_non_scrolling_region;
+ 
+   /* Get the topic title. */
+   get_rest_of_line (&temp);
+   if (in_non_scrolling_region)
+     {
+       /* Now that we have the topic title, we can create an index entry for it. */
+       in_non_scrolling_region = 0;
+       inserts ("${\\footnote ");
+       execute_string ("%s", temp);
+       inserts ("}\n");
+       close_paragraph_with_lines (0);
+     }
+   else
+     close_paragraph ();
+ #else
    close_paragraph ();
+ #endif
    filling_enabled =  indented_fill = 0;
    old_no_indent = no_indent;
    no_indent = 1;
*************** insert_and_underscore (with_char)
*** 4136,4142 ****
--- 4692,4711 ----
      append_to_expansion_output (input_text_offset + 1);
  #endif /* HAVE_MACROS */
  
+ #ifdef RTF_OUTPUT
+   /* We already have the rest of the line. */
+ #else
    get_rest_of_line (&temp);
+ #endif
+ 
+ #ifdef RTF_OUTPUT
+   if (! imprint_printed)
+     imprint ();
+   if (big_heading)
+     inserts ("\\pard{\\fs24\\b "); /* choose big bold font for topic title */
+   else
+     inserts ("\\pard{\\b ");	/* bold font for subtopic title */
+ #endif
  
    starting_pos = output_position + output_paragraph_offset;
  #if defined (HAVE_MACROS)
*************** insert_and_underscore (with_char)
*** 4152,4166 ****
--- 4721,4743 ----
      }
    else
  #endif /* HAVE_MACROS */
+ #ifdef RTF_OUTPUT
+   execute_string ("%s", temp);
+ #else
    execute_string ("%s\n", temp);
+ #endif
  
    ending_pos = output_position + output_paragraph_offset;
    free (temp);
  
    len = (ending_pos - starting_pos) - 1;
+ #ifdef RTF_OUTPUT
+   inserts ("}");
+ #else
    for (i = 0; i < len; i++)
      add_char (with_char);
    insert ('\n');
+ #endif
    close_paragraph ();
    filling_enabled = 1;
    no_indent = old_no_indent;
*************** cm_node ()
*** 4708,4713 ****
--- 5285,5292 ----
  #endif /* HAVE_MACROS */
  
    no_indent = 1;
+ #ifdef RTF_OUTPUT
+ #else
    if (!no_headers)
      {
        add_word_args ("\037\nFile: %s,  Node: ", pretty_output_filename);
*************** cm_node ()
*** 4720,4725 ****
--- 5299,5305 ----
        execute_string ("%s", node);
        filling_enabled = indented_fill = 0;
      }
+ #endif
  
    /* Check for defaulting of this node's next, prev, and up fields. */
    defaulting = ((strlen (next) == 0) &&
*************** cm_node ()
*** 4920,4925 ****
--- 5500,5508 ----
      }
  #endif /* HAVE_MACROS */
  
+ #ifdef RTF_OUTPUT
+   start_topic (node, next, prev, up);
+ #else
    if (!no_headers)
      {
  #if defined (HAVE_MACROS)
*************** cm_node ()
*** 4949,4954 ****
--- 5532,5538 ----
  	me_inhibit_expansion--;
  #endif /* HAVE_MACROS */
      }
+ #endif
  
    close_paragraph ();
    no_indent = 0;
*************** save_node:
*** 5559,5564 ****
--- 6143,6247 ----
      return (nodename);
  }
  
+ #ifdef RTF_OUTPUT
+ process_menu_line ()
+ {
+   int i, j;
+   char *nodename;
+ 
+   if (strncmp (&input_text[input_text_offset],
+ 	       menu_starter,
+ 	       strlen (menu_starter)) != 0)
+     {
+       /* This line only contains descriptive text. */
+       skip_whitespace ();
+      
+       if (curchar() == '\n')
+ 	{
+ 	  /* Correction. This line is empty. */
+ 	  add_char ('\n');
+ 	  add_char ('\n');
+ 	}
+       add_char (' ');
+       return (0);
+     }
+   else
+     {
+       /* This line begins with "* ". It's now time to begin a new paragraph. */
+       if (! last_char_was_newline)
+ 	add_char ('\n');
+       input_text_offset += strlen (menu_starter);
+     }
+ 
+   get_until_in_line (":", &nodename);
+   if (curchar () == ':')
+     input_text_offset++;
+   canon_white (nodename);
+ 
+   add_char ('i');
+   output_paragraph_offset--;
+ 
+   inserts ("{\\uldb ");
+   execute_string ("%s", nodename);
+   inserts ("}{\\v ");
+ 
+   if (curchar () == ':')
+     {
+       input_text_offset++;
+       i = strlen (nodename);
+       if (i && nodename[i - 1] == ':')
+ 	nodename[i - 1] = '\0';
+       insert_context_string (nodename);
+       free (nodename);
+       inserts ("}\\tab ");
+       skip_whitespace ();
+     }
+   else
+     {
+       free (nodename);
+       get_rest_of_line (&nodename);
+       i = strlen (nodename);
+       backup_input_pointer ();
+       isolate_nodename (nodename);
+       if (*nodename == '(')
+ 	{
+ 	  char *filename = strdup(nodename+1);
+ 	  char *cp = filename+1;
+ 	  while (*cp && *cp != ')')
+ 	    cp++;
+ 	  if (*cp == ')')
+ 	    {
+ 	      char *nodename_in_info_file = cp+1;
+ 	      size_t fnlen;
+ 	      *cp++ = 0;
+ 	      fnlen = strlen(filename);
+ 	      if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 		filename[fnlen-5] = 0;
+ 	      if (*nodename_in_info_file)
+ 		insert_context_string (nodename_in_info_file);
+ 	      else
+ 		insert_context_string ("Top");
+ 	      vinserts (" @%s.hlp", filename);
+ 	    }
+ 	  else
+ 	    insert_context_string (nodename);
+ 	  free (filename);
+ 	}
+       else
+ 	insert_context_string (nodename);
+       inserts ("}\\tab ");
+       j = strlen (nodename);      
+       if (i > j)
+ 	{
+ 	  char *description = nodename + j + 1;
+ 	  canon_white (description);
+ 	  execute_string ("%s", description);
+ 	}
+       free (nodename);
+     }
+ }
+ #endif /* RTF_OUTPUT */
+ 
  static void
  isolate_nodename (nodename)
       char *nodename;
*************** get_xref_token ()
*** 5644,5649 ****
--- 6327,6335 ----
  }
  
  int px_ref_flag = 0;		/* Controls initial output string. */
+ #ifdef RTF_OUTPUT
+ int ref_flag = 0;		/* Controls initial output string. */
+ #endif
  
  /* Make a cross reference. */
  void
*************** cm_xref (arg)
*** 5659,5665 ****
--- 6345,6355 ----
        arg4 = get_xref_token ();
        arg5 = get_xref_token ();
  
+ #ifdef RTF_OUTPUT
+       add_word_args ("%s", px_ref_flag ? "see " : (ref_flag ? "" : "See "));
+ #else
        add_word_args ("%s", px_ref_flag ? "*note " : "*Note ");
+ #endif
  
        if (*arg5 || *arg4)
  	{
*************** cm_xref (arg)
*** 5675,5681 ****
--- 6365,6388 ----
  	  else
  	    node_name = arg2;
  
+ #ifdef RTF_OUTPUT
+ 	  inserts ("{\\uldb ");
+ 	  execute_string ("%s", node_name);
+ 	  inserts ("}{\\v ");
+ 	  insert_context_string (arg1);
+ 
+ 	  {
+ 	    char *filename = strdup(arg4);
+ 	    size_t fnlen;
+ 	    fnlen = strlen(filename);
+ 	    if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 	      filename[fnlen-5] = 0;
+ 	    vinserts (" @%s.hlp}", filename);
+ 	    free (filename);
+ 	  }
+ #else
  	  execute_string ("%s: (%s)%s", node_name, arg4, arg1);
+ #endif
  	  /* Free all of the arguments found. */
  	  if (arg1) free (arg1);
  	  if (arg2) free (arg2);
*************** cm_xref (arg)
*** 5689,5705 ****
--- 6396,6450 ----
  
        if (*arg3)
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (!*arg2)
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg3);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ 	  else
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg2);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ #else
  	  if (!*arg2)
  	    execute_string ("%s: %s", arg3, arg1);
  	  else
  	    execute_string ("%s: %s", arg2, arg1);
+ #endif
  	}
        else
  	{
+ #ifdef RTF_OUTPUT
+ 	  if (*arg2)
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg2);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ 	  else
+ 	    {
+ 	      inserts ("{\\uldb ");
+ 	      execute_string ("%s", arg1);
+ 	      inserts ("}{\\v ");
+ 	      insert_context_string (arg1);
+ 	      inserts ("}");
+ 	    }
+ #else
  	  if (*arg2)
  	    execute_string ("%s: %s", arg2, arg1);
  	  else
  	    execute_string ("%s::", arg1);
+ #endif
  	}
  
        /* Free all of the arguments found. */
*************** cm_xref (arg)
*** 5740,5745 ****
--- 6485,6504 ----
      }
  }
  
+ #ifdef RTF_OUTPUT
+ void
+ cm_ref (arg)
+      int arg;
+ {
+   if (arg == START)
+     {
+       ref_flag++;
+       cm_xref (arg);
+       ref_flag--;
+     }
+ }
+ #endif /* RTF_OUTPUT */
+ 
  void
  cm_pxref (arg)
       int arg;
*************** cm_pxref (arg)
*** 5750,5757 ****
--- 6509,6518 ----
        cm_xref (arg);
        px_ref_flag--;
      }
+ #ifndef RTF_OUTPUT
    else
      add_char ('.');
+ #endif
  }
  
  void
*************** cm_inforef (arg)
*** 5766,5772 ****
--- 6527,6538 ----
        pname = get_xref_token ();
        file = get_xref_token ();
  
+ #ifdef RTF_OUTPUT
+       execute_string ("%cxref{%s, %s,, %s}", COMMAND_PREFIX,
+ 		      node, pname, file);
+ #else
        execute_string ("*note %s: (%s)%s", pname, file, node);
+ #endif
      }
  }
  
*************** cm_ftable ()
*** 5881,5886 ****
--- 6647,6660 ----
    begin_insertion (ftable);
  }
  
+ #ifdef RTF_OUTPUT
+ void
+ cm_ktable ()
+ {
+   begin_insertion (ktable);
+ }
+ #endif
+ 
  void
  cm_vtable ()
  {
*************** cm_item ()
*** 6443,6449 ****
--- 7217,7242 ----
  	    }
  	  else
  	    {
+ #ifdef RTF_OUTPUT
+ 	      int old_rtf_fi = rtf_fi;
+ 	      int old_rtf_n_tab_stops = rtf_n_tab_stops;
+ 	      int old_rtf_tab_stops[sizeof(rtf_tab_stops) / sizeof(int)];
+ 	      memcpy (old_rtf_tab_stops,
+ 		      rtf_tab_stops, sizeof (old_rtf_tab_stops));
+ 	      rtf_fi = -ENUM_INDENTATION_INCREMENT;
+ 	      rtf_n_tab_stops = 2;
+ 	      rtf_tab_stops[0] = (rtf_li
+ 				  - ENUM_INDENTATION_INCREMENT
+ 				  + ENUM_PRE_INCREMENT);
+ 	      rtf_tab_stops[1] = rtf_li;
+ #endif
  	      start_paragraph ();
+ #ifdef RTF_OUTPUT
+ 	      memcpy (rtf_tab_stops, old_rtf_tab_stops,
+ 		      sizeof (old_rtf_tab_stops));
+ 	      rtf_fi = old_rtf_fi;
+ 	      rtf_n_tab_stops = old_rtf_n_tab_stops;
+ #endif
  	      kill_self_indent (-1);
  	      filling_enabled = indented_fill = 1;
  
*************** cm_item ()
*** 6451,6456 ****
--- 7244,7253 ----
  		{
  		  indent (output_column = current_indent - 2);
  
+ #ifdef RTF_OUTPUT
+ 		  inserts ("\\tab{}");
+ #endif
+ 
  		  /* I need some way to determine whether this command
  		     takes braces or not.  I believe the user can type
  		     either "@bullet" or "@bullet{}".  Of course, they
*************** cm_item ()
*** 6465,6471 ****
--- 7262,7272 ----
  		      else
  			execute_string ("%s", item_func);
  		    }
+ #ifdef RTF_OUTPUT
+ 		  inserts ("\\tab{}");
+ #else
  		  insert (' ');
+ #endif
  		  output_column++;
  		}
  	      else
*************** cm_item ()
*** 6489,6496 ****
--- 7290,7304 ----
  
  	case table:
  	case ftable:
+ #ifdef RTF_OUTPUT
+ 	case ktable:
+ #endif
  	case vtable:
  	  {
+ #ifdef RTF_OUTPUT
+ 	    int old_rtf_li = rtf_li;
+ 	    rtf_li -= TABLE_INDENTATION_INCREMENT;
+ #endif
  	    /* Get rid of extra characters. */
  	    kill_self_indent (-1);
  
*************** cm_item ()
*** 6531,6536 ****
--- 7339,7349 ----
  	    if (current_insertion_type () == ftable)
  	      execute_string ("%cfindex %s\n", COMMAND_PREFIX, rest_of_line);
  
+ #ifdef RTF_OUTPUT
+ 	    if (current_insertion_type () == ktable)
+ 	      execute_string ("%ckindex %s\n", COMMAND_PREFIX, rest_of_line);
+ #endif
+ 
  	    if (current_insertion_type () == vtable)
  	      execute_string ("%cvindex %s\n", COMMAND_PREFIX, rest_of_line);
  
*************** cm_item ()
*** 6538,6543 ****
--- 7351,7359 ----
  	       do the indenting of it for you. */
  	    close_single_paragraph ();
  	    indented_fill = filling_enabled = 1;
+ #ifdef RTF_OUTPUT
+ 	    rtf_li = old_rtf_li;
+ #endif
  	  }
  	}
        free (rest_of_line);
*************** defun_internal (type, x_p)
*** 6925,6930 ****
--- 7741,7749 ----
    /* Write the definition header line.
       This should start at the normal indentation.  */
    current_indent -= default_indentation_increment;
+ #ifdef RTF_OUTPUT
+   rtf_li -= EXAMPLE_INDENTATION_INCREMENT;
+ #endif
    start_paragraph ();
  
    switch (base_type)
*************** defun_internal (type, x_p)
*** 6932,6961 ****
--- 7751,7812 ----
      case deffn:
      case defvr:
      case deftp:
+ #ifdef RTF_OUTPUT
+       execute_string ("%s: %cstrong{%s}",
+ 		      category, COMMAND_PREFIX, defined_name);
+ #else
        execute_string (" -- %s: %s", category, defined_name);
+ #endif
        break;
      case deftypefn:
      case deftypevr:
+ #ifdef RTF_OUTPUT
+       execute_string ("%s: %s %cstrong{%s}",
+ 		      category, type_name, COMMAND_PREFIX, defined_name);
+ #else
        execute_string (" -- %s: %s %s", category, type_name, defined_name);
+ #endif
        break;
      case defcv:
+ #ifdef RTF_OUTPUT
+       execute_string ("%s of %s: %cstrong{%s}",
+ 		      category, type_name, COMMAND_PREFIX, defined_name);
+ #else
        execute_string (" -- %s of %s: %s", category, type_name, defined_name);
+ #endif
        break;
      case defop:
+ #ifdef RTF_OUTPUT
+       execute_string ("%s on %s: %cstrong{%s}",
+ 		      category, type_name, COMMAND_PREFIX, defined_name);
+ #else
        execute_string (" -- %s on %s: %s", category, type_name, defined_name);
+ #endif
        break;
      case deftypemethod:
+ #ifdef RTF_OUTPUT
+       execute_string ("%s on %s: %s %cstrong{%s}",
+ 		      category, type_name, type_name2,
+ 		      COMMAND_PREFIX, defined_name);
+ #else
        execute_string (" -- %s on %s: %s %s", category, type_name, type_name2,
  		      defined_name);
+ #endif
        break;
      }
    current_indent += default_indentation_increment;
+ #ifdef RTF_OUTPUT
+   rtf_li += EXAMPLE_INDENTATION_INCREMENT;
+ #endif
  
    /* Now process the function arguments, if any.
       If these carry onto the next line, they should be indented by two
       increments to distinguish them from the body of the definition,
       which is indented by one increment.  */
    current_indent += default_indentation_increment;
+ #ifdef RTF_OUTPUT
+   rtf_li += EXAMPLE_INDENTATION_INCREMENT;
+ #endif
  
    switch (base_type)
      {
*************** defun_internal (type, x_p)
*** 6970,6975 ****
--- 7821,7829 ----
        break;
      }
    current_indent -= default_indentation_increment;
+ #ifdef RTF_OUTPUT
+   rtf_li -= EXAMPLE_INDENTATION_INCREMENT;
+ #endif
    close_single_paragraph ();
  
    /* Make an entry in the appropriate index. */
*************** cm_center ()
*** 7156,7161 ****
--- 8010,8021 ----
    unsigned char *line;
  
    close_paragraph ();
+ #ifdef RTF_OUTPUT
+   get_rest_of_line ((char **)&line);
+   execute_string ("%s", (char *)line);
+   free (line);
+   inserts ("\\qc{}");
+ #else /* ! RTF_OUTPUT */
    filling_enabled = indented_fill = 0;
    cm_noindent ();
    start = output_paragraph_offset;
*************** cm_center ()
*** 7188,7193 ****
--- 8048,8054 ----
  
        free (line);
      }
+ #endif /* ! RTF_OUTPUT */
  
    insert ('\n');
    close_paragraph ();
*************** cm_expansion (arg)
*** 7212,7218 ****
      add_word ("==>");
  }
  
! /* Indicates two expressions are equivalent. */
  void
  cm_equiv (arg)
       int arg;
--- 8073,8079 ----
      add_word ("==>");
  }
  
! /* Indicates two expressions are euqivalent. */
  void
  cm_equiv (arg)
       int arg;
*************** cm_ignore_sentence_ender ()
*** 7376,7381 ****
--- 8237,8249 ----
  void
  cm_bye ()
  {
+ #ifdef RTF_OUTPUT
+   if (insertion_level > 0)
+     {
+       discard_insertions ();
+       flush_output ();
+     }
+ #endif
    input_text_offset = size_of_input_text;
  }
  
*************** index_add_arg (name)
*** 7652,7657 ****
--- 8520,8538 ----
        new->code = tem->code;
        new->defining_line = line_number - 1;
        the_indices[which] = new;
+ #ifdef RTF_OUTPUT
+       add_char ('i');
+       output_paragraph_offset--;
+       inserts ("{K{\\footnote K ");
+       in_index_entry++;
+ #if 0
+       save_insert (index_entry);
+ #else
+       execute_string ("%s", index_entry);
+ #endif
+       in_index_entry--;
+       inserts ("}}");
+ #endif
      }
  }
  
*************** cm_printindex ()
*** 7949,7955 ****
--- 8830,8838 ----
    filling_enabled = 0;
    inhibit_paragraph_indentation = 1;
    close_paragraph ();
+ #ifndef RTF_OUTPUT
    add_word ("* Menu:\n\n");
+ #endif
  
    printing_index = 1;
  
*************** cm_printindex ()
*** 7965,7983 ****
--- 8848,8886 ----
  	 at the line which contains the entry. */
        line_number = index->defining_line;
  
+ #ifdef RTF_OUTPUT
+       inserts ("{");
+       vinserts ("\\fi%d", -MENU_INDENTATION);
+       vinserts ("\\li%d", MENU_INDENTATION);
+       vinserts ("\\tx%d", MENU_INDENTATION);
+ #endif
+ 
        /* If this particular entry should be printed as a "code" index,
  	 then wrap the entry with "@code{...}". */
+ #ifdef RTF_OUTPUT
        if (index->code)
+ 	execute_string ("%ccode{%s}:", COMMAND_PREFIX, index->entry);
+       else
+ 	execute_string ("%s:", index->entry);
+ #else
+       if (index->code)
  	execute_string ("* %ccode{%s}: ", COMMAND_PREFIX, index->entry);
        else
  	execute_string ("* %s: ", index->entry);
+ #endif
  
        /* Pad the front of the destination nodename so that
  	 the output looks nice. */
        if (fill_column > 40 && output_column < 40)
  	indent (40 - output_column);
  
+ #ifdef RTF_OUTPUT
+       inserts ("\\tab ");
+       execute_string ("%cref{%s}.\n", COMMAND_PREFIX, index->node);
+       inserts ("}");
+ #else
        execute_string ("%s.\n", index->node);
+ #endif
  
        line_number = real_line_number;
        flush_output ();
*************** cm_paragraphindent ()
*** 8086,8092 ****
--- 8989,8999 ----
  #define SeparateNode 0
  #define EndNode 1
  
+ #ifdef RTF_OUTPUT
+ int footnote_style = SeparateNode;
+ #else
  int footnote_style = EndNode;
+ #endif
  int first_footnote_this_node = 1;
  int footnote_count = 0;
  
*************** cm_footnote ()
*** 8242,8258 ****
--- 9149,9184 ----
    switch (footnote_style)
      {
      case SeparateNode:
+ #ifndef RTF_OUTPUT
        add_word_args ("(%s)", marker);
        if (first_footnote_this_node)
+ #endif
  	{
  	  char *temp_string;
  
+ #ifdef RTF_OUTPUT
+ 	  temp_string = (char *)
+ 	    xmalloc ((strlen (current_node)) + 1 + (strlen (marker)) + 1);
+ #else
  	  temp_string = (char *)
  	    xmalloc ((strlen (current_node)) + (strlen ("-Footnotes")) + 1);
+ #endif
  
+ #ifndef RTF_OUTPUT
  	  add_word_args (" (*note %s-Footnotes::)", current_node);
+ #endif
  	  strcpy (temp_string, current_node);
+ #ifdef RTF_OUTPUT
+ 	  strcat (temp_string, "-");
+ 	  strcat (temp_string, marker);
+ 	  inserts ("({\\ul ");
+ 	  save_insert (marker);
+ 	  inserts ("}{\\v ");
+ 	  insert_context_string (temp_string);
+ 	  inserts ("})");
+ #else
  	  strcat (temp_string, "-Footnotes");
+ #endif
  	  remember_node_reference (temp_string, line_number, followed_reference);
  	  free (temp_string);
  	  first_footnote_this_node = 0;
*************** output_pending_notes ()
*** 8286,8291 ****
--- 9212,9218 ----
    switch (footnote_style)
      {
  
+ #ifndef RTF_OUTPUT
      case SeparateNode:
        {
  	char *old_current_node = current_node;
*************** output_pending_notes ()
*** 8300,8305 ****
--- 9227,9233 ----
  	command = old_command;
        }
        break;
+ #endif
  
      case EndNode:
        close_paragraph ();
*************** output_pending_notes ()
*** 8330,8335 ****
--- 9258,9281 ----
  	switch (footnote_style)
  	  {
  	  case SeparateNode:
+ #ifdef RTF_OUTPUT
+ 	    {
+ 	      char *old_current_node = current_node;
+ 	      char *old_command = strdup (command);
+ 	      
+ 	      already_outputting_pending_notes++;
+ 	      execute_string ("%cnode %s-%s,,,%s\n",
+ 			      COMMAND_PREFIX, old_current_node, footnote->marker,
+ 			      old_current_node);
+ 	      already_outputting_pending_notes--;
+ 	      current_node = old_current_node;
+ 	      free (command);
+ 	      command = old_command;
+ 	    }
+ 	    execute_string ("%s", footnote->note);
+ 	    close_paragraph ();
+ 	    break;
+ #endif
  	  case EndNode:
  	    execute_string ("(%s)  %s", footnote->marker, footnote->note);
  	    close_paragraph ();
*************** get_file_info_in_path (filename, path, f
*** 9281,9283 ****
--- 10227,10597 ----
      }
    return ((char *)NULL);
  }
+ 
+ 
+ #ifdef RTF_OUTPUT
+ /* **************************************************************** */
+ /*                                                                  */
+ /*                           RTF-Stuff                              */
+ /*                                                                  */
+ /* **************************************************************** */
+ 
+ inserts (s)
+      char *s;
+ {
+   while (*s)
+     insert (*s++);
+ }
+ 
+ #if defined (HAVE_VARARGS_H) && defined (HAVE_VSPRINTF)
+ 
+ vinserts (va_alist)
+      va_dcl
+ {
+   char buffer[1000];
+   char *format;
+   va_list args;
+ 
+   va_start (args);
+   format = va_arg (args, char *);
+   vsprintf (buffer, format, args);
+   va_end (args);
+   inserts (buffer);
+ }
+ 
+ #else /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */
+ 
+ vinserts (format, arg1, arg2, arg3, arg4, arg5)
+      char *format;
+ {
+   char buffer[1000];
+   sprintf (buffer, format, arg1, arg2, arg3, arg4, arg5);
+   inserts (buffer);
+ }
+ 
+ #endif /* !(HAVE_VARARGS_H && HAVE_VSPRINTF) */
+ 
+ save_insert (s)
+      char *s;
+ {
+   while (*s)
+     {
+       if (*s == '{' || *s == '}' || *s == '\\' || ! isascii (*s))
+ 	vinserts ("\\'%02X", (int) (*s & 0xff));
+       else
+ 	insert (*s);
+       s++;
+     }
+ }
+ 
+ make_context_string (context_string, text)
+      char *context_string;
+      char *text;
+ {
+   char *cp = context_string;
+   if (text)
+     {
+       while (*text)
+ 	{
+ 	  if (*text == '\n')
+ 	    {
+ 	      *cp++ = '_';
+ 	      text++;
+ 	      while (*text && isspace(*text))
+ 		text++;
+ 	      if (*text == 0)
+ 		break;
+ 	    }
+ 	  if (!isalnum (*text) || !isascii(*text))
+ 	    *cp = '_';
+ 	  else
+ 	    *cp = *text;
+ 	  cp++;
+ 	  text++;
+ 	}
+     }
+   *cp = 0;
+ }
+ 
+ insert_context_string (text)
+      char *text;
+ {
+   char context_string[ 8192 ];
+   make_context_string (context_string, text);
+   save_insert (context_string);
+ }
+ 
+ insert_hot_spot (text, node)
+      char *text;
+      char *node;
+ {
+   char context_string[ 8192 ];
+   if (node == 0)
+     make_context_string (context_string, text);
+   else
+     make_context_string (context_string, node);
+   inserts ("{\\uldb ");
+   if (text == 0 || *text == 0)
+     {
+       if (node)
+ 	save_insert (node);
+     }
+   else
+     save_insert (text);
+   inserts ("}{\\v ");
+ 
+   if (node && *node == '(')
+     {
+       char *filename = strdup(node+1);
+       char *cp = filename+1;
+       while (*cp && *cp != ')')
+ 	cp++;
+       if (*cp == ')')
+ 	{
+ 	  char *nodename_in_info_file = cp+1;
+ 	  size_t fnlen;
+ 	  *cp++ = 0;
+ 	  fnlen = strlen(filename);
+ 	  if (fnlen >= 5 && (strcmp(filename+fnlen-5, ".info") == 0))
+ 	    filename[fnlen-5] = 0;
+ 	  if (*nodename_in_info_file)
+ 	    insert_context_string (nodename_in_info_file);
+ 	  else
+ 	    insert_context_string ("Top");
+ 	  vinserts (" @%s.hlp", filename);
+ 	}
+       else
+ 	insert_context_string (node);
+       free (filename);
+     }
+   else
+     insert_context_string (node);
+   inserts ("}");
+ }
+ 
+ /* Start the RTF file. Select a code table and a font. Define the font
+    table. */
+ start_rtf_file ()
+ {
+   fprintf (output_stream, "\
+ {\\rtf1\\windows \\deff0{\\fonttbl\n\
+ {\\f0\\fswiss MS Sans Serif;}\
+ {\\f1\\fmodern Courier New;}\
+ {\\f2\\ftech Symbol;}}\
+ \\fs20\n");
+   fprintf (output_stream, "\\page #{\\footnote hcAbout}\
+ ${\\footnote \\pard{}About this help file}\
+ \\pard{\\fs24\\b About this help file}\\par\
+ \\par\
+ \\pard{}This file was made with the help of {\\ul Makertf %s}{\\v hcMakertf} \
+ from the input file %s.\\par\\par",
+            makertf_version_string, input_filename);
+ }
+ 
+ /* End up the RTF file. */
+ end_rtf_file ()
+ {
+ fprintf (output_stream, "\\page K{\\footnote Makertf}#{\\footnote hcMakertf}\
+ ${\\footnote \\pard{}About Makertf}\
+ \\pard{\\fs24\\b About Makertf}\\par\
+ \\par\
+ \\pard{}Makertf is a program that converts \"Texinfo\" files into \"Rich Text \
+ Format\" (RTF) files. It can be used to make WinHelp Files from GNU manuals and \
+ other documentation written in Texinfo.\\par\\par\n\
+ Makertf is derived from GNU Makeinfo, which is \
+ a part of the GNU Texinfo documentation system.\\par\\par\n\
+ Christian Schenk\\par\n\
+ {\\f1cschenk@berlin.snafu.de}");
+   fprintf (output_stream, "}");
+ }
+ 
+ /* Start a new help topic. Write the node line into a non-scrolling
+    region. */
+ start_topic (node, next, prev, up)
+      char *node;
+      char *next;
+      char *prev;
+      char *up;
+ {
+   char context_string[ 8192 ];
+ 
+   inserts ("\\page\\pard");
+   if (already_outputting_pending_notes == 0)
+     {
+       in_non_scrolling_region = 1;
+       inserts (" Node: {\\b ");
+       save_insert (node);
+       inserts ("}, \\keepn Next: ");
+       insert_hot_spot (0, next);
+       inserts (", Prev: ");
+       insert_hot_spot (0, prev);
+       inserts (", Up: ");
+       insert_hot_spot (0, up);
+       if (strcmp (node, "Top") == 0)
+ 	inserts ("\\tab\\tab{\\uldb About this help file}{\\v hcAbout}");
+       inserts ("\\line\n");
+       make_context_string (context_string, node);
+       inserts ("K{\\footnote K ");
+       save_insert (node);
+       inserts ("}\n");
+       inserts ("#{\\footnote ");
+       save_insert (context_string);
+       inserts ("}\n");
+     }
+   else
+     {
+       make_context_string (context_string, node);
+       inserts ("#{\\footnote ");
+       save_insert (context_string);
+       inserts ("}\n");
+     }
+ }
+ 
+ char *help_window_title;
+ 
+ /* Set the title for the help file. */
+ void
+ cm_settitle ()
+ 
+ {
+   get_rest_of_line (&help_window_title);
+ }
+ 
+ /* Write the HPJ file for the help compiler. */
+ write_help_project_file (hpj_filename, rtf_filename)
+      char *hpj_filename;
+      char *rtf_filename;
+ {
+   FILE *hpj_stream = fopen(hpj_filename, "w");
+   if (!hpj_stream)
+     perror (hpj_filename);
+   else
+     {
+       char *title;
+       fprintf (hpj_stream, "[OPTIONS]\n");
+       fprintf (hpj_stream, "CONTENTS=TOP\n");
+       fprintf (hpj_stream, "COMPRESS=YES\n");
+       fprintf (hpj_stream, "COPYRIGHT=Made with the help of Makertf %s\n",
+ 	       makertf_version_string);
+       if (help_window_title)
+ 	title = help_window_title;
+       else
+ 	title = doc_title;
+       if (title)
+ 	{
+ #define MAX_TITLE_LEN 50 /* Window titles shouldn't be longer than this. */
+ 	  static char buf[ MAX_TITLE_LEN + 1 ];
+ 	  static char search[] = {COMMAND_PREFIX,
+ 				  'v', 'a', 'l', 'u', 'e', '{', '\0'};
+ 	  size_t search_len = strlen(search);
+ 	  char *cp=title, *cp1=buf;
+ 	  size_t len = 0;
+ 	  while (*cp && len < MAX_TITLE_LEN)
+ 	    {
+ 	      if (strncmp(cp, search, search_len) == 0)
+ 		{
+ 		  char *var;
+ 		  char *cp2;
+ 		  cp2 = cp + search_len;
+ 		  var = cp2;
+ 		  while (*cp2 && *cp2 != '}')
+ 		    cp2++;
+ 		  if (*cp2 == '}')
+ 		    {
+ 		      char *value;
+ 		      size_t vlen;
+ 		      *cp2++ = 0;
+ 		      value = set_p(var);
+ 		      if (value && (vlen=strlen(value))+len < MAX_TITLE_LEN)
+ 			{
+ 			  strcpy (cp1, value);
+ 			  cp1 += vlen;
+ 			  len += vlen;
+ 			  cp = cp2;
+ 			  continue;
+ 			}
+ 		    }
+ 		}
+ 	      *cp1++ = *cp++;
+ 	      len++;
+ 	    }
+ 	  *cp1 = 0;
+ 	  fprintf (hpj_stream, "TITLE=%s\n", buf);
+ 	}
+       else
+ 	{
+ 	  warning ("Missing %csettitle command", COMMAND_PREFIX);
+ 	  fprintf (hpj_stream, "TITLE=Untitled\n");
+ 	}
+       fprintf (hpj_stream, "\n");
+       fprintf (hpj_stream, "[WINDOWS]\n");
+       fprintf (hpj_stream, "main=,,0,,(192,192,192),0\n\n");
+       fprintf (hpj_stream, "[FILES]\n");
+       fprintf (hpj_stream, "%s\n", rtf_filename);
+       fclose (hpj_stream);
+     }
+ }
+ 
+ imprint ()
+ 
+ {
+   inserts ("\\pard");
+   if (author_name && doc_title)
+     {
+       inserts ("{\\fs28\\b ");
+       execute_string ("%s", doc_title);
+       inserts ("}\\par");
+       inserts ("{\\fs24 ");
+       if (strncmp (author_name, "by ", 3) != 0)
+ 	execute_string ("by ");
+       execute_string ("%s", author_name);
+       inserts ("}\\par\\par\\par");
+     }
+   imprint_printed = 1;
+ }
+ 
+ preprocess ()
+ 
+ {
+   char search_string[20];
+   input_text_offset = 0;
+   author_name = 0;
+   sprintf (search_string, "%cauthor ", COMMAND_PREFIX);
+   while ((input_text_offset = search_forward (search_string,
+ 					      input_text_offset)) >= 0)
+     {
+       char *cp;
+       if (input_text_offset > 0
+ 	  && input_text[input_text_offset-1] == COMMAND_PREFIX)
+         {
+           input_text_offset += strlen (search_string);
+           continue;
+         }
+       input_text_offset += strlen (search_string);
+       get_until ("\n", &cp);
+       canon_white (cp);
+       if (author_name == 0)
+ 	author_name = strdup (cp);
+       else
+ 	{
+ 	  char *new_author_name = (char *) xmalloc (strlen (author_name)
+ 						    + strlen (cp) + 6);
+ 	  sprintf (new_author_name, "%s and %s", author_name, cp);
+ 	  free (author_name);
+ 	  author_name = new_author_name;
+ 	}
+       free (cp);
+     }
+   sprintf (search_string, "%ctitle ", COMMAND_PREFIX);
+   input_text_offset = search_forward (search_string, 0);
+   if (input_text_offset >= 0)
+     {
+       input_text_offset += strlen (search_string);
+       get_until ("\n", &doc_title);
+       canon_white (doc_title);
+     }
+   else
+     author_name = 0;
+   input_text_offset = 0;
+ }
+ #endif /* RTF_OUTPUT */
