/*****************************************************************

PICKTEST.CPP


(c)	1995 Simon Whiteside


This application demonstrates the use of the Pick List control.

It creates a main window containing a pick list and fills the
list with some sample data.

*****************************************************************/
#include "picklist.h"
#include <windowsx.h>
#include <ctl3d.h>
/*****************************************************************
Typedefs
*****************************************************************/
#define PICKTEST_CLASS "PickTest"
/*****************************************************************
Globals
*****************************************************************/
HINSTANCE hInst;
HFONT hSmallFont;
HWND hwndList;
/*****************************************************************

Window Procedures

*****************************************************************/
//-----------------------------------------------------------------
LRESULT _export CALLBACK WindowProc(HWND hwnd,UINT msg,
                                    WPARAM wParam,LPARAM lParam)
//-----------------------------------------------------------------
{
	LRESULT ret=0;
    switch (msg){
    //-----------------------------------------------------------------
        case WM_CREATE:{
    //-----------------------------------------------------------------
    		//	create a Pick List
    		//	note style MUST contain LBS_OWNERDRAWFIXED|LBS_HASSTRINGS
    		
    		hwndList=CreateWindow(PICKLIST_CLASS,
    									"",
    									LBS_OWNERDRAWFIXED|LBS_HASSTRINGS|
    									LBS_SORT|WS_VISIBLE|WS_CHILD,
    									0,0,0,0,
										hwnd,(HMENU)1,hInst,0);
			if (hwndList){
			    //	put some sample data into the list
			    for (int x=0;x<10;x++){
			        char buffer[40];
			        wsprintf(buffer,"Test %d",x);
			        int index=ListBox_AddString(hwndList,buffer);
			        
			        //	set the check for even numbered items
			        //	the lowest bit of the item data specifies 
			        //	the check value
			        if (x%2==0)
			            ListBox_SetItemData(hwndList,index,1L);
			    }
			}
    		break;
        }
    //-----------------------------------------------------------------
        case WM_SIZE:
    //-----------------------------------------------------------------
    		//	make sure the list box is the same size as the main window
    		MoveWindow(hwndList,0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
    		break;
    //-----------------------------------------------------------------
        case WM_DESTROY:
    //-----------------------------------------------------------------
    		//	clean up resources and quit
			DeleteObject(hSmallFont);
    		PostQuitMessage(0);
    		break;
    //-----------------------------------------------------------------
        case WM_DRAWITEM:
    //-----------------------------------------------------------------
    		//	pass message back to the control so it can draw itself
    		return SendMessage(hwndList,msg,wParam,lParam);
    }
    ret=DefWindowProc(hwnd,msg,wParam,lParam);
    return ret;
}
/*****************************************************************

Initialization and Termination

*****************************************************************/
//-----------------------------------------------------------------
int PASCAL WinMain(HINSTANCE hinst,HINSTANCE,LPSTR ,int nCmdShow )
//-----------------------------------------------------------------
{
    int ret=0;
    //	Enable 3D
    Ctl3dRegister(hinst);
    Ctl3dAutoSubclass(hinst);
    hInst=hinst;
    //	Make sure the DLL containing the Pick List is Loaded
    PkLoad();	
    //	Register Main Window Class
    WNDCLASS ws;
    ws.style=CS_DBLCLKS;
    ws.lpfnWndProc=WindowProc;
    ws.cbClsExtra=0;
    ws.cbWndExtra=0;
	ws.hInstance=hinst;
    ws.hIcon=0;
    ws.hCursor=LoadCursor(0,IDC_ARROW);
	ws.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
	ws.lpszMenuName=0;
	ws.lpszClassName=PICKTEST_CLASS;
	if (RegisterClass(&ws)){
	    //	Create the main window
	    HWND hwnd=  CreateWindow(PICKTEST_CLASS,
	    						"Pick Test",
	    						WS_VISIBLE|WS_OVERLAPPED|WS_THICKFRAME|
	    						WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
	    						CW_USEDEFAULT,CW_USEDEFAULT,
	    						CW_USEDEFAULT,CW_USEDEFAULT,
	    						0,0,hinst,0);
	    if (hwnd){
	        ShowWindow(hwnd,nCmdShow);
	        //	Go into a message loop
	        MSG msg;
	        while ((GetMessage(&msg, 0, 0, 0))) {
				TranslateMessage(&msg);
	            DispatchMessage(&msg);
			}
			ret=msg.wParam;
		}						
	}
    Ctl3dUnregister(hinst);
	return ret;
}

