#ifndef PICKLIST_H
#define PICKLIST_H
#include <windows.h>
/*-----------------------------------------------------------------

    PICKLIST.H


    Declarations for Pick List Control
    
    v 1.00

    (c) 1995 Simon Whiteside


	Description:
	
	A Pick List is a list box where each entry has a check box
	that can be selected or unselected
	
	Usage:
	
	Create and use like a normal list box. To activate the
	check box behaviour, create with the styles LBS_OWNERDRAWFIXED
	and LBS_HASSTRINGS	and pass all WM_DRAWITEM messages back to the 
	control.
	
	The control stores the checked state in the bottommost bit of the
	item data, so applications should store their data in the top
	31-bits of this data. The bottommost bit can be used to
	change/query the checked state.
	
-----------------------------------------------------------------*/

#define PICKLIST_CLASS "PICKLIST"
#define PICKLIST_DLL "PICKLIST.DLL"

        
/*  Used to load the DLL */

#ifdef __cplusplus
extern "C"{
#endif
void _export CALLBACK PkLoad(void);
#ifdef __cplusplus
}
#endif
#endif
